/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.morphology;

import icy.roi.BooleanMask2D;
import icy.roi.ROI;
import icy.roi.ROIUtil;
import icy.sequence.Sequence;
import icy.sequence.SequenceDataIterator;
import icy.type.dimension.Dimension3D;
import icy.type.rectangle.Rectangle5D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import plugins.kernel.roi.roi2d.ROI2DArea;
import plugins.kernel.roi.roi3d.ROI3DArea;

public class ROIDilationCalculator {
    private ROI roi;
    private Dimension3D pixelSize;
    private double distance;
    private ROI dilationRoi;
    private BooleanMask2D roiBooleanMask;
    ROI2DArea distanceMapRoi2d;
    Rectangle distanceMapRoiMaskRect;

    public ROIDilationCalculator(ROI roi, Dimension3D pixelSize, double distance) {
        this.roi = roi;
        this.pixelSize = pixelSize;
        this.distance = distance;
    }

    public ROI getDilation() throws InterruptedException {
        if (this.dilationRoi == null) {
            this.compute();
        }
        return this.dilationRoi;
    }

    private void compute() throws InterruptedException {
        Rectangle5D roiBounds = this.roi.getBounds5D();
        if (roiBounds.getSizeZ() == 1.0 || Double.isInfinite(roiBounds.getSizeZ())) {
            this.roiBooleanMask = this.roi.getBooleanMask2D(0, Double.isInfinite(roiBounds.getSizeT()) ? 0 : (int)roiBounds.getT(), 0, true);
            Rectangle maskBounds = (Rectangle)this.roiBooleanMask.bounds.clone();
            this.roiBooleanMask.bounds.x = 0;
            this.roiBooleanMask.bounds.y = 0;
            this.setDistanceMapRoi2D();
            Sequence dt = ROIUtil.computeDistanceMap(this.distanceMapRoi2d, this.distanceMapRoi2d.getBounds5D().getDimension(), this.pixelSize, false);
            boolean[] dilationMask = new boolean[this.distanceMapRoiMaskRect.width * this.distanceMapRoiMaskRect.height];
            SequenceDataIterator dtIt = new SequenceDataIterator(dt, this.distanceMapRoi2d);
            while (!dtIt.done()) {
                double pixelValue = dtIt.get();
                if (pixelValue <= this.distance) {
                    dilationMask[dtIt.getPositionX() + dtIt.getPositionY() * this.distanceMapRoiMaskRect.width] = true;
                }
                dtIt.next();
            }
            BooleanMask2D dilationMask2D = new BooleanMask2D(this.distanceMapRoiMaskRect, dilationMask);
            dilationMask2D.add(this.roiBooleanMask.bounds, this.roiBooleanMask.mask);
            dilationMask2D.bounds.x += maskBounds.x;
            dilationMask2D.bounds.y += maskBounds.y;
            ROI2DArea dilationRoi2d = new ROI2DArea(dilationMask2D);
            dilationRoi2d.setZ(Double.isInfinite(roiBounds.getZ()) ? -1 : (int)roiBounds.getZ());
            dilationRoi2d.setT(Double.isInfinite(roiBounds.getT()) ? -1 : (int)roiBounds.getT());
            this.dilationRoi = dilationRoi2d;
        } else if (this.roi.getBounds5D().getSizeZ() > 1.0) {
            ArrayList<ROI> listRois = new ArrayList<ROI>();
            listRois.add(this.roi);
            Sequence dt = ROIUtil.computeDistanceMap(listRois, this.roi.getBounds5D().getDimension(), this.pixelSize, false);
            ROI3DArea erosionRoi = new ROI3DArea();
            SequenceDataIterator dtIt = new SequenceDataIterator(dt, this.roi);
            while (!dtIt.done()) {
                double pixelValue = dtIt.get();
                if (pixelValue > this.distance) {
                    erosionRoi.addPoint(dtIt.getPositionX(), dtIt.getPositionY(), dtIt.getPositionZ());
                }
                dtIt.next();
            }
            this.dilationRoi = erosionRoi;
        } else {
            this.dilationRoi = null;
        }
    }

    private void setDistanceMapRoi2D() {
        Rectangle distanceMapRoiMaskRect = new Rectangle((int)((double)this.roiBooleanMask.bounds.x - Math.ceil(this.distance)), (int)((double)this.roiBooleanMask.bounds.y - Math.ceil(this.distance)), (int)((double)this.roiBooleanMask.bounds.width + 2.0 * Math.ceil(this.distance)), (int)((double)this.roiBooleanMask.bounds.height + 2.0 * Math.ceil(this.distance)));
        this.distanceMapRoiMaskRect = new Rectangle(distanceMapRoiMaskRect);
        boolean[] distanceMapMask = new boolean[distanceMapRoiMaskRect.width * distanceMapRoiMaskRect.height];
        Arrays.fill(distanceMapMask, true);
        BooleanMask2D distanceMapRoiMask = new BooleanMask2D(distanceMapRoiMaskRect, distanceMapMask);
        distanceMapRoiMask.subtract(this.roiBooleanMask.bounds, this.roiBooleanMask.mask);
        distanceMapRoiMask.bounds.x = 0;
        distanceMapRoiMask.bounds.y = 0;
        this.distanceMapRoi2d = new ROI2DArea(distanceMapRoiMask);
        this.distanceMapRoi2d.setZ(0);
        this.distanceMapRoi2d.setT(0);
        this.distanceMapRoi2d.setC(0);
    }
}

