package plugins.ylemontag.sequencecomparator;

import java.util.WeakHashMap;

import icy.sequence.Sequence;

/**
 * 
 * @author Yoann Le Montagner
 *
 * Comparison between one reference sequence and any number of test videos
 */
public class GlobalComparisonPool extends ComparisonPool<ErrorMeasure, GlobalComparator>
{
	private WeakHashMap<Sequence, ErrorMeasure> _errorMeasures;
	
	/**
	 * Constructor
	 */
	public GlobalComparisonPool()
	{
		super();
		_errorMeasures = new WeakHashMap<Sequence, ErrorMeasure>();
	}

	@Override
	protected ErrorMeasure allocateResult(Sequence seq)
	{
		synchronized (_errorMeasures)
		{
			ErrorMeasure retVal = _errorMeasures.get(seq);
			if(retVal==null) {
				retVal = new ErrorMeasure();
				_errorMeasures.put(seq, retVal);
			}
			return retVal;
		}
	}
}
