package plugins.ylemontag.sequencecomparator.blocks;

import javax.swing.JComponent;

import plugins.adufour.vars.gui.VarEditor;
import plugins.adufour.vars.gui.swing.SwingVarEditor;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarArray;
import plugins.ylemontag.sequencecomparator.ErrorMeasure;
import plugins.ylemontag.sequencecomparator.gui.ErrorMeasureComponent;

/**
 * 
 * @author Yoann Le Montagner
 * 
 * Error measurement between two sequences
 */
public class VarErrorMeasureArray extends VarArray<ErrorMeasure>
{
	/**
	 * Editor
	 */
	private static class Editor extends SwingVarEditor<ErrorMeasure[]>
	{
		private ErrorMeasureComponent _component;
		
		public Editor(Var<ErrorMeasure[]> variable)
		{
			super(variable);
		}
		
		@Override
		protected JComponent createEditorComponent()
		{
			_component = new ErrorMeasureComponent();
			return _component;
		}
		
		@Override
		public boolean isComponentEnabled()
		{
			return true;
		}

		@Override
		protected void activateListeners()
		{
			// Nothing to do as the component cannot change the value of the
			// underlying variable
		}

		@Override
		protected void deactivateListeners()
		{
			// Nothing to do as the component cannot change the value of the
			// underlying variable
		}

		@Override
		protected void updateInterfaceValue()
		{
			_component.removeAllMeasures();
			ErrorMeasure[] data = variable.getValue();
			if(data==null) {
				return;
			}
			for(ErrorMeasure m : data) {
				_component.addMeasure(m);
			}
		}
	}
	
	public VarErrorMeasureArray(String name, ErrorMeasure[] defaultValue)
	{
		super(name, ErrorMeasure[].class, defaultValue);
	}
	
	@Override
	public VarEditor<ErrorMeasure[]> createVarViewer()
	{
		return new Editor(this);
	}
}
