package plugins.ylemontag.sequencecomparator.comparators;

import icy.sequence.Sequence;
import plugins.ylemontag.sequencecomparator.CompareUtil;
import plugins.ylemontag.sequencecomparator.Controller;
import plugins.ylemontag.sequencecomparator.LocalComparator;

/**
 * 
 * @author Yoann Le Montagner
 *
 * Error map generator for distances for which the error in a given XY plane
 * depends only on the value of the 2 compared sequences in this plane
 */
public abstract class PlaneSeparableLocalComparator extends LocalComparator
{
	/**
	 * Constructor
	 */
	public PlaneSeparableLocalComparator(String distanceName)
	{
		super(distanceName);
	}
	
	/**
	 * Function to override to compute the error at a given point
	 */
	protected abstract void computePlaneError(int sizeX, int sizeY, double[] refPlane, double[] seqPlane, double[] outPlane);
	
	@Override
	protected void implCompare(Sequence ref, Sequence seq, Sequence out, Controller controller)
		throws Controller.CanceledByUser
	{
		boolean extendRefT = false;
		boolean extendRefZ = false;
		if(!CompareUtil.haveSameSize(ref, seq)) {
			if(CompareUtil.comparableWithZExtent(ref, seq)) {
				extendRefZ = true;
			}
			else if(CompareUtil.comparableWithTExtent(ref, seq)) {
				extendRefT = true;
			}
			else if(CompareUtil.comparableWithZTExtent(ref, seq)) {
				extendRefZ = true;
				extendRefT = true;
			}
			else {
				throw new IncompatibleSizes();
			}
		}
		int sizeX = seq.getSizeX();
		int sizeY = seq.getSizeY();
		int sizeZ = seq.getSizeZ();
		int sizeT = seq.getSizeT();
		int sizeC = seq.getSizeC();
		makeDifferenceMap(ref, seq, out);
		for(int t=0; t<sizeT; ++t) {
			for(int z=0; z<sizeZ; ++z) {
				for(int c=0; c<sizeC; ++c) {
					controller.checkPoint();
					int t0 = extendRefT ? 0 : t;
					int z0 = extendRefZ ? 0 : z;
					double[] refPlane = getReadOnlyDataXYAsDouble(ref, t0, z0, c);
					double[] seqPlane = getReadOnlyDataXYAsDouble(seq, t , z , c);
					double[] outPlane = out.getDataXYAsDouble(t, z, c);
					computePlaneError(sizeX, sizeY, refPlane, seqPlane, outPlane);
				}
			}
		}
		out.dataChanged();
	}
}
