package plugins.spop.advancefilters;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginLibrary;
import icy.sequence.Sequence;

public class DiffusionTools extends Plugin implements PluginLibrary {
	
/**
 * Perona Malik rational function 
 * g(s)=1/(1+s*s/K*K)
 * 
 * @param in - first order derivative (Dx or Dy,..)
 * @param threshold - square of K threshold;
 *  
 */
	public static double PM_function(double in, double threshold)
    {
        return 1 / (1 + in * in / threshold);

    }
    
    public static double minmod(double x, double y)
    {
        double minmod, u;
        u = Math.abs(x) < Math.abs(y) ? Math.abs(x) : Math.abs(y);
        if ((x * y) <= 0)
            minmod = 0;
        else
            minmod = u * sign(x);
        return minmod;
    }

    public static double sign(double x)
    {
        double sign;
        if (x < 0)
            sign = -1;
        else if (x > 0)
            sign = 1;
        else
            sign = 0;
        return sign;
    }

    public static double sign_Gilboa(double x)
    {
        double sign;
        sign = 2 * Math.atan(x) / Math.PI;
        return sign;
    }
    
		
/**
 * Update 3D data
 * U(t+1)=div(D*gradU(t))
 *     a  d  e
 * D = d  b  f    - is the diffusion matrix
 *     e  f  c 
 */
	public static void Anisotropic_3d_update_Zres(double[][] input, double[][] a,double[][] b,double[][] c, double[][] d,double[][] e,double[][] f,int width, int height, int depth, double dt, double inv_hz,double[][] output)
	{
		int i,j,z=0, temp;
		double inter;
		for (z=1; z<depth-1; z++)
		{
			for (j=0; j<height; j++)
				for (i=0; i<width; i++)
				{
					temp=j*width+i;
					if((j==0)||(j==height-1)||(i==0)||(i==width-1))
						inter=0;
					else
					{
						inter=((a[z][temp-1]+a[z][temp])*input[z][temp-1]+(a[z][temp+1]+a[z][temp])*input[z][temp+1])*0.5;
						inter+=(-(a[z][temp-1]+2.0*a[z][temp]+a[z][temp+1])*input[z][temp])*0.5;
			
						inter+=((b[z][temp+width]+b[z][temp])*input[z][temp+width]+(b[z][temp-width]+b[z][temp])*input[z][temp-width])*0.5;
						inter+=(-(b[z][temp-width]+2.0*b[z][temp]+b[z][temp+width])*input[z][temp])*0.5;
			
						inter+=((c[z+1][temp]+c[z][temp])*input[z+1][temp]+(c[z-1][temp]+c[z][temp])*input[z-1][temp])*0.5*inv_hz;
						inter+=(-(c[z+1][temp]+c[z-1][temp]+2.0*c[z][temp])*input[z][temp])*0.5*inv_hz;
				
						inter+=((d[z][temp+width]+d[z][temp+1])*input[z][temp+width+1]+(d[z][temp-width]+d[z][temp-1])*input[z][temp-width-1])*0.25;
						inter+=(-(d[z][temp+width]+d[z][temp-1])*input[z][temp+width-1]-(d[z][temp-width]+d[z][temp+1])*input[z][temp-width+1])*0.25;
			
						inter+=((e[z+1][temp]+e[z][temp+1])*input[z+1][temp+1]+(e[z-1][temp]+e[z][temp-1])*input[z-1][temp-1])*0.25*inv_hz;
						inter+=(-(e[z+1][temp]+e[z][temp-1])*input[z+1][temp-1]-(e[z-1][temp]+e[z][temp+1])*input[z-1][temp+1])*0.25*inv_hz;
			
						inter+=((f[z][temp+width]+f[z+1][temp])*input[z+1][temp+width]+(f[z][temp-width]+f[z-1][temp])*input[z-1][temp-width])*0.25*inv_hz;
						inter+=(-(f[z][temp-width]+f[z+1][temp])*input[z+1][temp-width]-(f[z][temp+width]+f[z-1][temp])*input[z-1][temp+width])*0.25*inv_hz;
						
										
					}
					output[z][temp]=input[z][temp]+dt*inter;
				}
		}
		
	}
	/**
	 * 
	 * @param x - eigenvalues difference square
	 * @param C - range; default : 1; 
	 * @param alpha - positive near 0 value
	 * @return - a value in the interval [alpha, 1] which represents the amount of diffusivity
	 */
	static double g_Weickert_CED(double x, double C, double alpha)
	{
		double f=0;
		if(x==0)
			f=alpha;
		else
			f=alpha+(1-alpha)*Math.exp(-C/x);
		return f;
	}
	/**
	* Eigenvalues of a symmetric 3*3 matrix
	* 	Matrix= a d e
	* 		    d b f
	*		    e f c
	* 
	 * @input a,b,c,d,e,f
	 * @output x - decreasing ordered eigenvalues x[0]>x[1]>x[2]
	 * 
	 * 
	 * 3rd degree equation - Cardan solution
	*	x^3-(a+b+c)*x^2+(a*b+a*c+b*c-e*e-f*f-d*d)*x+(d*d*c+e*e*b+f*f*a-2*d*e*f-a*b*c)=0
	*		   a2				a1								a0
	*
	*	p=(3*a1-a2*a2)/3
	*	q=(2*a2*a2*a2+27*a0-9*a1*a2)/27
	*	x=X-a2/3;
	*	=> X^3+ p*X+ q=0	
	 */

	static void eigenvalues_computation(double a,double b,double c,double d,double e,double f, double[] x)
	{
			
		double X_27=0.037037037,X_3=0.333333333;
		double PI;
		double r,fi,p,q,delta;
		PI=Math.PI;
		delta=a+b+c;
		fi=a*b+a*c+b*c-e*e-f*f-d*d;

		p=(3.0*fi-delta*delta)*X_3;
		q=(-2.0*delta*delta*delta+27.0*(d*d*c+e*e*b+f*f*a-2.0*d*e*f-a*b*c)+9.0*delta*fi)*X_27;

		delta=q*q+4.0*p*p*p*X_27;
		
				if(delta>0) 
				{
					//r=-q*0.5;
					//fi=PI;
					delta=Math.sqrt(delta);
					r=(-q-delta)/2;
					q=(-q+delta)/2;
					if(q<0&&p<0) 
						q=p=0;
					else
					{
						q=Math.pow(q,X_3);
						r=Math.pow(r,X_3);	

						
						x[0]=r+q;
						x[1]=-r;
						x[2]=-q;
					}
				
				}
				else
				{	
					if(p>=0)
						r=0.001;
					else
						r=Math.sqrt(-p*p*p*X_27);

					fi=-q/(2.0*r);
					
					if(fi>1)
						fi=0;
					if(fi<-1)
						fi=PI;

					fi=Math.acos(fi);
					
					x[0]=Math.pow(r,X_3)*Math.cos(fi*X_3)*2.0;
					x[1]=Math.pow(r,X_3)*Math.cos((fi+2*PI)*X_3)*2.0;
					x[2]=Math.pow(r,X_3)*Math.cos((fi+4*PI)*X_3)*2.0;

				}
				if(r<=0)
				{
					r=-r;
				}

			
			
			

		delta=(a+b+c)*X_3;
		if(x[0]!=x[0])
			x[0]=delta;
		else
			x[0]+=delta;
		
		if(x[1]!=x[1])// NaN value test
			x[1]=delta;
		else
			x[1]+=delta;
		
		if(x[2]!=x[2])
			x[2]=delta;
		else
			x[2]+=delta;
		//put the values in a decreasing order, x[0]-the biggest value
		if(Math.abs(x[0])<Math.abs(x[1])){
			p=x[0];
			x[0]=x[1];
			x[1]=p;
		
		}
		if(Math.abs(x[1])<Math.abs(x[2])){
			p=x[1];
			x[1]=x[2];
			x[2]=p;
			
		}
		if(Math.abs(x[0])<Math.abs(x[1])){
			p=x[0];
			x[0]=x[1];
			x[1]=p;
			
		}
	}

/**
 * Eigenvector computation of a 3*3 symmetric matrix
 * Matrix= a d e
 * 		   d b f
 *		   e f c
 * @input a,b,c,d,e,f -matrix coefficients 
 * @input lambda - input of eigenvalues
 * @output x - eigenvectors 
 * 
 * Ex : first eigenvector corresponding to the first eigenvalue lambda[0] is
 *      V1=[x[0],x[1],x[2]]  : x[0] - component on X axis; x[1] - component on Y axis; x[2] - component on Z axis; 
 * the third eigenvector corresponding to the third eigenvalue lambda[2] is
 *  	V3=[x[6],x[7],x[8]]
 */
	static void eigenvectors_computation(double a,double b,double c,double d,double e,double f, double[] lambda, double[] x)
	{
		//
		//    
		double det1,det2,det3,det4,det5,det6,sum;
		int i,j;
		double a1,b1,c1;
		
		sum=a+b+c+d+e+f;
		for(i=0;i<3;i++)
		{
			j=3*i;
			a1=a-lambda[i];//lambda[0]-first eigenvalue
			b1=b-lambda[i];
			c1=c-lambda[i];

			//the matrix minors
			//for a  3*3 symmetric matrix there are 6 different minors
			det1=a1*b1-d*d;
			det2=b1*c1-f*f;
			det3=a1*c1-e*e;
			det4=f*d-b1*e;
			det5=a1*f-d*e;
			det6=d*c1-e*f;


			if(det1!=0)
			{
				(x[j+2])=sum;
				(x[j+0])=(x[j+2])*det4/det1;
				(x[j+1])=-(x[j+2])*det5/det1;
			}
			else{
				if(det2!=0)
				{
					(x[j+0])=sum;
					(x[j+1])=-(x[j+0])*det6/det2;
					(x[j+2])=(x[j+0])*det4/det2;
				}
				else{
					if(det3!=0)
					{
						(x[j+1])=sum;
						(x[j+0])=-(x[j+1])*det6/det3;
						(x[j+2])=-(x[j+1])*det5/det3;
					}
					else{
						if(det4!=0)
						{
							(x[j+0])=sum;
							(x[j+1])=-(x[j+0])*det5/det4;
							(x[j+2])=(x[j+0])*det1/det4;
						}
						else{
							if(det5!=0)
							{
								(x[j+2])=sum;
								(x[j+0])=(x[j+2])*det6/det5;
								(x[j+1])=-(x[j+2])*det3/det5;
							}
							else{
								if(det6!=0)
								{
									(x[j+1])=sum;
									(x[j+0])=-(x[j+1])*det2/det6;
									(x[j+2])=-(x[j+1])*det4/det6;
								}
								else{
									if(e!=0)
									{
										(x[j+1])=sum;
										(x[j+0])=(x[j+1]);
										(x[j+2])=((a-lambda[i])*(x[j+0])+d*(x[j+1]))/e;
									}
								else{
									(x[j+1])=sum;
									(x[j+0])=sum;
									(x[j+2])=sum;//all are 0

									}
								}
							}
						}
					}
				}
			}

			det1=(x[j+0])*(x[j+0])+(x[j+1])*(x[j+1])+(x[j+2])*(x[j+2]);//norm
			if(det1!=0)
			{
				det1=Math.sqrt(det1);
				det1=1/det1;
				(x[j+0])=(x[j+0])*det1;
				(x[j+1])=(x[j+1])*det1;
				(x[j+2])=(x[j+2])*det1;
			}
		}

	}
	
/**
 *  
 * @param input - current image; dimension : [width*height]; 
 * @param a - first diagonal component of structure tensor; dimension : [width*height]; 
 * @param b - second diagonal component of structure tensor; dimension : [width*height]; 
 * @param c - 12 or 21 component of structure tensor; dimension : [width*height]; 
 * @param width
 * @param height 
 * @param dt - iteration step
 * @param alpha - diffusion function parameter
 * @param C - diffusion function parameter
 * @param output - image after one iteration
	 */
    public static void Weickert_core_2D(double[] input, double[] a,double[] b,double[] c,int width, int height, double dt, double alpha, double C, double[] output)
	{
		int i, j,  temp;
		double x1,x2,y1,y2;
		double current;
		double norm1,lambda;//, lambda1, lambda2;
		
		double  inter=0;
		double  co;
		double a1, b1, c1;
		
		for (temp=0; temp<height*width; temp++)
			{
			
				//structure tensor components
				a1=a[temp];
				b1=b[temp];
				c1=c[temp];
		
				co=Math.sqrt((a1-b1)*(a1-b1)+4*c1*c1);			
				norm1=Math.sqrt((co-a1+b1)*(co-a1+b1)+4*c1*c1);
			
				//1st eigenvector computation
				if(norm1!=0)
				{
					
					y1=(co-a1+b1)/norm1;
					x1=2*c1/norm1;
				}
				else
				{
					x1=1;
					y1=0;
				}
				//2nd eigenvector
				x2=-y1;
				y2=x1;
				// amount of diffusion in the structure direction
				lambda=DiffusionTools.g_Weickert_CED(co*co,C,alpha);
				//compute of the diffusion matrix components
				a[temp]=alpha*x1*x1+lambda*x2*x2;
				b[temp]=alpha*x1*y1+lambda*x2*y2;
				c[temp]=alpha*y1*y1+lambda*y2*y2;
					
	
			}
		// image update based on current image and diffusion matrix	
		for (j=1; j<height-1; j++)
			for (i=1; i<width-1; i++)
			{
				temp=j*width+i;
				current=input[temp];
							
				inter=(-(a[temp-1]+2*a[temp]+a[temp+1])*current)*0.5;
				inter+=(-(c[temp-width]+2*c[temp]+c[temp+width])*current)*0.5;
	
				inter+=((b[temp-1]+b[temp-width])*input[temp-width-1]+(b[temp+1]+b[temp+width])*input[temp+width+1])*0.25;
				inter+=(-(b[temp-1]+b[temp+width])*input[temp+width-1]-(b[temp+1]+b[temp-width])*input[temp-width+1])*0.25;
	
				inter+=((a[temp-1]+a[temp])*input[temp-1]+(a[temp+1]+a[temp])*input[temp+1])*0.5;
				inter+=((c[temp+width]+c[temp])*input[temp+width]+(c[temp-width]+c[temp])*input[temp-width])*0.5;
	
				output[temp]=current+dt*inter;
				inter=0;
			}
		
	}
/**
 * 
 * @param input - current data; dimension : [depth][width*height]; 
 * @param a - first diagonal component of structure tensor; dimension : [depth][width*height]; 
 * @param b - second diagonal component of structure tensor; dimension : [depth][width*height]; 
 * @param c - third diagonal component of structure tensor; dimension : [depth][width*height]; 
 * @param d - 12 or 21 component of structure tensor; dimension : [depth][width*height];
 * @param e - 13 or 31 component of structure tensor; dimension : [depth][width*height];
 * @param f - 23 or 32 component of structure tensor; dimension : [depth][width*height];
 * @param width
 * @param height 
 * @param depth
 * @param dt - iteration step
 * @param alpha - diffusion function parameter
 * @param C - diffusion function parameter
 * @param coh_type - 0: CED1D or 1: CED2D
 * @param hz_inv - X/Z resolution ratio
 * @param output - data after one iteration
 */
    public static void Weickert_core_3D(double[][] input, double[][] a,double[][] b,double[][] c, double[][] d,double[][] e,double[][] f,int width, int height, int depth, double dt, double alpha, double C, int coh_type, double hz_inv,double[][] output)
    {
    	int z, temp;
    	
    	double  lambda2=0, lambda=0,coW,lambdaalpha=0;
    	double val0,val1,val2;
    	double a1, b1, c1, d1, e1, f1;
    	
    	double[] valeur=new double[3];
    	double[] vector=new double[9];
    	
    	for (z=0; z<depth; z++)
    	{
    		for (temp=0; temp<height*width; temp++)    	
			{
			
		
				a1=a[z][temp];
				b1=b[z][temp];
				c1=c[z][temp];
				d1=d[z][temp];
				e1=e[z][temp];
				f1=f[z][temp];
				
				eigenvalues_computation(a1, b1, c1, d1, e1, f1,valeur);
				eigenvectors_computation(a1, b1, c1, d1, e1, f1,valeur,vector);
				val0=Math.abs(valeur[0]);
				val1=Math.abs(valeur[1]);
				val2=Math.abs(valeur[2]);
				//coherence value
				coW=(val0-val1)*(val0-val1)+(val0-val2)*(val0-val2)+(val2-val1)*(val2-val1);
				//lambda - amount of diffusion in the most homogeneous direction
				lambda=DiffusionTools.g_Weickert_CED(coW,C,alpha);
				//lambdaalpha - amount of diffusion in the mean gradient direction
				lambdaalpha=alpha;
				//lambda2 - amount of diffusion in the other orthogonal direction ( 2nd eigenvector direction)
				lambda2=alpha;
				switch(coh_type)
				{
		            case 0:
			            {//Weickert 1D
	    					lambda2=alpha;					
	    				}
		                break;
		            
		            case 1:
			            {//Weickert 2D
	    					lambda2=lambda;					
	    				}
		                break;
    			}
				//update of the diffusion matrix components
				a[z][temp]=lambdaalpha*vector[0]*vector[0]+lambda2*vector[3]*vector[3]+lambda*vector[6]*vector[6];
				b[z][temp]=lambdaalpha*vector[1]*vector[1]+lambda2*vector[4]*vector[4]+lambda*vector[7]*vector[7];
				c[z][temp]=lambdaalpha*vector[2]*vector[2]+lambda2*vector[5]*vector[5]+lambda*vector[8]*vector[8];
				d[z][temp]=lambdaalpha*vector[0]*vector[1]+lambda2*vector[3]*vector[4]+lambda*vector[6]*vector[7];
				e[z][temp]=lambdaalpha*vector[0]*vector[2]+lambda2*vector[3]*vector[5]+lambda*vector[6]*vector[8];
				f[z][temp]=lambdaalpha*vector[1]*vector[2]+lambda2*vector[4]*vector[5]+lambda*vector[7]*vector[8];
					
	
			}
    	}
    	// update of the 3D data based on the diffusion matrix components
    	Anisotropic_3d_update_Zres(input,a,b,c,d,e,f,width,height,depth,dt,hz_inv, output);

    }

    static double[] fonction_Terebes_LUT(double gamma, double t)
	{
		double[] sortie=new double[1001];
		for(int i=0;i<1001;i++)
		{
			sortie[i]=Math.tanh(gamma*(1.0-t))+1;
			
			if(sortie[i]!=0) 
				sortie[i]=(Math.tanh(gamma*(((double)i/1000)-t))+1)/sortie[i];
		}
		return sortie;
	}
    
    static public Sequence extractT(Sequence in, int t)
	{
		Sequence out = new Sequence();
		out=in.getSubSequence(0, 0, 0, t, in.getSizeX(), in.getSizeY(), in.getSizeZ(), 1);
		return out;
	}
	static public void putT(Sequence in, Sequence toPut, int t)
	{
		//in.beginUpdate();
		for(int z=0;z<toPut.getSizeZ();z++)
			in.setImage(t, z, toPut.getImage(0, z));	
		//in.endUpdate();
	}
	
	public static double PM_function_fluxDerive(double in, double threshold)
    {
		in=in * in;
		double denom=(1 + in  / threshold);
		
        return 1 /denom  - (2*in)/(threshold*denom*denom);

    }

}
