/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.particletracking;

import icy.gui.dialog.MessageDialog;
import icy.gui.frame.IcyFrame;
import icy.gui.frame.IcyInternalFrame;
import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.frame.progress.ProgressFrame;
import icy.image.ImageUtil;
import icy.main.Icy;
import icy.plugin.abstract_.PluginActionable;
import icy.resource.ResourceUtil;
import icy.sequence.Sequence;
import icy.swimmingPool.SwimmingObject;
import icy.system.IcyExceptionHandler;
import icy.system.SystemUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import lpsolve.LpSolve;
import plugins.fab.trackmanager.TrackGroup;
import plugins.fab.trackmanager.TrackManager;
import plugins.fab.trackmanager.TrackSegment;
import plugins.nchenouard.particletracking.DetectionSpotTrack;
import plugins.nchenouard.particletracking.MHTparameterSet;
import plugins.nchenouard.particletracking.SpotTracking;
import plugins.nchenouard.particletracking.gui.TrackingMainPanel;
import plugins.nchenouard.particletracking.legacytracker.StoppableTracker;
import plugins.nchenouard.particletracking.legacytracker.Tracker;
import plugins.nchenouard.particletracking.legacytracker.associationMethod.InstantaneousTracker;
import plugins.nchenouard.particletracking.legacytracker.associationMethod.Track;
import plugins.nchenouard.particletracking.legacytracker.gui.PanelTracking;
import plugins.nchenouard.particletracking.simplifiedMHT.SimplifiedMHTPanel;
import plugins.nchenouard.spot.DetectionResult;
import plugins.nchenouard.spot.Spot;

public class SpotTrackingPlugin
extends PluginActionable
implements ActionListener {
    GUIStateEnum currentGUISate = GUIStateEnum.SIMPLE;
    IcyFrame mainFrame;
    JMenuBar menuBar;
    JMenu guiMenu;
    JMenu fileMenu;
    JMenu infoMenu;
    JMenuItem menuItem;
    JPanel mainPanel;
    final String SIMPLEGUI = "Simple interface";
    final String ADVANCEDGUI = "Avanced interface";
    final String LEGACYGUI = "Legacy plugin";
    TrackingMainPanel advancedGUIPanel;
    SimplifiedMHTPanel simpleGUIPanel;
    PanelTracking legacyGUIPanel;
    LegacyTrackerManager legacyTrackerManager;
    public MHTrackerManager mhTrackerManager;
    MHTparameterSet mhtParameterSet = null;
    boolean defaultParameterSet = true;
    Thread computationThread = null;
    ProgressFrame trackingAnnounce;
    public static boolean optimizationLibraryLoaded = false;
    boolean useMultithreading = true;
    boolean useLPSolve = false;

    public SpotTrackingPlugin() {
        if (!optimizationLibraryLoaded) {
            try {
                if (!this.loadLibrary("lpsolve55")) {
                    System.err.println("lpsolve55 cannot be loaded !");
                    throw new Exception("lpsolve55 cannot be loaded !");
                }
                File libFile = this.extractLibrary("lpsolve55j");
                if (libFile == null) {
                    System.err.println("lpsolve55j cannot be extracted !");
                    throw new Exception("lpsolve55j cannot be extracted !");
                }
                LpSolve.initLib(libFile);
            }
            catch (Exception | UnsatisfiedLinkError e) {
                IcyExceptionHandler.showErrorMessage((Throwable)e, (boolean)true);
                if (!Icy.getMainInterface().isHeadLess()) {
                    MessageDialog.showDialog((String)"Warning", (String)("The lpsolve55 optimization library has failed to load:\n" + e.getMessage()), (int)2);
                }
                return;
            }
            optimizationLibraryLoaded = true;
        }
    }

    public File extractLibrary(String libName) {
        try {
            String mappedlibName = System.mapLibraryName(libName);
            String basePath = this.getResourceLibraryPath() + "/";
            URL libUrl = this.getResource(basePath + mappedlibName);
            if (libUrl == null) {
                if (mappedlibName.endsWith(".jnilib")) {
                    mappedlibName = mappedlibName.substring(0, mappedlibName.length() - 7) + ".dylib";
                    libUrl = this.getResource(basePath + mappedlibName);
                } else if (mappedlibName.endsWith(".dylib")) {
                    mappedlibName = mappedlibName.substring(0, mappedlibName.length() - 6) + ".jnilib";
                    libUrl = this.getResource(basePath + mappedlibName);
                }
            }
            if (libUrl == null) {
                throw new IOException("Couldn't find resource " + basePath + mappedlibName);
            }
            return this.extractResource(SystemUtil.getTempLibraryDirectory() + "/" + mappedlibName, libUrl);
        }
        catch (IOException e) {
            System.err.println("Error while extracting library " + libName + ": " + e);
            return null;
        }
    }

    public void run() {
        this.mhTrackerManager = new MHTrackerManager();
        this.mainPanel = new JPanel();
        this.mainFrame = new IcyFrame("Spot Tracking", true, true, true, true);
        this.mainFrame.getContentPane().add(this.mainPanel);
        this.mainPanel.setLayout(new BorderLayout());
        int iconSize = 100;
        ImageIcon detectionIcon = ResourceUtil.getImageIcon((Image)ImageUtil.load((InputStream)this.getResourceAsStream("plugins/nchenouard/particletracking/simplifiedMHT/detectionIcon.png")), (int)iconSize);
        ImageIcon mhtIcon = ResourceUtil.getImageIcon((Image)ImageUtil.load((InputStream)this.getResourceAsStream("plugins/nchenouard/particletracking/simplifiedMHT/MHTIcon.png")), (int)iconSize);
        ImageIcon outputIcon = ResourceUtil.getImageIcon((Image)ImageUtil.load((InputStream)this.getResourceAsStream("plugins/nchenouard/particletracking/simplifiedMHT/trackPoolIcon.png")), (int)iconSize);
        ImageIcon workingIcon = ResourceUtil.getImageIcon((Image)ImageUtil.load((InputStream)this.getResourceAsStream("plugins/nchenouard/particletracking/simplifiedMHT/workingIcon.png")), (int)iconSize);
        this.simpleGUIPanel = new SimplifiedMHTPanel(detectionIcon, mhtIcon, outputIcon, workingIcon);
        this.mainPanel.add((Component)this.simpleGUIPanel, "Center");
        this.simpleGUIPanel.loadParametersButton.addActionListener(this);
        this.simpleGUIPanel.runTrackingButton.addActionListener(this.mhTrackerManager);
        this.simpleGUIPanel.detectionChooser.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (SpotTrackingPlugin.this.simpleGUIPanel.detectionChooser.getSelectedDetectionResult() != null && SpotTrackingPlugin.this.mhtParameterSet != null) {
                    SpotTrackingPlugin.this.mhtParameterSet.detectionResults = SpotTrackingPlugin.this.simpleGUIPanel.detectionChooser.getSelectedDetectionResult();
                }
            }
        });
        this.simpleGUIPanel.trackGroupNameTF.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                SpotTrackingPlugin.this.mhtParameterSet.trackGroupName = SpotTrackingPlugin.this.simpleGUIPanel.trackGroupNameTF.getText();
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.simpleGUIPanel.estimateParametersButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SpotTrackingPlugin.this.estimateTrackingParameters();
            }
        });
        this.advancedGUIPanel = new TrackingMainPanel();
        this.advancedGUIPanel.startTrackingButton.addActionListener(this.mhTrackerManager);
        this.advancedGUIPanel.configFilePanel.exportConfigurationFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpotTrackingPlugin.this.mhtParameterSet = SpotTrackingPlugin.this.advancedGUIPanel.getParameterSet();
                SpotTrackingPlugin.this.exportConfiguration();
            }
        });
        this.advancedGUIPanel.configFilePanel.loadConfigurationFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpotTrackingPlugin.this.loadMHTParameters();
            }
        });
        this.refreshMainPanel(this.currentGUISate);
        this.legacyGUIPanel = new PanelTracking();
        this.legacyTrackerManager = new LegacyTrackerManager(this.legacyGUIPanel);
        this.menuBar = new JMenuBar();
        this.mainFrame.setJMenuBar(this.menuBar);
        this.fileMenu = new JMenu("File");
        this.menuBar.add(this.fileMenu);
        JMenuItem saveConfigurationItem = new JMenuItem("Save parameters");
        this.fileMenu.add(saveConfigurationItem);
        saveConfigurationItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpotTrackingPlugin.this.exportConfiguration();
            }
        });
        JMenuItem loadConfigurationItem = new JMenuItem("Load parameters");
        this.fileMenu.add(loadConfigurationItem);
        loadConfigurationItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpotTrackingPlugin.this.loadMHTParameters();
            }
        });
        JMenuItem configurationItem = new JMenuItem("Plugin configuration");
        this.fileMenu.add(configurationItem);
        configurationItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String title = "Plugin configuration";
                boolean resizable = false;
                boolean closable = true;
                boolean maximizable = false;
                boolean iconifiable = true;
                final IcyInternalFrame configFrame = new IcyInternalFrame(title, resizable, closable, maximizable, iconifiable);
                JPanel configFramePanel = new JPanel();
                configFrame.setContentPane((Container)configFramePanel);
                configFramePanel.setLayout(new GridLayout(3, 1));
                final JCheckBox multithreadingBox = new JCheckBox("Multithreaded computation.");
                multithreadingBox.setSelected(SpotTrackingPlugin.this.useMultithreading);
                final JCheckBox lpSolveBox = new JCheckBox("Optimization library in C (faster).");
                lpSolveBox.setSelected(SpotTrackingPlugin.this.useLPSolve);
                JButton closeButton = new JButton("Apply");
                configFramePanel.add(multithreadingBox);
                configFramePanel.add(lpSolveBox);
                configFramePanel.add(closeButton);
                closeButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SpotTrackingPlugin.this.useMultithreading = multithreadingBox.isSelected();
                        SpotTrackingPlugin.this.useLPSolve = lpSolveBox.isSelected();
                        configFrame.close(false);
                    }
                });
                configFrame.pack();
                configFrame.setVisible(true);
                Icy.getMainInterface().addToDesktopPane((JInternalFrame)configFrame);
            }
        });
        this.guiMenu = new JMenu("Interface");
        this.menuBar.add(this.guiMenu);
        JMenuItem simplifiedGUIItem = new JMenuItem("Simple interface");
        this.guiMenu.add(simplifiedGUIItem);
        simplifiedGUIItem.addActionListener(this);
        JMenuItem advancedGUIItem = new JMenuItem("Avanced interface");
        this.guiMenu.add(advancedGUIItem);
        advancedGUIItem.addActionListener(this);
        JMenuItem legacyInterfaceItem = new JMenuItem("Legacy plugin");
        this.guiMenu.add(legacyInterfaceItem);
        legacyInterfaceItem.addActionListener(this);
        this.infoMenu = new JMenu("Info");
        this.menuBar.add(this.infoMenu);
        JMenuItem manualItem = new JMenuItem("Manual");
        this.infoMenu.add(manualItem);
        manualItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IcyFrame manualFrame = new IcyFrame("Spot Tracking Plugin Manual");
                manualFrame.setResizable(true);
                manualFrame.setClosable(true);
                JEditorPane descriptionPane = new JEditorPane();
                descriptionPane.setEditable(false);
                descriptionPane.setContentType("text/html");
                descriptionPane.setText("<html><p>For a full description, please read the <a href=http://icy.bioimageanalysis.org/plugin/Spot_Tracking#documentation>online manual</a> on ICY website:<br> http://icy.bioimageanalysis.org/plugin/Spot_Tracking#documentation<p><b>Quick description:</b><br><html>The usual way of using the software is to follow indications given by the interface from top to bottom.<br> Tool tip text on each graphical element gives useful information about the use.<br>In general, the following sequence of operations will be performed: <ol><li>Select a set of locations in space and over time (detections) for the spots to track.<br> This can be done with the Spot Detector plugin. (Section 1)</li> <li>Estimate parameters for the tracking steps or load a set of existing parameters from a local file. (Section 2)</li><li>Specify a unique name for the tracking results. (Section 3)</li><li>Run the track construction process. (Section 4)</li><li>Analyze and save tracking results with the Track Manager plugin.</li><li>Save the tracking parameters via the File menu of the plugin for future re-use.</li></ol><br>Exhaustive control of the tracking parameters is accessible by switching to the advanced interface.<br> (Menu Interface/Advanced Interface).</html>");
                manualFrame.setContentPane((Container)descriptionPane);
                manualFrame.pack();
                SpotTrackingPlugin.this.addIcyFrame(manualFrame);
                manualFrame.setVisible(true);
            }
        });
        JMenuItem aboutItem = new JMenuItem("About");
        this.infoMenu.add(aboutItem);
        aboutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                IcyFrame aboutFrame = new IcyFrame("About Spot Tracking Plugin");
                aboutFrame.setResizable(true);
                aboutFrame.setClosable(true);
                JEditorPane descriptionPane = new JEditorPane();
                descriptionPane.setEditable(false);
                descriptionPane.setContentType("text/html");
                descriptionPane.setText("<html><p>The Spot Tracking Plugin is a essentially an implementation of the methods described in the article:<br>Nicolas Chenouard, Isabelle Bloch, Jean-Christophe Olivo-Marin,<br> <b>Multiple Hypothesis Tracking for Cluttered Biological Image Sequences</b>, <br>IEEE Transactions on Pattern Analysis and Machine Intelligence, vol. 35, no. 11, pp. 2736-3750, Nov., 2013<br>Pubmed link: http://www.ncbi.nlm.nih.gov/pubmed/23689865<br><p>By using the software for data analysis you agree to properly cite and reference this work<br> in any communication regarding results obtained by using it.<br><p>Author: Nicolas Chenouard. Institut Pasteur, Paris, France.<br>Version 3.1, 2013-11-13.</html>");
                aboutFrame.setContentPane((Container)descriptionPane);
                aboutFrame.pack();
                SpotTrackingPlugin.this.addIcyFrame(aboutFrame);
                aboutFrame.setVisible(true);
            }
        });
        this.mainFrame.pack();
        this.mainFrame.addToDesktopPane();
        this.mainFrame.center();
        this.mainFrame.setVisible(true);
        this.mainFrame.requestFocus();
        this.defaultParameterSet = true;
        this.simpleGUIPanel.setUsingDefaultParameters(this.defaultParameterSet);
    }

    private void refreshMHTParameterSetFromGUI() {
        MHTparameterSet parameters;
        if (this.advancedGUIPanel != null && (parameters = this.advancedGUIPanel.getParameterSet()) != null) {
            this.mhtParameterSet = parameters;
            this.simpleGUIPanel.setParameter(this.mhtParameterSet);
            this.defaultParameterSet = false;
            this.simpleGUIPanel.setUsingDefaultParameters(this.defaultParameterSet);
        }
    }

    private void setMHTParameterSetToGUI() {
        if (this.advancedGUIPanel != null && this.mhtParameterSet != null) {
            this.advancedGUIPanel.setParameterset(this.mhtParameterSet);
            this.simpleGUIPanel.setParameter(this.mhtParameterSet);
            this.defaultParameterSet = false;
        }
    }

    private void refreshMainPanel(GUIStateEnum guiState) {
        this.mainPanel.removeAll();
        switch (guiState) {
            case ADVANCED: {
                this.setMHTParameterSetToGUI();
                this.mainPanel.add((Component)this.advancedGUIPanel, "Center");
                break;
            }
            case LEGACY: {
                this.mainPanel.add((Component)this.legacyGUIPanel, "Center");
                break;
            }
            case SIMPLE: {
                this.refreshMHTParameterSetFromGUI();
                this.mainPanel.add((Component)this.simpleGUIPanel, "Center");
                break;
            }
        }
        this.mainFrame.pack();
        this.mainFrame.updateUI();
        this.currentGUISate = guiState;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JMenuItem) {
            if (((JMenuItem)e.getSource()).getText().equals("Simple interface")) {
                this.refreshMainPanel(GUIStateEnum.SIMPLE);
            }
            if (((JMenuItem)e.getSource()).getText().equals("Avanced interface")) {
                this.refreshMainPanel(GUIStateEnum.ADVANCED);
            }
            if (((JMenuItem)e.getSource()).getText().equals("Legacy plugin")) {
                this.refreshMainPanel(GUIStateEnum.LEGACY);
            }
        }
        if (e.getSource() == this.simpleGUIPanel.loadParametersButton) {
            this.loadMHTParameters();
        }
    }

    public void loadMHTParameters() {
        MHTparameterSet parameters = this.loadConfiguration();
        if (parameters != null) {
            parameters.detectionResults = this.mhtParameterSet.detectionResults;
            this.mhtParameterSet = parameters;
            this.setMHTParameterSetToGUI();
        }
    }

    public void exportConfiguration() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "XML file filter";
            }

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().endsWith(".xml");
            }
        });
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setName("Output xml file selection");
        int returnVal = fileChooser.showOpenDialog(this.mainPanel);
        if (returnVal == 0) {
            String path = fileChooser.getSelectedFile().getAbsolutePath();
            if (!path.toLowerCase().endsWith(".xml")) {
                path = path + ".xml";
            }
            SpotTracking.saveParameters(this.mhtParameterSet, path);
        }
    }

    public MHTparameterSet loadConfiguration() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "XML file filter";
            }

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().endsWith(".xml");
            }
        });
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setName("Input xml file selection");
        int returnVal = fileChooser.showOpenDialog(this.mainPanel);
        if (returnVal == 0) {
            File file = fileChooser.getSelectedFile();
            return SpotTracking.loadParameters(file);
        }
        return null;
    }

    public static void sendTracksToPool(final TrackGroup trackGroup, final Sequence sequence) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwimmingObject result = new SwimmingObject((Object)trackGroup);
                Icy.getMainInterface().getSwimmingPool().add(result);
                TrackManager manager = new TrackManager();
                if (sequence != null) {
                    manager.setDisplaySequence(sequence);
                }
                new AnnounceFrame("Tracking results exported to Track manager plugin");
            }
        });
    }

    static double squaredDistance(Spot s1, Spot s2) {
        return SpotTracking.squaredDistance(s1, s2);
    }

    public void estimateTrackingParameters() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ParameterEstimationFrame estimationFrame = new ParameterEstimationFrame();
                SpotTrackingPlugin.this.addIcyFrame(estimationFrame);
                estimationFrame.setVisible(true);
            }
        });
    }

    public void estimateParameters(boolean isDirectedMotion, boolean isSingleMotion, boolean isUpdateMotion) {
        SpotTracking.estimateParameters(this.mhtParameterSet, this.mhtParameterSet.detectionResults, isDirectedMotion, isSingleMotion, isUpdateMotion);
        this.setMHTParameterSetToGUI();
    }

    private static enum GUIStateEnum {
        ADVANCED,
        SIMPLE,
        LEGACY;

    }

    public class MHTrackerManager
    implements ActionListener {
        volatile boolean isRunning = false;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == SpotTrackingPlugin.this.advancedGUIPanel.startTrackingButton || e.getSource() == SpotTrackingPlugin.this.simpleGUIPanel.runTrackingButton) {
                if (e.getSource() == SpotTrackingPlugin.this.advancedGUIPanel.startTrackingButton) {
                    SpotTrackingPlugin.this.mhtParameterSet = SpotTrackingPlugin.this.advancedGUIPanel.getParameterSet();
                }
                this.startSoppableMHTracking();
            }
        }

        public void startSoppableMHTracking() {
            if (this.isRunning) {
                return;
            }
            SpotTrackingPlugin.this.computationThread = new Thread(){

                @Override
                public void run() {
                    MHTrackerManager.this.isRunning = true;
                    MHTrackerManager.this.enableTracking(false);
                    try {
                        TrackGroup result = SpotTracking.executeTracking(SpotTrackingPlugin.this.mhtParameterSet, SpotTrackingPlugin.this.mhtParameterSet.detectionResults, SpotTrackingPlugin.this.useLPSolve, SpotTrackingPlugin.this.useMultithreading, true);
                        SpotTrackingPlugin.sendTracksToPool(result, result.getSequence());
                    }
                    catch (IllegalArgumentException e) {
                        new AnnounceFrame(e.getMessage());
                        return;
                    }
                    finally {
                        MHTrackerManager.this.isRunning = false;
                        MHTrackerManager.this.enableTracking(true);
                    }
                }
            };
            SpotTrackingPlugin.this.computationThread.start();
        }

        private void enableTracking(final boolean isEnableTracking) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpotTrackingPlugin.this.simpleGUIPanel.changeTrackingState(!isEnableTracking);
                    SpotTrackingPlugin.this.advancedGUIPanel.changeTrackingState(!isEnableTracking);
                }
            });
        }

        private void startMHTracking() {
            SpotTrackingPlugin.this.computationThread = new Thread(){

                @Override
                public void run() {
                    MHTrackerManager.this.isRunning = true;
                    try {
                        TrackGroup result = SpotTracking.executeTracking(SpotTrackingPlugin.this.mhtParameterSet, SpotTrackingPlugin.this.mhtParameterSet.detectionResults, true);
                        SpotTrackingPlugin.sendTracksToPool(result, result.getSequence());
                    }
                    catch (IllegalArgumentException e) {
                        new AnnounceFrame(e.getMessage());
                        return;
                    }
                    finally {
                        MHTrackerManager.this.isRunning = false;
                        MHTrackerManager.this.enableTracking(true);
                    }
                }
            };
            SpotTrackingPlugin.this.computationThread.start();
        }
    }

    class LegacyTrackerManager
    implements ActionListener {
        private StoppableTracker runningTracker = null;
        private boolean stopTracking = false;
        private boolean isRunning = false;
        private Thread runningThread = null;
        private Lock stopLock = new ReentrantLock();
        private Condition stopCondition = this.stopLock.newCondition();
        PanelTracking panelTracking;

        public LegacyTrackerManager(PanelTracking legacyGUIPanel) {
            legacyGUIPanel.trackingStartButton.addActionListener(this);
            this.panelTracking = legacyGUIPanel;
        }

        private void enableTracking(final boolean isEnableTracking) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LegacyTrackerManager.this.panelTracking.changeTrackingState(!isEnableTracking);
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.panelTracking.trackingStartButton) {
                if (this.isRunning) {
                    this.stopLock.lock();
                    if (this.runningTracker != null) {
                        this.runningTracker.stopComputing();
                    }
                    this.stopTracking = true;
                    try {
                        while (this.isRunning) {
                            this.stopCondition.await();
                        }
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                    finally {
                        this.stopLock.unlock();
                    }
                    this.stopTracking = false;
                } else {
                    DetectionResult detections = this.panelTracking.getDetectionResults();
                    if (detections != null) {
                        this.enableTracking(false);
                        this.executeTracking(detections, detections.getSequence());
                    } else {
                        new AnnounceFrame("Please first select a detection set.");
                    }
                }
            }
        }

        public synchronized void executeTracking(final DetectionResult detections, final Sequence sequence) {
            if (detections != null) {
                Thread trackThread;
                this.isRunning = true;
                this.runningThread = trackThread = new Thread(){

                    @Override
                    public void run() {
                        Tracker tracker;
                        int dim = 2;
                        if (sequence.getSizeZ() > 1) {
                            dim = 3;
                        }
                        if ((tracker = LegacyTrackerManager.this.panelTracking.buildTracker(dim)) instanceof StoppableTracker) {
                            LegacyTrackerManager.this.runningTracker = (StoppableTracker)((Object)tracker);
                        }
                        int firstT = detections.getFirstFrameTime();
                        int lastT = detections.getLastFrameTime();
                        String message = "Tracking at frame ";
                        ProgressFrame announceFrame = new ProgressFrame("");
                        announceFrame.setLength((double)(lastT - firstT + 1));
                        boolean stopped = false;
                        for (int t = firstT; t <= lastT; ++t) {
                            if (LegacyTrackerManager.this.stopTracking) {
                                stopped = true;
                                break;
                            }
                            announceFrame.setPosition((double)t);
                            announceFrame.setMessage(message + " " + t);
                            tracker.track(t, detections.getDetectionsAtT(t));
                        }
                        announceFrame.close();
                        if (tracker instanceof InstantaneousTracker) {
                            TrackGroup trackGroup = new TrackGroup(sequence);
                            trackGroup.setDescription(LegacyTrackerManager.this.panelTracking.getTrackGroupName());
                            for (Track track : ((InstantaneousTracker)tracker).getTracks()) {
                                TrackSegment ts = LegacyTrackerManager.this.convertTrack2TrackSegment(track, null);
                                if (ts == null || ts.getDetectionList().size() <= 1) continue;
                                trackGroup.addTrackSegment(ts);
                            }
                            SpotTrackingPlugin.sendTracksToPool(trackGroup, sequence);
                            new AnnounceFrame("Tracks exported as " + trackGroup.getDescription() + " in TrackEditor");
                        }
                        LegacyTrackerManager.this.isRunning = false;
                        LegacyTrackerManager.this.enableTracking(true);
                        if (stopped) {
                            LegacyTrackerManager.this.stopLock.lock();
                            LegacyTrackerManager.this.isRunning = false;
                            LegacyTrackerManager.this.stopCondition.signalAll();
                            LegacyTrackerManager.this.stopLock.unlock();
                        }
                        LegacyTrackerManager.this.runningThread = null;
                        LegacyTrackerManager.this.runningTracker = null;
                    }
                };
                trackThread.start();
            }
        }

        public TrackSegment convertTrack2TrackSegment(Track track, Object detectionEditor) {
            int lastIndex;
            int firstIndex = track.getFirstIndex();
            for (int i = lastIndex = track.getLastIndex(); i > firstIndex && track.isPredictionAtFrame(i); --i) {
                lastIndex = i - 1;
            }
            if (firstIndex <= lastIndex) {
                ArrayList<DetectionSpotTrack> detections = new ArrayList<DetectionSpotTrack>(lastIndex - firstIndex + 1);
                for (int i = firstIndex; i <= lastIndex; ++i) {
                    Spot s = track.getSpotAtFrame(i);
                    DetectionSpotTrack detect = new DetectionSpotTrack(s, i);
                    if (track.isPredictionAtFrame(i)) {
                        detect.setDetectionType(2);
                    }
                    detections.add(detect);
                }
                return new TrackSegment(detections);
            }
            return null;
        }
    }

    class ParameterEstimationFrame
    extends IcyFrame {
        public ParameterEstimationFrame() {
            super("Parameters estimation", true, true, true, true);
            JPanel mainPanel = new JPanel();
            this.setContentPane(mainPanel);
            mainPanel.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.fill = 2;
            gc.gridy = 0;
            mainPanel.add((Component)new JLabel("Target motion"), gc);
            ++gc.gridy;
            JRadioButton diffusiveButton = new JRadioButton("is mainly diffusive (default).");
            mainPanel.add((Component)diffusiveButton, gc);
            ++gc.gridy;
            final JRadioButton directedButton = new JRadioButton("is mainly directed.");
            mainPanel.add((Component)directedButton, gc);
            ++gc.gridy;
            final JRadioButton directedDiffusiveButton = new JRadioButton("is both diffusive and directed.");
            mainPanel.add((Component)directedDiffusiveButton, gc);
            ++gc.gridy;
            ButtonGroup motionGroup = new ButtonGroup();
            motionGroup.add(diffusiveButton);
            motionGroup.add(directedButton);
            motionGroup.add(directedDiffusiveButton);
            diffusiveButton.setSelected(true);
            mainPanel.add((Component)new JLabel("Parameters for target motion"), gc);
            ++gc.gridy;
            JRadioButton noUpdateMotionButton = new JRadioButton("are kept to their initial values (default).");
            mainPanel.add((Component)noUpdateMotionButton, gc);
            ++gc.gridy;
            final JRadioButton updateMotionButton = new JRadioButton("are re-estimated online.");
            mainPanel.add((Component)updateMotionButton, gc);
            ++gc.gridy;
            ButtonGroup updateGroup = new ButtonGroup();
            updateGroup.add(noUpdateMotionButton);
            updateGroup.add(updateMotionButton);
            noUpdateMotionButton.setSelected(true);
            JButton estimateParametersButton = new JButton("Run parameter estimation procedure");
            mainPanel.add((Component)estimateParametersButton, gc);
            estimateParametersButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    SpotTrackingPlugin.this.computationThread = new Thread(){

                        @Override
                        public void run() {
                            SpotTrackingPlugin.this.estimateParameters(directedButton.isSelected(), !directedDiffusiveButton.isSelected(), updateMotionButton.isSelected());
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    SpotTrackingPlugin.this.simpleGUIPanel.changeTrackingState(false);
                                    SpotTrackingPlugin.this.advancedGUIPanel.changeTrackingState(false);
                                    if (SpotTrackingPlugin.this.trackingAnnounce != null) {
                                        SpotTrackingPlugin.this.trackingAnnounce.close();
                                    }
                                }
                            });
                        }
                    };
                    SpotTrackingPlugin.this.trackingAnnounce = new ProgressFrame("Parameter estimation in progress");
                    SpotTrackingPlugin.this.simpleGUIPanel.changeTrackingState(true);
                    SpotTrackingPlugin.this.advancedGUIPanel.changeTrackingState(true);
                    SpotTrackingPlugin.this.computationThread.start();
                    ParameterEstimationFrame.this.close();
                }
            });
            this.pack();
        }
    }
}

