/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.particletracking.legacytracker.gui;

import icy.gui.component.pool.SwimmingObjectChooser;
import icy.swimmingPool.SwimmingObject;
import icy.swimmingPool.SwimmingPoolEvent;
import icy.swimmingPool.SwimmingPoolEventType;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import plugins.nchenouard.particletracking.filtering.Predictor;
import plugins.nchenouard.particletracking.legacytracker.Tracker;
import plugins.nchenouard.particletracking.legacytracker.associationMethod.InstantaneousTracker;
import plugins.nchenouard.particletracking.legacytracker.associationMethod.SolveMLAssociation;
import plugins.nchenouard.particletracking.legacytracker.gui.IMMPanel;
import plugins.nchenouard.particletracking.legacytracker.gui.SingleMotionPanel;
import plugins.nchenouard.spot.DetectionResult;

public class PanelTracking
extends JPanel {
    private static final long serialVersionUID = -1080899131238029873L;
    SwimmingObjectChooser detectionChooser;
    SingleMotionPanel singleMotionPanel;
    IMMPanel immPanel;
    final String singleMotionString = "Single motion model";
    final String multipleMotionString = "Multiple motion models";
    final JComboBox filtersBox = new JComboBox<String>(new String[]{"Single motion model", "Multiple motion models"});
    JCheckBox covUpdateBox;
    private SpinnerNumberModel gateFactorModel = new SpinnerNumberModel(3.0, 0.5, 100.0, 0.5);
    private JSpinner gateFactorSpinner = new JSpinner(this.gateFactorModel);
    private SpinnerNumberModel maxConsPredModel = new SpinnerNumberModel(2, 0, 100, 1);
    private JSpinner maxConsPredSpinner = new JSpinner(this.maxConsPredModel);
    private JTextField trackGroupNameTF;
    private String runningString = "Stop tracking";
    private String nonRunningString = "Start tracking";
    public JButton trackingStartButton;
    String[] associationNames = new String[]{"Maximum Likelihood", "Optimal association (slower)", "Greedy association (faster)"};

    public PanelTracking() {
        GridBagLayout mainLayout = new GridBagLayout();
        this.setLayout(mainLayout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 2;
        this.add((Component)new JLabel("Detection source:"), constraints);
        ++constraints.gridy;
        this.detectionChooser = new SwimmingObjectChooser(DetectionResult.class);
        this.detectionChooser.swimmingPoolChangeEvent(new SwimmingPoolEvent(SwimmingPoolEventType.ELEMENT_REMOVED, new SwimmingObject(null)));
        this.add((Component)this.detectionChooser, constraints);
        ++constraints.gridy;
        this.add((Component)new JLabel("Motion model:"), constraints);
        ++constraints.gridy;
        final CardLayout motionCardLayout = new CardLayout();
        final JPanel motionModelPanel = new JPanel(motionCardLayout);
        this.singleMotionPanel = new SingleMotionPanel();
        this.immPanel = new IMMPanel();
        this.immPanel.setDefaultValues();
        motionModelPanel.add((Component)this.singleMotionPanel, "Single motion model");
        motionModelPanel.add((Component)this.immPanel, "Multiple motion models");
        motionModelPanel.setBorder(new TitledBorder("Motion setting"));
        this.filtersBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                motionCardLayout.show(motionModelPanel, PanelTracking.this.filtersBox.getSelectedItem().toString());
            }
        });
        this.add((Component)this.filtersBox, constraints);
        ++constraints.gridy;
        this.add((Component)motionModelPanel, constraints);
        ++constraints.gridy;
        this.covUpdateBox = new JCheckBox("Use adaptive covariance filter");
        this.add((Component)this.covUpdateBox, constraints);
        ++constraints.gridy;
        this.add((Component)new JLabel("Max. number of consecutive missed detections:"), constraints);
        ++constraints.gridy;
        this.add((Component)this.maxConsPredSpinner, constraints);
        ++constraints.gridy;
        this.add((Component)new JLabel("Gate factor:"), constraints);
        ++constraints.gridy;
        this.add((Component)this.gateFactorSpinner, constraints);
        ++constraints.gridy;
        JLabel trackGroupLabel = new JLabel("Name of the output track group");
        this.add((Component)trackGroupLabel, constraints);
        ++constraints.gridy;
        this.trackGroupNameTF = new JTextField("newTracks-1");
        this.add((Component)this.trackGroupNameTF, constraints);
        ++constraints.gridy;
        this.trackingStartButton = new JButton();
        this.changeTrackingState(false);
        this.add((Component)this.trackingStartButton, constraints);
    }

    public void changeTrackingState(boolean isRunning) {
        if (isRunning) {
            this.trackingStartButton.setText(this.runningString);
        } else {
            this.trackingStartButton.setText(this.nonRunningString);
        }
        this.trackingStartButton.updateUI();
    }

    public DetectionResult getDetectionResults() {
        if (this.detectionChooser.getSelectedObject() != null) {
            return (DetectionResult)this.detectionChooser.getSelectedObject();
        }
        return null;
    }

    public boolean IsErasePreExistingTracks() {
        return false;
    }

    public Predictor buildPredictor(int dim) {
        if (this.filtersBox.getSelectedItem().equals("Single motion model")) {
            return this.singleMotionPanel.buildPredictor(dim, this.covUpdateBox.isSelected());
        }
        return this.immPanel.buildPredictor(dim, this.covUpdateBox.isSelected());
    }

    public AssociationMethods getAssociationMethod() {
        return AssociationMethods.ML;
    }

    public double getGateFactor() {
        return this.gateFactorModel.getNumber().doubleValue();
    }

    public int getMaxConsPred() {
        return this.maxConsPredModel.getNumber().intValue();
    }

    public Tracker buildTracker(int dim) {
        Predictor predictor = this.buildPredictor(dim);
        SolveMLAssociation assignementSolver = null;
        assignementSolver = new SolveMLAssociation(true);
        InstantaneousTracker tracker = new InstantaneousTracker(assignementSolver, predictor, true, this.getGateFactor(), this.getMaxConsPred() + 1);
        return tracker;
    }

    public String getTrackGroupName() {
        return this.trackGroupNameTF.getText();
    }

    public static enum AssociationMethods {
        ML,
        OPTIMAL,
        GREEDY;

    }
}

