/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.particletracking.legacytracker.gui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import plugins.nchenouard.particletracking.filtering.Predictor;
import plugins.nchenouard.particletracking.legacytracker.gui.DirectedMotionPanel;
import plugins.nchenouard.particletracking.legacytracker.gui.PredictorPanel;
import plugins.nchenouard.particletracking.legacytracker.gui.RandomWalkPanel;

public class SingleMotionPanel
extends JPanel {
    private static final long serialVersionUID = 1562007105810413917L;
    private int defaultModel = 0;
    private PredictorPanel[] predictorJPs = new PredictorPanel[]{new RandomWalkPanel(), new DirectedMotionPanel()};
    private String[] modelNames;
    private JComboBox trackingFilters;
    private final CardLayout predictorCardLayout = new CardLayout();
    JPanel predictorsPanel = new JPanel(this.predictorCardLayout);

    public SingleMotionPanel() {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        this.modelNames = new String[this.predictorJPs.length];
        for (int i = 0; i < this.predictorJPs.length; ++i) {
            this.modelNames[i] = this.predictorJPs[i].getName();
            this.predictorsPanel.add((Component)this.predictorJPs[i], this.predictorJPs[i].getName());
        }
        this.trackingFilters = new JComboBox<String>(this.modelNames);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 2;
        this.add((Component)new JLabel("Motion type"), constraints);
        ++constraints.gridy;
        this.add((Component)this.trackingFilters, constraints);
        ++constraints.gridy;
        this.setDefaultValues();
        this.trackingFilters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SingleMotionPanel.this.predictorCardLayout.show(SingleMotionPanel.this.predictorsPanel, SingleMotionPanel.this.modelNames[SingleMotionPanel.this.trackingFilters.getSelectedIndex()]);
            }
        });
        this.add((Component)this.predictorsPanel, constraints);
        ++constraints.gridy;
    }

    private void setDefaultValues() {
        this.trackingFilters.setSelectedIndex(this.defaultModel);
        this.predictorCardLayout.show(this.predictorsPanel, this.modelNames[this.defaultModel]);
        for (PredictorPanel pp : this.predictorJPs) {
            pp.setDefaultValues();
        }
    }

    public Predictor buildPredictor(int dim, boolean covUpdate) {
        return this.predictorJPs[this.trackingFilters.getSelectedIndex()].buildPredictor(dim, covUpdate);
    }
}

