/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.particletracking.gui;

import icy.util.XMLUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.nchenouard.particletracking.MHTparameterSet;

public class MHTPanel
extends JPanel {
    private static final long serialVersionUID = -6779807374365876629L;
    final DefaultMutableTreeNode node = new DefaultMutableTreeNode("Tracking algorithm");
    protected final NumberFormat gateFactorFormat = NumberFormat.getNumberInstance();
    protected final JFormattedTextField gateFactorTF = new JFormattedTextField(this.gateFactorFormat);
    protected final JSpinner numberNewTrackSpinner = new JSpinner();
    protected final JSpinner numberInitialTrackSpinner = new JSpinner();
    protected final JSpinner spinnerMHTDepth = new JSpinner();

    public MHTPanel() {
        this.setLayout(new BorderLayout());
        JPanel pane = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        pane.setLayout(gbl);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        this.numberNewTrackSpinner.setModel(new SpinnerNumberModel((Number)10.0, new Double(0.0), null, new Double(1.0)));
        JPanel spinnerNewTrackPanel = new JPanel();
        spinnerNewTrackPanel.setLayout(new GridLayout(2, 1, 0, 0));
        spinnerNewTrackPanel.add(new JLabel("Expected number of new objects per frame"));
        spinnerNewTrackPanel.add(this.numberNewTrackSpinner);
        c.gridx = 0;
        c.gridy = 0;
        pane.add((Component)spinnerNewTrackPanel, c);
        this.numberInitialTrackSpinner.setModel(new SpinnerNumberModel((Number)20.0, new Double(0.0), null, new Double(1.0)));
        JPanel spinnerInitialTrackPanel = new JPanel();
        spinnerInitialTrackPanel.setLayout(new GridLayout(2, 1, 0, 0));
        spinnerInitialTrackPanel.add(new JLabel("Expected number of objects in the first frame"));
        spinnerInitialTrackPanel.add(this.numberInitialTrackSpinner);
        c.gridx = 0;
        c.gridy = 1;
        pane.add((Component)spinnerInitialTrackPanel, c);
        this.spinnerMHTDepth.setModel(new SpinnerNumberModel(new Integer(4), new Integer(1), new Integer(8), new Integer(1)));
        JPanel spinnerDepthPanel = new JPanel();
        spinnerDepthPanel.setLayout(new GridLayout(2, 1, 0, 0));
        spinnerDepthPanel.add(new JLabel("Depth of the track trees"));
        spinnerDepthPanel.add(this.spinnerMHTDepth);
        c.gridx = 0;
        c.gridy = 2;
        pane.add((Component)spinnerDepthPanel, c);
        this.gateFactorFormat.setMinimumFractionDigits(0);
        this.gateFactorFormat.setMaximumFractionDigits(12);
        this.gateFactorFormat.setMinimumIntegerDigits(0);
        this.gateFactorFormat.setMaximumIntegerDigits(12);
        this.gateFactorTF.setValue(4.0);
        JPanel gateFactorPanel = new JPanel();
        gateFactorPanel.setLayout(new GridLayout(2, 1, 0, 0));
        gateFactorPanel.add(new JLabel("Gate factor for association"));
        gateFactorPanel.add(this.gateFactorTF);
        c.gridx = 0;
        c.gridy = 3;
        pane.add((Component)gateFactorPanel, c);
        this.add((Component)pane, "North");
    }

    public double getGateFactor() throws ParseException {
        return this.gateFactorFormat.parse(this.gateFactorTF.getText()).doubleValue();
    }

    public double getNumberInitialTracks() {
        return ((SpinnerNumberModel)this.numberInitialTrackSpinner.getModel()).getNumber().doubleValue();
    }

    public int getMHTDepth() {
        return ((SpinnerNumberModel)this.spinnerMHTDepth.getModel()).getNumber().intValue();
    }

    public double getNumbeNewTracks() {
        return ((SpinnerNumberModel)this.numberNewTrackSpinner.getModel()).getNumber().doubleValue();
    }

    public void saveToXML(Node node) {
        Element nodeMHT = XMLUtil.setElement((Node)node, (String)"mht");
        if (nodeMHT != null) {
            XMLUtil.setAttributeDoubleValue((Element)nodeMHT, (String)"numberNewObjects", (double)this.getNumbeNewTracks());
            XMLUtil.setAttributeDoubleValue((Element)nodeMHT, (String)"numberObjectsFirstFrame", (double)this.getNumberInitialTracks());
            XMLUtil.setAttributeIntValue((Element)nodeMHT, (String)"mhtDepth", (int)this.getMHTDepth());
            try {
                XMLUtil.setAttributeDoubleValue((Element)nodeMHT, (String)"gateFactor", (double)this.getGateFactor());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    public void loadFromFromXML(Node node) {
        Element nodeDetection = XMLUtil.getElement((Node)node, (String)"mht");
        if (nodeDetection != null) {
            try {
                this.gateFactorTF.setValue(XMLUtil.getAttributeDoubleValue((Element)nodeDetection, (String)"gateFactor", (double)this.getGateFactor()));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            ((SpinnerNumberModel)this.numberNewTrackSpinner.getModel()).setValue(XMLUtil.getAttributeDoubleValue((Element)nodeDetection, (String)"numberNewObjects", (double)this.getNumbeNewTracks()));
            ((SpinnerNumberModel)this.numberInitialTrackSpinner.getModel()).setValue(XMLUtil.getAttributeDoubleValue((Element)nodeDetection, (String)"numberObjectsFirstFrame", (double)this.getNumberInitialTracks()));
            ((SpinnerNumberModel)this.spinnerMHTDepth.getModel()).setValue(XMLUtil.getAttributeIntValue((Element)nodeDetection, (String)"mhtDepth", (int)this.getMHTDepth()));
        }
    }

    public void fillParameterSet(MHTparameterSet parameterSet) {
        parameterSet.numberNewObjects = this.getNumbeNewTracks();
        parameterSet.numberInitialObjects = this.getNumberInitialTracks();
        parameterSet.mhtDepth = this.getMHTDepth();
        try {
            parameterSet.gateFactor = this.getGateFactor();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public void setParameters(MHTparameterSet parameterSet) {
        this.gateFactorTF.setValue(parameterSet.gateFactor);
        ((SpinnerNumberModel)this.numberNewTrackSpinner.getModel()).setValue(parameterSet.numberNewObjects);
        ((SpinnerNumberModel)this.numberInitialTrackSpinner.getModel()).setValue(parameterSet.numberInitialObjects);
        ((SpinnerNumberModel)this.spinnerMHTDepth.getModel()).setValue(parameterSet.mhtDepth);
    }
}

