/*
 * Decompiled with CFR 0.152.
 */
package plugins.mitiv;

import icy.image.IcyBufferedImage;
import icy.main.Icy;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLauncher;
import icy.plugin.PluginLoader;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import plugins.adufour.ezplug.EzLabel;
import plugins.adufour.ezplug.EzPlug;

public class IcyJulia
extends EzPlug {
    EzLabel status;
    boolean run = false;
    static final int PORT = 10001;
    static final int BYTE = 0;
    static final int SHORT = 1;
    static final int INT = 2;
    static final int FLOAT = 3;
    static final int DOUBLE = 4;
    byte[] arrayByte = null;

    private void reset() {
        this.arrayByte = null;
    }

    private void convertDataToIcy(String title, int[] dims, int rank, int type) {
        if (rank < 2) {
            System.err.println("Data of rank " + rank + " not supported");
            return;
        }
        if (rank > 4) {
            System.err.println("Data of rank " + rank + " not supported");
            return;
        }
        Sequence seq = new Sequence(title);
        switch (type) {
            case 0: {
                ByteBuffer bytebuffer = ByteBuffer.wrap(this.arrayByte);
                for (int i = 0; i < dims[3]; ++i) {
                    for (int j = 0; j < dims[2]; ++j) {
                        int size = dims[0] * dims[1];
                        byte[] tmp = new byte[size];
                        bytebuffer.get(tmp, 0, size);
                        seq.setImage(i, j, (BufferedImage)new IcyBufferedImage(dims[0], dims[1], (Object)tmp));
                    }
                }
                break;
            }
            case 1: {
                ShortBuffer shortbuffer = ByteBuffer.wrap(this.arrayByte).asShortBuffer();
                for (int i = 0; i < dims[3]; ++i) {
                    for (int j = 0; j < dims[2]; ++j) {
                        int size = dims[0] * dims[1];
                        short[] tmp = new short[size];
                        shortbuffer.get(tmp, 0, size);
                        seq.setImage(i, j, (BufferedImage)new IcyBufferedImage(dims[0], dims[1], (Object)tmp));
                    }
                }
                break;
            }
            case 2: {
                IntBuffer intbuffer = ByteBuffer.wrap(this.arrayByte).asIntBuffer();
                for (int i = 0; i < dims[3]; ++i) {
                    for (int j = 0; j < dims[2]; ++j) {
                        int size = dims[0] * dims[1];
                        int[] tmp = new int[size];
                        intbuffer.get(tmp, 0, size);
                        seq.setImage(i, j, (BufferedImage)new IcyBufferedImage(dims[0], dims[1], (Object)tmp));
                    }
                }
                break;
            }
            case 3: {
                FloatBuffer floatbuffer = ByteBuffer.wrap(this.arrayByte).asFloatBuffer();
                for (int i = 0; i < dims[3]; ++i) {
                    for (int j = 0; j < dims[2]; ++j) {
                        int size = dims[0] * dims[1];
                        float[] tmp = new float[size];
                        floatbuffer.get(tmp, 0, size);
                        seq.setImage(i, j, (BufferedImage)new IcyBufferedImage(dims[0], dims[1], (Object)tmp));
                    }
                }
                break;
            }
            case 4: {
                DoubleBuffer doublebuffer = ByteBuffer.wrap(this.arrayByte).asDoubleBuffer();
                block15: for (int i = 0; i < dims[3]; ++i) {
                    for (int j = 0; j < dims[2]; ++j) {
                        int size = dims[0] * dims[1];
                        double[] tmp = new double[size];
                        if (doublebuffer.remaining() < size) continue block15;
                        doublebuffer.get(tmp, 0, size);
                        seq.setImage(i, j, (BufferedImage)new IcyBufferedImage(dims[0], dims[1], (Object)tmp));
                    }
                }
                break;
            }
        }
        this.addSequence(seq);
    }

    public void clean() {
        this.stopExecution();
    }

    protected void execute() {
        if (this.run) {
            System.out.println("Server already running");
            return;
        }
        ThreadUtil.bgRun(() -> {
            this.run = true;
            this.status.setText("Run");
            ServerSocket serverSocket = null;
            try {
                serverSocket = new ServerSocket(10001, 0, InetAddress.getByName(null));
                serverSocket.setReuseAddress(true);
                while (this.run) {
                    try {
                        Socket clientSocket = serverSocket.accept();
                        BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
                        String detail = in.readLine();
                        in.close();
                        if (detail.compareTo("Closing") == 0) continue;
                        clientSocket.close();
                        Object[] tmpDataTitle = detail.split("#");
                        System.out.println(Arrays.toString(tmpDataTitle));
                        String[] details = ((String)tmpDataTitle[0]).split("x");
                        int type = Integer.parseInt(details[0]);
                        int count = 1;
                        int rank = 0;
                        int[] dims = new int[]{1, 1, 1, 1};
                        for (int i = 1; i < details.length; ++i) {
                            int tmp = Integer.parseInt(details[i]);
                            count *= tmp;
                            dims[i - 1] = tmp;
                            ++rank;
                        }
                        int sizebyte = 0;
                        switch (type) {
                            case 0: {
                                sizebyte = count;
                                break;
                            }
                            case 1: {
                                sizebyte = count * 2;
                                break;
                            }
                            case 2: {
                                sizebyte = count * 4;
                                break;
                            }
                            case 3: {
                                sizebyte = count * 4;
                                break;
                            }
                            case 4: {
                                sizebyte = count * 8;
                                break;
                            }
                        }
                        clientSocket = serverSocket.accept();
                        in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
                        DataInputStream data = new DataInputStream(clientSocket.getInputStream());
                        this.arrayByte = new byte[sizebyte];
                        data.readFully(this.arrayByte, 0, sizebyte);
                        this.convertDataToIcy((String)tmpDataTitle[1], dims, rank, type);
                        in.close();
                        clientSocket.close();
                        this.reset();
                        this.arrayByte = null;
                    }
                    catch (IOException e) {
                        System.err.println("Error while handling client request: " + e.getMessage());
                    }
                }
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                this.status.setText("Failed see Logs");
                e.printStackTrace();
            }
            finally {
                try {
                    if (serverSocket != null) {
                        serverSocket.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    protected void initialize() {
        this.status = new EzLabel("Stopped");
        this.getUI().setParametersIOVisible(false);
        this.getUI().clickRun();
    }

    public void stopExecution() {
        this.run = false;
        try {
            Socket kkSocket = new Socket("localhost", 10001);
            BufferedOutputStream out = new BufferedOutputStream(kkSocket.getOutputStream());
            String end = "Closing";
            out.write(end.getBytes());
            out.close();
            kkSocket.close();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.status.setText("Stopped");
    }

    public static void main(String[] args) {
        Icy.main((String[])args);
        PluginLauncher.start((PluginDescriptor)PluginLoader.getPlugin((String)IcyJulia.class.getName()));
    }
}

