/*
 * Decompiled with CFR 0.152.
 */
package plugins.vannary.morphomaths;

import icy.sequence.Sequence;
import icy.type.collection.array.Array2DUtil;

public class Chamfer3 {
    public final double a = 1.0;
    public final double b = Math.sqrt(2.0);
    public final double c = Math.sqrt(3.0);
    public final double d = Math.sqrt(5.0);

    public void unsignedChamferDistanceMap(Sequence input, double threshold, boolean interiorMap) {
        int width = input.getSizeX();
        int height = input.getSizeY();
        int depth = input.getSizeZ();
        int time = input.getSizeT();
        int channels = input.getSizeC();
        boolean signed = input.getDataType_().isSigned();
        double[][] map = new double[depth][width * height];
        int maxDistance = width * height * depth;
        int foregroundInit = interiorMap ? maxDistance : 0;
        int backgroundInit = interiorMap ? 0 : maxDistance;
        for (int t = 0; t < time; ++t) {
            for (int c = 0; c < channels; ++c) {
                Array2DUtil.arrayToDoubleArray((Object)input.getDataXYZ(t, c), (double[][])map, (boolean)signed);
                for (int z = 0; z < depth; ++z) {
                    double[] slice = map[z];
                    for (int i = 0; i < slice.length; ++i) {
                        slice[i] = slice[i] > threshold ? foregroundInit : backgroundInit;
                    }
                }
                if (depth == 1) {
                    this.updateUnsignedChamferDistance2D(width, height, map[0]);
                } else {
                    this.updateUnsignedChamferDistance3D(width, height, depth, map);
                }
                Array2DUtil.doubleArrayToArray((double[][])map, (Object)input.getDataXYZ(t, c));
            }
        }
    }

    public void updateUnsignedChamferDistance2D(int width, int height, double[] map) {
        double bDist;
        double aDist;
        int i;
        int j;
        int index = 0;
        for (j = 0; j < height; ++j) {
            i = 0;
            while (i < width) {
                aDist = map[index] + 1.0;
                if (i < width - 1 && map[index + 1] > aDist) {
                    map[index + 1] = aDist;
                }
                if (j < height - 1) {
                    bDist = aDist - 1.0 + this.b;
                    if (map[index + width] > aDist) {
                        map[index + width] = aDist;
                    }
                    if (i < width - 1 && map[index + width + 1] > bDist) {
                        map[index + width + 1] = bDist;
                    }
                    if (i > 0 && map[index + width - 1] > bDist) {
                        map[index + width - 1] = bDist;
                    }
                }
                ++i;
                ++index;
            }
        }
        --index;
        for (j = height - 1; j >= 0; --j) {
            i = width - 1;
            while (i >= 0) {
                aDist = map[index] + 1.0;
                if (i > 0 && map[index - 1] > aDist) {
                    map[index - 1] = aDist;
                }
                if (j > 0) {
                    bDist = aDist - 1.0 + this.b;
                    if (map[index - width] > aDist) {
                        map[index - width] = aDist;
                    }
                    if (i > 0 && map[index - width - 1] > bDist) {
                        map[index - width - 1] = bDist;
                    }
                    if (i < width - 1 && map[index - width + 1] > bDist) {
                        map[index - width + 1] = bDist;
                    }
                }
                --i;
                --index;
            }
        }
    }

    public void updateUnsignedChamferDistance3D(int width, int height, int depth, double[][] map) {
        double cDist;
        double bDist;
        double aDist;
        double val;
        int i;
        int j;
        double[] thisSlice;
        int k;
        int offset = 0;
        for (k = 0; k < depth - 1; ++k) {
            thisSlice = map[k];
            double[] nextSlice = k < depth - 1 ? map[k + 1] : null;
            offset = 0;
            for (j = 0; j < height; ++j) {
                i = 0;
                while (i < width) {
                    val = thisSlice[offset];
                    aDist = val + 1.0;
                    bDist = val + this.b;
                    cDist = val + this.c;
                    if (k < depth - 1) {
                        if (nextSlice[offset] > aDist) {
                            nextSlice[offset] = aDist;
                        }
                        if (j < height - 1) {
                            if (nextSlice[offset + width] > bDist) {
                                nextSlice[offset + width] = bDist;
                            }
                            if (i > 0 && nextSlice[offset + width - 1] > cDist) {
                                nextSlice[offset + width - 1] = cDist;
                            }
                            if (i < width - 1 && nextSlice[offset + width + 1] > cDist) {
                                nextSlice[offset + width + 1] = cDist;
                            }
                        }
                        if (j > 0) {
                            if (nextSlice[offset - width] > bDist) {
                                nextSlice[offset - width] = bDist;
                            }
                            if (i > 0 && nextSlice[offset - width - 1] > cDist) {
                                nextSlice[offset - width - 1] = cDist;
                            }
                            if (i < width - 1 && nextSlice[offset - width + 1] > cDist) {
                                nextSlice[offset - width + 1] = cDist;
                            }
                        }
                        if (i > 0 && nextSlice[offset - 1] > bDist) {
                            nextSlice[offset - 1] = bDist;
                        }
                        if (i < width - 1 && nextSlice[offset + 1] > bDist) {
                            nextSlice[offset + 1] = bDist;
                        }
                    }
                    if (j < height - 1) {
                        if (thisSlice[offset + width] > aDist) {
                            thisSlice[offset + width] = aDist;
                        }
                        if (i < width - 1 && thisSlice[offset + width + 1] > bDist) {
                            thisSlice[offset + width + 1] = bDist;
                        }
                        if (i > 0 && thisSlice[offset + width - 1] > bDist) {
                            thisSlice[offset + width - 1] = bDist;
                        }
                    }
                    if (i < width - 1 && thisSlice[offset + 1] > aDist) {
                        thisSlice[offset + 1] = aDist;
                    }
                    ++i;
                    ++offset;
                }
            }
        }
        for (k = depth - 1; k > 0; --k) {
            thisSlice = map[k];
            double[] prevSlice = k > 0 ? map[k - 1] : null;
            offset = thisSlice.length - 1;
            for (j = height - 1; j >= 0; --j) {
                i = width - 1;
                while (i >= 0) {
                    val = thisSlice[offset];
                    aDist = val + 1.0;
                    bDist = val + this.b;
                    if (k > 0) {
                        cDist = val + this.c;
                        if (prevSlice[offset] > aDist) {
                            prevSlice[offset] = aDist;
                        }
                        if (j > 0) {
                            if (prevSlice[offset - width] > bDist) {
                                prevSlice[offset - width] = bDist;
                            }
                            if (i > 0 && prevSlice[offset - width - 1] > cDist) {
                                prevSlice[offset - width - 1] = cDist;
                            }
                            if (i < width - 1 && prevSlice[offset - width + 1] > cDist) {
                                prevSlice[offset - width + 1] = cDist;
                            }
                        }
                        if (j < height - 1) {
                            if (prevSlice[offset + width] > bDist) {
                                prevSlice[offset + width] = bDist;
                            }
                            if (i > 0 && prevSlice[offset + width - 1] > cDist) {
                                prevSlice[offset + width - 1] = cDist;
                            }
                            if (i < width - 1 && prevSlice[offset + width + 1] > cDist) {
                                prevSlice[offset + width + 1] = cDist;
                            }
                        }
                        if (i > 0 && prevSlice[offset - 1] > bDist) {
                            prevSlice[offset - 1] = bDist;
                        }
                        if (i < width - 1 && prevSlice[offset + 1] > bDist) {
                            prevSlice[offset + 1] = bDist;
                        }
                    }
                    if (j > 0) {
                        if (thisSlice[offset - width] > aDist) {
                            thisSlice[offset - width] = aDist;
                        }
                        if (i > 0 && thisSlice[offset - width - 1] > bDist) {
                            thisSlice[offset - width - 1] = bDist;
                        }
                        if (i < width - 1 && thisSlice[offset - width + 1] > bDist) {
                            thisSlice[offset - width + 1] = bDist;
                        }
                    }
                    if (i > 0 && thisSlice[offset - 1] > aDist) {
                        thisSlice[offset - 1] = aDist;
                    }
                    --i;
                    --offset;
                }
            }
        }
    }
}

