/*
 * Decompiled with CFR 0.152.
 */
package plugins.vannary.morphomaths;

import icy.sequence.Sequence;
import icy.type.collection.array.Array2DUtil;

public class DistanceTransforms {
    private final float a = 1.0f;
    private final float b = 1.4142135f;
    private final float c = 1.7320508f;

    public void unsignedDistanceMap(Sequence input, double threshold, boolean invertMap, Algorithm type) {
        switch (type) {
            case Chamfer: {
                double[][] map = new double[input.getSizeZ()][input.getWidth() * input.getHeight()];
                int maxDistance = map.length * map[0].length;
                int foregroundInit = invertMap ? maxDistance : 0;
                int backgroundInit = invertMap ? 0 : maxDistance;
                for (int t = 0; t < input.getSizeT(); ++t) {
                    for (int c = 0; c < input.getSizeC(); ++c) {
                        Array2DUtil.arrayToDoubleArray((Object)input.getDataXYZ(t, c), (double[][])map, (boolean)false);
                        for (int z = 0; z < map.length; ++z) {
                            double[] slice = map[z];
                            for (int i = 0; i < slice.length; ++i) {
                                slice[i] = slice[i] > threshold ? foregroundInit : backgroundInit;
                            }
                        }
                        if (map.length == 1) {
                            this.updateUnsignedChamferDistance2D(input.getWidth(), input.getHeight(), map[0]);
                        } else {
                            this.updateUnsignedChamferDistance3D(input.getWidth(), input.getHeight(), map.length, map);
                        }
                        Array2DUtil.doubleArrayToArray((double[][])map, (Object)input.getDataXYZ(t, c));
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Distance algorithm not supported : " + (Object)((Object)type));
            }
        }
    }

    public void updateUnsignedChamferDistance2D(int width, int height, double[] map) {
        double bDist;
        double aDist;
        int i;
        int j;
        int index = 0;
        for (j = 0; j < height; ++j) {
            i = 0;
            while (i < width) {
                aDist = map[index] + 1.0;
                bDist = map[index] + 1.4142135381698608;
                if (i < width - 1) {
                    map[index + 1] = Math.min(map[index + 1], aDist);
                }
                if (j < height - 1) {
                    map[index + width] = Math.min(map[index + width], aDist);
                    if (i < width - 1) {
                        map[index + 1 + width] = Math.min(map[index + 1 + width], bDist);
                    }
                    if (i > 0) {
                        map[index - 1 + width] = Math.min(map[index - 1 + width], bDist);
                    }
                }
                ++i;
                ++index;
            }
        }
        --index;
        for (j = height - 1; j >= 0; --j) {
            i = width - 1;
            while (i >= 0) {
                aDist = map[index] + 1.0;
                bDist = map[index] + 1.4142135381698608;
                if (i > 0) {
                    map[index - 1] = Math.min(map[index - 1], aDist);
                }
                if (j > 0) {
                    map[index - width] = Math.min(map[index - width], aDist);
                    if (i > 0) {
                        map[index - 1 - width] = Math.min(map[index - 1 - width], bDist);
                    }
                    if (i < width - 1) {
                        map[index + 1 - width] = Math.min(map[index + 1 - width], bDist);
                    }
                }
                --i;
                --index;
            }
        }
    }

    public void updateUnsignedChamferDistance3D(int width, int height, int depth, double[][] map) {
        double cDist;
        double bDist;
        double aDist;
        int i;
        int j;
        double[] thisSlice;
        int k;
        int offset = 0;
        for (k = 0; k < depth - 1; ++k) {
            thisSlice = map[k];
            double[] nextSlice = map[k + 1];
            offset = 0;
            for (j = 0; j < height; ++j) {
                i = 0;
                while (i < width) {
                    aDist = thisSlice[offset] + 1.0;
                    bDist = thisSlice[offset] + 1.4142135381698608;
                    cDist = thisSlice[offset] + 1.7320507764816284;
                    if (k < depth - 1) {
                        if (nextSlice[offset] > aDist) {
                            nextSlice[offset] = aDist;
                        }
                        if (j < height - 1) {
                            if (nextSlice[offset + width] > bDist) {
                                nextSlice[offset + width] = bDist;
                            }
                            if (i > 0 && nextSlice[offset + width - 1] > cDist) {
                                nextSlice[offset + width - 1] = cDist;
                            }
                            if (i < width - 1 && nextSlice[offset + width + 1] > cDist) {
                                nextSlice[offset + width + 1] = cDist;
                            }
                        }
                        if (j > 0) {
                            if (nextSlice[offset - width] > bDist) {
                                nextSlice[offset - width] = bDist;
                            }
                            if (i > 0 && nextSlice[offset - width - 1] > cDist) {
                                nextSlice[offset - width - 1] = cDist;
                            }
                            if (i < width - 1 && nextSlice[offset - width + 1] > cDist) {
                                nextSlice[offset - width + 1] = cDist;
                            }
                        }
                        if (i > 0 && nextSlice[offset - 1] > bDist) {
                            nextSlice[offset - 1] = bDist;
                        }
                        if (i < width - 1 && nextSlice[offset + 1] > bDist) {
                            nextSlice[offset + 1] = bDist;
                        }
                    }
                    if (j < height - 1) {
                        if (thisSlice[offset + width] > aDist) {
                            thisSlice[offset + width] = aDist;
                        }
                        if (i < width - 1 && thisSlice[offset + width + 1] > bDist) {
                            thisSlice[offset + width + 1] = bDist;
                        }
                        if (i > 0 && thisSlice[offset + width - 1] > bDist) {
                            thisSlice[offset + width - 1] = bDist;
                        }
                    }
                    if (i < width - 1 && thisSlice[offset + 1] > aDist) {
                        thisSlice[offset + 1] = aDist;
                    }
                    ++i;
                    ++offset;
                }
            }
        }
        for (k = depth - 1; k > 0; --k) {
            thisSlice = map[k];
            double[] prevSlice = map[k - 1];
            offset = thisSlice.length - 1;
            for (j = height - 1; j >= 0; --j) {
                i = width - 1;
                while (i >= 0) {
                    aDist = thisSlice[offset] + 1.0;
                    bDist = thisSlice[offset] + 1.4142135381698608;
                    cDist = thisSlice[offset] + 1.7320507764816284;
                    if (k > 0) {
                        if (prevSlice[offset] > aDist) {
                            prevSlice[offset] = aDist;
                        }
                        if (j > 0) {
                            if (prevSlice[offset - width] > bDist) {
                                prevSlice[offset - width] = bDist;
                            }
                            if (i > 0 && prevSlice[offset - width - 1] > cDist) {
                                prevSlice[offset - width - 1] = cDist;
                            }
                            if (i < width - 1 && prevSlice[offset - width + 1] > cDist) {
                                prevSlice[offset - width + 1] = cDist;
                            }
                        }
                        if (j < height - 1) {
                            if (prevSlice[offset + width] > bDist) {
                                prevSlice[offset + width] = bDist;
                            }
                            if (i > 0 && prevSlice[offset + width - 1] > cDist) {
                                prevSlice[offset + width - 1] = cDist;
                            }
                            if (i < width - 1 && prevSlice[offset + width + 1] > cDist) {
                                prevSlice[offset + width + 1] = cDist;
                            }
                        }
                        if (i > 0 && prevSlice[offset - 1] > bDist) {
                            prevSlice[offset - 1] = bDist;
                        }
                        if (i < width - 1 && prevSlice[offset + 1] > bDist) {
                            prevSlice[offset + 1] = bDist;
                        }
                    }
                    if (j > 0) {
                        if (thisSlice[offset - width] > aDist) {
                            thisSlice[offset - width] = aDist;
                        }
                        if (i > 0 && thisSlice[offset - width - 1] > bDist) {
                            thisSlice[offset - width - 1] = bDist;
                        }
                        if (i < width - 1 && thisSlice[offset - width + 1] > bDist) {
                            thisSlice[offset - width + 1] = bDist;
                        }
                    }
                    if (i > 0 && thisSlice[offset - 1] > aDist) {
                        thisSlice[offset - 1] = aDist;
                    }
                    --i;
                    --offset;
                }
            }
        }
    }

    public static enum Algorithm {
        Chamfer;

    }
}

