/*
 * Decompiled with CFR 0.152.
 */
package plugins.vannary.morphomaths;

import icy.gui.dialog.MessageDialog;
import icy.gui.frame.IcyFrame;
import icy.gui.util.GuiUtil;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import icy.system.IcyExceptionHandler;
import icy.type.DataType;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import plugins.adufour.ezplug.EzButton;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarEnum;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarListener;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.vannary.morphomaths.ImageJskeletton;
import plugins.vannary.morphomaths.MorphOp;

public class MorphoMaths
extends EzPlug {
    EzVarSequence in;
    EzVarEnum<MethodType> method;
    EzVarEnum<SkelType> skel;
    EzVarDouble threshSkel;
    EzVarBoolean aboveThreshSkel;
    EzVarInteger smoothOrder;
    EzGroup groupSkel;
    EzVarEnum<WshedDisplay> wshedDisplay;
    EzGroup groupWshed;
    EzGroup groupDMap;
    EzVarDouble thresh;
    EzVarBoolean aboveThresh;
    EzVarBoolean inplace;
    EzVarBoolean option3D;
    EzVarInteger zValue;
    EzButton changeElts;
    EzGroup groupGenSettings;
    Sequence out;
    boolean showResult = true;
    private static final int SCROLLPANE_MAX_SIZE = 310;
    int xElt = 3;
    int yElt = 3;
    int zElt = 3;
    int centerX = 1;
    int centerY = 1;
    int centerZ = 1;
    double[][][] eltS3D = new double[][][]{new double[][]{{1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}}, new double[][]{{1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}}, new double[][]{{1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}}};
    double[][] eltS2D = new double[][]{{1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}};
    ArrayList<JTextField> listeFieldsEltS = new ArrayList();
    IcyFrame frameEltS = new IcyFrame("Structuring element", false, true, false, true);
    JPanel panEltDesc = GuiUtil.generatePanel((String)"Structuring element description");
    JPanel panValiderElt = new JPanel();
    JPanel panEltInput = GuiUtil.generatePanel((String)"Structuring element input");
    JScrollPane scrollPane = new JScrollPane(this.panEltInput);
    JPanel mainPan = new JPanel();
    JTextField fieldMatrixX = new JTextField("3", 3);
    JTextField fieldMatrixY = new JTextField("3", 3);
    JTextField fieldMatrixZ = new JTextField("3", 3);
    JTextField fieldCx = new JTextField("1", 3);
    JTextField fieldCy = new JTextField("1", 3);
    JTextField fieldCz = new JTextField("1", 3);
    JButton validerTaille = new JButton("Validate caracteristics");
    JButton validerElt = new JButton("Validate Structuring element");

    public void initialize() {
        this.in = new EzVarSequence("Input:");
        this.addEzComponent((EzComponent)this.in);
        this.method = new EzVarEnum("Method:", (Enum[])MethodType.values());
        this.addEzComponent((EzComponent)this.method);
        this.wshedDisplay = new EzVarEnum("Display type :", (Enum[])WshedDisplay.values());
        this.groupWshed = new EzGroup("Watershed parameters", new EzComponent[]{this.wshedDisplay});
        this.addEzComponent((EzComponent)this.groupWshed);
        String zValueName = new String("Z stack to transform: ");
        String threshName = new String("Threshold :");
        boolean firstvalue3D = false;
        if (this.in.getValue(false) != null) {
            if (((Sequence)this.in.getValue()).getSizeZ() > 1) {
                firstvalue3D = true;
            }
            this.zValue = new EzVarInteger(zValueName, 0, 0, ((Sequence)this.in.getValue()).getSizeZ() - 1, 1);
            DataType type = ((Sequence)this.in.getValue()).getFirstImage().getDataType_();
            boolean signed = ((Sequence)this.in.getValue()).getColorModel().isSignedDataType();
            switch (type) {
                case BYTE: 
                case UBYTE: {
                    this.thresh = new EzVarDouble(threshName, 127.0, 0.0, 255.0, 1.0);
                    this.threshSkel = new EzVarDouble(threshName, 127.0, 0.0, 255.0, 1.0);
                    break;
                }
                case SHORT: 
                case USHORT: {
                    this.thresh = new EzVarDouble(threshName, signed ? 0.0 : 32767.0, signed ? -32768.0 : 0.0, signed ? 32767.0 : 65535.0, 1.0);
                    this.threshSkel = new EzVarDouble(threshName, signed ? 0.0 : 32767.0, signed ? -32768.0 : 0.0, signed ? 32767.0 : 65535.0, 1.0);
                    break;
                }
                case INT: 
                case UINT: {
                    this.thresh = new EzVarDouble(threshName, signed ? 0.0 : 2.147483647E9, signed ? -2.147483648E9 : 0.0, signed ? 2.147483647E9 : 4.294967295E9, 1.0);
                    this.threshSkel = new EzVarDouble(threshName, signed ? 0.0 : 2.147483647E9, signed ? -2.147483648E9 : 0.0, signed ? 2.147483647E9 : 4.294967295E9, 1.0);
                    break;
                }
                case FLOAT: {
                    this.thresh = new EzVarDouble(threshName, 0.5, 0.0, 3.4028234663852886E38, 0.1);
                    this.threshSkel = new EzVarDouble(threshName, 0.5, 0.0, 3.4028234663852886E38, 0.1);
                    break;
                }
                case DOUBLE: {
                    this.thresh = new EzVarDouble(threshName, 0.5, 0.0, 100000.0, 0.1);
                    this.threshSkel = new EzVarDouble(threshName, 0.5, 0.0, 100000.0, 0.1);
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported data type: " + type);
                }
            }
        } else {
            this.zValue = new EzVarInteger(zValueName, 0, 0, 0, 1);
            this.thresh = new EzVarDouble(threshName, 0.0, 0.0, 0.0, 0.1);
            this.threshSkel = new EzVarDouble(threshName, 0.0, 0.0, 0.0, 0.1);
        }
        this.aboveThresh = new EzVarBoolean("Object above threshold", true);
        this.aboveThreshSkel = new EzVarBoolean("Object above threshold", true);
        this.inplace = new EzVarBoolean("Inplace image", false);
        this.option3D = new EzVarBoolean("3D Process", firstvalue3D);
        this.changeElts = new EzButton("Set custom structuring element", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MorphoMaths.this.initEltFrame();
            }
        });
        this.smoothOrder = new EzVarInteger("Smoothing order :", 3, 1, 10, 1);
        this.skel = new EzVarEnum("Skeleton type :", (Enum[])SkelType.values());
        this.groupSkel = new EzGroup("Skeleton method parameters", new EzComponent[]{this.skel, this.smoothOrder, this.threshSkel, this.aboveThreshSkel});
        this.addEzComponent((EzComponent)this.groupSkel);
        this.groupDMap = new EzGroup("Distance map parameters", new EzComponent[]{this.thresh, this.aboveThresh});
        this.addEzComponent((EzComponent)this.groupDMap);
        this.groupGenSettings = new EzGroup("General settings", new EzComponent[]{this.inplace, this.option3D, this.zValue, this.changeElts});
        this.addEzComponent((EzComponent)this.groupGenSettings);
        this.in.addVarChangeListener((EzVarListener)new EzVarListener<Sequence>(){

            public void variableChanged(EzVar<Sequence> source, Sequence newValue) {
                MorphoMaths.this.updateDefaultParams();
            }
        });
        this.method.addVisibilityTriggerTo((EzComponent)this.groupSkel, (Object[])new MethodType[]{MethodType.SKEL});
        this.skel.addVisibilityTriggerTo((EzComponent)this.smoothOrder, (Object[])new SkelType[]{SkelType.SKEL2});
        this.method.addVisibilityTriggerTo((EzComponent)this.groupWshed, (Object[])new MethodType[]{MethodType.WSHED});
        this.method.addVisibilityTriggerTo((EzComponent)this.groupDMap, (Object[])new MethodType[]{MethodType.DISTANCE_MAP});
        this.option3D.addVisibilityTriggerTo((EzComponent)this.zValue, (Object[])new Boolean[]{false});
        super.setTimeDisplay(true);
    }

    private void updateDefaultParams() {
        if (this.in.getValue(false) != null) {
            int newZMax = ((Sequence)this.in.getValue()).getSizeZ() - 1;
            if ((Integer)this.zValue.getValue() > newZMax) {
                this.zValue.setValue((Object)0);
            }
            this.zValue.setMaxValue((Comparable)Integer.valueOf(newZMax));
            if (((Sequence)this.in.getValue()).getSizeZ() > 1) {
                this.option3D.setValue((Object)true);
            } else {
                this.option3D.setValue((Object)false);
            }
            DataType type = ((Sequence)this.in.getValue()).getFirstImage().getDataType_();
            if (type.isFloat()) {
                this.thresh.setMaxValue((Comparable)Double.valueOf(type.getMaxValue()));
                this.thresh.setMinValue((Comparable)Double.valueOf(0.0));
                this.thresh.setValue((Object)0.5);
                this.thresh.setStep((Number)0.1);
            } else {
                this.thresh.setMaxValue((Comparable)Double.valueOf(type.getMaxValue()));
                this.thresh.setMinValue((Comparable)Double.valueOf(type.getMinValue()));
                this.thresh.setValue((Object)((type.getMaxValue() + type.getMinValue()) / 2.0));
                this.thresh.setStep((Number)1.0);
            }
            this.threshSkel.setMaxValue((Comparable)((Object)this.thresh.getMaxValue()));
            this.threshSkel.setMinValue((Comparable)((Object)this.thresh.getMinValue()));
            this.threshSkel.setStep((Number)((Double)this.thresh.getStep()));
            this.threshSkel.setValue((Object)((Double)this.thresh.getValue()));
        } else {
            this.zValue.setValue((Object)0);
            this.zValue.setMaxValue((Comparable)Integer.valueOf(0));
            this.thresh.setValue((Object)0.0);
            this.thresh.setMinValue((Comparable)Double.valueOf(0.0));
            this.thresh.setMaxValue((Comparable)Double.valueOf(0.0));
            this.threshSkel.setValue((Object)0.0);
            this.threshSkel.setMinValue((Comparable)Double.valueOf(0.0));
            this.threshSkel.setMaxValue((Comparable)Double.valueOf(0.0));
        }
    }

    public void execute() {
        try {
            if (this.in.getValue() == null) {
                this.showResult = false;
                return;
            }
            boolean _inplace = (Boolean)this.inplace.getValue();
            Sequence seqToTransform = _inplace ? (Sequence)this.in.getValue() : SequenceUtil.getCopy((Sequence)((Sequence)this.in.getValue()));
            boolean proc3D = (Boolean)this.option3D.getValue();
            int z = (Integer)this.zValue.getValue();
            if (!proc3D && z >= seqToTransform.getSizeZ()) {
                System.err.println("Z is too high");
                this.showResult = false;
                return;
            }
            MethodType _method = (MethodType)((Object)this.method.getValue());
            double _thresh = (Double)this.thresh.getValue();
            boolean _aboveThresh = (Boolean)this.aboveThresh.getValue();
            try {
                switch (_method) {
                    case ERODE_GREY: {
                        if (proc3D) {
                            MorphOp.erodeGreyScale3D(seqToTransform, this.eltS3D, this.centerX, this.centerY, this.centerZ);
                        } else {
                            MorphOp.erodeGreyScale(seqToTransform, z, this.eltS2D, this.centerX, this.centerY);
                        }
                        seqToTransform.setName(((Sequence)this.in.getValue()).getName() + "_Erosion");
                        break;
                    }
                    case DILATE_GREY: {
                        if (proc3D) {
                            MorphOp.dilateGreyScale3D(seqToTransform, this.eltS3D, this.centerX, this.centerY, this.centerZ);
                        } else {
                            MorphOp.dilateGreyScale(seqToTransform, z, this.eltS2D, this.centerX, this.centerY);
                        }
                        seqToTransform.setName(((Sequence)this.in.getValue()).getName() + "_Dilation");
                        break;
                    }
                    case OPEN: {
                        if (proc3D) {
                            MorphOp.openGreyScale3D(seqToTransform, this.eltS3D, this.centerX, this.centerY, this.centerZ);
                        } else {
                            MorphOp.openGreyScale(seqToTransform, z, this.eltS2D, this.centerX, this.centerY);
                        }
                        seqToTransform.setName(((Sequence)this.in.getValue()).getName() + "_Opening");
                        break;
                    }
                    case CLOSE: {
                        if (proc3D) {
                            MorphOp.closeGreyScale3D(seqToTransform, this.eltS3D, this.centerX, this.centerY, this.centerZ);
                        } else {
                            MorphOp.closeGreyScale(seqToTransform, z, this.eltS2D, this.centerX, this.centerY);
                        }
                        seqToTransform.setName(((Sequence)this.in.getValue()).getName() + "_Closing");
                        break;
                    }
                    case WTH: {
                        if (proc3D) {
                            MorphOp.whiteTopHat3D(seqToTransform, this.eltS3D, this.centerX, this.centerY, this.centerZ);
                        } else {
                            MorphOp.whiteTopHat(seqToTransform, z, this.eltS2D, this.centerX, this.centerY);
                        }
                        seqToTransform.setName(((Sequence)this.in.getValue()).getName() + "_WtopHat");
                        break;
                    }
                    case BTH: {
                        if (proc3D) {
                            MorphOp.blackTopHat3D(seqToTransform, this.eltS3D, this.centerX, this.centerY, this.centerZ);
                        } else {
                            MorphOp.blackTopHat(seqToTransform, z, this.eltS2D, this.centerX, this.centerY);
                        }
                        seqToTransform.setName(((Sequence)this.in.getValue()).getName() + "_BtopHat");
                        break;
                    }
                    case DISTANCE_MAP: {
                        if (proc3D) {
                            MorphOp.distanceMap3D(seqToTransform, _thresh, _aboveThresh);
                        } else {
                            MorphOp.distanceMap2D(seqToTransform, z, _thresh, _aboveThresh);
                        }
                        seqToTransform.setName(((Sequence)this.in.getValue()).getName() + "_Distance");
                        seqToTransform.dataChanged();
                        break;
                    }
                    case DISTANCE_8: {
                        if (proc3D) {
                            MorphOp.distanceMap3D(seqToTransform, _thresh, _aboveThresh);
                        } else {
                            seqToTransform = MorphOp.getDistance(seqToTransform, 8);
                        }
                        seqToTransform.setName(((Sequence)this.in.getValue()).getName() + "_Distance_8");
                        seqToTransform.dataChanged();
                        break;
                    }
                    case DISTANCE_: {
                        if (proc3D) {
                            MorphOp.distanceMap3D(seqToTransform, _thresh, _aboveThresh);
                        } else {
                            seqToTransform = MorphOp.getDistance(seqToTransform, 4);
                        }
                        seqToTransform.setName(((Sequence)this.in.getValue()).getName() + "_Distance_4");
                        seqToTransform.dataChanged();
                        break;
                    }
                    case SKEL: {
                        SkelType _skel = (SkelType)((Object)this.skel.getValue());
                        if (proc3D) {
                            MorphOp.skeleton3D(seqToTransform, _thresh, _aboveThresh);
                        } else {
                            switch (_skel) {
                                case SKEL1: {
                                    MorphOp.skeleton(seqToTransform, z, _thresh, _aboveThresh, 0, 0);
                                    break;
                                }
                                case SKEL2: {
                                    MorphOp.skeleton(seqToTransform, z, _thresh, _aboveThresh, 1, (Integer)this.smoothOrder.getValue());
                                }
                            }
                        }
                        seqToTransform.dataChanged();
                        break;
                    }
                    case SKELIMAGEJ: {
                        ImageJskeletton imageJSkel = new ImageJskeletton();
                        imageJSkel.skeleton(seqToTransform);
                        break;
                    }
                    case WSHED: {
                        WshedDisplay _wshedDisplay = (WshedDisplay)((Object)this.wshedDisplay.getValue());
                        if (proc3D) {
                            switch (_wshedDisplay) {
                                case SEP_VERSANTS: {
                                    MorphOp.watershed3D(seqToTransform, 0);
                                    break;
                                }
                                case CARTE_BASSINS_VERSANTS: {
                                    MorphOp.watershed3D(seqToTransform, 1);
                                    break;
                                }
                                case WSHED_ONLY: {
                                    MorphOp.watershed3D(seqToTransform, 2);
                                }
                            }
                        } else {
                            switch (_wshedDisplay) {
                                case SEP_VERSANTS: {
                                    MorphOp.watershed2D(seqToTransform, z, 0);
                                    break;
                                }
                                case CARTE_BASSINS_VERSANTS: {
                                    MorphOp.watershed2D(seqToTransform, z, 1);
                                    break;
                                }
                                case WSHED_ONLY: {
                                    MorphOp.watershed2D(seqToTransform, z, 2);
                                }
                            }
                        }
                        seqToTransform.dataChanged();
                        break;
                    }
                    case GRADIENT: {
                        if (proc3D) {
                            MorphOp.gradient3D(seqToTransform, this.eltS3D, this.centerX, this.centerY, this.centerZ);
                            break;
                        }
                        MorphOp.gradient(seqToTransform, z, this.eltS2D, this.centerX, this.centerY);
                        break;
                    }
                }
                this.out = seqToTransform;
            }
            catch (MorphOp.UnhandledImageTypeException e) {
                String message = "Unsupported image type";
                MessageDialog.showDialog((String)"Error", (String)message, (int)0);
            }
            if (!this.showResult || this.out == null) {
                this.out = null;
                this.showResult = true;
                return;
            }
            boolean _inplace1 = (Boolean)this.inplace.getValue();
            if (_inplace1) {
                ((Sequence)this.in.getValue()).dataChanged();
            } else {
                this.addSequence(this.out);
            }
        }
        catch (InterruptedException e) {
            IcyExceptionHandler.showErrorMessage((Throwable)e, (boolean)false);
        }
    }

    private void initEltFrame() {
        if (this.frameEltS.isVisible()) {
            return;
        }
        this.frameEltS.remove((Component)this.panEltDesc);
        this.frameEltS.remove((Component)this.panValiderElt);
        this.frameEltS.remove((Component)this.scrollPane);
        this.panEltDesc.removeAll();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridwidth = 0;
        this.mainPan.setLayout(new GridBagLayout());
        this.panEltDesc.setLayout(new GridBagLayout());
        JPanel panSize = new JPanel();
        c.insets = new Insets(0, 5, 0, 5);
        panSize.add((Component)new JLabel("Size on axis :"), c);
        panSize.add((Component)new JLabel("X : "), c);
        panSize.add((Component)this.fieldMatrixX, c);
        panSize.add((Component)new JLabel("Y : "), c);
        panSize.add((Component)this.fieldMatrixY, c);
        panSize.add((Component)new JLabel("Z : "), c);
        panSize.add((Component)this.fieldMatrixZ, c);
        JPanel panCenter = new JPanel();
        panCenter.add((Component)new JLabel("Center position :"), c);
        panCenter.add((Component)new JLabel("X : "), c);
        panCenter.add(this.fieldCx);
        panCenter.add((Component)new JLabel("Y : "), c);
        panCenter.add(this.fieldCy);
        panCenter.add((Component)new JLabel("Z : "), c);
        panCenter.add(this.fieldCz);
        c.gridy = 0;
        this.panEltDesc.add((Component)panSize, c);
        c.gridy = 1;
        this.panEltDesc.add((Component)panCenter, c);
        c.gridy = 2;
        this.panEltDesc.add((Component)this.validerTaille, c);
        c.gridy = -1;
        if (this.validerTaille.getActionListeners().length < 1) {
            this.validerTaille.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    MorphoMaths.this.xElt = Integer.parseInt(MorphoMaths.this.fieldMatrixX.getText());
                    MorphoMaths.this.yElt = Integer.parseInt(MorphoMaths.this.fieldMatrixY.getText());
                    MorphoMaths.this.zElt = Integer.parseInt(MorphoMaths.this.fieldMatrixZ.getText());
                    MorphoMaths.this.centerX = Integer.parseInt(MorphoMaths.this.fieldCx.getText());
                    MorphoMaths.this.centerY = Integer.parseInt(MorphoMaths.this.fieldCy.getText());
                    MorphoMaths.this.centerZ = Integer.parseInt(MorphoMaths.this.fieldCz.getText());
                    if (MorphoMaths.this.xElt <= 0 || MorphoMaths.this.yElt <= 0 || MorphoMaths.this.zElt <= 0) {
                        System.out.println("Invalid sutrcturing element size");
                        return;
                    }
                    if (MorphoMaths.this.centerX < 0 || MorphoMaths.this.centerY < 0 || MorphoMaths.this.centerZ < 0 || MorphoMaths.this.centerX >= MorphoMaths.this.xElt || MorphoMaths.this.centerY >= MorphoMaths.this.yElt || MorphoMaths.this.zElt > 1 && MorphoMaths.this.centerZ >= MorphoMaths.this.zElt) {
                        System.out.println("Invalid center position");
                        return;
                    }
                    MorphoMaths.this.panEltInput.removeAll();
                    while (!MorphoMaths.this.listeFieldsEltS.isEmpty()) {
                        MorphoMaths.this.listeFieldsEltS.remove(0);
                    }
                    MorphoMaths.this.scrollPane.setVisible(true);
                    GridBagConstraints c = new GridBagConstraints();
                    for (int z = 0; z < MorphoMaths.this.zElt; ++z) {
                        JPanel panelZ = GuiUtil.generatePanel((String)("Z = " + z));
                        MorphoMaths.this.panEltInput.add(GuiUtil.besidesPanel((Component[])new Component[]{panelZ}));
                        panelZ.setLayout(new GridBagLayout());
                        for (int y = 0; y < MorphoMaths.this.yElt; ++y) {
                            int x = 0;
                            while (x < MorphoMaths.this.xElt) {
                                c.gridx = x++;
                                c.gridy = y;
                                c.fill = 1;
                                JTextField field = new JTextField("1.0", 0);
                                MorphoMaths.this.listeFieldsEltS.add(field);
                                panelZ.add((Component)field, c);
                            }
                        }
                    }
                    MorphoMaths.this.scrollPane.setPreferredSize(null);
                    MorphoMaths.this.scrollPane.setMaximumSize(new Dimension(MorphoMaths.this.scrollPane.getSize().width, 310));
                    MorphoMaths.this.validerElt.setVisible(true);
                    MorphoMaths.this.frameEltS.pack();
                    MorphoMaths.this.scrollPane.setPreferredSize(new Dimension(MorphoMaths.this.scrollPane.getSize().width, Math.min(MorphoMaths.this.scrollPane.getSize().height, 310)));
                    MorphoMaths.this.frameEltS.pack();
                }
            });
        }
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setVisible(false);
        this.panValiderElt.setLayout(new GridBagLayout());
        this.panValiderElt.add(this.validerElt);
        if (this.validerElt.getActionListeners().length < 1) {
            this.validerElt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int offset = 0;
                    if (MorphoMaths.this.zElt > 1) {
                        MorphoMaths.this.eltS3D = new double[MorphoMaths.this.xElt][MorphoMaths.this.yElt][MorphoMaths.this.zElt];
                    } else {
                        MorphoMaths.this.eltS2D = new double[MorphoMaths.this.xElt][MorphoMaths.this.yElt];
                    }
                    for (int z = 0; z < MorphoMaths.this.zElt; ++z) {
                        for (int y = 0; y < MorphoMaths.this.yElt; ++y) {
                            int x = 0;
                            while (x < MorphoMaths.this.xElt) {
                                if (MorphoMaths.this.zElt > 1) {
                                    MorphoMaths.this.eltS3D[x][y][z] = Double.parseDouble(MorphoMaths.this.listeFieldsEltS.get(offset).getText());
                                } else {
                                    MorphoMaths.this.eltS2D[x][y] = Double.parseDouble(MorphoMaths.this.listeFieldsEltS.get(offset).getText());
                                }
                                ++x;
                                ++offset;
                            }
                        }
                    }
                    if (MorphoMaths.this.zElt > 1) {
                        System.out.println("3D element updated");
                    } else {
                        System.out.println("2D element updated");
                    }
                    MorphoMaths.this.scrollPane.setVisible(false);
                    MorphoMaths.this.validerElt.setVisible(false);
                    MorphoMaths.this.frameEltS.pack();
                }
            });
        }
        this.validerElt.setVisible(false);
        c.gridwidth = 0;
        this.mainPan.add((Component)this.panEltDesc, c);
        c.gridwidth = 0;
        this.mainPan.add((Component)this.scrollPane, c);
        c.gridwidth = 0;
        this.mainPan.add((Component)this.panValiderElt, c);
        this.frameEltS.add((Component)this.mainPan);
        this.frameEltS.pack();
        this.frameEltS.setVisible(true);
        this.addIcyFrame(this.frameEltS);
    }

    public void clean() {
    }

    private static enum MethodType {
        ERODE_GREY("Erosion"),
        DILATE_GREY("Dilation"),
        OPEN("Opening"),
        CLOSE("Closing"),
        WTH("White top-hat"),
        BTH("Black top-hat"),
        GRADIENT("Gradient"),
        DISTANCE_MAP("Distance map"),
        DISTANCE_8("Discrete Distance 8"),
        DISTANCE_("Discrete Distance 4"),
        SKEL("Skeleton"),
        SKELIMAGEJ("3D Medial Axis (Skeleton)"),
        WSHED("Watershed");

        private final String name;

        private MethodType(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }
    }

    private static enum WshedDisplay {
        SEP_VERSANTS("Separate basins"),
        CARTE_BASSINS_VERSANTS("Basins map"),
        WSHED_ONLY("Watershed only");

        private final String name;

        private WshedDisplay(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }
    }

    private static enum SkelType {
        SKEL1("Maximum"),
        SKEL2("Smooth");

        private final String name;

        private SkelType(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }
    }
}

