/*
 * Decompiled with CFR 0.152.
 */
package plugins.vannary.morphomaths.blocks;

import icy.plugin.abstract_.PluginActionable;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import icy.system.IcyExceptionHandler;
import icy.system.IcyHandledException;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarListener;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.vars.lang.Var;
import plugins.vannary.morphomaths.MorphOp;

public class OpeningBinary
extends PluginActionable
implements Block {
    private static double[][][] STRUCTURING_ELEMENT_3D = new double[][][]{new double[][]{{1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}}, new double[][]{{1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}}, new double[][]{{1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}}};
    private static double[][] STRUCTURING_ELEMENT_2D = new double[][]{{1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}};
    private EzVarSequence inputSequence;
    private EzVarInteger inputDistance1;
    private EzVarInteger inputDistance2;
    private EzVarBoolean inputOverwriteResult;
    private EzVarBoolean input3dModality;
    private EzVarInteger inputProcessedZ;
    private EzVarSequence outputSequence;
    private Sequence transformedSequence;

    public void declareInput(VarList inputMap) {
        this.inputSequence = new EzVarSequence("Sequence");
        this.inputDistance1 = new EzVarInteger("Distance Erosion", 1, 0, Integer.MAX_VALUE, 1);
        this.inputDistance2 = new EzVarInteger("Distance Dilation", 1, 0, Integer.MAX_VALUE, 1);
        this.inputOverwriteResult = new EzVarBoolean("Results on input", false);
        this.input3dModality = new EzVarBoolean("Compute in 3D", false);
        this.inputProcessedZ = new EzVarInteger("Z value");
        this.inputProcessedZ.getVariable().setEnabled(false);
        this.input3dModality.addVarChangeListener((EzVarListener)new EzVarListener<Boolean>(){

            public void variableChanged(EzVar<Boolean> source, Boolean newValue) {
                if (newValue.booleanValue()) {
                    OpeningBinary.this.inputProcessedZ.getVariable().setEnabled(false);
                } else {
                    OpeningBinary.this.inputProcessedZ.getVariable().setEnabled(true);
                }
            }
        });
        inputMap.add(this.inputSequence.name, (Var)this.inputSequence.getVariable());
        inputMap.add(this.inputDistance1.name, this.inputDistance1.getVariable());
        inputMap.add(this.inputDistance2.name, this.inputDistance2.getVariable());
        inputMap.add(this.inputOverwriteResult.name, this.inputOverwriteResult.getVariable());
        inputMap.add(this.input3dModality.name, this.input3dModality.getVariable());
        inputMap.add(this.inputProcessedZ.name, this.inputProcessedZ.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        this.outputSequence = new EzVarSequence("Dilation Sequence");
        outputMap.add(this.outputSequence.name, (Var)this.outputSequence.getVariable());
    }

    public void run() {
        try {
            int i;
            int processedZ;
            boolean is3D;
            boolean isReusingSequence;
            int distance2;
            int distance1;
            Sequence inSequence = this.inputSequence != null ? (Sequence)this.inputSequence.getValue(true) : this.getActiveSequence();
            if (inSequence == null) {
                throw new IcyHandledException("No sequence selected!");
            }
            if (this.inputSequence != null) {
                distance1 = (Integer)this.inputDistance1.getValue();
                distance2 = (Integer)this.inputDistance2.getValue();
                isReusingSequence = (Boolean)this.inputOverwriteResult.getValue();
                is3D = (Boolean)this.input3dModality.getValue();
                processedZ = (Integer)this.inputProcessedZ.getValue();
            } else {
                distance1 = 1;
                distance2 = 1;
                isReusingSequence = false;
                is3D = inSequence.getSizeZ() > 1;
                processedZ = 0;
            }
            if (isReusingSequence) {
                this.transformedSequence = inSequence;
            } else {
                this.transformedSequence = SequenceUtil.getCopy((Sequence)inSequence);
                this.transformedSequence.setName(inSequence.getName() + "_Opening");
            }
            if (distance1 < 0 || distance2 < 0) {
                throw new RuntimeException("Distances must be non-negative");
            }
            for (i = 0; i < distance1 && !Thread.interrupted(); ++i) {
                if (is3D) {
                    MorphOp.erodeGreyScale3D(this.transformedSequence, STRUCTURING_ELEMENT_3D, 1, 1, 1);
                    continue;
                }
                if (processedZ >= 0 && processedZ < this.transformedSequence.getSizeZ()) {
                    MorphOp.erodeGreyScale(this.transformedSequence, processedZ, STRUCTURING_ELEMENT_2D, 1, 1);
                    continue;
                }
                throw new RuntimeException("Invalid z coordinate: " + processedZ + ". Expected [0 - " + this.transformedSequence.getSizeZ() + ")");
            }
            for (i = 0; i < distance2 && !Thread.interrupted(); ++i) {
                if (is3D) {
                    MorphOp.dilateGreyScale3D(this.transformedSequence, STRUCTURING_ELEMENT_3D, 1, 1, 1);
                    continue;
                }
                if (processedZ >= 0 && processedZ < this.transformedSequence.getSizeZ()) {
                    MorphOp.dilateGreyScale(this.transformedSequence, processedZ, STRUCTURING_ELEMENT_2D, 1, 1);
                    continue;
                }
                throw new RuntimeException("Invalid z coordinate: " + processedZ + ". Expected [0 - " + this.transformedSequence.getSizeZ() + ")");
            }
            this.transformedSequence.dataChanged();
            if (this.outputSequence != null) {
                this.outputSequence.setValue(this.transformedSequence);
            } else {
                this.addSequence(this.transformedSequence);
            }
        }
        catch (InterruptedException e) {
            IcyExceptionHandler.showErrorMessage((Throwable)e, (boolean)false);
        }
    }
}

