/*
 * Decompiled with CFR 0.152.
 */
package plugins.vannary.morphomaths;

import icy.file.FileUtil;
import icy.image.IcyBufferedImage;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import icy.system.IcyExceptionHandler;
import icy.type.collection.array.Array1DUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import jxl.Workbook;
import jxl.write.Formula;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.vars.lang.Var;
import plugins.kernel.roi.roi2d.ROI2DLine;
import plugins.vannary.morphomaths.Edge;
import plugins.vannary.morphomaths.Point3DEdge;

public class AnalyzeSkeleton
extends EzPlug
implements Block {
    private EzVarSequence in = new EzVarSequence("Sequence in ");
    private EzVarFile fileXls = new EzVarFile("Xls File", FileUtil.getApplicationDirectory());
    private EzVarSequence out = new EzVarSequence("Sequence out");
    private EzVarInteger ezMeltingAngle = new EzVarInteger("melting angle", 0, 180, 1);
    private EzVarBoolean drawROI = new EzVarBoolean("draw ROI", false);
    private Sequence seq;

    protected void initialize() {
        super.addEzComponent((EzComponent)this.in);
        super.addEzComponent((EzComponent)this.fileXls);
        super.addEzComponent((EzComponent)this.ezMeltingAngle);
        super.addEzComponent((EzComponent)this.drawROI);
    }

    protected void execute() {
        try {
            this.seq = SequenceUtil.getCopy((Sequence)((Sequence)this.in.getValue()));
            ArrayList<Edge> edges = null;
            edges = this.seq.getSizeZ() > 1 ? this.analyzeSkeleton3D(this.seq) : this.analyzeSkeleton(this.seq, 0);
            this.addSequence(this.seq);
            if (((Boolean)this.drawROI.getValue()).booleanValue()) {
                this.drawROIOnEdges(edges);
            }
            if (this.fileXls.getValue() != null) {
                this.saveResult2ExcelAurel(((File)this.fileXls.getValue()).getPath(), edges);
            }
        }
        catch (InterruptedException e) {
            IcyExceptionHandler.showErrorMessage((Throwable)e, (boolean)false);
        }
    }

    public void clean() {
    }

    public void declareInput(VarList inputMap) {
        inputMap.add(this.in.name, (Var)this.in.getVariable());
        inputMap.add(this.fileXls.name, this.fileXls.getVariable());
        inputMap.add(this.ezMeltingAngle.name, this.ezMeltingAngle.getVariable());
        inputMap.add(this.drawROI.name, this.drawROI.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add(this.out.name, (Var)this.out.getVariable());
    }

    private double getTabVal(double[] tab, int x, int y, int nc, int nr) {
        if (x < 0 || x >= nc || y < 0 || y >= nr) {
            return 0.0;
        }
        double d = tab[x + nc * y];
        return d;
    }

    private void setTabVal(double[] tab, int x, int y, double d, int nc, int nr) {
        if (x >= 0 && x < nc && y >= 0 && y < nr) {
            tab[x + nc * y] = d;
        }
    }

    private double getTabVal3D(double[][] tab, int x, int y, int z, int nc, int nr, int nz) {
        if (x < 0 || x >= nc || y < 0 || y >= nr || z < 0 || z >= nz) {
            return 0.0;
        }
        return tab[x + nc * y][z];
    }

    private void setTabVal3D(double[][] tab, int x, int y, int z, double d, int nc, int nr, int nz) {
        if (x >= 0 && x < nc && y >= 0 && y < nr && z >= 0 && z < nz) {
            tab[x + nc * y][z] = d;
        }
    }

    public int getNbNeighbors(double[] tab, int i, int j, int width, int height) {
        int nbNeighbors = 0;
        for (int l = j - 1; l <= j + 1; ++l) {
            for (int k = i - 1; k <= i + 1; ++k) {
                if (l == j && k == i || this.getTabVal(tab, k, l, width, height) != 1.0) continue;
                ++nbNeighbors;
            }
        }
        return nbNeighbors;
    }

    public ArrayList<Point3DEdge> getNeighbors(double[] tab, int i, int j, int z, int width, int height) {
        ArrayList<Point3DEdge> list = new ArrayList<Point3DEdge>();
        for (int l = j - 1; l <= j + 1; ++l) {
            for (int k = i - 1; k <= i + 1; ++k) {
                if (l == j && k == i || this.getTabVal(tab, k, l, width, height) != 1.0) continue;
                list.add(new Point3DEdge(k, l, z));
            }
        }
        return list;
    }

    public void groupEdges(ArrayList<Edge> edges) {
        double angle = 0.0;
        double meltingAngle = ((Integer)this.ezMeltingAngle.getValue()).intValue();
        int i = 0;
        boolean invert = false;
        Point3DEdge vertex1 = null;
        Point3DEdge vertex2 = null;
        while (i < edges.size()) {
            int j = i + 1;
            Point3DEdge pRemove = null;
            Edge listToMerge = null;
            double angleMax = 0.0;
            if (this.Distancebetween2Point3D(edges.get(i).getVertex1(), edges.get(i).getVertex2()) < 2.0) {
                ++i;
                continue;
            }
            while (j < edges.size()) {
                if (this.Distancebetween2Point3D(edges.get(j).getVertex1(), edges.get(j).getVertex2()) < 2.0) {
                    ++j;
                    continue;
                }
                if (this.samePoint3D(edges.get(i).getVertex1(), edges.get(j).getVertex1()) && (angle = this.angleCalculator(edges.get(i).getVertex1(), edges.get(i).getVertex2(), edges.get(j).getVertex2())) >= meltingAngle && angle >= angleMax) {
                    angleMax = angle;
                    listToMerge = edges.get(j);
                    pRemove = listToMerge.getVertex1();
                    invert = true;
                    vertex1 = edges.get(i).getVertex2();
                    vertex2 = edges.get(j).getVertex2();
                }
                if (this.samePoint3D(edges.get(i).getVertex1(), edges.get(j).getVertex2()) && (angle = this.angleCalculator(edges.get(i).getVertex1(), edges.get(i).getVertex2(), edges.get(j).getVertex1())) >= meltingAngle && angle >= angleMax) {
                    angleMax = angle;
                    listToMerge = edges.get(j);
                    pRemove = listToMerge.getVertex2();
                    invert = false;
                    vertex1 = edges.get(i).getVertex2();
                    vertex2 = edges.get(j).getVertex1();
                }
                if (this.samePoint3D(edges.get(i).getVertex2(), edges.get(j).getVertex1()) && (angle = this.angleCalculator(edges.get(i).getVertex2(), edges.get(i).getVertex1(), edges.get(j).getVertex2())) >= meltingAngle && angle >= angleMax) {
                    angleMax = angle;
                    listToMerge = edges.get(j);
                    pRemove = listToMerge.getVertex1();
                    invert = false;
                    vertex1 = edges.get(i).getVertex1();
                    vertex2 = edges.get(j).getVertex2();
                    edges.get(i).invertEdge();
                }
                if (this.samePoint3D(edges.get(i).getVertex2(), edges.get(j).getVertex2()) && (angle = this.angleCalculator(edges.get(i).getVertex2(), edges.get(i).getVertex1(), edges.get(j).getVertex1())) >= meltingAngle && angle >= angleMax) {
                    angleMax = angle;
                    listToMerge = edges.get(j);
                    pRemove = listToMerge.getVertex2();
                    invert = true;
                    vertex1 = edges.get(i).getVertex1();
                    vertex2 = edges.get(j).getVertex1();
                }
                ++j;
            }
            if (listToMerge != null) {
                listToMerge.removePoint3DFromList(pRemove);
                edges.get(i).setVertex1(vertex1);
                edges.get(i).setVertex2(vertex2);
                edges.get(i).fuseEdges(listToMerge, invert);
                edges.remove(listToMerge);
                i = 0;
                continue;
            }
            ++i;
        }
    }

    public ArrayList<Edge> analyzeSkeleton(Sequence seq, int z) {
        int t = 0;
        int width = seq.getWidth();
        int height = seq.getHeight();
        IcyBufferedImage img = seq.getImage(t, z);
        ArrayList<Edge> edges = new ArrayList<Edge>();
        double[] tabDouble = Array1DUtil.arrayToDoubleArray((Object)img.getDataXY(0), (boolean)img.isSignedDataType());
        LinkedList<Point3DEdge> fifo = new LinkedList<Point3DEdge>();
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                if (tabDouble[i + j * width] == 0.0) continue;
                tabDouble[i + j * width] = 1.0;
            }
        }
        int co = 3;
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                if (this.getTabVal(tabDouble, i, j, width, height) != 1.0 || this.getNbNeighbors(tabDouble, i, j, width, height) != 1) continue;
                fifo.add(new Point3DEdge(i, j, z));
                while (!fifo.isEmpty()) {
                    Point3DEdge v1 = (Point3DEdge)fifo.poll();
                    ArrayList<Point3DEdge> list = new ArrayList<Point3DEdge>();
                    list.add(v1);
                    int k = (int)v1.getX();
                    int l = (int)v1.getY();
                    int nbNeighbors = this.getNbNeighbors(tabDouble, k, l, width, height);
                    this.setTabVal(tabDouble, k, l, 2.0, width, height);
                    if (nbNeighbors == 0) continue;
                    Point3DEdge p = this.getNeighbors(tabDouble, k, l, z, width, height).get(0);
                    k = (int)p.getX();
                    l = (int)p.getY();
                    while (nbNeighbors == 1) {
                        this.setTabVal(tabDouble, k, l, co, width, height);
                        list.add(new Point3DEdge(k, l, z));
                        p = this.getNeighbors(tabDouble, k, l, z, width, height).get(0);
                        k = (int)p.getX();
                        l = (int)p.getY();
                        nbNeighbors = this.getNbNeighbors(tabDouble, k, l, width, height);
                    }
                    this.setTabVal(tabDouble, k, l, 2.0, width, height);
                    Point3DEdge v2 = new Point3DEdge(k, l, z);
                    list.add(v2);
                    Edge e = new Edge(v1, v2, list);
                    edges.add(e);
                    for (int n = 0; n < nbNeighbors; ++n) {
                        fifo.add(new Point3DEdge(k, l, z));
                    }
                    ++co;
                }
            }
        }
        img.setDataXY(0, Array1DUtil.doubleArrayToArray((double[])tabDouble, (Object)img.getDataXY(0)));
        seq.setName(seq.getName() + "_AnalyzeSkeleton");
        return edges;
    }

    public int getNbNeighbors3D(double[][] tab, int i, int j, int z, int width, int height, int depth) {
        int nbNeighbors = 0;
        for (int m = z - 1; m <= z + 1; ++m) {
            for (int l = j - 1; l <= j + 1; ++l) {
                for (int k = i - 1; k <= i + 1; ++k) {
                    if (l == j && k == i && m == z || this.getTabVal3D(tab, k, l, m, width, height, depth) != 1.0) continue;
                    ++nbNeighbors;
                }
            }
        }
        return nbNeighbors;
    }

    public ArrayList<Point3DEdge> getNeighbors3D(double[][] tab, int i, int j, int z, int width, int height, int depth) {
        ArrayList<Point3DEdge> list = new ArrayList<Point3DEdge>();
        for (int m = z - 1; m <= z + 1; ++m) {
            for (int l = j - 1; l <= j + 1; ++l) {
                for (int k = i - 1; k <= i + 1; ++k) {
                    if (l == j && k == i && m == z || this.getTabVal3D(tab, k, l, m, width, height, depth) != 1.0) continue;
                    list.add(new Point3DEdge(k, l, m));
                }
            }
        }
        return list;
    }

    public ArrayList<Edge> analyzeSkeleton3D(Sequence seq) {
        int z;
        int t = 0;
        int width = seq.getWidth();
        int height = seq.getHeight();
        int depth = seq.getSizeZ();
        double[][] tabDouble = new double[width * height][depth];
        for (int z2 = 0; z2 < depth; ++z2) {
            IcyBufferedImage img = seq.getImage(t, z2);
            double[] tab = Array1DUtil.arrayToDoubleArray((Object)img.getDataXY(0), (boolean)img.isSignedDataType());
            for (int i = 0; i < tab.length; ++i) {
                tabDouble[i][z2] = tab[i];
            }
        }
        ArrayList<Edge> edges = new ArrayList<Edge>();
        LinkedList<Point3DEdge> fifo = new LinkedList<Point3DEdge>();
        for (int z3 = 0; z3 < depth; ++z3) {
            for (int j = 0; j < height; ++j) {
                for (int i = 0; i < width; ++i) {
                    if (tabDouble[i + j * width][z3] == 0.0) continue;
                    tabDouble[i + j * width][z3] = 1.0;
                }
            }
        }
        int co = 3;
        for (z = 0; z < depth; ++z) {
            for (int j = 0; j < height; ++j) {
                for (int i = 0; i < width; ++i) {
                    if (this.getTabVal3D(tabDouble, i, j, z, width, height, depth) != 1.0 || this.getNbNeighbors3D(tabDouble, i, j, z, width, height, depth) != 1) continue;
                    fifo.add(new Point3DEdge(i, j, z));
                    while (!fifo.isEmpty()) {
                        Point3DEdge v1 = (Point3DEdge)fifo.poll();
                        ArrayList<Point3DEdge> list = new ArrayList<Point3DEdge>();
                        list.add(v1);
                        int k = (int)v1.getX();
                        int l = (int)v1.getY();
                        int m = (int)v1.getZ();
                        this.setTabVal3D(tabDouble, k, l, m, 2.0, width, height, depth);
                        if (this.getNbNeighbors3D(tabDouble, k, l, m, width, height, depth) == 0) continue;
                        Point3DEdge p = this.getNeighbors3D(tabDouble, k, l, m, width, height, depth).get(0);
                        k = (int)p.getX();
                        l = (int)p.getY();
                        m = (int)p.getZ();
                        while (this.getNbNeighbors3D(tabDouble, k, l, m, width, height, depth) == 1) {
                            this.setTabVal3D(tabDouble, k, l, m, co, width, height, depth);
                            list.add(new Point3DEdge(k, l, m));
                            p = this.getNeighbors3D(tabDouble, k, l, m, width, height, depth).get(0);
                            k = (int)p.getX();
                            l = (int)p.getY();
                            m = (int)p.getZ();
                        }
                        this.setTabVal3D(tabDouble, k, l, m, 2.0, width, height, depth);
                        Point3DEdge v2 = new Point3DEdge(k, l, m);
                        list.add(v2);
                        Edge e = new Edge(v1, v2, list);
                        edges.add(e);
                        for (int n = 0; n < this.getNbNeighbors3D(tabDouble, k, l, m, width, height, depth); ++n) {
                            fifo.add(new Point3DEdge(k, l, m));
                        }
                        ++co;
                    }
                }
            }
        }
        for (z = 0; z < depth; ++z) {
            IcyBufferedImage img = seq.getImage(t, z);
            double[] tab = new double[tabDouble.length];
            for (int i = 0; i < tabDouble.length; ++i) {
                tab[i] = tabDouble[i][z];
            }
            img.setDataXY(0, Array1DUtil.doubleArrayToArray((double[])tab, (Object)img.getDataXY(0)));
        }
        return edges;
    }

    public String VertexInformation(Point3DEdge p) {
        return "Point3DEdge[x=" + p.getX() + ", y=" + p.getY() + ", z=" + p.getZ() + "]";
    }

    public double Distancebetween2Point3D(Point3DEdge a, Point3DEdge b) {
        return Math.sqrt((b.getX() - a.getX()) * (b.getX() - a.getX()) + (b.getY() - a.getY()) * (b.getY() - a.getY()) + (b.getZ() - a.getZ()) * (b.getZ() - a.getZ()));
    }

    public double realDistancebetween2Point3D(List<Point3DEdge> list) {
        double dr = 0.0;
        int j = 1;
        int i = 0;
        while (i < list.size()) {
            if (j < list.size()) {
                dr += this.Distancebetween2Point3D(list.get(i), list.get(j));
            }
            ++i;
            ++j;
        }
        return dr;
    }

    public double angleCalculator(Point3DEdge p, Point3DEdge p1, Point3DEdge p2) {
        double x1 = p1.getX() - p.getX();
        double y1 = p1.getY() - p.getY();
        double z1 = p1.getZ() - p.getZ();
        double x2 = p2.getX() - p.getX();
        double y2 = p2.getY() - p.getY();
        double z2 = p2.getZ() - p.getZ();
        double scalarProduct = x1 * x2 + y1 * y2 + z1 * z2;
        double magnitude1 = this.Distancebetween2Point3D(p, p1);
        double magnitude2 = this.Distancebetween2Point3D(p, p2);
        if (magnitude1 == 0.0 || magnitude2 == 0.0) {
            return -1.0;
        }
        return Math.toDegrees(Math.acos(scalarProduct / (magnitude1 * magnitude2)));
    }

    public void drawROIOnEdges(List<Edge> edges) {
        for (Edge e : edges) {
            ROI2DLine roi = new ROI2DLine(e.getVertex1().getX(), e.getVertex1().getY(), e.getVertex2().getX(), e.getVertex2().getY());
            roi.setReadOnly(false);
            this.seq.addROI((ROI)roi);
        }
    }

    public boolean samePoint3D(Point3DEdge p1, Point3DEdge p2) {
        return p1.getX() == p2.getX() && p1.getY() == p2.getY() && p1.getZ() == p2.getZ();
    }

    public int indexOfPoint3D(List<Point3DEdge> list, Point3DEdge p) {
        for (int i = 0; i < list.size(); ++i) {
            if (!this.samePoint3D(list.get(i), p)) continue;
            return i;
        }
        return -1;
    }

    public void saveResult2Excel(String path, ArrayList<Edge> edges) {
        try {
            WritableWorkbook pageresultat = Workbook.createWorkbook((File)new File(path));
            WritableSheet page = pageresultat.createSheet("RESULT ", 0);
            page.mergeCells(0, 0, 2, 0);
            page.mergeCells(3, 0, 5, 0);
            page.setColumnView(6, 40);
            page.setColumnView(7, 40);
            int row = 0;
            page.addCell((WritableCell)new Label(6, row, this.seq.getName()));
            page.addCell((WritableCell)new Label(0, ++row, "Vertex 1"));
            page.addCell((WritableCell)new Label(3, row, "Vertex 2"));
            page.addCell((WritableCell)new Label(6, row, "Real distance"));
            page.addCell((WritableCell)new Label(7, row, "Distance between the two vertices"));
            page.addCell((WritableCell)new Label(8, row, "Number of pixel from segment"));
            page.addCell((WritableCell)new Label(9, row, "ratio"));
            page.addCell((WritableCell)new Label(0, ++row, "x"));
            page.addCell((WritableCell)new Label(1, row, "y"));
            page.addCell((WritableCell)new Label(2, row, "z"));
            page.addCell((WritableCell)new Label(3, row, "x"));
            page.addCell((WritableCell)new Label(4, row, "y"));
            page.addCell((WritableCell)new Label(5, row, "z"));
            ++row;
            for (Edge e : edges) {
                double distance = this.Distancebetween2Point3D(e.getVertex1(), e.getVertex2());
                if (distance <= 10.0) continue;
                Number number = new Number(0, row, e.getVertex1().getX());
                page.addCell((WritableCell)number);
                number = new Number(1, row, e.getVertex1().getY());
                page.addCell((WritableCell)number);
                number = new Number(2, row, e.getVertex1().getZ());
                page.addCell((WritableCell)number);
                number = new Number(3, row, e.getVertex2().getX());
                page.addCell((WritableCell)number);
                number = new Number(4, row, e.getVertex2().getY());
                page.addCell((WritableCell)number);
                number = new Number(5, row, e.getVertex2().getZ());
                page.addCell((WritableCell)number);
                double realDistance = this.realDistancebetween2Point3D(e.getEdge());
                if (realDistance > 2.0) {
                    number = new Number(6, row, realDistance);
                }
                page.addCell((WritableCell)number);
                number = new Number(7, row, distance);
                page.addCell((WritableCell)number);
                number = new Number(8, row, (double)e.getEdge().size());
                page.addCell((WritableCell)number);
                number = new Number(9, row, realDistance / distance);
                page.addCell((WritableCell)number);
                ++row;
            }
            Formula formule = new Formula(9, row, "MOYENNE(J4:J" + row + ")");
            page.addCell((WritableCell)formule);
            pageresultat.write();
            pageresultat.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (WriteException we) {
            we.printStackTrace();
        }
    }

    public void saveResult2ExcelAurel(String path, ArrayList<Edge> edges) {
        try {
            WritableWorkbook pageresultat = Workbook.createWorkbook((File)new File(path));
            WritableSheet page = pageresultat.createSheet("RESULT ", 0);
            int row = 0;
            page.addCell((WritableCell)new Label(6, row, this.seq.getName()));
            page.addCell((WritableCell)new Label(0, ++row, "# astocytes"));
            page.addCell((WritableCell)new Label(3, row, "id"));
            page.addCell((WritableCell)new Label(6, row, "# primary process"));
            page.addCell((WritableCell)new Label(7, row, "# secondary process"));
            page.addCell((WritableCell)new Label(8, row, "# third process"));
            page.addCell((WritableCell)new Label(9, row, "branch"));
            pageresultat.write();
            pageresultat.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (WriteException we) {
            we.printStackTrace();
        }
    }
}

