/*
 * Decompiled with CFR 0.152.
 */
package plugins.vannary.morphomaths;

import icy.image.IcyBufferedImage;
import icy.image.ImageDataIterator;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import icy.type.collection.array.Array2DUtil;
import icy.type.dimension.Dimension5D;
import icy.type.point.Point3D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferDouble;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import plugins.adufour.connectedcomponents.ConnectedComponents;
import plugins.vannary.morphomaths.Chamfer3;
import plugins.vannary.morphomaths.DistanceTransforms;
import plugins.vannary.morphomaths.PixWatershed;
import plugins.vannary.morphomaths.PixWatershed3D;

public class MorphOp {
    static final int TYPESKEL_MAX = 0;
    static final int TYPESKEL_SMOOTH = 1;
    static final int TYPEWSHED_SEP_BASINS = 0;
    static final int TYPEWSHED_BASINS_MAP = 1;
    static final int TYPEWSHED_WSHEDONLY = 2;
    private static final Point FICTIF = new Point(-1, -1);
    private static final Point3D FICTIF3D = new Point3D.Float(-1.0f, -1.0f, -1.0f);
    private static final byte CH0 = 0;
    private static final byte CH1 = 1;
    private static final byte CH2 = 2;
    private static final byte CH3 = 3;
    static final int MAXVAL = 37265;
    private static final int MASK = -2;
    private static final int WSHED = 0;
    private static final int INIT = -1;
    private static final int INQUEUE = -3;
    private static final int BORDER = -4;

    public static void erodeGreyScale(Sequence seq, int z, double[][] eltS, int xCenterElt, int yCenterElt) {
        double eWidth = eltS.length;
        double eHeight = eltS[0].length;
        int width = seq.getFirstImage().getWidth();
        int height = seq.getFirstImage().getHeight();
        for (int t = 0; t < seq.getSizeT(); ++t) {
            int offset = 0;
            IcyBufferedImage img = seq.getImage(t, z);
            double[] tabInDouble = Array1DUtil.arrayToDoubleArray((Object)img.getDataXY(0), (boolean)img.isSignedDataType());
            double[] tabOutDouble = Arrays.copyOf(tabInDouble, tabInDouble.length);
            for (int y = 0; y < height; ++y) {
                int x = 0;
                while (x < width) {
                    double val = Double.MAX_VALUE;
                    int yElt = 0;
                    while ((double)yElt < eHeight) {
                        int xElt = 0;
                        while ((double)xElt < eWidth) {
                            if (eltS[xElt][yElt] > 0.0) {
                                int offRel;
                                double temp;
                                int xRel = xElt - xCenterElt;
                                int yRel = yElt - yCenterElt;
                                if (xRel + x >= 0 && yRel + y >= 0 && xRel + x < width && yRel + y < height && (temp = tabInDouble[offRel = xRel + x + width * (y + yRel)]) < val) {
                                    val = temp;
                                }
                            }
                            ++xElt;
                        }
                        ++yElt;
                    }
                    tabOutDouble[offset] = val;
                    ++x;
                    ++offset;
                }
            }
            img.setDataXY(0, Array1DUtil.doubleArrayToArray((double[])tabOutDouble, (Object)img.getDataXY(0)));
        }
    }

    public static void dilateGreyScale(Sequence seq, int z, double[][] eltS, int xCenterElt, int yCenterElt) {
        double eWidth = eltS.length;
        double eHeight = eltS[0].length;
        int width = seq.getFirstImage().getWidth();
        int height = seq.getFirstImage().getHeight();
        for (int t = 0; t < seq.getSizeT(); ++t) {
            int offset = 0;
            IcyBufferedImage img = seq.getImage(t, z);
            double[] tabInDouble = Array1DUtil.arrayToDoubleArray((Object)img.getDataXY(0), (boolean)img.isSignedDataType());
            double[] tabOutDouble = Arrays.copyOf(tabInDouble, tabInDouble.length);
            for (int y = 0; y < height; ++y) {
                int x = 0;
                while (x < width) {
                    double val = 0.0;
                    int yElt = 0;
                    while ((double)yElt < eHeight) {
                        int xElt = 0;
                        while ((double)xElt < eWidth) {
                            if (eltS[xElt][yElt] > 0.0) {
                                int offRel;
                                double temp;
                                int xRel = xElt - xCenterElt;
                                int yRel = yElt - yCenterElt;
                                if (xRel + x >= 0 && yRel + y >= 0 && xRel + x < width && yRel + y < height && (temp = tabInDouble[offRel = xRel + x + width * (y + yRel)]) > val) {
                                    val = temp;
                                }
                            }
                            ++xElt;
                        }
                        ++yElt;
                    }
                    tabOutDouble[offset] = val;
                    ++x;
                    ++offset;
                }
            }
            img.setDataXY(0, Array1DUtil.doubleArrayToArray((double[])tabOutDouble, (Object)img.getDataXY(0)));
        }
    }

    public static void erodeGreyScale3D(Sequence seq, double[][][] eltS, int xCenterElt, int yCenterElt, int zCenterElt) {
        int eWidth = eltS.length;
        int eHeight = eltS[0].length;
        int eDepth = eltS[0][0].length;
        int width = seq.getFirstImage().getWidth();
        int height = seq.getFirstImage().getHeight();
        int sizeT = seq.getSizeT();
        for (int t = 0; t < sizeT; ++t) {
            int z;
            int depth = seq.getSizeZ(t);
            double[][] dataInDouble = Array2DUtil.arrayToDoubleArray((Object)seq.getDataXYZ(t, 0), (boolean)seq.isSignedDataType());
            double[][] dataOutDouble = Array2DUtil.doubleArrayToDoubleArray((double[][])dataInDouble, (int)0, null, (int)0, (int)dataInDouble.length);
            for (z = 0; z < depth; ++z) {
                int offset = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        double val = Double.MAX_VALUE;
                        for (int zElt = 0; zElt < eDepth; ++zElt) {
                            for (int yElt = 0; yElt < eHeight; ++yElt) {
                                for (int xElt = 0; xElt < eWidth; ++xElt) {
                                    int offRel;
                                    double temp;
                                    if (!(eltS[xElt][yElt][zElt] > 0.0)) continue;
                                    int xRel = xElt - xCenterElt;
                                    int yRel = yElt - yCenterElt;
                                    int zRel = zElt - zCenterElt;
                                    int xTemp = xRel + x;
                                    int yTemp = yRel + y;
                                    int zTemp = zRel + z;
                                    if (xTemp < 0 || yTemp < 0 || xTemp >= width || yTemp >= height || zTemp < 0 || zTemp >= seq.getSizeZ(t) || !((temp = dataInDouble[zTemp][offRel = xTemp + width * yTemp]) < val)) continue;
                                    val = temp;
                                }
                            }
                        }
                        dataOutDouble[z][offset] = val;
                        ++x;
                        ++offset;
                    }
                }
            }
            seq.beginUpdate();
            for (z = 0; z < depth; ++z) {
                IcyBufferedImage img = seq.getImage(t, z);
                img.setDataXY(0, Array1DUtil.doubleArrayToArray((double[])dataOutDouble[z], (Object)img.getDataXY(0)));
            }
            seq.endUpdate();
        }
    }

    public static void dilateGreyScale3D(Sequence seq, double[][][] eltS, int xCenterElt, int yCenterElt, int zCenterElt) {
        double eWidth = eltS.length;
        double eHeight = eltS[0].length;
        double eDepth = eltS[0][0].length;
        int width = seq.getFirstImage().getWidth();
        int height = seq.getFirstImage().getHeight();
        int sizeT = seq.getSizeT();
        for (int t = 0; t < sizeT; ++t) {
            int z;
            int depth = seq.getSizeZ(t);
            double[][] dataInDouble = Array2DUtil.arrayToDoubleArray((Object)seq.getDataXYZ(t, 0), (boolean)seq.isSignedDataType());
            double[][] dataOutDouble = Array2DUtil.doubleArrayToDoubleArray((double[][])dataInDouble, (int)0, null, (int)0, (int)dataInDouble.length);
            for (z = 0; z < depth; ++z) {
                int offset = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        double val = 0.0;
                        int zElt = 0;
                        while ((double)zElt < eDepth) {
                            int yElt = 0;
                            while ((double)yElt < eHeight) {
                                int xElt = 0;
                                while ((double)xElt < eWidth) {
                                    if (eltS[xElt][yElt][zElt] > 0.0) {
                                        int offRel;
                                        double temp;
                                        int xRel = xElt - xCenterElt;
                                        int yRel = yElt - yCenterElt;
                                        int zRel = zElt - zCenterElt;
                                        int xTemp = xRel + x;
                                        int yTemp = yRel + y;
                                        int zTemp = zRel + z;
                                        if (xTemp >= 0 && yTemp >= 0 && xTemp < width && yTemp < height && zTemp >= 0 && zTemp < seq.getSizeZ(t) && (temp = dataInDouble[zTemp][offRel = xTemp + width * yTemp]) > val) {
                                            val = temp;
                                        }
                                    }
                                    ++xElt;
                                }
                                ++yElt;
                            }
                            ++zElt;
                        }
                        dataOutDouble[z][offset] = val;
                        ++x;
                        ++offset;
                    }
                }
            }
            seq.beginUpdate();
            for (z = 0; z < depth; ++z) {
                IcyBufferedImage img = seq.getImage(t, z);
                img.setDataXY(0, Array1DUtil.doubleArrayToArray((double[])dataOutDouble[z], (Object)img.getDataXY(0)));
            }
            seq.endUpdate();
        }
    }

    public static void openGreyScale(Sequence seq, int z, double[][] eltS, int xCenterElt, int yCenterElt) {
        MorphOp.erodeGreyScale(seq, z, eltS, xCenterElt, yCenterElt);
        int width = eltS.length;
        int height = eltS[0].length;
        double[][] eltST = MorphOp.transpose(eltS);
        MorphOp.dilateGreyScale(seq, z, eltST, width - xCenterElt - 1, height - yCenterElt - 1);
    }

    public static void closeGreyScale(Sequence seq, int z, double[][] eltS, int xCenterElt, int yCenterElt) {
        MorphOp.dilateGreyScale(seq, z, eltS, xCenterElt, yCenterElt);
        int width = eltS.length;
        int height = eltS[0].length;
        double[][] eltST = MorphOp.transpose(eltS);
        MorphOp.erodeGreyScale(seq, z, eltST, width - xCenterElt - 1, height - yCenterElt - 1);
    }

    private static double[][] transpose(double[][] elt) {
        int width = elt.length;
        int height = elt[0].length;
        double[][] transp = new double[width][height];
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                transp[i][j] = elt[width - i - 1][height - j - 1];
            }
        }
        return transp;
    }

    public static void openGreyScale3D(Sequence seq, double[][][] eltS, int xCenterElt, int yCenterElt, int zCenterElt) {
        MorphOp.erodeGreyScale3D(seq, eltS, xCenterElt, yCenterElt, zCenterElt);
        int depth = eltS[0][0].length;
        int height = eltS[0].length;
        int width = eltS.length;
        double[][][] eltST = MorphOp.transpose(eltS);
        MorphOp.dilateGreyScale3D(seq, eltST, width - 1 - xCenterElt, height - 1 - yCenterElt, depth - 1 - zCenterElt);
    }

    public static void closeGreyScale3D(Sequence seq, double[][][] eltS, int xCenterElt, int yCenterElt, int zCenterElt) {
        MorphOp.dilateGreyScale3D(seq, eltS, xCenterElt, yCenterElt, zCenterElt);
        int depth = eltS[0][0].length;
        int height = eltS[0].length;
        int width = eltS.length;
        double[][][] eltST = MorphOp.transpose(eltS);
        MorphOp.erodeGreyScale3D(seq, eltST, width - 1 - xCenterElt, height - 1 - yCenterElt, depth - 1 - zCenterElt);
    }

    private static double[][][] transpose(double[][][] elt) {
        int depth = elt[0][0].length;
        int height = elt[0].length;
        int width = elt.length;
        double[][][] transp = new double[width][height][depth];
        for (int z = 0; z < depth; ++z) {
            for (int j = 0; j < height; ++j) {
                for (int i = 0; i < width; ++i) {
                    transp[i][j][z] = elt[width - i - 1][height - j - 1][depth - z - 1];
                }
            }
        }
        return transp;
    }

    public static void whiteTopHat(Sequence seqIn, int z, double[][] eltS, int xCenterElt, int yCenterElt) throws InterruptedException {
        int eWidth = eltS.length;
        int eHeight = eltS[0].length;
        Sequence seqTemp = SequenceUtil.getCopy((Sequence)seqIn);
        MorphOp.erodeGreyScale(seqTemp, z, eltS, xCenterElt, yCenterElt);
        int width = seqIn.getFirstImage().getWidth();
        int height = seqIn.getFirstImage().getHeight();
        double[][] eltST = MorphOp.transpose(eltS);
        xCenterElt = eWidth - 1 - xCenterElt;
        yCenterElt = eHeight - 1 - yCenterElt;
        for (int t = 0; t < seqIn.getSizeT(); ++t) {
            IcyBufferedImage img = seqIn.getImage(t, z);
            IcyBufferedImage imgTemp = seqTemp.getImage(t, z);
            int offset = 0;
            double[] tabInDouble = Array1DUtil.arrayToDoubleArray((Object)img.getDataXY(0), (boolean)img.isSignedDataType());
            double[] tabOutDouble = Array1DUtil.arrayToDoubleArray((Object)imgTemp.getDataXY(0), (boolean)imgTemp.isSignedDataType());
            for (int y = 0; y < height; ++y) {
                int x = 0;
                while (x < width) {
                    double val = 0.0;
                    for (int yElt = 0; yElt < eHeight; ++yElt) {
                        for (int xElt = 0; xElt < eWidth; ++xElt) {
                            int offRel;
                            double temp;
                            if (!(eltST[xElt][yElt] > 0.0)) continue;
                            int xRel = xElt - xCenterElt;
                            int yRel = yElt - yCenterElt;
                            int xTemp = xRel + x;
                            int yTemp = yRel + y;
                            if (xTemp < 0 || yTemp < 0 || xTemp >= width || yTemp >= height || !((temp = tabOutDouble[offRel = xTemp + width * yTemp]) > val)) continue;
                            val = temp;
                        }
                    }
                    tabInDouble[offset] = tabInDouble[offset] - val;
                    ++x;
                    ++offset;
                }
            }
            img.setDataXY(0, Array1DUtil.doubleArrayToArray((double[])tabInDouble, (Object)img.getDataXY(0)));
        }
    }

    public static void blackTopHat(Sequence seqIn, int z, double[][] eltS, int xCenterElt, int yCenterElt) throws InterruptedException {
        int eWidth = eltS.length;
        int eHeight = eltS[0].length;
        Sequence seqTemp = SequenceUtil.getCopy((Sequence)seqIn);
        MorphOp.dilateGreyScale(seqTemp, z, eltS, xCenterElt, yCenterElt);
        double[][] eltST = MorphOp.transpose(eltS);
        xCenterElt = eWidth - 1 - xCenterElt;
        yCenterElt = eHeight - 1 - yCenterElt;
        int width = seqIn.getFirstImage().getWidth();
        int height = seqIn.getFirstImage().getHeight();
        for (int t = 0; t < seqIn.getSizeT(); ++t) {
            IcyBufferedImage img = seqIn.getImage(t, z);
            IcyBufferedImage imgTemp = seqTemp.getImage(t, z);
            int offset = 0;
            double[] tabInDouble = Array1DUtil.arrayToDoubleArray((Object)img.getDataXY(0), (boolean)img.isSignedDataType());
            double[] tabOutDouble = Array1DUtil.arrayToDoubleArray((Object)imgTemp.getDataXY(0), (boolean)imgTemp.isSignedDataType());
            for (int y = 0; y < height; ++y) {
                int x = 0;
                while (x < width) {
                    double val = Double.MAX_VALUE;
                    for (int yElt = 0; yElt < eHeight; ++yElt) {
                        for (int xElt = 0; xElt < eWidth; ++xElt) {
                            int offRel;
                            double temp;
                            if (!(eltST[xElt][yElt] > 0.0)) continue;
                            int xRel = xElt - xCenterElt;
                            int yRel = yElt - yCenterElt;
                            int xTemp = xRel + x;
                            int yTemp = yRel + y;
                            if (xTemp < 0 || yTemp < 0 || xTemp >= width || yTemp >= height || !((temp = tabOutDouble[offRel = xTemp + width * yTemp]) < val)) continue;
                            val = temp;
                        }
                    }
                    tabInDouble[offset] = val - tabInDouble[offset];
                    ++x;
                    ++offset;
                }
            }
            img.setDataXY(0, Array1DUtil.doubleArrayToArray((double[])tabInDouble, (Object)img.getDataXY(0)));
        }
    }

    public static void whiteTopHat3D(Sequence seqIn, double[][][] eltS, int xCenterElt, int yCenterElt, int zCenterElt) throws InterruptedException {
        int eWidth = eltS.length;
        int eHeight = eltS[0].length;
        int eDepth = eltS[0][0].length;
        Sequence seqTemp = SequenceUtil.getCopy((Sequence)seqIn);
        MorphOp.erodeGreyScale3D(seqTemp, eltS, xCenterElt, yCenterElt, zCenterElt);
        double[][][] eltST = MorphOp.transpose(eltS);
        xCenterElt = eWidth - 1 - xCenterElt;
        yCenterElt = eHeight - 1 - yCenterElt;
        zCenterElt = eDepth - 1 - zCenterElt;
        int width = seqIn.getFirstImage().getWidth();
        int height = seqIn.getFirstImage().getHeight();
        for (int t = 0; t < seqIn.getSizeT(); ++t) {
            int z;
            int depth = seqIn.getSizeZ(t);
            double[][] dataInDouble = Array2DUtil.arrayToDoubleArray((Object)seqIn.getDataXYZ(t, 0), (boolean)seqIn.isSignedDataType());
            double[][] dataTempDouble = Array2DUtil.arrayToDoubleArray((Object)seqTemp.getDataXYZ(t, 0), (boolean)seqTemp.isSignedDataType());
            for (z = 0; z < depth; ++z) {
                int offset = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        double val = 0.0;
                        for (int zElt = 0; zElt < eDepth; ++zElt) {
                            for (int yElt = 0; yElt < eHeight; ++yElt) {
                                for (int xElt = 0; xElt < eWidth; ++xElt) {
                                    double temp;
                                    if (!(eltST[xElt][yElt][zElt] > 0.0)) continue;
                                    int xRel = xElt - xCenterElt;
                                    int yRel = yElt - yCenterElt;
                                    int zRel = zElt - zCenterElt;
                                    int xTemp = xRel + x;
                                    int yTemp = yRel + y;
                                    int zTemp = zRel + z;
                                    if (xTemp < 0 || yTemp < 0 || xTemp >= width || yTemp >= height || zRel + z < 0 || zRel + z >= seqIn.getSizeZ(t) || !((temp = dataTempDouble[zTemp][xTemp + width * yTemp]) > val)) continue;
                                    val = temp;
                                }
                            }
                        }
                        dataInDouble[z][offset] = dataInDouble[z][offset] - val;
                        ++x;
                        ++offset;
                    }
                }
            }
            seqIn.beginUpdate();
            for (z = 0; z < depth; ++z) {
                IcyBufferedImage img = seqIn.getImage(t, z);
                img.setDataXY(0, Array1DUtil.doubleArrayToArray((double[])dataInDouble[z], (Object)img.getDataXY(0)));
            }
            seqIn.endUpdate();
        }
    }

    public static void blackTopHat3D(Sequence seqIn, double[][][] eltS, int xCenterElt, int yCenterElt, int zCenterElt) throws InterruptedException {
        int eWidth = eltS.length;
        int eHeight = eltS[0].length;
        int eDepth = eltS[0][0].length;
        Sequence seqTemp = SequenceUtil.getCopy((Sequence)seqIn);
        MorphOp.dilateGreyScale3D(seqTemp, eltS, xCenterElt, yCenterElt, zCenterElt);
        double[][][] eltST = MorphOp.transpose(eltS);
        xCenterElt = eWidth - 1 - xCenterElt;
        yCenterElt = eHeight - 1 - yCenterElt;
        zCenterElt = eDepth - 1 - zCenterElt;
        int width = seqIn.getFirstImage().getWidth();
        int height = seqIn.getFirstImage().getHeight();
        for (int t = 0; t < seqIn.getSizeT(); ++t) {
            int z;
            int depth = seqIn.getSizeZ(t);
            double[][] dataInDouble = Array2DUtil.arrayToDoubleArray((Object)seqIn.getDataXYZ(t, 0), (boolean)seqIn.isSignedDataType());
            double[][] dataOutDouble = Array2DUtil.arrayToDoubleArray((Object)seqTemp.getDataXYZ(t, 0), (boolean)seqTemp.isSignedDataType());
            for (z = 0; z < depth; ++z) {
                int offset = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        double val = Double.MAX_VALUE;
                        for (int zElt = 0; zElt < eDepth; ++zElt) {
                            for (int yElt = 0; yElt < eHeight; ++yElt) {
                                for (int xElt = 0; xElt < eWidth; ++xElt) {
                                    if (!(eltST[xElt][yElt][zElt] > 0.0)) continue;
                                    int xRel = xElt - xCenterElt;
                                    int yRel = yElt - yCenterElt;
                                    int zRel = zElt - zCenterElt;
                                    int xTemp = xRel + x;
                                    int yTemp = yRel + y;
                                    int zTemp = zRel + z;
                                    if (xTemp < 0 || yTemp < 0 || xTemp >= width || yTemp >= height || zRel + z < 0 || zRel + z >= depth) continue;
                                    val = Math.min(dataOutDouble[zTemp][xTemp + width * yTemp], val);
                                }
                            }
                        }
                        dataInDouble[z][offset] = val - dataInDouble[z][offset];
                        ++x;
                        ++offset;
                    }
                }
            }
            seqIn.beginUpdate();
            for (z = 0; z < depth; ++z) {
                IcyBufferedImage img = seqIn.getImage(t, z);
                img.setDataXY(0, Array1DUtil.doubleArrayToArray((double[])dataInDouble[z], (Object)img.getDataXY(0)));
            }
            seqIn.endUpdate();
        }
    }

    public static void gradient(Sequence seq, int z, double[][] eltS, int xCenterElt, int yCenterElt) throws InterruptedException {
        double eWidth = eltS.length;
        double eHeight = eltS[0].length;
        int width = seq.getFirstImage().getWidth();
        int height = seq.getFirstImage().getHeight();
        Sequence seqTemp = SequenceUtil.getCopy((Sequence)seq);
        for (int t = 0; t < seq.getSizeT(); ++t) {
            int offset = 0;
            IcyBufferedImage img = seq.getImage(t, z);
            IcyBufferedImage imgTemp = seqTemp.getImage(t, z);
            double[] tabInDouble = Array1DUtil.arrayToDoubleArray((Object)img.getDataXY(0), (boolean)img.isSignedDataType());
            double[] tabOutDouble = Array1DUtil.arrayToDoubleArray((Object)imgTemp.getDataXY(0), (boolean)imgTemp.isSignedDataType());
            for (int y = 0; y < height; ++y) {
                int x = 0;
                while (x < width) {
                    double min = Double.MAX_VALUE;
                    double max = 0.0;
                    int yElt = 0;
                    while ((double)yElt < eHeight) {
                        int xElt = 0;
                        while ((double)xElt < eWidth) {
                            if (eltS[xElt][yElt] > 0.0) {
                                int xRel = xElt - xCenterElt;
                                int yRel = yElt - yCenterElt;
                                int xTemp = xRel + x;
                                int yTemp = yRel + y;
                                if (xTemp >= 0 && yTemp >= 0 && xTemp < width && yTemp < height) {
                                    int offRel = xTemp + width * yTemp;
                                    double temp = tabOutDouble[offRel];
                                    if (temp < min) {
                                        min = temp;
                                    }
                                    if (temp > max) {
                                        max = temp;
                                    }
                                }
                            }
                            ++xElt;
                        }
                        ++yElt;
                    }
                    tabInDouble[offset] = max - min;
                    ++x;
                    ++offset;
                }
            }
            img.setDataXY(0, Array1DUtil.doubleArrayToArray((double[])tabInDouble, (Object)img.getDataXY(0)));
        }
    }

    public static void gradient3D(Sequence seq, double[][][] eltS, int xCenterElt, int yCenterElt, int zCenterElt) {
        int eWidth = eltS.length;
        int eHeight = eltS[0].length;
        int eDepth = eltS[0][0].length;
        int width = seq.getFirstImage().getWidth();
        int height = seq.getFirstImage().getHeight();
        int sizeT = seq.getSizeT();
        for (int t = 0; t < sizeT; ++t) {
            int z;
            int depth = seq.getSizeZ(t);
            double[][] dataInDouble = Array2DUtil.arrayToDoubleArray((Object)seq.getDataXYZ(t, 0), (boolean)seq.isSignedDataType());
            double[][] dataOutDouble = Array2DUtil.doubleArrayToDoubleArray((double[][])dataInDouble, (int)0, null, (int)0, (int)dataInDouble.length);
            for (z = 0; z < depth; ++z) {
                int offset = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        double min = Double.MAX_VALUE;
                        double max = 0.0;
                        for (int zElt = 0; zElt < eDepth; ++zElt) {
                            for (int yElt = 0; yElt < eHeight; ++yElt) {
                                for (int xElt = 0; xElt < eWidth; ++xElt) {
                                    if (!(eltS[xElt][yElt][zElt] > 0.0)) continue;
                                    int xRel = xElt - xCenterElt;
                                    int yRel = yElt - yCenterElt;
                                    int zRel = zElt - zCenterElt;
                                    int xTemp = xRel + x;
                                    int yTemp = yRel + y;
                                    int zTemp = zRel + z;
                                    if (xTemp < 0 || yTemp < 0 || xTemp >= width || yTemp >= height || zTemp < 0 || zTemp >= seq.getSizeZ(t)) continue;
                                    double temp = dataInDouble[zTemp][xTemp + width * yTemp];
                                    if (temp < min) {
                                        min = temp;
                                    }
                                    if (!(temp > max)) continue;
                                    max = temp;
                                }
                            }
                        }
                        dataOutDouble[z][offset] = max - min;
                        ++x;
                        ++offset;
                    }
                }
            }
            seq.beginUpdate();
            for (z = 0; z < depth; ++z) {
                IcyBufferedImage img = seq.getImage(t, z);
                img.setDataXY(0, Array1DUtil.doubleArrayToArray((double[])dataOutDouble[z], (Object)img.getDataXY(0)));
            }
            seq.endUpdate();
        }
    }

    public static void distanceMap2D(Sequence seqIn, int z, double threshold, boolean above) {
        int t;
        DistanceTransforms distTrans = new DistanceTransforms();
        int width = seqIn.getFirstImage().getWidth();
        int height = seqIn.getFirstImage().getHeight();
        int sizeImage = width * height;
        Sequence seqOut = new Sequence();
        for (t = 0; t < seqIn.getSizeT(); ++t) {
            IcyBufferedImage img = seqIn.getImage(t, z);
            IcyBufferedImage imgOut = new IcyBufferedImage(width, height, 1, DataType.DOUBLE);
            DataBufferDouble bufOut = (DataBufferDouble)imgOut.getRaster().getDataBuffer();
            double[] map = bufOut.getData();
            double[] tabInDouble = Array1DUtil.arrayToDoubleArray((Object)img.getDataXY(0), (boolean)img.isSignedDataType());
            for (int i = 0; i < sizeImage; ++i) {
                map[i] = (above ? tabInDouble[i] > threshold : tabInDouble[i] < threshold) ? (double)sizeImage : 0.0;
            }
            distTrans.updateUnsignedChamferDistance2D(width, height, map);
            seqOut.setImage(t, z, (BufferedImage)imgOut);
        }
        seqIn.removeAllImages();
        for (t = 0; t < seqOut.getSizeT(); ++t) {
            seqIn.setImage(t, z, (BufferedImage)seqOut.getImage(t, 0));
        }
    }

    public static void distanceMap3D(Sequence seqIn, double threshold, boolean above) {
        int t;
        Chamfer3 distTrans = new Chamfer3();
        int width = seqIn.getFirstImage().getWidth();
        int height = seqIn.getFirstImage().getHeight();
        int maxPix = width * height;
        Sequence seqOut = new Sequence();
        for (t = 0; t < seqIn.getSizeT(); ++t) {
            int depth = seqIn.getSizeZ(t);
            double[][] map = MorphOp.initializeMap(seqIn, t, above, threshold);
            distTrans.updateUnsignedChamferDistance3D(width, height, depth, map);
            for (int z = 0; z < depth; ++z) {
                IcyBufferedImage imgOut = new IcyBufferedImage(width, height, 1, DataType.DOUBLE);
                DataBufferDouble bufOut = (DataBufferDouble)imgOut.getRaster().getDataBuffer();
                double[] dataOut = bufOut.getData();
                for (int offset = 0; offset < maxPix; ++offset) {
                    dataOut[offset] = map[z][offset];
                }
                seqOut.setImage(t, z, (BufferedImage)imgOut);
            }
        }
        seqIn.removeAllImages();
        for (t = 0; t < seqOut.getSizeT(); ++t) {
            for (int z = 0; z < seqOut.getSizeZ(t); ++z) {
                seqIn.setImage(t, z, (BufferedImage)seqOut.getImage(t, z));
            }
        }
    }

    private static double[][] initializeMap(Sequence seq, int t, boolean above, double threshold) {
        Dimension5D.Integer size = seq.getDimension5D();
        double[][] volumeMap = new double[size.sizeZ][];
        int pixelNumber = size.sizeX * size.sizeY;
        for (int k = 0; k < size.sizeZ; ++k) {
            double[] sliceMap = new double[pixelNumber];
            ImageDataIterator sliceIt = new ImageDataIterator(seq.getImage(t, k), 0);
            while (!sliceIt.done()) {
                double intensity = sliceIt.get();
                sliceMap[sliceIt.getX() + sliceIt.getY() * size.sizeX] = above ? (double)(intensity > threshold ? pixelNumber : 0) : (double)(intensity < threshold ? pixelNumber : 0);
                sliceIt.next();
            }
            volumeMap[k] = sliceMap;
        }
        return volumeMap;
    }

    private static double getTabVal(double[] tab, int x, int y, int nc, int nr) {
        if (x < 0 || x >= nc || y < 0 || y >= nr) {
            return 0.0;
        }
        double d = tab[x + nc * y];
        return d;
    }

    private static void setTabVal(double[] tab, int x, int y, double d, int nc, int nr) {
        if (x >= 0 && x < nc && y >= 0 && y < nr) {
            tab[x + nc * y] = d;
        }
    }

    private static double getTabVal3D(double[][] tab, int x, int y, int z, int nc, int nr, int nz) {
        if (x < 0 || x >= nc || y < 0 || y >= nr || z < 0 || z >= nz) {
            return 0.0;
        }
        return tab[z][x + nc * y];
    }

    private static void setTabVal3D(double[][] tab, int x, int y, int z, double d, int nc, int nr, int nz) {
        if (x >= 0 && x < nc && y >= 0 && y < nr && z >= 0 && z < nz) {
            tab[z][x + nc * y] = d;
        }
    }

    private static boolean isPt(double[] tab, int i, int j, int ncols, int nrows) {
        return MorphOp.getTabVal(tab, i, j, ncols, nrows) > 0.0;
    }

    private static boolean isPt3D(double[][] tab, int i, int j, int z, int ncols, int nrows, int nz) {
        return MorphOp.getTabVal3D(tab, i, j, z, ncols, nrows, nz) > 0.0;
    }

    private static boolean isPtSkel(double[] tab, int i, int j, int ncols, int nrows) {
        return true;
    }

    private static boolean isPtSkel3D(double[][] tab, int i, int j, int z, int ncols, int nrows, int nz) {
        for (int m = z - 1; m < z + 1; ++m) {
            for (int l = j - 1; l < j + 1; ++l) {
                for (int k = i - 1; k < i + 1; ++k) {
                    if (MorphOp.getTabVal3D(tab, m, l, k, ncols, nrows, nz) != 2.0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static void invertFifo(LinkedList<Point> fifo) {
        int i;
        int size = fifo.size();
        ArrayList<Point> list = new ArrayList<Point>();
        for (i = 0; i < size; ++i) {
            list.add(fifo.pollLast());
        }
        for (i = 0; i < size; ++i) {
            fifo.add((Point)list.get(0));
            list.remove(0);
        }
    }

    private static void invertFifo3D(LinkedList<Point3D> fifo) {
        int i;
        int size = fifo.size();
        ArrayList<Point3D> list = new ArrayList<Point3D>();
        for (i = 0; i < size; ++i) {
            list.add(fifo.pollLast());
        }
        for (i = 0; i < size; ++i) {
            fifo.add((Point3D)list.get(0));
            list.remove(0);
        }
    }

    private static void initSquelet1(Sequence seq, int z, double threshold, boolean above) throws InterruptedException {
        double nmin = 1.0;
        double nmax = Double.MAX_VALUE;
        int nc = seq.getFirstImage().getWidth();
        int nr = seq.getFirstImage().getHeight();
        Sequence seqOut = SequenceUtil.getCopy((Sequence)seq);
        boolean signed = seq.getDataType_().isSigned();
        double[] tab_Dist = new double[nc * nr];
        seqOut = MorphOp.getDistance(seqOut, 4);
        for (int t = 0; t < seq.getSizeT(); ++t) {
            for (int c = 0; c < seq.getSizeC(); ++c) {
                int i;
                int j;
                double n = 0.0;
                Array1DUtil.arrayToDoubleArray((Object)seqOut.getDataXY(t, z, c), (double[])tab_Dist, (boolean)signed);
                int offset = 0;
                IcyBufferedImage img = seq.getImage(t, z);
                double[] tab_Img = Array1DUtil.arrayToDoubleArray((Object)img.getDataXY(0), (boolean)img.isSignedDataType());
                for (j = 0; j < nr; ++j) {
                    for (i = 0; i < nc; ++i) {
                        if (tab_Img[i + j * nc] == 0.0) continue;
                        tab_Img[i + j * nc] = 3.0;
                    }
                }
                for (j = 0; j < nr; ++j) {
                    for (i = 0; i < nc; ++i) {
                        offset = i + nc * j;
                        n = MorphOp.getTabVal(tab_Dist, i, j, nc, nr);
                        if (n >= nmin && n <= nmax) {
                            if (MorphOp.getTabVal(tab_Dist, i, j - 1, nc, nr) <= n && MorphOp.getTabVal(tab_Dist, i - 1, j, nc, nr) <= n && MorphOp.getTabVal(tab_Dist, i + 1, j, nc, nr) <= n && MorphOp.getTabVal(tab_Dist, i, j + 1, nc, nr) <= n && MorphOp.getTabVal(tab_Img, i - 1, j - 1, nc, nr) != 2.0 && MorphOp.getTabVal(tab_Img, i, j - 1, nc, nr) != 2.0 && MorphOp.getTabVal(tab_Img, i + 1, j - 1, nc, nr) != 2.0 && MorphOp.getTabVal(tab_Img, i - 1, j, nc, nr) != 2.0 && i > 1 && i < nc - 2 && j > 1 && j < nr - 2) {
                                tab_Img[offset] = 2.0;
                                continue;
                            }
                            tab_Img[offset] = 1.0;
                            continue;
                        }
                        tab_Img[offset] = 0.0;
                    }
                }
                img.setDataXY(0, Array1DUtil.doubleArrayToArray((double[])tab_Img, (Object)img.getDataXY(0)));
            }
        }
    }

    private static void initSquelet2(Sequence seq, int z, double threshold, boolean above, int nmin) throws InterruptedException {
        int nc = seq.getFirstImage().getWidth();
        int nr = seq.getFirstImage().getHeight();
        Sequence seqOut = SequenceUtil.getCopy((Sequence)seq);
        seqOut = MorphOp.getDistance(seqOut, 8);
        for (int t = 0; t < seq.getSizeT(); ++t) {
            DataBufferDouble bufOut = (DataBufferDouble)seqOut.getImage(0, z).getRaster().getDataBuffer();
            double[] tab_Dist = bufOut.getData();
            int offset = 0;
            IcyBufferedImage img = seq.getImage(t, z);
            double[] tab_Img_Double = Array1DUtil.arrayToDoubleArray((Object)img.getDataXY(0), (boolean)img.isSignedDataType());
            for (int j = 0; j < nr; ++j) {
                int i = 0;
                while (i < nc) {
                    double n = MorphOp.getTabVal(tab_Dist, i, j, nc, nr);
                    tab_Img_Double[offset] = n >= (double)nmin ? (MorphOp.getTabVal(tab_Dist, i - 1, j - 1, nc, nr) <= n && MorphOp.getTabVal(tab_Dist, i, j - 1, nc, nr) <= n && MorphOp.getTabVal(tab_Dist, i + 1, j - 1, nc, nr) <= n && MorphOp.getTabVal(tab_Dist, i - 1, j, nc, nr) <= n && MorphOp.getTabVal(tab_Dist, i + 1, j, nc, nr) <= n && MorphOp.getTabVal(tab_Dist, i - 1, j + 1, nc, nr) <= n && MorphOp.getTabVal(tab_Dist, i, j + 1, nc, nr) <= n && MorphOp.getTabVal(tab_Dist, i + 1, j + 1, nc, nr) <= n && MorphOp.getTabVal(tab_Dist, i + 2, j - 1, nc, nr) <= n && MorphOp.getTabVal(tab_Dist, i + 2, j - 2, nc, nr) <= n && MorphOp.getTabVal(tab_Dist, i - 1, j - 2, nc, nr) <= n && MorphOp.getTabVal(tab_Dist, i - 2, j - 1, nc, nr) <= n && MorphOp.getTabVal(tab_Dist, i - 2, j + 1, nc, nr) <= n && MorphOp.getTabVal(tab_Dist, i - 2, j + 2, nc, nr) <= n && MorphOp.getTabVal(tab_Dist, i - 1, j + 2, nc, nr) <= n && MorphOp.getTabVal(tab_Dist, i + 2, j + 1, nc, nr) <= n && MorphOp.getTabVal(tab_Img_Double, i + 2, j - 1, nc, nr) != 2.0 && MorphOp.getTabVal(tab_Img_Double, i + 2, j - 2, nc, nr) != 2.0 && MorphOp.getTabVal(tab_Img_Double, i - 1, j - 2, nc, nr) != 2.0 && MorphOp.getTabVal(tab_Img_Double, i - 2, j - 1, nc, nr) != 2.0 && MorphOp.getTabVal(tab_Img_Double, i - 1, j - 1, nc, nr) != 2.0 && MorphOp.getTabVal(tab_Img_Double, i, j - 1, nc, nr) != 2.0 && MorphOp.getTabVal(tab_Img_Double, i + 1, j - 1, nc, nr) != 2.0 && MorphOp.getTabVal(tab_Img_Double, i - 1, j, nc, nr) != 2.0 ? 2.0 : 1.0) : 0.0;
                    ++i;
                    ++offset;
                }
            }
            seq.beginUpdate();
            img.setDataXY(0, Array1DUtil.doubleArrayToArray((double[])tab_Img_Double, (Object)img.getDataXY(0)));
            seq.endUpdate();
        }
    }

    private static void initSquelet3D(Sequence seq, double threshold, boolean above) throws InterruptedException {
        double nmin = 1.0;
        double nmax = Double.MAX_VALUE;
        int nc = seq.getFirstImage().getWidth();
        int nr = seq.getFirstImage().getHeight();
        int nz = seq.getSizeZ();
        Sequence seqOut = SequenceUtil.getCopy((Sequence)seq);
        MorphOp.testDistance3D(seqOut);
        int depth = seq.getSizeZ();
        double[][] tab_Dist = new double[depth][nc * nr];
        double[][] tab_Img = new double[depth][nc * nr];
        for (int t = 0; t < seq.getSizeT(); ++t) {
            for (int c = 0; c < seq.getSizeC(); ++c) {
                double n = 0.0;
                Array2DUtil.arrayToDoubleArray((Object)seqOut.getDataXYZ(t, c), (double[][])tab_Dist, (boolean)seqOut.isSignedDataType());
                Array2DUtil.arrayToDoubleArray((Object)seq.getDataXYZ(t, c), (double[][])tab_Img, (boolean)seq.isSignedDataType());
                int offset = 0;
                for (int z = 0; z < nz; ++z) {
                    for (int j = 0; j < nr; ++j) {
                        int i = 0;
                        while (i < nc) {
                            n = MorphOp.getTabVal3D(tab_Dist, i, j, z, nc, nr, nz);
                            tab_Img[z][offset] = n >= nmin && n <= nmax ? (MorphOp.getTabVal3D(tab_Dist, i - 1, j - 1, z - 1, nc, nr, nz) <= n && MorphOp.getTabVal3D(tab_Dist, i, j - 1, z - 1, nc, nr, nz) <= n && MorphOp.getTabVal3D(tab_Dist, i + 1, j - 1, z - 1, nc, nr, nz) <= n && MorphOp.getTabVal3D(tab_Dist, i - 1, j, z - 1, nc, nr, nz) <= n && MorphOp.getTabVal3D(tab_Dist, i, j, z - 1, nc, nr, nz) <= n && MorphOp.getTabVal3D(tab_Dist, i + 1, j, z - 1, nc, nr, nz) <= n && MorphOp.getTabVal3D(tab_Dist, i - 1, j + 1, z - 1, nc, nr, nz) <= n && MorphOp.getTabVal3D(tab_Dist, i, j + 1, z - 1, nc, nr, nz) <= n && MorphOp.getTabVal3D(tab_Dist, i + 1, j + 1, z - 1, nc, nr, nz) <= n && MorphOp.getTabVal3D(tab_Dist, i - 1, j - 1, z, nc, nr, nz) <= n && MorphOp.getTabVal3D(tab_Dist, i, j - 1, z, nc, nr, nz) <= n && MorphOp.getTabVal3D(tab_Dist, i + 1, j - 1, z, nc, nr, nz) <= n && MorphOp.getTabVal3D(tab_Dist, i - 1, j, z, nc, nr, nz) <= n && MorphOp.getTabVal3D(tab_Dist, i + 1, j, z, nc, nr, nz) <= n && MorphOp.getTabVal3D(tab_Dist, i - 1, j + 1, z, nc, nr, nz) <= n && MorphOp.getTabVal3D(tab_Dist, i, j + 1, z, nc, nr, nz) <= n && MorphOp.getTabVal3D(tab_Dist, i + 1, j + 1, z, nc, nr, nz) <= n && MorphOp.getTabVal3D(tab_Dist, i - 1, j - 1, z + 1, nc, nr, nz) <= n && MorphOp.getTabVal3D(tab_Dist, i, j - 1, z + 1, nc, nr, nz) <= n && MorphOp.getTabVal3D(tab_Dist, i + 1, j - 1, z + 1, nc, nr, nz) <= n && MorphOp.getTabVal3D(tab_Dist, i - 1, j, z + 1, nc, nr, nz) <= n && MorphOp.getTabVal3D(tab_Dist, i, j, z + 1, nc, nr, nz) <= n && MorphOp.getTabVal3D(tab_Dist, i + 1, j, z + 1, nc, nr, nz) <= n && MorphOp.getTabVal3D(tab_Dist, i - 1, j + 1, z + 1, nc, nr, nz) <= n && MorphOp.getTabVal3D(tab_Dist, i, j + 1, z + 1, nc, nr, nz) <= n && MorphOp.getTabVal3D(tab_Dist, i + 1, j + 1, z + 1, nc, nr, nz) <= n && MorphOp.getTabVal3D(tab_Img, i - 1, j - 1, z - 1, nc, nr, nz) != 2.0 && MorphOp.getTabVal3D(tab_Img, i, j - 1, z - 1, nc, nr, nz) != 2.0 && MorphOp.getTabVal3D(tab_Img, i + 1, j - 1, z - 1, nc, nr, nz) != 2.0 && MorphOp.getTabVal3D(tab_Img, i - 1, j, z - 1, nc, nr, nz) != 2.0 && MorphOp.getTabVal3D(tab_Img, i, j, z - 1, nc, nr, nz) != 2.0 && MorphOp.getTabVal3D(tab_Img, i + 1, j, z - 1, nc, nr, nz) != 2.0 && MorphOp.getTabVal3D(tab_Img, i - 1, j + 1, z - 1, nc, nr, nz) != 2.0 && MorphOp.getTabVal3D(tab_Img, i, j + 1, z - 1, nc, nr, nz) != 2.0 && MorphOp.getTabVal3D(tab_Img, i + 1, j + 1, z - 1, nc, nr, nz) != 2.0 && MorphOp.getTabVal3D(tab_Img, i - 1, j - 1, z, nc, nr, nz) != 2.0 && MorphOp.getTabVal3D(tab_Img, i, j - 1, z, nc, nr, nz) != 2.0 && MorphOp.getTabVal3D(tab_Img, i + 1, j - 1, z, nc, nr, nz) != 2.0 && MorphOp.getTabVal3D(tab_Img, i - 1, j, z, nc, nr, nz) != 2.0 ? 2.0 : 1.0) : 0.0;
                            ++i;
                            ++offset;
                        }
                    }
                    offset = 0;
                }
                Array2DUtil.doubleArrayToArray((double[][])tab_Img, (Object)seq.getDataXYZ(t, c));
            }
        }
    }

    private static boolean confBarb(double[] tab, int i, int j, int ncols, int nrows) {
        int n = 0;
        int v = 0;
        boolean CurrentP = MorphOp.isPt(tab, i + 1, j, ncols, nrows);
        if (!CurrentP) {
            ++v;
        }
        if (MorphOp.isPt(tab, i + 1, j + 1, ncols, nrows) != CurrentP) {
            ++n;
            CurrentP = MorphOp.isPt(tab, i + 1, j + 1, ncols, nrows);
        }
        if (!CurrentP) {
            ++v;
        }
        if (MorphOp.isPt(tab, i, j + 1, ncols, nrows) != CurrentP) {
            ++n;
            CurrentP = MorphOp.isPt(tab, i, j + 1, ncols, nrows);
        }
        if (!CurrentP) {
            ++v;
        }
        if (MorphOp.isPt(tab, i - 1, j + 1, ncols, nrows) != CurrentP) {
            ++n;
            CurrentP = MorphOp.isPt(tab, i - 1, j + 1, ncols, nrows);
        }
        if (!CurrentP) {
            ++v;
        }
        if (MorphOp.isPt(tab, i - 1, j, ncols, nrows) != CurrentP) {
            ++n;
            CurrentP = MorphOp.isPt(tab, i - 1, j, ncols, nrows);
        }
        if (!CurrentP) {
            ++v;
        }
        if (MorphOp.isPt(tab, i - 1, j - 1, ncols, nrows) != CurrentP) {
            ++n;
            CurrentP = MorphOp.isPt(tab, i - 1, j - 1, ncols, nrows);
        }
        if (!CurrentP) {
            ++v;
        }
        if (MorphOp.isPt(tab, i, j - 1, ncols, nrows) != CurrentP) {
            ++n;
            CurrentP = MorphOp.isPt(tab, i, j - 1, ncols, nrows);
        }
        if (!CurrentP) {
            ++v;
        }
        if (MorphOp.isPt(tab, i + 1, j - 1, ncols, nrows) != CurrentP) {
            ++n;
            CurrentP = MorphOp.isPt(tab, i + 1, j - 1, ncols, nrows);
        }
        return (n <= 2 || n == 0) && v >= 5;
    }

    private static boolean confBarb3D(double[][] tab, int i, int j, int z, int ncols, int nrows, int nz) {
        return false;
    }

    private static boolean confHomo(double[] tab, int i, int j, int ncols, int nrows) {
        int n = 0;
        boolean CurrentP = MorphOp.isPt(tab, i + 1, j, ncols, nrows);
        if (MorphOp.isPt(tab, i + 1, j - 1, ncols, nrows) != CurrentP) {
            ++n;
            CurrentP = MorphOp.isPt(tab, i + 1, j - 1, ncols, nrows);
        }
        if (MorphOp.isPt(tab, i, j - 1, ncols, nrows) != CurrentP) {
            ++n;
            CurrentP = MorphOp.isPt(tab, i, j - 1, ncols, nrows);
        }
        if (MorphOp.isPt(tab, i - 1, j - 1, ncols, nrows) != CurrentP) {
            ++n;
            CurrentP = MorphOp.isPt(tab, i - 1, j - 1, ncols, nrows);
        }
        if (MorphOp.isPt(tab, i - 1, j, ncols, nrows) != CurrentP) {
            ++n;
            CurrentP = MorphOp.isPt(tab, i - 1, j, ncols, nrows);
        }
        if (MorphOp.isPt(tab, i - 1, j + 1, ncols, nrows) != CurrentP) {
            ++n;
            CurrentP = MorphOp.isPt(tab, i - 1, j + 1, ncols, nrows);
        }
        if (MorphOp.isPt(tab, i, j + 1, ncols, nrows) != CurrentP) {
            ++n;
            CurrentP = MorphOp.isPt(tab, i, j + 1, ncols, nrows);
        }
        if (MorphOp.isPt(tab, i + 1, j + 1, ncols, nrows) != CurrentP) {
            ++n;
            CurrentP = MorphOp.isPt(tab, i + 1, j - 1, ncols, nrows);
        }
        return n > 2 || n == 0;
    }

    private static boolean confHomo3D(double[][] tab, int i, int j, int z, int ncols, int nrows, int nz) {
        Sequence input = new Sequence();
        int offset = 0;
        Map componentsMap = new TreeMap();
        for (int m = z - 1; m <= z + 1; ++m) {
            double[] tabVoxel = new double[9];
            for (int l = j - 1; l <= j + 1; ++l) {
                int k = i - 1;
                while (k <= i + 1) {
                    tabVoxel[offset] = MorphOp.getTabVal3D(tab, k, l, m, ncols, nrows, nz) != 0.0 ? 255.0 : 0.0;
                    ++k;
                    ++offset;
                }
            }
            if (m == z) {
                tabVoxel[4] = 0.0;
            }
            offset = 0;
            IcyBufferedImage image = new IcyBufferedImage(3, 3, (Object)tabVoxel);
            input.addImage((BufferedImage)image);
        }
        int nbObjects = 0;
        componentsMap = ConnectedComponents.extractConnectedComponents((Sequence)input, (double)255.0, (ConnectedComponents.ExtractionType)ConnectedComponents.ExtractionType.VALUE, (boolean)false, (boolean)false, (boolean)false, (int)0, (int)Integer.MAX_VALUE, null);
        for (List ccs : componentsMap.values()) {
            nbObjects += ccs.size();
        }
        if (nbObjects > 1 || nbObjects == 0) {
            System.out.println("x : " + i + " | y : " + j + " | z : " + z);
        }
        return nbObjects > 1;
    }

    private static void progage3D(Sequence seq) {
        int nc = seq.getFirstImage().getWidth();
        int nr = seq.getFirstImage().getHeight();
        int nz = seq.getSizeZ();
        int connex = 4;
        int[] d = new int[]{1, nc, -1, -nc};
        int sizeImage = nc * nr;
        LinkedList<Point3D> fifo = new LinkedList<Point3D>();
        LinkedList<Point3D.Float> tabPix = new LinkedList<Point3D.Float>();
        double[][] tabDouble = new double[nz][nr * nc];
        for (int t = 0; t < seq.getSizeT(); ++t) {
            for (int c = 0; c < seq.getSizeC(); ++c) {
                int k;
                int i;
                int j;
                int z;
                Array2DUtil.arrayToDoubleArray((Object)seq.getDataXYZ(t, c), (double[][])tabDouble, (boolean)seq.isSignedDataType());
                for (z = 0; z < nz; ++z) {
                    for (j = 0; j < nr; ++j) {
                        block4: for (i = 0; i < nc; ++i) {
                            if (tabDouble[z][i + nc * j] != 1.0) continue;
                            int offset = i + nc * j;
                            for (k = 0; k < connex; ++k) {
                                if (offset + d[k] < 0 || offset + d[k] >= sizeImage || tabDouble[z][offset + d[k]] != 0.0) continue;
                                fifo.add((Point3D)new Point3D.Float((float)i, (float)j, (float)z));
                                tabDouble[z][i + nc * j] = 3.0;
                                continue block4;
                            }
                        }
                    }
                }
                fifo.add(FICTIF3D);
                while (true) {
                    Point3D p = (Point3D)fifo.poll();
                    i = (int)p.getX();
                    j = (int)p.getY();
                    z = (int)p.getZ();
                    if (p.equals((Object)FICTIF3D)) {
                        if (fifo.isEmpty()) {
                            int l;
                            int m;
                            int q;
                            for (q = 0; q < tabPix.size(); ++q) {
                                p = (Point3D)tabPix.get(q);
                                i = (int)p.getX();
                                if (!MorphOp.confBarb3D(tabDouble, i, j = (int)p.getY(), z = (int)p.getZ(), nc, nr, nz)) continue;
                                tabDouble[z][i + nc * j] = 1.0;
                                fifo.add((Point3D)new Point3D.Float((float)i, (float)j, (float)z));
                            }
                            while (!fifo.isEmpty()) {
                                p = fifo.poll();
                                i = (int)p.getX();
                                if (MorphOp.confBarb3D(tabDouble, i, j = (int)p.getY(), z = (int)p.getZ(), nc, nr, nz)) {
                                    tabDouble[z][i + nc * j] = 0.0;
                                    for (m = z - 1; m <= z + 1; ++m) {
                                        for (l = j - 1; l <= j + 1; ++l) {
                                            for (k = i - 1; k <= i + 1; ++k) {
                                                if (MorphOp.getTabVal3D(tabDouble, k, l, m, nc, nr, nz) != 3.0 || k == i && l == j) continue;
                                                fifo.add((Point3D)new Point3D.Float((float)k, (float)l, (float)m));
                                                tabDouble[m][k + nc * l] = 1.0;
                                            }
                                        }
                                    }
                                    continue;
                                }
                                tabDouble[i + nc * j][z] = 3.0;
                            }
                            for (q = 0; q < tabPix.size(); ++q) {
                                p = (Point3D)tabPix.get(q);
                                k = (int)p.getX();
                                l = (int)p.getY();
                                m = (int)p.getZ();
                                if (tabDouble[m][k * nr + l] != 3.0) continue;
                                tabDouble[m][k * nr + l] = 2.0;
                            }
                            break;
                        }
                        MorphOp.invertFifo3D(fifo);
                        fifo.add(FICTIF3D);
                        continue;
                    }
                    if (MorphOp.getTabVal3D(tabDouble, i - 1, j, z, nc, nr, nz) == 1.0) {
                        fifo.add((Point3D)new Point3D.Float((float)(i - 1), (float)j, (float)z));
                        tabDouble[z][i - 1 + nc * j] = 3.0;
                    }
                    if (MorphOp.getTabVal3D(tabDouble, i, j - 1, z, nc, nr, nz) == 1.0) {
                        fifo.add((Point3D)new Point3D.Float((float)i, (float)(j - 1), (float)z));
                        tabDouble[z][i + nc * (j - 1)] = 3.0;
                    }
                    if (MorphOp.getTabVal3D(tabDouble, i + 1, j, z, nc, nr, nz) == 1.0) {
                        fifo.add((Point3D)new Point3D.Float((float)(i + 1), (float)j, (float)z));
                        tabDouble[z][i + 1 + nc * j] = 3.0;
                    }
                    if (MorphOp.getTabVal3D(tabDouble, i, j + 1, z, nc, nr, nz) == 1.0) {
                        fifo.add((Point3D)new Point3D.Float((float)i, (float)(j + 1), (float)z));
                        tabDouble[z][i + nc * (j + 1)] = 3.0;
                    }
                    Array2DUtil.doubleArrayToArray((double[][])tabDouble, (Object)seq.getDataXYZ(t, c));
                    seq.dataChanged();
                    if (MorphOp.confHomo3D(tabDouble, i, j, z, nc, nr, nz)) {
                        tabPix.add(new Point3D.Float((float)i, (float)j, (float)z));
                        continue;
                    }
                    tabDouble[z][i + nc * j] = 0.0;
                }
                Array2DUtil.doubleArrayToArray((double[][])tabDouble, (Object)seq.getDataXYZ(t, c));
            }
        }
    }

    private static void propage(Sequence seq, int z) {
        int k;
        int i;
        int j;
        int nc = seq.getFirstImage().getWidth();
        int nr = seq.getFirstImage().getHeight();
        int connex = 4;
        int[] d = new int[]{1, nc, -1, -nc, 1 + nc, -1 + nc, -1 - nc, 1 - nc};
        int t = 0;
        int sizeImage = nc * nr;
        LinkedList<Point> fifo = new LinkedList<Point>();
        LinkedList<Point> tabPix = new LinkedList<Point>();
        IcyBufferedImage img = seq.getImage(t, z);
        double[] tabDouble = Array1DUtil.arrayToDoubleArray((Object)img.getDataXY(0), (boolean)img.isSignedDataType());
        for (j = 0; j < nr; ++j) {
            for (i = 0; i < nc; ++i) {
                if (tabDouble[i + nc * j] == 0.0) continue;
                boolean flag = false;
                int offset = i + nc * j;
                for (k = 0; !flag && k < connex; ++k) {
                    if (offset + d[k] < 0 || offset + d[k] >= sizeImage || tabDouble[offset + d[k]] != 0.0) continue;
                    fifo.add(new Point(i, j));
                    tabDouble[i + nc * j] = 3.0;
                    flag = true;
                }
            }
        }
        img.setDataXY(0, Array1DUtil.doubleArrayToArray((double[])tabDouble, (Object)img.getDataXY(0)));
        fifo.add(FICTIF);
        while (true) {
            int l;
            Point p = (Point)fifo.poll();
            i = p.x;
            j = p.y;
            if (p.equals(FICTIF)) {
                if (fifo.isEmpty()) {
                    int q;
                    for (q = 0; q < tabPix.size(); ++q) {
                        p = (Point)tabPix.get(q);
                        i = p.x;
                        j = p.y;
                        if (!MorphOp.confBarb(tabDouble, i, j, nc, nr)) continue;
                        tabDouble[i + nc * j] = 1.0;
                        fifo.add(new Point(i, j));
                    }
                    while (!fifo.isEmpty()) {
                        p = fifo.poll();
                        i = p.x;
                        j = p.y;
                        if (MorphOp.confBarb(tabDouble, i, j, nc, nr)) {
                            tabDouble[i + nc * j] = 0.0;
                            for (l = j - 1; l <= j + 1; ++l) {
                                for (k = i - 1; k <= i + 1; ++k) {
                                    if (MorphOp.getTabVal(tabDouble, k, l, nc, nr) != 3.0 || k == i && l == j) continue;
                                    fifo.add(new Point(k, l));
                                    tabDouble[k + nc * l] = 1.0;
                                }
                            }
                            continue;
                        }
                        tabDouble[i + nc * j] = 3.0;
                    }
                    for (q = 0; q < tabPix.size(); ++q) {
                        p = (Point)tabPix.get(q);
                        k = p.x;
                        l = p.y;
                        if (tabDouble[k * nr + l] != 3.0) continue;
                        tabDouble[k * nr + l] = 2.0;
                    }
                    break;
                }
                MorphOp.invertFifo(fifo);
                fifo.add(FICTIF);
                continue;
            }
            block9: for (l = j - 1; l <= j + 1; ++l) {
                for (k = i - 1; k <= i + 1; ++k) {
                    if (MorphOp.getTabVal(tabDouble, k, l, nc, nr) != 1.0 || k != i && l != j) continue;
                    fifo.add(new Point(k, l));
                    tabDouble[k + nc * l] = 3.0;
                    continue block9;
                }
            }
            if (MorphOp.confHomo(tabDouble, i, j, nc, nr)) {
                tabPix.add(new Point(i, j));
                continue;
            }
            tabDouble[i + nc * j] = 0.0;
        }
        img.setDataXY(0, Array1DUtil.doubleArrayToArray((double[])tabDouble, (Object)img.getDataXY(0)));
    }

    private static void initVoisins(Point[] voisin) {
        voisin[0] = new Point(1, 0);
        voisin[1] = new Point(1, -1);
        voisin[2] = new Point(0, -1);
        voisin[3] = new Point(-1, -1);
        voisin[4] = new Point(-1, 0);
        voisin[5] = new Point(-1, 1);
        voisin[6] = new Point(0, 1);
        voisin[7] = new Point(1, 1);
    }

    private static boolean ebarbulage(double[] tab, int i, int j, int nc, int nr) {
        int k;
        Point[] voisin = new Point[8];
        MorphOp.initVoisins(voisin);
        int tabVois = 0;
        for (k = 0; k < 8; ++k) {
            if (!MorphOp.isPt(tab, i + voisin[k].x, j + voisin[k].y, nc, nr)) continue;
            tabVois |= 1 << k;
        }
        for (k = 0; k < 4; ++k) {
            if ((tabVois & 1 << 2 * k) == 1 && (tabVois & 1 << (2 + 2 * k) % 8) == 1 && (tabVois & 1 << (4 + 2 * k) % 8) == 1 && (~tabVois & 1 << (1 + 2 * k) % 8) == 1 && (~tabVois & 1 << (3 + 2 * k) % 8) == 1 && (~tabVois & 1 << (5 + 2 * k) % 8) == 1 && (~tabVois & 1 << (6 + 2 * k) % 8) == 1 && (~tabVois & 1 << (7 + 2 * k) % 8) == 1) {
                return true;
            }
            if ((tabVois & 1 << 1 + 2 * k) == 1 && (tabVois & 1 << (2 + 2 * k) % 8) == 1 && (tabVois & 1 << (3 + 2 * k) % 8) == 1 && (~tabVois & 1 << 2 * k % 8) == 1 && (~tabVois & 1 << (4 + 2 * k) % 8) == 1 && (~tabVois & 1 << (5 + 2 * k) % 8) == 1 && (~tabVois & 1 << (6 + 2 * k) % 8) == 1 && (~tabVois & 1 << (7 + 2 * k) % 8) == 1) {
                return true;
            }
            if ((tabVois & 1 << 2 * k) == 1 && (tabVois & 1 << (2 + 2 * k) % 8) == 1 && (~tabVois & 1 << (1 + 2 * k) % 8) == 1 && (~tabVois & 1 << (3 + 2 * k) % 8) == 1 && (~tabVois & 1 << (4 + 2 * k) % 8) == 1 && (~tabVois & 1 << (5 + 2 * k) % 8) == 1 && (~tabVois & 1 << (6 + 2 * k) % 8) == 1 && (~tabVois & 1 << (7 + 2 * k) % 8) == 1) {
                return true;
            }
            if ((tabVois & 1 << 2 * k) == 1 && (tabVois & 1 << (1 + 2 * k) % 8) == 1 && (~tabVois & 1 << (2 + 2 * k) % 8) == 1 && (~tabVois & 1 << (3 + 2 * k) % 8) == 1 && (~tabVois & 1 << (4 + 2 * k) % 8) == 1 && (~tabVois & 1 << (5 + 2 * k) % 8) == 1 && (~tabVois & 1 << (6 + 2 * k) % 8) == 1 && (~tabVois & 1 << (7 + 2 * k) % 8) == 1) {
                return true;
            }
            if ((tabVois & 1 << (2 + 2 * k) % 8) != 1 || (tabVois & 1 << (1 + 2 * k) % 8) != 1 || (~tabVois & 1 << 2 * k % 8) != 1 || (~tabVois & 1 << (3 + 2 * k) % 8) != 1 || (~tabVois & 1 << (4 + 2 * k) % 8) != 1 || (~tabVois & 1 << (5 + 2 * k) % 8) != 1 || (~tabVois & 1 << (6 + 2 * k) % 8) != 1 || (~tabVois & 1 << (7 + 2 * k) % 8) != 1) continue;
            return true;
        }
        return false;
    }

    private static void ebarbulFinal(Sequence seq, int z) {
        for (int t = 0; t < seq.getSizeT(); ++t) {
            int nc = seq.getFirstImage().getWidth();
            int nr = seq.getFirstImage().getHeight();
            IcyBufferedImage img = seq.getImage(t, z);
            double[] tabDouble = Array1DUtil.arrayToDoubleArray((Object)img.getDataXY(0), (boolean)img.isSignedDataType());
            for (int j = 1; j < nr; ++j) {
                for (int i = 1; i < nc; ++i) {
                    boolean val;
                    if (tabDouble[i + nc * j] != 2.0 || !(val = MorphOp.ebarbulage(tabDouble, i, j, nc, nr))) continue;
                    tabDouble[i + nc * j] = 0.0;
                }
            }
            img.setDataXY(0, Array1DUtil.doubleArrayToArray((double[])tabDouble, (Object)img.getDataXY(0)));
        }
    }

    public static int getNb4Neighbors(double[] tab, int i, int j, int width, int height) {
        int nb = 0;
        if (MorphOp.getTabVal(tab, i - 1, j, width, height) > 0.0) {
            ++nb;
        }
        if (MorphOp.getTabVal(tab, i, j - 1, width, height) > 0.0) {
            ++nb;
        }
        if (MorphOp.getTabVal(tab, i + 1, j, width, height) > 0.0) {
            ++nb;
        }
        if (MorphOp.getTabVal(tab, i, j + 1, width, height) > 0.0) {
            ++nb;
        }
        return nb;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void four2Eight(Sequence seqIn, int z) {
        int x;
        int y;
        double[] tabDouble;
        IcyBufferedImage img;
        int offset;
        int width = seqIn.getFirstImage().getWidth();
        int height = seqIn.getFirstImage().getHeight();
        int t = 0;
        block0: while (true) {
            if (t >= seqIn.getSizeT()) break;
            offset = 0;
            img = seqIn.getImage(t, z);
            tabDouble = Array1DUtil.arrayToDoubleArray((Object)img.getDataXY(0), (boolean)img.isSignedDataType());
            y = 0;
            while (true) {
                if (y < height) {
                } else {
                    img.setDataXY(0, Array1DUtil.doubleArrayToArray((double[])tabDouble, (Object)img.getDataXY(0)));
                    ++t;
                    continue block0;
                }
                for (x = 0; x < width; ++x, ++offset) {
                    if (x == 551 && y == 150) {
                        System.out.print(" point ");
                    }
                    int N1r = x - 1;
                    int N1c = y;
                    int N2r = x;
                    int N2c = y + 1;
                    if (MorphOp.isPt(tabDouble, x, y, width, height) && MorphOp.isPt(tabDouble, N1r, N1c, width, height) && MorphOp.isPt(tabDouble, N2r, N2c, width, height)) {
                        if (!MorphOp.isPt(tabDouble, x + 1, y - 1, width, height)) {
                            tabDouble[offset] = 0.0;
                        }
                    } else {
                        N1r = x - 1;
                        N1c = y;
                        N2r = x;
                        N2c = y - 1;
                        if (MorphOp.isPt(tabDouble, x, y, width, height) && MorphOp.isPt(tabDouble, N1r, N1c, width, height) && MorphOp.isPt(tabDouble, N2r, N2c, width, height)) {
                            if (!MorphOp.isPt(tabDouble, x + 1, y + 1, width, height)) {
                                tabDouble[offset] = 0.0;
                            }
                        } else {
                            N1r = x + 1;
                            N1c = y;
                            N2r = x;
                            N2c = y - 1;
                            if (MorphOp.isPt(tabDouble, x, y, width, height) && MorphOp.isPt(tabDouble, N1r, N1c, width, height) && MorphOp.isPt(tabDouble, N2r, N2c, width, height)) {
                                if (!MorphOp.isPt(tabDouble, x - 1, y + 1, width, height)) {
                                    tabDouble[offset] = 0.0;
                                }
                            } else {
                                N1r = x + 1;
                                N1c = y;
                                N2r = x;
                                N2c = y + 1;
                                if (MorphOp.isPt(tabDouble, x, y, width, height) && MorphOp.isPt(tabDouble, N1r, N1c, width, height) && MorphOp.isPt(tabDouble, N2r, N2c, width, height) && !MorphOp.isPt(tabDouble, x - 1, y - 1, width, height)) {
                                    tabDouble[offset] = 0.0;
                                }
                            }
                        }
                    }
                    if (MorphOp.getNb4Neighbors(tabDouble, x, y, width, height) == 3) {
                        tabDouble[offset] = 0.0;
                    }
                    N1r = x - 1;
                    N1c = y;
                    N2r = x;
                    N2c = y + 1;
                    if (!MorphOp.isPt(tabDouble, x, y, width, height) || !MorphOp.isPt(tabDouble, N1r, N1c, width, height) || !MorphOp.isPt(tabDouble, N2r, N2c, width, height) || MorphOp.isPt(tabDouble, x + 1, y - 1, width, height) || MorphOp.isPt(tabDouble, x - 1, y - 1, width, height) || MorphOp.isPt(tabDouble, x + 1, y, width, height)) continue;
                    tabDouble[offset] = 0.0;
                }
                ++y;
            }
            break;
        }
        t = 0;
        block3: while (t < seqIn.getSizeT()) {
            offset = 0;
            img = seqIn.getImage(t, z);
            tabDouble = Array1DUtil.arrayToDoubleArray((Object)img.getDataXY(0), (boolean)img.isSignedDataType());
            y = 0;
            while (true) {
                if (y < height) {
                } else {
                    img.setDataXY(0, Array1DUtil.doubleArrayToArray((double[])tabDouble, (Object)img.getDataXY(0)));
                    ++t;
                    continue block3;
                }
                for (x = 0; x < width; ++x, ++offset) {
                    if (!(tabDouble[offset] > 0.0)) continue;
                    ArrayList<Integer> lNeighbors = MorphOp.getOffsetNeighbors(x, y, width, height);
                    int nbNeighbors = 0;
                    int[] tabVoisins = new int[8];
                    for (int i = 0; i < lNeighbors.size(); ++i) {
                        if (!(tabDouble[lNeighbors.get(i)] > 0.0)) continue;
                        tabVoisins[nbNeighbors] = lNeighbors.get(i);
                        ++nbNeighbors;
                    }
                    if (nbNeighbors == 1) {
                        ArrayList<Integer> lNeighbor2 = MorphOp.getOffsetNeighbors(tabVoisins[0], width, height);
                        int nbNb = 0;
                        int[] tabVoisins2 = new int[8];
                        for (int i = 0; i < lNeighbor2.size(); ++i) {
                            if (!(tabDouble[lNeighbor2.get(i)] > 0.0)) continue;
                            tabVoisins2[nbNb] = lNeighbor2.get(i);
                            ++nbNb;
                        }
                        if (nbNb <= 2) continue;
                        int offsetVoisin = tabVoisins[0];
                        int xp = offsetVoisin % width;
                        int yp = (int)Math.floor(offsetVoisin / width);
                        if (nbNb == 3) {
                            int x1 = 0;
                            int y1 = 0;
                            int x2 = 0;
                            int y2 = 0;
                            boolean trouve = false;
                            if (tabVoisins2[0] != offset) {
                                x1 = tabVoisins2[0] % width;
                                y1 = (int)Math.floor(tabVoisins2[0] / width);
                            } else {
                                trouve = true;
                            }
                            if (tabVoisins2[1] != offset) {
                                if (trouve) {
                                    x1 = tabVoisins2[1] % width;
                                    y1 = (int)Math.floor(tabVoisins2[1] / width);
                                } else {
                                    x2 = tabVoisins2[1] % width;
                                    y2 = (int)Math.floor(tabVoisins2[1] / width);
                                }
                            } else {
                                trouve = true;
                            }
                            if (trouve) {
                                x2 = tabVoisins2[2] % width;
                                y2 = (int)Math.floor(tabVoisins2[2] / width);
                            }
                            if (y1 != yp && y1 == y2 && x1 + x2 == xp + xp || x1 != xp && x1 == x2 && y1 + y2 == yp + yp) continue;
                        }
                        if (xp == x && (yp == y - 1 && MorphOp.isPt(tabDouble, x, yp - 1, width, height) || yp == y + 1 && MorphOp.isPt(tabDouble, x, yp + 1, width, height)) || yp == y && (xp == x - 1 && MorphOp.isPt(tabDouble, xp - 1, y, width, height) || xp == x + 1 && MorphOp.isPt(tabDouble, xp + 1, y, width, height))) continue;
                        tabDouble[offset] = 0.0;
                        continue;
                    }
                    if (nbNeighbors != 2) continue;
                    int off1 = tabVoisins[0];
                    int x1 = off1 % width;
                    int y1 = (int)Math.floor(off1 / width);
                    int off2 = tabVoisins[1];
                    int x2 = off2 % width;
                    int y2 = (int)Math.floor(off2 / width);
                    if (x1 == x - 1 && x1 == x2 && (y1 == y && (y2 == y + 1 || y2 == y - 1) || y2 == y && (y1 == y + 1 || y1 == y - 1))) {
                        tabDouble[offset] = 0.0;
                        continue;
                    }
                    if (y1 == y + 1 && y1 == y2 && (x1 == x && (x2 == x - 1 || x2 == x + 1) || x2 == x && (x1 == x - 1 || x1 == x + 1))) {
                        tabDouble[offset] = 0.0;
                        continue;
                    }
                    if (x1 == x + 1 && x1 == x2 && (y1 == y && (y2 == y - 1 || y2 == y + 1) || y2 == y && (y1 == y - 1 || y2 == y + 1))) {
                        tabDouble[offset] = 0.0;
                        continue;
                    }
                    if (y1 == y - 1 && y1 == y2 && (x1 == x && (x2 == x + 1 || x2 == x - 1) || x2 == x && (x1 == x + 1 || x1 == x - 1))) {
                        tabDouble[offset] = 0.0;
                        continue;
                    }
                    if (y1 != y && y1 == y2 && x1 + x2 == x + x) {
                        tabDouble[y1 * width + x] = tabDouble[offset];
                        tabDouble[offset] = 0.0;
                        continue;
                    }
                    if (x1 == x || x1 != x2 || y1 + y2 != y + y) continue;
                    tabDouble[x1 + y * width] = tabDouble[offset];
                    tabDouble[offset] = 0.0;
                }
                ++y;
            }
            break;
        }
        return;
    }

    public static void skeleton(Sequence seq, int z, double threshold, boolean above, int typeSkel, int n) throws InterruptedException {
        switch (typeSkel) {
            case 0: {
                MorphOp.initSquelet1(seq, z, threshold, above);
                break;
            }
            case 1: {
                MorphOp.initSquelet2(seq, z, threshold, above, n);
            }
        }
        MorphOp.propage(seq, z);
        MorphOp.ebarbulFinal(seq, z);
        MorphOp.four2Eight(seq, z);
    }

    public static void skeleton3D(Sequence seq, double threshold, boolean above) throws InterruptedException {
        MorphOp.initSquelet3D(seq, threshold, above);
        MorphOp.progage3D(seq);
    }

    public static int valPixel(double[][] tab, int i, int j, int k, int width, int height, int depth) {
        if (MorphOp.getTabVal3D(tab, i, j, k - 1, width, height, depth) == 0.0) {
            return 3;
        }
        if (MorphOp.getTabVal3D(tab, i, j, k + 1, width, height, depth) == 0.0) {
            return 3;
        }
        if (MorphOp.getTabVal3D(tab, i - 1, j, k, width, height, depth) == 0.0) {
            return 3;
        }
        if (MorphOp.getTabVal3D(tab, i, j - 1, k, width, height, depth) == 0.0) {
            return 3;
        }
        if (MorphOp.getTabVal3D(tab, i + 1, j, k, width, height, depth) == 0.0) {
            return 3;
        }
        if (MorphOp.getTabVal3D(tab, i, j + 1, k, width, height, depth) == 0.0) {
            return 3;
        }
        if (MorphOp.getTabVal3D(tab, i - 1, j - 1, k, width, height, depth) == 0.0) {
            return 4;
        }
        if (MorphOp.getTabVal3D(tab, i - 1, j + 1, k, width, height, depth) == 0.0) {
            return 4;
        }
        if (MorphOp.getTabVal3D(tab, i + 1, j - 1, k, width, height, depth) == 0.0) {
            return 4;
        }
        if (MorphOp.getTabVal3D(tab, i + 1, j + 1, k, width, height, depth) == 0.0) {
            return 4;
        }
        if (MorphOp.getTabVal3D(tab, i - 1, j - 1, k - 1, width, height, depth) == 0.0) {
            return 5;
        }
        if (MorphOp.getTabVal3D(tab, i - 1, j + 1, k - 1, width, height, depth) == 0.0) {
            return 5;
        }
        if (MorphOp.getTabVal3D(tab, i + 1, j - 1, k - 1, width, height, depth) == 0.0) {
            return 5;
        }
        if (MorphOp.getTabVal3D(tab, i + 1, j + 1, k - 1, width, height, depth) == 0.0) {
            return 5;
        }
        if (MorphOp.getTabVal3D(tab, i - 1, j - 1, k + 1, width, height, depth) == 0.0) {
            return 5;
        }
        if (MorphOp.getTabVal3D(tab, i - 1, j + 1, k + 1, width, height, depth) == 0.0) {
            return 5;
        }
        if (MorphOp.getTabVal3D(tab, i + 1, j - 1, k + 1, width, height, depth) == 0.0) {
            return 5;
        }
        if (MorphOp.getTabVal3D(tab, i + 1, j + 1, k + 1, width, height, depth) == 0.0) {
            return 5;
        }
        return 0;
    }

    public static boolean samePoint3D(Point3D p1, Point3D p2) {
        return p1.getX() == p2.getX() && p1.getY() == p2.getY() && p1.getZ() == p2.getZ();
    }

    public static double min(double d, double d2) {
        if (d <= d2) {
            return d;
        }
        return d2;
    }

    public static boolean containsPixel(ArrayList<Point3D> list, Point3D p) {
        for (Point3D po : list) {
            if (!MorphOp.samePoint3D(po, p)) continue;
            return true;
        }
        return false;
    }

    public static void testDistance3D(Sequence seq) {
        int width = seq.getWidth();
        int height = seq.getHeight();
        int depth = seq.getSizeZ();
        int times = seq.getSizeT();
        int channels = seq.getSizeC();
        double[][] tab = new double[depth][width * height];
        double[][] tab_Dist = new double[depth][width * height];
        LinkedList<Point3D.Integer> pixelContour = new LinkedList<Point3D.Integer>();
        ArrayList<Point3D.Integer> pixelForme = new ArrayList<Point3D.Integer>();
        for (int t = 0; t < times; ++t) {
            for (int c = 0; c < channels; ++c) {
                tab = Array2DUtil.arrayToDoubleArray((Object)seq.getDataXYZ(t, c), (boolean)seq.isSignedDataType());
                for (int z = 0; z < depth; ++z) {
                    for (int j = 0; j < height; ++j) {
                        for (int i = 0; i < width; ++i) {
                            if (tab[z][i + j * width] == 0.0) continue;
                            tab[z][i + j * width] = 2.0;
                            tab_Dist[z][i + j * width] = Double.MAX_VALUE;
                            int val = MorphOp.valPixel(tab, i, j, z, width, height, depth);
                            if (val != 0) {
                                tab_Dist[z][i + j * width] = val;
                                pixelContour.add(new Point3D.Integer(i, j, z));
                                tab[z][i + j * width] = 1.0;
                                continue;
                            }
                            pixelForme.add(new Point3D.Integer(i, j, z));
                        }
                    }
                }
                while (!pixelContour.isEmpty()) {
                    Point3D.Integer p;
                    Point3D pEnCours = (Point3D)pixelContour.poll();
                    int i = (int)pEnCours.getX();
                    int j = (int)pEnCours.getY();
                    int k = (int)pEnCours.getZ();
                    double d = tab_Dist[k][i + j * width];
                    tab[k][i + j * width] = 1.0;
                    if (MorphOp.getTabVal3D(tab, i - 1, j, k, width, height, depth) == 2.0) {
                        p = new Point3D.Integer(i - 1, j, k);
                        pixelContour.add(p);
                        tab_Dist[k][i - 1 + j * width] = MorphOp.min(tab_Dist[k][i - 1 + j * width], d + 3.0);
                    }
                    if (MorphOp.getTabVal3D(tab, i, j - 1, k, width, height, depth) == 2.0) {
                        p = new Point3D.Integer(i, j - 1, k);
                        pixelContour.add(p);
                        tab_Dist[k][i + (j - 1) * width] = MorphOp.min(tab_Dist[k][i + (j - 1) * width], d + 3.0);
                    }
                    if (MorphOp.getTabVal3D(tab, i + 1, j, k, width, height, depth) == 2.0) {
                        p = new Point3D.Integer(i + 1, j, k);
                        pixelContour.add(p);
                        tab_Dist[k][i + 1 + j * width] = MorphOp.min(tab_Dist[k][i + 1 + j * width], d + 3.0);
                    }
                    if (MorphOp.getTabVal3D(tab, i, j + 1, k, width, height, depth) != 2.0) continue;
                    p = new Point3D.Integer(i, j + 1, k);
                    pixelContour.add(p);
                    tab_Dist[k][i + (j + 1) * width] = MorphOp.min(tab_Dist[k][i + (j + 1) * width], d + 3.0);
                }
                Array2DUtil.doubleArrayToArray((double[][])tab_Dist, (Object)seq.getDataXYZ(t, c));
            }
        }
    }

    public static IcyBufferedImage thinning(Sequence seq, int nmin) {
        int i;
        int j;
        double n = 0.0;
        int nr = seq.getHeight();
        int nc = seq.getWidth();
        IcyBufferedImage img = seq.getFirstImage();
        double[] result = Array1DUtil.arrayToDoubleArray((Object)img.getDataXY(0), (boolean)img.isSignedDataType());
        seq.setName(seq.getName() + "_thin" + nmin);
        Sequence seqD = MorphOp.getDistance(seq, 8);
        IcyBufferedImage imgDist = seqD.getFirstImage();
        double[] resultDistance = Array1DUtil.arrayToDoubleArray((Object)imgDist.getDataXY(0), (boolean)imgDist.isSignedDataType());
        for (j = 0; j < nr; ++j) {
            for (i = 0; i < nc; ++i) {
                n = MorphOp.getDist(resultDistance, i, j, nc, nr);
                if (!(n > 0.0)) continue;
                if (n < (double)nmin) {
                    if (MorphOp.swip_voisins(nmin, resultDistance, nc, nr, i, j)) {
                        result[i + nc * j] = 3.0;
                        continue;
                    }
                    result[i + nc * j] = 0.0;
                    continue;
                }
                result[i + nc * j] = 1.0;
            }
        }
        for (j = 0; j < nr; ++j) {
            for (i = 0; i < nc; ++i) {
                result[i + nc * j] = result[i + j * nc] >= 1.0 ? 255.0 : 0.0;
            }
        }
        img.setDataXY(0, Array1DUtil.doubleArrayToArray((double[])result, (Object)img.getDataXY(0)));
        return img;
    }

    public static Sequence getDistance(Sequence seq, int connex) {
        IcyBufferedImage imgIn = seq.getFirstImage();
        int nr = seq.getHeight();
        int nc = seq.getWidth();
        int k = nc * nr;
        IcyBufferedImage imgOut = new IcyBufferedImage(nc, nr, seq.getSizeC(), DataType.DOUBLE);
        double[] tabIn = Array1DUtil.arrayToDoubleArray((Object)imgIn.getDataXY(0), (boolean)imgIn.isSignedDataType());
        boolean black = false;
        int[] d = new int[8];
        double[] tab = new double[k];
        switch (connex) {
            case 4: {
                d[0] = 1;
                d[1] = nc;
                d[2] = -1;
                d[3] = -nc;
                break;
            }
            case 8: {
                d[0] = 1;
                d[1] = nc;
                d[2] = -1;
                d[3] = -nc;
                d[4] = 1 + nc;
                d[5] = -1 + nc;
                d[6] = -1 - nc;
                d[7] = 1 - nc;
            }
        }
        for (int i = 0; i < k; ++i) {
            tab[i] = tabIn[i] != (double)black ? 37265.0 : 0.0;
        }
        LinkedList<PixWatershed> fifo = new LinkedList<PixWatershed>();
        for (int i = 0; i < k; ++i) {
            boolean flag = false;
            if (tab[i] != 37265.0) continue;
            for (int j = 0; !flag && j < connex; ++j) {
                if (i % nc == 0 || i % nc == nc - 1 || i + d[j] < 0 || i + d[j] > nc * nr) {
                    tab[i] = 1.0;
                }
                if (i + d[j] < 0 || i + d[j] >= k || tab[i + d[j]] != (double)black) continue;
                PixWatershed p_num = new PixWatershed(i, nc);
                fifo.add(p_num);
                tab[i] = 1.0;
                flag = true;
            }
        }
        int maxd = -1;
        while (!fifo.isEmpty()) {
            PixWatershed p_num = (PixWatershed)fifo.poll();
            int i = p_num.getOffset();
            for (int j = 0; j < connex; ++j) {
                int l = i + d[j];
                if (l < 0 || l >= k || tab[l] != 37265.0) continue;
                tab[l] = tab[i] + 1.0;
                PixWatershed p = new PixWatershed(l, nc);
                maxd = Math.max((int)tab[l], maxd);
                fifo.add(p);
            }
        }
        imgOut.setDataXY(0, Array1DUtil.doubleArrayToArray((double[])tab, (Object)imgOut.getDataXY(0)));
        Sequence seqOut = new Sequence();
        seqOut.addImage((BufferedImage)imgOut);
        return seqOut;
    }

    public static Sequence computeDistance(Sequence seq, int connex) {
        int nr = seq.getHeight();
        int nc = seq.getWidth();
        int k = nc * nr;
        IcyBufferedImage imgOut = new IcyBufferedImage(nc, nr, seq.getSizeC(), DataType.DOUBLE);
        boolean black = false;
        int white = 255;
        int[] d = new int[8];
        IcyBufferedImage img = seq.getFirstImage();
        double[] tab = Array1DUtil.arrayToDoubleArray((Object)img.getDataXY(0), (boolean)img.isSignedDataType());
        switch (connex) {
            case 4: {
                d = new int[]{-nc, 1, nc, -1};
                break;
            }
            case 8: {
                d[0] = -1 - nc;
                d[1] = nc;
                d[2] = nc + 1;
                d[3] = -1;
                d[4] = 1;
                d[5] = -1 + nc;
                d[6] = nc + 1;
                d[7] = 1 + nc;
            }
        }
        LinkedList<PixWatershed> fifo = new LinkedList<PixWatershed>();
        for (int i = 0; i < k; ++i) {
            boolean flag = false;
            if (tab[i] == (double)black) continue;
            for (int j = 0; !flag && j < connex; ++j) {
                if (i + d[j] >= k || i + d[j] < 0 || tab[i + d[j]] != (double)black) continue;
                PixWatershed p_num = new PixWatershed(i, nc);
                fifo.add(p_num);
                tab[i] = 2.0;
                flag = true;
            }
        }
        int maxd = -1;
        while (!fifo.isEmpty()) {
            PixWatershed p_num = (PixWatershed)fifo.poll();
            int i = p_num.getOffset();
            for (int j = 0; j < connex; ++j) {
                int l = i + d[j];
                if (l >= 0 && l < k) {
                    if (tab[l] != (double)white) continue;
                    tab[l] = tab[i] + 1.0;
                    PixWatershed p = new PixWatershed(l, nc);
                    maxd = Math.max((int)tab[l], maxd);
                    fifo.add(p);
                    continue;
                }
                System.out.println(" l: " + l);
            }
        }
        imgOut.setDataXY(0, Array1DUtil.doubleArrayToArray((double[])tab, (Object)imgOut.getDataXY(0)));
        Sequence seqOut = new Sequence();
        seqOut.addImage((BufferedImage)imgOut);
        return seqOut;
    }

    static double getDist(double[] Tab, int x, int y, int nc, int nr) {
        if (x < 0 || x >= nc || y < 0 || y >= nr) {
            return 0.0;
        }
        return Tab[x + nc * y];
    }

    static boolean swip_voisins(int val, double[] resultDist, int nc, int nr, int i, int j) {
        int[] d = new int[]{-nc, 1, nc, -1, 1 - nc, 1 + nc, nc - 1, -1 - nc, -2 * nc, 2, 2 * nc, -2};
        int k = 0;
        boolean find = false;
        do {
            if (j * nc + i + d[k] >= nc * nr || j * nc + i + d[k] <= 0 || !(resultDist[j * nc + i + d[k]] >= (double)val)) continue;
            find = true;
        } while (!find && ++k < 12);
        return find;
    }

    private static void calculerLPE(Sequence seq, int z, int cv) {
        int t;
        int nc = seq.getFirstImage().getWidth();
        int nr = seq.getFirstImage().getHeight();
        int nbPixels = nc * nr;
        int[] d = new int[]{-nc, 1, nc, -1, 1 - nc, 1 + nc, nc - 1, -1 - nc};
        Sequence seqOut = new Sequence();
        for (t = 0; t < seq.getSizeT(); ++t) {
            int l;
            int i;
            int i2;
            IcyBufferedImage imgIn = seq.getImage(t, z);
            int[] tabIn = Array1DUtil.arrayToIntArray((Object)imgIn.getDataXY(0), (boolean)imgIn.isSignedDataType());
            IcyBufferedImage imgOut = new IcyBufferedImage(seq.getSizeX(), seq.getSizeY(), 1, seq.getDataType_());
            double[] tabOut = Array1DUtil.arrayToDoubleArray((Object)imgOut.getDataXY(0), (boolean)imgOut.isSignedDataType());
            for (i2 = 0; i2 < nc; ++i2) {
                tabOut[i2] = -4.0;
                tabOut[i2 + nbPixels - nc] = -4.0;
            }
            for (i2 = 0; i2 < nbPixels; i2 += nc) {
                tabOut[i2] = -4.0;
                tabOut[i2 + nc - 1] = -4.0;
            }
            LinkedList<PixWatershed> fifo = new LinkedList<PixWatershed>();
            boolean flag = false;
            int cr_label = 0;
            int hmin = Short.MAX_VALUE;
            int hmax = 0;
            for (int i3 = 0; i3 < nbPixels; ++i3) {
                int val = tabIn[i3] & 0xFFFFFF;
                hmin = Math.min(val, hmin);
                hmax = Math.max(val, hmax) & 0xFF;
            }
            int[] Hist = new int[hmax + 1];
            int[] HistCum = new int[hmax + 1];
            for (i = 0; i < hmax; ++i) {
                Hist[i] = 0;
                HistCum[i] = 0;
            }
            for (i = 0; i < nbPixels; ++i) {
                int n = tabIn[i] & 0xFFFFFF;
                Hist[n] = Hist[n] + 1;
            }
            for (i = hmin + 1; i <= hmax; ++i) {
                HistCum[i] = HistCum[i - 1] + Hist[i - 1];
            }
            int[] ims = new int[nc * nr];
            for (int i4 = 1; i4 < nc - 1; ++i4) {
                for (int j = 1; j < nr - 1; ++j) {
                    ims[HistCum[tabIn[l]]] = l = i4 + j * nc;
                    int n = tabIn[l];
                    HistCum[n] = HistCum[n] + 1;
                }
            }
            for (int i5 = hmin; i5 <= hmax; ++i5) {
                int pos;
                int j;
                int lower_b = i5 != 0 ? HistCum[i5 - 1] : 0;
                for (j = lower_b; j < HistCum[i5]; ++j) {
                    l = ims[j];
                    tabOut[l] = -2.0;
                    for (int r = 0; r < cv; ++r) {
                        pos = l + d[r];
                        PixWatershed pixel = new PixWatershed(pos, nc);
                        if (pos >= nbPixels || pos < 0 || !(tabOut[pos] > 0.0) && tabOut[pos] != 0.0) continue;
                        fifo.add(pixel);
                        tabOut[l] = -3.0;
                    }
                }
                while (!fifo.isEmpty()) {
                    PixWatershed pixel = (PixWatershed)fifo.pollFirst();
                    l = pixel.getOffset();
                    int pos2 = 0;
                    for (int r = 0; r < cv; ++r) {
                        pos2 = l + d[r];
                        if (pos2 < 0 || pos2 >= nbPixels) continue;
                        if (tabOut[pos2] > 0.0) {
                            if (tabOut[l] == -3.0 || tabOut[l] == 0.0 && flag) {
                                tabOut[l] = tabOut[pos2];
                                continue;
                            }
                            if (!(tabOut[l] > 0.0) || tabOut[l] == tabOut[pos2]) continue;
                            tabOut[l] = 0.0;
                            flag = false;
                            continue;
                        }
                        if (tabOut[pos2] == 0.0) {
                            if (tabOut[l] != -3.0) continue;
                            tabOut[l] = 0.0;
                            flag = true;
                            continue;
                        }
                        if (tabOut[pos2] != -2.0) continue;
                        tabOut[pos2] = -3.0;
                        PixWatershed pixel2 = new PixWatershed(pos2, nc);
                        fifo.add(pixel2);
                    }
                }
                for (j = lower_b; j < HistCum[i5]; ++j) {
                    l = ims[j];
                    if (tabOut[l] == -2.0) {
                        tabOut[l] = ++cr_label;
                        PixWatershed pixel = new PixWatershed(l, nc);
                        fifo.add(pixel);
                    }
                    while (!fifo.isEmpty()) {
                        PixWatershed pixel = (PixWatershed)fifo.pollFirst();
                        pos = pixel.getOffset();
                        for (int r = 0; r < cv; ++r) {
                            int lpos = pos + d[r];
                            if (lpos < 0 || lpos >= nbPixels || tabOut[lpos] != -2.0) continue;
                            PixWatershed pixel2 = new PixWatershed(lpos, nc);
                            fifo.add(pixel2);
                            tabOut[lpos] = cr_label;
                        }
                    }
                }
            }
            imgOut.setDataXY(0, Array1DUtil.doubleArrayToArray((double[])tabOut, (Object)imgOut.getDataXY(0)));
            seqOut.setImage(t, z, (BufferedImage)imgOut);
        }
        seq.removeAllImages();
        for (t = 0; t < seqOut.getSizeT(); ++t) {
            seq.setImage(t, 0, (BufferedImage)seqOut.getImage(t, 0));
        }
    }

    private static void calculerVersantsEtiquetes(Sequence seq, int z) {
        int t;
        int width = seq.getFirstImage().getWidth();
        int height = seq.getFirstImage().getHeight();
        int maxPix = width * height;
        Sequence seqOut = new Sequence();
        for (t = 0; t < seq.getSizeT(); ++t) {
            int h;
            int i;
            IcyBufferedImage imgIn = seq.getImage(t, z);
            IcyBufferedImage imgOut = new IcyBufferedImage(imgIn.getWidth(), imgIn.getHeight(), imgIn.getSizeC(), DataType.DOUBLE);
            double[] tJ = Array1DUtil.arrayToDoubleArray((Object)imgOut.getDataXY(0), (boolean)imgOut.isSignedDataType());
            int[] Id = new int[maxPix];
            PixWatershed fictif = new PixWatershed(-1, -1, -1);
            PixWatershed[] pixels = new PixWatershed[maxPix];
            int hmin = 65535;
            int hmax = 0;
            LinkedList<PixWatershed> fifo = new LinkedList<PixWatershed>();
            int label_courant = 0;
            double[] tabIn = Array1DUtil.arrayToDoubleArray((Object)imgIn.getDataXY(0), (boolean)imgIn.isSignedDataType());
            for (i = 0; i < maxPix; ++i) {
                int val = (int)tabIn[i];
                hmin = Math.min(val, hmin);
                hmax = Math.max(val, hmax);
            }
            int[] Hi = new int[hmax + 1];
            for (i = hmin; i <= hmax; ++i) {
                Hi[i] = 0;
            }
            int[] HCi = new int[hmax + 1];
            HCi[hmin] = 0;
            for (i = 0; i < maxPix; ++i) {
                int n = (int)tabIn[i];
                Hi[n] = Hi[n] + 1;
            }
            for (h = hmin + 1; h <= hmax; ++h) {
                HCi[h] = HCi[h - 1] + Hi[h - 1];
                System.out.println(" h:" + h + " Hi[h-1]:" + Hi[h - 1] + " HCi[h - 1]:" + HCi[h - 1]);
            }
            for (int offset = 0; offset < maxPix; ++offset) {
                int i2 = HCi[(int)tabIn[offset]];
                pixels[i2] = new PixWatershed(offset, width);
                int n = (int)tabIn[offset];
                HCi[n] = HCi[n] + 1;
            }
            for (i = 0; i < tJ.length; ++i) {
                tJ[i] = -1.0;
            }
            for (h = hmin; h <= hmax; ++h) {
                int offneighbor;
                int offset;
                int i3;
                int start = h == hmin ? 0 : HCi[h - 1];
                int end = HCi[h];
                for (i3 = start; i3 < end; ++i3) {
                    offset = pixels[i3].getOffset();
                    if (offset == 5074) {
                        System.out.println(" i:" + i3 + " offset:" + offset + " x:" + pixels[offset].getX() + " y:" + pixels[offset].getY());
                    }
                    tJ[offset] = -2.0;
                    int x = pixels[i3].getX();
                    int y = pixels[i3].getY();
                    ArrayList<Integer> lNeighbors = MorphOp.getOffsetNeighbors(x, y, width, height);
                    for (int ind = 0; ind < lNeighbors.size(); ++ind) {
                        offneighbor = lNeighbors.get(ind);
                        if (!(tJ[offneighbor] > 0.0) && tJ[offneighbor] != 0.0) continue;
                        Id[offset] = 1;
                        fifo.add(pixels[i3]);
                    }
                }
                int dist_courante = 1;
                fifo.add(fictif);
                block10: while (true) {
                    PixWatershed p;
                    if ((p = (PixWatershed)fifo.poll()).equals(fictif)) {
                        if (fifo.isEmpty()) break;
                        fifo.add(fictif);
                        ++dist_courante;
                        p = (PixWatershed)fifo.poll();
                    }
                    int x = p.getX();
                    int y = p.getY();
                    int offset2 = p.getOffset();
                    ArrayList<Integer> lNeighBors = MorphOp.getOffsetNeighbors(x, y, width, height);
                    int i4 = 0;
                    while (true) {
                        if (i4 >= lNeighBors.size()) continue block10;
                        offneighbor = lNeighBors.get(i4);
                        if (Id[offneighbor] < dist_courante && (tJ[offneighbor] > 0.0 || tJ[offneighbor] == 0.0)) {
                            if (tJ[offneighbor] > 0.0) {
                                if (tJ[offset2] == -2.0 || tJ[offset2] == 0.0) {
                                    tJ[offset2] = tJ[offneighbor];
                                } else if (tJ[offset2] != tJ[offneighbor]) {
                                    tJ[offset2] = 0.0;
                                }
                            } else if (tJ[offset2] == -2.0) {
                                tJ[offset2] = 0.0;
                            }
                        } else if (tJ[offneighbor] == -2.0 && Id[offneighbor] == 0) {
                            Id[offneighbor] = dist_courante + 1;
                            fifo.add(new PixWatershed(offneighbor, width));
                        }
                        ++i4;
                    }
                    break;
                }
                for (i3 = start; i3 < end; ++i3) {
                    offset = pixels[i3].getOffset();
                    if (tJ[offset] != -2.0) continue;
                    if (++label_courant == 45) {
                        System.out.println(" STOP");
                    }
                    fifo.add(pixels[i3]);
                    tJ[offset] = label_courant;
                    while (!fifo.isEmpty()) {
                        PixWatershed p2 = (PixWatershed)fifo.poll();
                        ArrayList<Integer> lNeighbors = MorphOp.getOffsetNeighbors(p2.getX(), p2.getY(), width, height);
                        for (int ind = 0; ind < lNeighbors.size(); ++ind) {
                            int offneighbor2 = lNeighbors.get(ind);
                            if (tJ[offneighbor2] != -2.0) continue;
                            fifo.add(new PixWatershed(offneighbor2, width));
                            tJ[offneighbor2] = label_courant;
                        }
                    }
                }
            }
            imgOut.setDataXY(0, Array1DUtil.doubleArrayToArray((double[])tJ, (Object)imgOut.getDataXY(0)));
            seqOut.setImage(t, z, (BufferedImage)imgOut);
        }
        seq.removeAllImages();
        for (t = 0; t < seqOut.getSizeT(); ++t) {
            seq.setImage(t, 0, (BufferedImage)seqOut.getImage(t, 0));
        }
    }

    private static void calculerVersantsEtiquetes3D(Sequence seq) {
        int t;
        int width = seq.getFirstImage().getWidth();
        int height = seq.getFirstImage().getHeight();
        int maxPix = width * height;
        Sequence seqOut = new Sequence();
        for (t = 0; t < seq.getSizeT(); ++t) {
            int offset;
            int h;
            int i;
            int z;
            int depth = seq.getSizeZ(t);
            double[][] tJ = new double[depth][maxPix];
            int[][] Id = new int[depth][maxPix];
            PixWatershed3D fictif = new PixWatershed3D(-1, -1, -1);
            PixWatershed3D[] pixels = new PixWatershed3D[maxPix * depth];
            int hmin = 65535;
            int hmax = 0;
            LinkedList<PixWatershed3D> fifo = new LinkedList<PixWatershed3D>();
            int label_courant = 0;
            double[][] tabIn = Array2DUtil.arrayToDoubleArray((Object)seq.getDataXYZ(t, 0), (boolean)seq.isSignedDataType());
            for (z = 0; z < depth; ++z) {
                for (i = 0; i < maxPix; ++i) {
                    int val = (int)tabIn[z][i] & 0xFFFFFF;
                    hmin = Math.min(val, hmin);
                    hmax = Math.max(val, hmax) & 0xFFFFFF;
                }
            }
            int[] Hi = new int[hmax + 1];
            for (int i2 = hmin; i2 <= hmax; ++i2) {
                Hi[i2] = 0;
            }
            int[] HCi = new int[hmax + 1];
            for (z = 0; z < depth; ++z) {
                HCi[hmin] = 0;
            }
            for (z = 0; z < depth; ++z) {
                for (i = 0; i < maxPix; ++i) {
                    int n = (int)tabIn[z][i] & 0xFFFFFF;
                    Hi[n] = Hi[n] + 1;
                }
            }
            for (h = hmin + 1; h <= hmax; ++h) {
                HCi[h] = HCi[h - 1] + Hi[h - 1];
            }
            for (z = 0; z < depth; ++z) {
                for (int offset2 = 0; offset2 < maxPix; ++offset2) {
                    pixels[HCi[(int)tabIn[z][offset2] & 0xFFFFFF]] = new PixWatershed3D(offset2, z, width);
                    int n = (int)tabIn[z][offset2] & 0xFFFFFF;
                    HCi[n] = HCi[n] + 1;
                }
            }
            for (z = 0; z < depth; ++z) {
                for (i = 0; i < tJ[0].length; ++i) {
                    tJ[z][i] = -1.0;
                }
            }
            for (h = hmin; h <= hmax; ++h) {
                int offneighbor;
                int zNeighbor;
                int start = h == hmin ? 0 : HCi[h - 1];
                int end = HCi[h];
                block13: for (int i3 = start; i3 < end; ++i3) {
                    offset = pixels[i3].getOffset();
                    int x = pixels[i3].getX();
                    int y = pixels[i3].getY();
                    int z2 = pixels[i3].getZ();
                    tJ[z2][offset] = -2.0;
                    ArrayList<int[]> lNeighbors = MorphOp.getOffsetNeighbors3D(x, y, z2, width, height, depth);
                    for (int ind = 0; ind < lNeighbors.size(); ++ind) {
                        zNeighbor = lNeighbors.get(ind)[0];
                        if (!(tJ[zNeighbor][offneighbor = lNeighbors.get(ind)[1]] > 0.0) && tJ[zNeighbor][offneighbor] != 0.0) continue;
                        Id[z2][offset] = 1;
                        fifo.add(pixels[i3]);
                        continue block13;
                    }
                }
                int dist_courante = 1;
                fifo.add(fictif);
                block15: while (true) {
                    PixWatershed3D p;
                    if ((p = (PixWatershed3D)fifo.poll()).equals(fictif)) {
                        if (fifo.isEmpty()) break;
                        fifo.add(fictif);
                        ++dist_courante;
                        p = (PixWatershed3D)fifo.poll();
                    }
                    int x = p.getX();
                    int y = p.getY();
                    int z3 = p.getZ();
                    int offset3 = p.getOffset();
                    ArrayList<int[]> lNeighBors = MorphOp.getOffsetNeighbors3D(x, y, z3, width, height, depth);
                    int i4 = 0;
                    while (true) {
                        if (i4 >= lNeighBors.size()) continue block15;
                        zNeighbor = lNeighBors.get(i4)[0];
                        if (Id[zNeighbor][offneighbor = lNeighBors.get(i4)[1]] < dist_courante && (tJ[zNeighbor][offneighbor] > 0.0 || tJ[zNeighbor][offneighbor] == 0.0)) {
                            if (tJ[zNeighbor][offneighbor] > 0.0) {
                                if (tJ[z3][offset3] == -2.0 || tJ[z3][offset3] == 0.0) {
                                    tJ[z3][offset3] = tJ[zNeighbor][offneighbor];
                                } else if (tJ[z3][offset3] != tJ[zNeighbor][offneighbor]) {
                                    tJ[z3][offset3] = 0.0;
                                }
                            } else if (tJ[z3][offset3] == -2.0) {
                                tJ[z3][offset3] = 0.0;
                            }
                        } else if (tJ[zNeighbor][offneighbor] == -2.0 && Id[zNeighbor][offneighbor] == 0) {
                            Id[zNeighbor][offneighbor] = dist_courante + 1;
                            fifo.add(new PixWatershed3D(offneighbor, zNeighbor, width));
                        }
                        ++i4;
                    }
                    break;
                }
                for (int i5 = start; i5 < end; ++i5) {
                    offset = pixels[i5].getOffset();
                    int z4 = pixels[i5].getZ();
                    if (tJ[z4][offset] != -2.0) continue;
                    fifo.add(pixels[i5]);
                    tJ[z4][offset] = ++label_courant;
                    while (!fifo.isEmpty()) {
                        PixWatershed3D p2 = (PixWatershed3D)fifo.poll();
                        ArrayList<int[]> lNeighbors = MorphOp.getOffsetNeighbors3D(p2.getX(), p2.getY(), p2.getZ(), width, height, depth);
                        for (int ind = 0; ind < lNeighbors.size(); ++ind) {
                            int offneighbor2;
                            int zNeighbor2 = lNeighbors.get(ind)[0];
                            if (tJ[zNeighbor2][offneighbor2 = lNeighbors.get(ind)[1]] != -2.0) continue;
                            fifo.add(new PixWatershed3D(offneighbor2, z4, width));
                            tJ[zNeighbor2][offneighbor2] = label_courant;
                        }
                    }
                }
            }
            for (z = 0; z < depth; ++z) {
                IcyBufferedImage imgOut = new IcyBufferedImage(width, height, 1, DataType.DOUBLE);
                DataBufferDouble bufOut = (DataBufferDouble)imgOut.getRaster().getDataBuffer();
                double[] dataOut = bufOut.getData();
                for (offset = 0; offset < maxPix; ++offset) {
                    dataOut[offset] = tJ[z][offset];
                }
                seqOut.setImage(t, z, (BufferedImage)imgOut);
            }
        }
        seq.removeAllImages();
        for (t = 0; t < seqOut.getSizeT(); ++t) {
            for (int z = 0; z < seqOut.getSizeZ(t); ++z) {
                seq.setImage(t, z, (BufferedImage)seqOut.getImage(t, z));
            }
        }
    }

    private static void separerVersants(Sequence seq, int z) {
        int width = seq.getFirstImage().getWidth();
        int height = seq.getFirstImage().getHeight();
        int maxPix = width * height;
        for (int t = 0; t < seq.getSizeT(); ++t) {
            IcyBufferedImage img = seq.getImage(t, z);
            DataBufferDouble buf = (DataBufferDouble)img.getRaster().getDataBuffer();
            double[] tabVersants = buf.getData();
            block1: for (int offset = 0; offset < maxPix; ++offset) {
                ArrayList<Integer> lNeighbors = MorphOp.getOffsetNeighbors(offset, width, height);
                for (int i = 0; i < lNeighbors.size(); ++i) {
                    int offNeighbor = lNeighbors.get(i);
                    if (!(tabVersants[offNeighbor] < tabVersants[offset]) || !(tabVersants[offNeighbor] > 0.0)) continue;
                    tabVersants[offset] = 0.0;
                    continue block1;
                }
            }
        }
    }

    private static void separerVersants3D(Sequence seq) {
        int width = seq.getFirstImage().getWidth();
        int height = seq.getFirstImage().getHeight();
        int maxPix = width * height;
        for (int t = 0; t < seq.getSizeT(); ++t) {
            int depth = seq.getSizeZ(t);
            double[][] tabVersants = Array2DUtil.arrayToDoubleArray((Object)seq.getDataXYZ(t, 0), (boolean)seq.isSignedDataType());
            for (int z = 0; z < depth; ++z) {
                block2: for (int offset = 0; offset < maxPix; ++offset) {
                    ArrayList<int[]> lNeighbors = MorphOp.getOffsetNeighbors3D(offset, z, width, height, depth);
                    for (int i = 0; i < lNeighbors.size(); ++i) {
                        int offNeighbor;
                        int zNeighbor = lNeighbors.get(i)[0];
                        if (!(tabVersants[zNeighbor][offNeighbor = lNeighbors.get(i)[1]] < tabVersants[z][offset]) || !(tabVersants[zNeighbor][offNeighbor] > 0.0)) continue;
                        tabVersants[z][offset] = 0.0;
                        continue block2;
                    }
                }
            }
        }
    }

    private static ArrayList<Integer> getOffsetNeighbors(int offset, int width, int height) {
        int x = offset % width;
        int y = offset / width;
        return MorphOp.getOffsetNeighbors(x, y, width, height);
    }

    private static ArrayList<int[]> getOffsetNeighbors3D(int offset, int z, int width, int height, int depth) {
        int x = offset % width;
        int y = offset / width;
        return MorphOp.getOffsetNeighbors3D(x, y, z, width, height, depth);
    }

    private static ArrayList<Integer> getOffsetNeighbors(int x, int y, int width, int height) {
        int offneighbor;
        ArrayList<Integer> listNeighbors = new ArrayList<Integer>();
        if (x - 1 >= 0 && y - 1 >= 0) {
            offneighbor = x - 1 + (y - 1) * width;
            listNeighbors.add(offneighbor);
        }
        if (y - 1 >= 0) {
            offneighbor = x + (y - 1) * width;
            listNeighbors.add(offneighbor);
        }
        if (y - 1 >= 0 && x + 1 < width) {
            offneighbor = x + 1 + (y - 1) * width;
            listNeighbors.add(offneighbor);
        }
        if (x - 1 >= 0) {
            offneighbor = x - 1 + y * width;
            listNeighbors.add(offneighbor);
        }
        if (x + 1 < width) {
            offneighbor = x + 1 + y * width;
            listNeighbors.add(offneighbor);
        }
        if (x - 1 >= 0 && y + 1 < height) {
            offneighbor = x - 1 + (y + 1) * width;
            listNeighbors.add(offneighbor);
        }
        if (y + 1 < height) {
            offneighbor = x + (y + 1) * width;
            listNeighbors.add(offneighbor);
        }
        if (x + 1 < width && y + 1 < height) {
            offneighbor = x + 1 + (y + 1) * width;
            listNeighbors.add(offneighbor);
        }
        return listNeighbors;
    }

    private static ArrayList<int[]> getOffsetNeighbors3D(int x, int y, int z, int width, int height, int depth) {
        int offneighbor;
        ArrayList<int[]> listNeighbors = new ArrayList<int[]>();
        if (x - 1 >= 0 && y - 1 >= 0) {
            offneighbor = x - 1 + (y - 1) * width;
            listNeighbors.add(new int[]{z, offneighbor});
            if (z - 1 >= 0) {
                listNeighbors.add(new int[]{z - 1, offneighbor});
            }
            if (z + 1 < depth) {
                listNeighbors.add(new int[]{z + 1, offneighbor});
            }
        }
        if (y - 1 >= 0) {
            offneighbor = x + (y - 1) * width;
            listNeighbors.add(new int[]{z, offneighbor});
            if (z - 1 >= 0) {
                listNeighbors.add(new int[]{z - 1, offneighbor});
            }
            if (z + 1 < depth) {
                listNeighbors.add(new int[]{z + 1, offneighbor});
            }
        }
        if (y - 1 >= 0 && x + 1 < width) {
            offneighbor = x + 1 + (y - 1) * width;
            listNeighbors.add(new int[]{z, offneighbor});
            if (z - 1 >= 0) {
                listNeighbors.add(new int[]{z - 1, offneighbor});
            }
            if (z + 1 < depth) {
                listNeighbors.add(new int[]{z + 1, offneighbor});
            }
        }
        if (x - 1 >= 0) {
            offneighbor = x - 1 + y * width;
            listNeighbors.add(new int[]{z, offneighbor});
            if (z - 1 >= 0) {
                listNeighbors.add(new int[]{z - 1, offneighbor});
            }
            if (z + 1 < depth) {
                listNeighbors.add(new int[]{z + 1, offneighbor});
            }
        }
        if (x + 1 < width) {
            offneighbor = x + 1 + y * width;
            listNeighbors.add(new int[]{z, offneighbor});
            if (z - 1 >= 0) {
                listNeighbors.add(new int[]{z - 1, offneighbor});
            }
            if (z + 1 < depth) {
                listNeighbors.add(new int[]{z + 1, offneighbor});
            }
        }
        if (x - 1 >= 0 && y + 1 < height) {
            offneighbor = x - 1 + (y + 1) * width;
            listNeighbors.add(new int[]{z, offneighbor});
            if (z - 1 >= 0) {
                listNeighbors.add(new int[]{z - 1, offneighbor});
            }
            if (z + 1 < depth) {
                listNeighbors.add(new int[]{z + 1, offneighbor});
            }
        }
        if (y + 1 < height) {
            offneighbor = x + (y + 1) * width;
            listNeighbors.add(new int[]{z, offneighbor});
            if (z - 1 >= 0) {
                listNeighbors.add(new int[]{z - 1, offneighbor});
            }
            if (z + 1 < depth) {
                listNeighbors.add(new int[]{z + 1, offneighbor});
            }
        }
        if (x + 1 < width && y + 1 < height) {
            offneighbor = x + 1 + (y + 1) * width;
            listNeighbors.add(new int[]{z, offneighbor});
            if (z - 1 >= 0) {
                listNeighbors.add(new int[]{z - 1, offneighbor});
            }
            if (z + 1 < depth) {
                listNeighbors.add(new int[]{z + 1, offneighbor});
            }
        }
        return listNeighbors;
    }

    private static void isolerWshed(Sequence seq, int z) {
        for (int t = 0; t < seq.getSizeT(); ++t) {
            IcyBufferedImage img = seq.getImage(t, z);
            DataBufferDouble buf = (DataBufferDouble)img.getRaster().getDataBuffer();
            double[] data = buf.getData();
            for (int i = 0; i < data.length; ++i) {
                data[i] = data[i] != 0.0 ? 0.0 : 1.0;
            }
        }
    }

    private static void isolerWshed3D(Sequence seq) {
        for (int t = 0; t < seq.getSizeT(); ++t) {
            double[][] data = Array2DUtil.arrayToDoubleArray((Object)seq.getDataXYZ(t, 0), (boolean)seq.isSignedDataType());
            for (int z = 0; z < seq.getSizeZ(t); ++z) {
                for (int i = 0; i < data[z].length; ++i) {
                    if (data[z][i] == 0.0) continue;
                    data[z][i] = 1.0;
                }
            }
        }
    }

    public static void watershed2D(Sequence seq, int z, int typeWshed) {
        switch (typeWshed) {
            case 0: {
                MorphOp.calculerVersantsEtiquetes(seq, z);
                break;
            }
            case 1: {
                MorphOp.calculerLPE(seq, z, 8);
                break;
            }
            case 2: {
                MorphOp.calculerVersantsEtiquetes(seq, z);
                MorphOp.separerVersants(seq, z);
                MorphOp.isolerWshed(seq, z);
            }
        }
    }

    public static void watershed3D(Sequence seq, int typeWshed) {
        MorphOp.calculerVersantsEtiquetes3D(seq);
        switch (typeWshed) {
            case 0: {
                MorphOp.separerVersants3D(seq);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                MorphOp.separerVersants3D(seq);
                MorphOp.isolerWshed3D(seq);
            }
        }
    }

    public static class UnhandledImageTypeException
    extends RuntimeException {
        static final long serialVersionUID = 0L;
        private String text;

        public UnhandledImageTypeException(String txt) {
            this.text = txt;
        }

        @Override
        public String toString() {
            return this.text;
        }
    }
}

