/*
 * Decompiled with CFR 0.152.
 */
package plugins.vannary.morphomaths.blocks;

import icy.plugin.abstract_.PluginActionable;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import icy.system.IcyExceptionHandler;
import icy.system.IcyHandledException;
import icy.type.DataType;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarListener;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.vars.lang.Var;
import plugins.vannary.morphomaths.MorphOp;

public class DistanceMap
extends PluginActionable
implements Block {
    private EzVarSequence inputSequence;
    private EzVarBoolean inputOverwriteResult;
    private EzVarBoolean input3dModality;
    private EzVarInteger inputProcessedZ;
    private EzVarSequence outputSequence;
    private Sequence transformedSequence;

    public void declareInput(VarList inputMap) {
        this.inputSequence = new EzVarSequence("Sequence");
        this.inputOverwriteResult = new EzVarBoolean("Results on input", false);
        this.input3dModality = new EzVarBoolean("Compute in 3D", false);
        this.inputProcessedZ = new EzVarInteger("Z value");
        this.inputProcessedZ.getVariable().setEnabled(false);
        this.input3dModality.addVarChangeListener((EzVarListener)new EzVarListener<Boolean>(){

            public void variableChanged(EzVar<Boolean> source, Boolean newValue) {
                if (newValue.booleanValue()) {
                    DistanceMap.this.inputProcessedZ.getVariable().setEnabled(false);
                } else {
                    DistanceMap.this.inputProcessedZ.getVariable().setEnabled(true);
                }
            }
        });
        inputMap.add(this.inputSequence.name, (Var)this.inputSequence.getVariable());
        inputMap.add(this.inputOverwriteResult.name, this.inputOverwriteResult.getVariable());
        inputMap.add(this.input3dModality.name, this.input3dModality.getVariable());
        inputMap.add(this.inputProcessedZ.name, this.inputProcessedZ.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        this.outputSequence = new EzVarSequence("Dilation Sequence");
        outputMap.add(this.outputSequence.name, (Var)this.outputSequence.getVariable());
    }

    public void run() {
        try {
            int processedZ;
            boolean is3D;
            boolean isReusingSequence;
            Sequence inSequence = this.inputSequence == null ? this.getActiveSequence() : (Sequence)this.inputSequence.getValue(true);
            if (inSequence == null) {
                throw new IcyHandledException("No sequence selected");
            }
            if (this.inputSequence == null) {
                isReusingSequence = false;
                is3D = inSequence.getSizeZ() > 1;
                processedZ = 0;
            } else {
                isReusingSequence = (Boolean)this.inputOverwriteResult.getValue();
                is3D = (Boolean)this.input3dModality.getValue();
                processedZ = (Integer)this.inputProcessedZ.getValue();
            }
            if (isReusingSequence) {
                this.transformedSequence = inSequence;
            } else {
                this.transformedSequence = SequenceUtil.convertToType((Sequence)SequenceUtil.toGray((Sequence)inSequence), (DataType)DataType.DOUBLE, (boolean)false);
                this.transformedSequence.setName(inSequence.getName() + "_DistanceMap");
            }
            if (is3D) {
                MorphOp.distanceMap3D(this.transformedSequence, 0.0, true);
            } else if (processedZ >= 0 && processedZ < this.transformedSequence.getSizeZ()) {
                MorphOp.distanceMap2D(this.transformedSequence, processedZ, 0.0, true);
            } else {
                throw new RuntimeException("Invalid z coordinate: " + processedZ + ". Expected [0 - " + this.transformedSequence.getSizeZ() + ")");
            }
            this.transformedSequence.dataChanged();
            if (this.outputSequence != null) {
                this.outputSequence.setValue(this.transformedSequence);
            } else {
                this.addSequence(this.transformedSequence);
            }
        }
        catch (InterruptedException e) {
            IcyExceptionHandler.showErrorMessage((Throwable)e, (boolean)false);
        }
    }
}

