/*
 * Decompiled with CFR 0.152.
 */
package plugins.nherve.colorpickerthreshold;

import icy.canvas.IcyCanvas;
import icy.gui.component.ComponentUtil;
import icy.gui.util.GuiUtil;
import icy.image.IcyBufferedImage;
import icy.main.Icy;
import icy.painter.Painter;
import icy.roi.ROI2DArea;
import icy.sequence.Sequence;
import icy.swimmingPool.SwimmingObject;
import icy.type.TypeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import plugins.nherve.toolbox.Algorithm;
import plugins.nherve.toolbox.NherveToolbox;
import plugins.nherve.toolbox.image.BinaryIcyBufferedImage;
import plugins.nherve.toolbox.image.feature.ColorDistance;
import plugins.nherve.toolbox.image.feature.L1ColorDistance;
import plugins.nherve.toolbox.image.feature.L2ColorDistance;
import plugins.nherve.toolbox.image.feature.SegmentableIcyBufferedImage;
import plugins.nherve.toolbox.image.feature.SupportRegion;
import plugins.nherve.toolbox.image.feature.descriptor.ColorPixel;
import plugins.nherve.toolbox.image.feature.learning.SVMClassifier;
import plugins.nherve.toolbox.image.feature.region.IcyPixel;
import plugins.nherve.toolbox.image.feature.signature.DenseVectorSignature;
import plugins.nherve.toolbox.image.feature.signature.SignatureException;
import plugins.nherve.toolbox.image.feature.signature.VectorSignature;
import plugins.nherve.toolbox.image.mask.Mask;
import plugins.nherve.toolbox.image.mask.MaskException;
import plugins.nherve.toolbox.image.toolboxes.ColorSpaceTools;
import plugins.nherve.toolbox.libsvm.svm;
import plugins.nherve.toolbox.plugin.PainterManagerSingletonPlugin;

public class ColorPickerThreshold
extends PainterManagerSingletonPlugin<ColorPickerThresholdPainter>
implements ActionListener,
ChangeListener,
ItemListener {
    private static final int COL_BLOCK_BORDER = 1;
    private static final int COL_BLOCK_SPACER = 1;
    private static final int COL_BLOCK_SIZE = 25;
    private static final int COL_GRID_HEIGHT = 3;
    private static final int COL_GRID_WIDTH = 8;
    private static final int COL_FULL_BLOCK_SIZE = 27;
    private static final Dimension COL_DIM = new Dimension(223, 83);
    private static final int COL_GRID_MAXCOLORS = 24;
    private static final String METHOD_1 = "KNN";
    private static final String METHOD_2 = "SVM";
    private JButton btCancelFilter;
    private JButton btFilter;
    private JButton btKeepMask;
    private JButton btAsROI;
    private JButton btMinus;
    private JButton btPlus;
    private int colDefaultDist;
    private int colMaxDist;
    private ColorBox m1ColorBox;
    private ColorBox m2PosColorBox;
    private ColorBox m2NegColorBox;
    private JLabel lbCurrent;
    private JRadioButton rbRGB;
    private JRadioButton rbHSV;
    private JRadioButton rbH1H2H3;
    private JRadioButton rbL1;
    private JRadioButton rbL2;
    private JRadioButton rbKernelLin;
    private JRadioButton rbKernelRBF;
    private JRadioButton rbKernelTri;
    private JSlider slC;
    private JSlider slGamma;
    private JLabel valC;
    private JLabel valGamma;
    private ColorDistance distance;
    private int choosenCS;
    private JSlider slDistThreshold;
    private int slMajTick;
    private int slMinTick;
    private JCheckBox cbShow;
    private JCheckBox cbAuto;
    private JTabbedPane tabbedPane;

    @Override
    public void actionPerformed(ActionEvent e) {
        AbstractButton b;
        Object o = e.getSource();
        if (o == null) {
            return;
        }
        if (o instanceof JButton) {
            b = (JButton)e.getSource();
            if (b == null) {
                return;
            }
            if (b == this.btFilter) {
                if (this.hasCurrentSequence()) {
                    try {
                        this.doFilter((ColorPickerThresholdPainter)this.getCurrentSequencePainter());
                    }
                    catch (SignatureException e1) {
                        Algorithm.err((Throwable)e1);
                    }
                }
                return;
            }
            if (b == this.btCancelFilter) {
                if (this.cbAuto.isSelected()) {
                    this.m1ColorBox.fireCancelFilterEvent();
                } else if (this.hasCurrentSequence()) {
                    ((ColorPickerThresholdPainter)this.getCurrentSequencePainter()).setMask(null);
                    this.getCurrentSequence().painterChanged(null);
                }
                return;
            }
            if (b == this.btPlus) {
                if (this.slDistThreshold.getValue() < this.slDistThreshold.getMaximum()) {
                    this.slDistThreshold.setValue(this.slDistThreshold.getValue() + 1);
                }
                return;
            }
            if (b == this.btMinus) {
                if (this.slDistThreshold.getValue() > this.slDistThreshold.getMinimum()) {
                    this.slDistThreshold.setValue(this.slDistThreshold.getValue() - 1);
                }
                return;
            }
            if (b == this.btKeepMask) {
                if (this.hasCurrentSequence()) {
                    Sequence currentSequence = this.getCurrentSequence();
                    try {
                        Mask m = this.doFilter((ColorPickerThresholdPainter)this.getCurrentSequencePainter());
                        if (m != null) {
                            SwimmingObject result = new SwimmingObject((Object)m);
                            Icy.getMainInterface().getSwimmingPool().add(result);
                        }
                    }
                    catch (SignatureException e1) {
                        Algorithm.err((Throwable)e1);
                    }
                    currentSequence.dataChanged();
                }
                return;
            }
            if (b == this.btAsROI) {
                if (this.hasCurrentSequence()) {
                    Sequence currentSequence = this.getCurrentSequence();
                    try {
                        Mask m = this.doFilter((ColorPickerThresholdPainter)this.getCurrentSequencePainter());
                        if (m != null) {
                            ROI2DArea a = m.asROI2DArea(currentSequence);
                            a.setName("From " + this.getName());
                        }
                    }
                    catch (SignatureException e1) {
                        Algorithm.err((Throwable)e1);
                    }
                    currentSequence.dataChanged();
                }
                return;
            }
        }
        if (o instanceof JRadioButton) {
            b = (JRadioButton)e.getSource();
            if (b == this.rbRGB) {
                this.choosenCS = 0;
            }
            if (b == this.rbHSV) {
                this.choosenCS = 4;
            }
            if (b == this.rbH1H2H3) {
                this.choosenCS = 3;
            }
            if (b == this.rbL1 || b == this.rbL2) {
                double currentPct = (double)this.slDistThreshold.getValue() / (double)this.slDistThreshold.getMaximum();
                if (b == this.rbL1) {
                    this.setDistance((ColorDistance)new L1ColorDistance());
                }
                if (b == this.rbL2) {
                    this.setDistance((ColorDistance)new L2ColorDistance());
                }
                this.slDistThreshold.setMaximum(this.colMaxDist);
                int currentValue = (int)(currentPct * (double)this.slDistThreshold.getMaximum());
                this.slDistThreshold.setValue(currentValue);
                this.m1ColorBox.setThreshold(currentValue);
                this.slDistThreshold.setMajorTickSpacing(this.slMajTick);
                this.slDistThreshold.setMinorTickSpacing(this.slMinTick);
            }
            if (this.hasCurrentSequence() && this.cbAuto.isSelected()) {
                try {
                    this.doFilter((ColorPickerThresholdPainter)this.getCurrentSequencePainter());
                }
                catch (SignatureException e1) {
                    Algorithm.err((Throwable)e1);
                }
            }
        }
    }

    public ColorPickerThresholdPainter createNewPainter() {
        ColorPickerThresholdPainter painter = new ColorPickerThresholdPainter();
        Sequence currentSequence = this.getCurrentSequence();
        painter.setSequence(currentSequence);
        this.m1ColorBox.register(painter);
        this.m2PosColorBox.register(painter);
        this.m2NegColorBox.register(painter);
        try {
            this.doFilter(painter);
        }
        catch (SignatureException e1) {
            Algorithm.err((Throwable)e1);
        }
        return painter;
    }

    private Mask doFilter(ColorPickerThresholdPainter painter) throws SignatureException {
        Sequence currentSequence = painter.getSequence();
        IcyBufferedImage currentImage = currentSequence.getFirstImage();
        Mask m = null;
        int comp = this.tabbedPane.getSelectedIndex();
        try {
            if (comp == 0) {
                m = this.filter1(this.m1ColorBox, currentImage);
                m.setLabel(this.getName() + " " + METHOD_1);
            } else if (comp == 1) {
                m = this.filter2(this.m2PosColorBox, this.m2NegColorBox, currentImage);
                m.setLabel(this.getName() + " " + METHOD_2);
            }
        }
        catch (MaskException maskException) {
            // empty catch block
        }
        painter.setMask(m);
        currentSequence.painterChanged(null);
        return m;
    }

    private Mask filter1(ColorBox box, IcyBufferedImage image) throws MaskException, SignatureException {
        if (box.nbColors == 0) {
            throw new MaskException("No color selected, filtering aborted");
        }
        Mask m = new Mask(image.getWidth(), image.getHeight(), false);
        BinaryIcyBufferedImage bin = m.getBinaryData();
        ArrayList<double[]> csColors = new ArrayList<double[]>();
        for (int k = 0; k < box.nbColors; ++k) {
            csColors.add(ColorSpaceTools.getColorComponentsD_0_255((int)this.choosenCS, (double)box.colors[k].getRed(), (double)box.colors[k].getGreen(), (double)box.colors[k].getBlue()));
        }
        byte[] raw = bin.getRawData();
        int idx = 0;
        for (int j = 0; j < image.getHeight(); ++j) {
            for (int i = 0; i < image.getWidth(); ++i) {
                double[] cc = ColorSpaceTools.getColorComponentsD_0_255((IcyBufferedImage)image, (int)this.choosenCS, (int)i, (int)j);
                boolean keep = false;
                for (int k = 0; k < box.nbColors; ++k) {
                    if (!(this.distance.computeDistance(cc, (double[])csColors.get(k)) < (double)box.getThreshold())) continue;
                    keep = true;
                    break;
                }
                if (keep) {
                    raw[idx] = -1;
                }
                ++idx;
            }
        }
        Color c = box.getAverageColor();
        int ir = 255 - c.getRed();
        int ig = 255 - c.getGreen();
        int ib = 255 - c.getBlue();
        m.setColor(new Color(ir, ig, ib));
        m.setOpacity(1.0f);
        return m;
    }

    private Mask filter2(ColorBox boxP, ColorBox boxN, IcyBufferedImage image) throws MaskException, SignatureException {
        int d;
        DenseVectorSignature s;
        double[] ddd;
        int i;
        if (boxP.nbColors == 0) {
            throw new MaskException("No positive color selected, filtering aborted");
        }
        if (boxN.nbColors == 0) {
            throw new MaskException("No negative color selected, filtering aborted");
        }
        VectorSignature[] pos = new VectorSignature[boxP.nbColors];
        VectorSignature[] neg = new VectorSignature[boxN.nbColors];
        for (i = 0; i < boxP.nbColors; ++i) {
            ddd = ColorSpaceTools.getColorComponentsD_0_1((int)this.choosenCS, (double)boxP.colors[i].getRed(), (double)boxP.colors[i].getGreen(), (double)boxP.colors[i].getBlue());
            s = new DenseVectorSignature(3);
            for (d = 0; d < 3; ++d) {
                s.set(d, ddd[d]);
            }
            pos[i] = s;
        }
        for (i = 0; i < boxN.nbColors; ++i) {
            ddd = ColorSpaceTools.getColorComponentsD_0_1((int)this.choosenCS, (double)boxN.colors[i].getRed(), (double)boxN.colors[i].getGreen(), (double)boxN.colors[i].getBlue());
            s = new DenseVectorSignature(3);
            for (d = 0; d < 3; ++d) {
                s.set(d, ddd[d]);
            }
            neg[i] = s;
        }
        SVMClassifier svm = new SVMClassifier();
        svm.createProblem(pos, neg);
        svm.setC(Math.pow(2.0, this.slC.getValue()));
        svm.setGamma(Math.pow(2.0, this.slGamma.getValue()));
        if (this.rbKernelLin.isSelected()) {
            svm.setKernel(0);
        } else if (this.rbKernelTri.isSelected()) {
            svm.setKernel(5);
        } else if (this.rbKernelRBF.isSelected()) {
            svm.setKernel(2);
        }
        svm.learnModel();
        Mask m = new Mask(image.getWidth(), image.getHeight(), false);
        BinaryIcyBufferedImage bin = m.getBinaryData();
        SegmentableIcyBufferedImage simg = new SegmentableIcyBufferedImage(image);
        ColorPixel col = new ColorPixel(false);
        col.setColorSpace(this.choosenCS);
        byte[] raw = bin.getRawData();
        int idx = 0;
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                IcyPixel pix = new IcyPixel((double)x, (double)y);
                VectorSignature vs = (VectorSignature)col.extractLocalSignature(simg, (SupportRegion)pix);
                if (svm.predict(vs) > 0.0) {
                    raw[idx] = -1;
                }
                ++idx;
            }
        }
        Color c = m.getAverageColor(image);
        int ir = 255 - c.getRed();
        int ig = 255 - c.getGreen();
        int ib = 255 - c.getBlue();
        m.setColor(new Color(ir, ig, ib));
        m.setOpacity(1.0f);
        return m;
    }

    public String getPainterName() {
        return ColorPickerThresholdPainter.class.getName();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object o = e.getSource();
        if (o == null) {
            return;
        }
        if (o instanceof JCheckBox) {
            JCheckBox c = (JCheckBox)e.getSource();
            int comp = this.tabbedPane.getSelectedIndex();
            ColorBox bx = null;
            if (comp == 0) {
                bx = this.m1ColorBox;
            } else if (comp == 1) {
                bx = this.m2PosColorBox;
            }
            if (c == this.cbShow) {
                bx.fireDisplayParametersChangeEvent();
            }
            if (c == this.cbAuto && this.cbAuto.isSelected()) {
                bx.fireFilterParametersChangeEvent();
            }
        }
    }

    public void sequenceHasChangedAfterSettingPainter() {
        if (this.hasCurrentSequence()) {
            Sequence currentSequence = this.getCurrentSequence();
            this.setTitle(this.getName() + " - " + currentSequence.getName());
            this.btFilter.setEnabled(true);
            this.btKeepMask.setEnabled(true);
            this.btAsROI.setEnabled(true);
            this.btCancelFilter.setEnabled(true);
        } else {
            this.setTitle(this.getName());
            this.btFilter.setEnabled(false);
            this.btKeepMask.setEnabled(false);
            this.btAsROI.setEnabled(false);
            this.btCancelFilter.setEnabled(false);
        }
    }

    public void sequenceHasChangedBeforeSettingPainter() {
    }

    public void sequenceWillChange() {
    }

    public void setDistance(ColorDistance distance) {
        this.distance = distance;
        this.colMaxDist = (int)Math.floor(distance.getMaxDistance());
        this.slMajTick = (int)Math.ceil((double)this.colMaxDist / 100.0) * 20;
        this.slMinTick = (int)Math.ceil((double)this.slMajTick / 5.0);
        this.colMaxDist = (int)Math.ceil((double)this.colMaxDist / (double)this.slMajTick) * this.slMajTick;
        this.colDefaultDist = (int)Math.ceil((double)this.colMaxDist / 10.0);
    }

    public Dimension getDefaultFrameDimension() {
        return null;
    }

    public void fillInterface(JPanel mainPanel) {
        ButtonGroup bgd = new ButtonGroup();
        this.rbL1 = new JRadioButton("L1");
        this.rbL1.addActionListener(this);
        bgd.add(this.rbL1);
        this.rbL2 = new JRadioButton("L2");
        this.rbL2.addActionListener(this);
        bgd.add(this.rbL2);
        this.rbL1.setSelected(true);
        this.setDistance((ColorDistance)new L1ColorDistance());
        this.slDistThreshold = new JSlider(0, 0, this.colMaxDist, this.colDefaultDist);
        this.slDistThreshold.addChangeListener(this);
        this.slDistThreshold.setMajorTickSpacing(this.slMajTick);
        this.slDistThreshold.setMinorTickSpacing(this.slMinTick);
        this.slDistThreshold.setPaintTicks(true);
        this.slDistThreshold.setPaintLabels(true);
        this.btPlus = new JButton(NherveToolbox.plusIcon);
        this.btPlus.addActionListener(this);
        this.btMinus = new JButton(NherveToolbox.minusIcon);
        this.btMinus.addActionListener(this);
        JPanel pmbt = GuiUtil.createPageBoxPanel((Component[])new Component[]{this.btPlus, this.btMinus});
        this.lbCurrent = new JLabel(Integer.toString(this.slDistThreshold.getValue()));
        JPanel boxDist = GuiUtil.createPageBoxPanel((Component[])new Component[]{GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createHorizontalGlue(), new JLabel("Distance"), Box.createHorizontalGlue()}), GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createHorizontalGlue(), this.rbL1, Box.createHorizontalGlue(), this.rbL2, Box.createHorizontalGlue()})});
        JPanel thresh = GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createHorizontalGlue(), boxDist, Box.createHorizontalGlue(), this.slDistThreshold, Box.createHorizontalGlue(), pmbt, Box.createHorizontalGlue(), this.lbCurrent, Box.createHorizontalGlue()});
        thresh.setBorder(new TitledBorder("Threshold"));
        this.m1ColorBox = new ColorBox("Choosen colors");
        this.m1ColorBox.setThreshold(this.colDefaultDist);
        JPanel box1 = GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createHorizontalGlue(), this.m1ColorBox, Box.createHorizontalGlue()});
        this.m2PosColorBox = new ColorBox("Positive");
        this.m2NegColorBox = new ColorBox("Negative");
        JPanel box2 = GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createHorizontalGlue(), this.m2PosColorBox, Box.createHorizontalGlue(), this.m2NegColorBox, Box.createHorizontalGlue()});
        ButtonGroup kern = new ButtonGroup();
        this.rbKernelLin = new JRadioButton(svm.kernel_type_table[0]);
        kern.add(this.rbKernelLin);
        this.rbKernelTri = new JRadioButton(svm.kernel_type_table[5]);
        kern.add(this.rbKernelTri);
        this.rbKernelRBF = new JRadioButton(svm.kernel_type_table[2]);
        kern.add(this.rbKernelRBF);
        this.rbKernelTri.setSelected(true);
        JPanel box3 = GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createHorizontalGlue(), this.rbKernelTri, this.rbKernelLin, this.rbKernelRBF, Box.createHorizontalGlue()});
        this.slC = new JSlider(0, -10, 10, 0);
        this.slC.setMajorTickSpacing(5);
        this.slC.setMinorTickSpacing(1);
        this.slC.setSnapToTicks(true);
        this.slC.setPaintTicks(true);
        this.slC.setPaintLabels(true);
        this.slC.addChangeListener(this);
        ComponentUtil.setFixedSize((Component)this.slC, (Dimension)new Dimension(275, 50));
        this.valC = new JLabel("C = " + Math.pow(2.0, this.slC.getValue()));
        JPanel box4 = GuiUtil.createLineBoxPanel((Component[])new Component[]{this.valC, Box.createHorizontalGlue(), this.slC});
        this.slGamma = new JSlider(0, -10, 10, 0);
        this.slGamma.setMajorTickSpacing(5);
        this.slGamma.setMinorTickSpacing(1);
        this.slGamma.setSnapToTicks(true);
        this.slGamma.setPaintTicks(true);
        this.slGamma.setPaintLabels(true);
        this.slGamma.addChangeListener(this);
        ComponentUtil.setFixedSize((Component)this.slGamma, (Dimension)new Dimension(275, 50));
        this.valGamma = new JLabel("gamma = " + Math.pow(2.0, this.slGamma.getValue()));
        JPanel box5 = GuiUtil.createLineBoxPanel((Component[])new Component[]{this.valGamma, Box.createHorizontalGlue(), this.slGamma});
        JPanel box6 = GuiUtil.createPageBoxPanel((Component[])new Component[]{box3, box4, box5});
        box6.setBorder(new TitledBorder("Kernel"));
        JPanel tabbed1 = GuiUtil.createPageBoxPanel((Component[])new Component[]{Box.createVerticalGlue(), box1, Box.createVerticalGlue(), thresh, Box.createVerticalGlue()});
        JPanel tabbed2 = GuiUtil.createPageBoxPanel((Component[])new Component[]{box2, box6});
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab(METHOD_1, tabbed1);
        this.tabbedPane.addTab(METHOD_2, tabbed2);
        ButtonGroup bgcs = new ButtonGroup();
        this.rbRGB = new JRadioButton("RGB");
        this.rbRGB.addActionListener(this);
        bgcs.add(this.rbRGB);
        this.rbRGB.setSelected(true);
        this.choosenCS = 0;
        this.rbHSV = new JRadioButton("HSV");
        this.rbHSV.addActionListener(this);
        bgcs.add(this.rbHSV);
        this.rbH1H2H3 = new JRadioButton("H1H2H3");
        this.rbH1H2H3.addActionListener(this);
        bgcs.add(this.rbH1H2H3);
        this.cbShow = new JCheckBox("Show");
        this.cbShow.setSelected(true);
        this.cbShow.addItemListener(this);
        this.cbAuto = new JCheckBox("Auto");
        this.cbAuto.addItemListener(this);
        this.btFilter = new JButton("Launch filtering");
        this.btFilter.addActionListener(this);
        this.btFilter.setEnabled(false);
        this.btCancelFilter = new JButton("Cancel filtering");
        this.btCancelFilter.addActionListener(this);
        this.btCancelFilter.setEnabled(false);
        this.btKeepMask = new JButton("As mask");
        this.btKeepMask.setEnabled(false);
        this.btKeepMask.addActionListener(this);
        this.btAsROI = new JButton("As ROI");
        this.btAsROI.setEnabled(false);
        this.btAsROI.addActionListener(this);
        JPanel buttons1 = GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createHorizontalGlue(), this.btFilter, this.btCancelFilter, this.btKeepMask, this.btAsROI, Box.createHorizontalGlue()});
        JPanel csp = GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createHorizontalGlue(), this.rbRGB, this.rbHSV, this.rbH1H2H3, this.cbShow, this.cbAuto, Box.createHorizontalGlue()});
        JPanel notTabbed = GuiUtil.createPageBoxPanel((Component[])new Component[]{csp, buttons1});
        mainPanel.add(this.tabbedPane);
        mainPanel.add(notTabbed);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider s = (JSlider)e.getSource();
        if (s == null) {
            return;
        }
        if (s == this.slDistThreshold) {
            this.lbCurrent.setText(Integer.toString(this.slDistThreshold.getValue()));
            this.m1ColorBox.setThreshold(this.slDistThreshold.getValue());
        }
        if (s == this.slC) {
            this.valC.setText("C = " + Math.pow(2.0, this.slC.getValue()));
            this.m2PosColorBox.fireFilterParametersChangeEvent();
        }
        if (s == this.slGamma) {
            this.valGamma.setText("gamma = " + Math.pow(2.0, this.slGamma.getValue()));
            this.m2PosColorBox.fireFilterParametersChangeEvent();
        }
    }

    public void stopInterface() {
    }

    class ColorPickerThresholdPainter
    implements Painter,
    ColorBoxListener {
        private Mask mask;
        private Sequence sequence;

        public ColorPickerThresholdPainter() {
            this.setMask(null);
            this.setSequence(null);
        }

        @Override
        public void cancelFilter() {
            this.setMask(null);
            this.displayParametersHaveChanged();
        }

        @Override
        public void displayParametersHaveChanged() {
            this.getSequence().painterChanged(null);
        }

        @Override
        public void filterParametersHaveChanged() {
            if (ColorPickerThreshold.this.cbAuto.isSelected()) {
                try {
                    ColorPickerThreshold.this.doFilter(this);
                }
                catch (SignatureException e1) {
                    Algorithm.err((Throwable)e1);
                }
            }
        }

        private int[] getClickedColor(Point pt) throws SignatureException {
            IcyBufferedImage image = ColorPickerThreshold.this.getCurrentSequence().getFirstImage();
            int[] c = null;
            if (image != null && image.isInside(pt)) {
                int x = (int)pt.getX();
                int y = (int)pt.getY();
                c = ColorSpaceTools.getColorComponentsI_0_255((IcyBufferedImage)image, (int)0, (int)x, (int)y);
            }
            return c;
        }

        public Mask getMask() {
            return this.mask;
        }

        public Sequence getSequence() {
            return this.sequence;
        }

        public void keyPressed(KeyEvent e, Point2D imagePoint, IcyCanvas canvas) {
        }

        public void keyReleased(KeyEvent e, Point2D imagePoint, IcyCanvas canvas) {
        }

        public void mouseClick(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
            int comp = ColorPickerThreshold.this.tabbedPane.getSelectedIndex();
            try {
                if (comp == 0) {
                    int[] c;
                    if (e.getButton() == 1 && (c = this.getClickedColor(TypeUtil.toPoint((Point2D)imagePoint))) != null) {
                        ColorPickerThreshold.this.m1ColorBox.addColor(c);
                    }
                } else if (comp == 1) {
                    int[] c;
                    if (e.getButton() == 1) {
                        int[] c2 = this.getClickedColor(TypeUtil.toPoint((Point2D)imagePoint));
                        if (c2 != null) {
                            ColorPickerThreshold.this.m2PosColorBox.addColor(c2);
                        }
                    } else if ((e.getButton() == 2 || e.getButton() == 3) && (c = this.getClickedColor(TypeUtil.toPoint((Point2D)imagePoint))) != null) {
                        ColorPickerThreshold.this.m2NegColorBox.addColor(c);
                    }
                }
            }
            catch (SignatureException ex) {
                Algorithm.err((Throwable)ex);
            }
        }

        public void mouseDrag(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
        }

        public void mouseMove(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
        }

        public void mousePressed(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
        }

        public void mouseReleased(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
        }

        public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
            if (this.getMask() != null && ColorPickerThreshold.this.cbShow.isSelected()) {
                this.getMask().paint(g);
            }
        }

        public void setMask(Mask mask) {
            this.mask = mask;
        }

        public void setSequence(Sequence sequence) {
            this.sequence = sequence;
        }
    }

    static interface ColorBoxListener {
        public void cancelFilter();

        public void displayParametersHaveChanged();

        public void filterParametersHaveChanged();
    }

    class ColorBox
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = -2779071071132708790L;
        private Color[] colors = new Color[24];
        private int nbColors;
        private int threshold;
        private ArrayList<ColorBoxListener> listeners = new ArrayList();
        private ColorSelector selector = new ColorSelector(this);
        private JButton btInitColors = new JButton("Clear");

        public ColorBox(String label) {
            this.btInitColors.setEnabled(false);
            this.btInitColors.addActionListener(this);
            JPanel p1 = GuiUtil.createLineBoxPanel((Component[])new Component[]{new JLabel(label), Box.createHorizontalGlue(), this.btInitColors});
            JPanel p2 = GuiUtil.createPageBoxPanel((Component[])new Component[]{this.selector, Box.createVerticalGlue(), p1});
            this.add(p2);
            this.initColors();
        }

        public void addColor(int[] c) {
            if (this.nbColors < 24) {
                this.colors[this.nbColors] = new Color(c[0], c[1], c[2]);
                ++this.nbColors;
                ColorPickerThreshold.this.btFilter.setEnabled(true);
                ColorPickerThreshold.this.btKeepMask.setEnabled(true);
                ColorPickerThreshold.this.btAsROI.setEnabled(true);
                this.btInitColors.setEnabled(true);
                this.repaint();
                this.fireFilterParametersChangeEvent();
            }
        }

        public Color getColor(int row, int col) {
            return this.colors[row * 8 + col];
        }

        public void fireCancelFilterEvent() {
            for (ColorBoxListener l : this.listeners) {
                l.cancelFilter();
            }
        }

        public void fireDisplayParametersChangeEvent() {
            for (ColorBoxListener l : this.listeners) {
                l.displayParametersHaveChanged();
            }
        }

        public void fireFilterParametersChangeEvent() {
            for (ColorBoxListener l : this.listeners) {
                l.filterParametersHaveChanged();
            }
        }

        public Color getAverageColor() {
            int r = 0;
            int g = 0;
            int b = 0;
            for (int k = 0; k < this.nbColors; ++k) {
                r += this.colors[k].getRed();
                g += this.colors[k].getGreen();
                b += this.colors[k].getBlue();
            }
            return new Color(r /= this.nbColors, g /= this.nbColors, b /= this.nbColors);
        }

        public int getThreshold() {
            return this.threshold;
        }

        public void initColors() {
            this.nbColors = 0;
            for (int i = 0; i < 24; ++i) {
                this.colors[i] = this.getBackground();
            }
            this.repaint();
            this.fireFilterParametersChangeEvent();
        }

        public void register(ColorBoxListener l) {
            this.listeners.add(l);
        }

        public void remove(ColorBoxListener l) {
            this.listeners.remove(l);
        }

        public void removeColor(int row, int col) {
            int idx;
            if (row < 3 && col < 8 && (idx = row * 8 + col) < this.nbColors) {
                for (int c = idx; c < this.nbColors && c < 23; ++c) {
                    this.colors[c] = this.colors[c + 1];
                }
                this.colors[this.nbColors - 1] = this.getBackground();
                --this.nbColors;
                if (this.nbColors == 0) {
                    this.btInitColors.setEnabled(false);
                }
                this.repaint();
                this.fireFilterParametersChangeEvent();
            }
        }

        public void setThreshold(int threshold) {
            this.threshold = threshold;
            this.fireFilterParametersChangeEvent();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object o = e.getSource();
            if (o == null) {
                return;
            }
            if (o instanceof JButton) {
                JButton b = (JButton)e.getSource();
                if (b == null) {
                    return;
                }
                if (b == this.btInitColors) {
                    this.initColors();
                    this.btInitColors.setEnabled(false);
                }
            }
        }

        private class ColorSelector
        extends JPanel
        implements MouseListener {
            private static final long serialVersionUID = 5232546251526771415L;
            private ColorBox box;

            public ColorSelector(ColorBox box) {
                this.box = box;
                this.addMouseListener(this);
                this.setOpaque(true);
            }

            @Override
            public Dimension getPreferredSize() {
                return COL_DIM;
            }

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getButton() == 1) {
                    int row = (int)Math.floor((double)me.getY() / 27.0);
                    int col = (int)Math.floor((double)me.getX() / 27.0);
                    this.box.removeColor(row, col);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void paintComponent(Graphics g) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                for (int row = 0; row < 3; ++row) {
                    int y = row * 28;
                    for (int column = 0; column < 8; ++column) {
                        int x = column * 28;
                        g.setColor(this.box.getColor(row, column));
                        g.fillRect(x, y, 25, 25);
                        g.setColor(Color.black);
                        g.drawRect(x, y, 25, 25);
                    }
                }
            }
        }
    }
}

