/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.particletracking;

import icy.util.StringUtil;
import icy.util.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.nchenouard.spot.DetectionResult;

public class MHTparameterSet {
    public DetectionResult detectionResults = null;
    public static final int defaultNumberOfFalseDetections = 20;
    public int numberOfFalseDetections = 20;
    public static final double defaultDetectionRate = 0.9;
    public double detectionRate = 0.9;
    public static final String ROOT_DETECTION_INPUT = "detectionInput";
    public static final String DETECTION_SOURCE = "detectionSource";
    public static final String NO_SOURCE = "noSource";
    public static final String FALSE_DETECTION = "numberFalseDetection";
    public static final String DETECTION_RATE = "detectionRate";
    public static final double defaultConfirmationThreshold = 0.5;
    public double confirmationThreshold = 0.5;
    public static final double defaultTerminationThreshold = 1.0E-4;
    public double terminationThreshold = 1.0E-4;
    public static final double defaultMeanTrackLength = 20.0;
    public double meanTrackLength = 20.0;
    public static final String ROOT_TARGET_EXISTENCE = "targetExistence";
    public static final String TRACK_LENGTH = "trackLength";
    public static final String CONFIRMATION_THRESHOLD = "confirmationThreshold";
    public static final String TERMINATION_THRESHOLD = "terminationThreshold";
    public static final boolean defaultIsSingleMotion = true;
    public boolean isSingleMotion = true;
    public static final double defaultDisplacementXY = 3.0;
    public double displacementXY = 3.0;
    public static final double defaultDisplacementZ = 3.0;
    public double displacementZ = 3.0;
    public static final boolean defaultIsUpdateMotion = false;
    public boolean isUpdateMotion = false;
    public static final boolean defaultIsDirectedMotion = false;
    public boolean isDirectedMotion = false;
    public static final double defaultDisplacementXY2 = 3.0;
    public double displacementXY2 = 3.0;
    public static final double defaultDisplacementZ2 = 3.0;
    public double displacementZ2 = 3.0;
    public static final boolean defaultIsUpdateMotion2 = false;
    public boolean isUpdateMotion2 = false;
    public static final boolean defaultIsDirectedMotion2 = true;
    public boolean isDirectedMotion2 = true;
    public static final boolean defaultUseMostLikelyModel = true;
    public boolean useMostLikelyModel = true;
    public static final double defaultIMMInertia = 0.8;
    public double immInertia = 0.8;
    public static final String ROOT_MOTION_MODEL = "motionModel";
    public static final String IS_SINGLE_MOTION = "isSingleMotion";
    public static final String IS_MOST_LIKELY_MODEL = "isMostLikelyModel";
    public static final String IMM_INERTIA = "IMMinertia";
    public static final String XYDISPLACEMENT_1 = "yxDisplacement_1";
    public static final String ZDISPLACEMENT_1 = "zDisplacement_1";
    public static final String IS_DIRECTED_MOTION_1 = "isDirectedMotion_1";
    public static final String IS_UPDATE_MOTION_1 = "updateMotion_1";
    public static final String XYDISPLACEMENT_2 = "yxDisplacement_2";
    public static final String ZDISPLACEMENT_2 = "zDisplacement_2";
    public static final String IS_DIRECTED_MOTION_2 = "isDirectedMotion_2";
    public static final String IS_UPDATE_MOTION_2 = "updateMotion_2";
    @Deprecated
    public static final String IS_UPDATE_COVARIANCE_2 = "updateCovariance_2";
    public static final double defaultGateFactor = 4.0;
    public double gateFactor = 4.0;
    public static final double defaultNumberInitialObjects = 20.0;
    public double numberInitialObjects = 20.0;
    public static final int defaultMHTDepth = 4;
    public int mhtDepth = 4;
    public static final double defaultNumberNewObjects = 10.0;
    public double numberNewObjects = 10.0;
    public static final String ROOT_MHT = "mht";
    public static final String NUMBER_NEW_OBJECTS = "numberNewObjects";
    public static final String NUMBER_OBJECTS_FIRST_FRAME = "numberObjectsFirstFrame";
    public static final String MHT_DEPTH = "mhtDepth";
    public static final String GATE_FACTOR = "gateFactor";
    public static final String ROOT_OUTPUT = "ouput";
    public static final String TRACK_GROUP_NAME = "trackGroupName";
    public String trackGroupName = "mht-tracks-1";
    public static final String defaultTrackGroupName = "mht-tracks-1";

    public static MHTparameterSet loadFromXML(Node node) {
        Element nodeOutput;
        Element nodeMHT;
        Element nodeMotion;
        Element nodeExistence;
        MHTparameterSet parameterSet = new MHTparameterSet();
        Element nodeDetection = XMLUtil.getElement((Node)node, (String)ROOT_DETECTION_INPUT);
        if (nodeDetection != null) {
            parameterSet.numberOfFalseDetections = XMLUtil.getAttributeIntValue((Element)nodeDetection, (String)FALSE_DETECTION, (int)20);
            parameterSet.detectionRate = XMLUtil.getAttributeDoubleValue((Element)nodeDetection, (String)DETECTION_RATE, (double)0.9);
        }
        if ((nodeExistence = XMLUtil.getElement((Node)node, (String)ROOT_TARGET_EXISTENCE)) != null) {
            parameterSet.meanTrackLength = XMLUtil.getAttributeDoubleValue((Element)nodeExistence, (String)TRACK_LENGTH, (double)20.0);
            parameterSet.confirmationThreshold = XMLUtil.getAttributeDoubleValue((Element)nodeExistence, (String)CONFIRMATION_THRESHOLD, (double)0.5);
            parameterSet.terminationThreshold = XMLUtil.getAttributeDoubleValue((Element)nodeExistence, (String)TERMINATION_THRESHOLD, (double)1.0E-4);
        }
        if ((nodeMotion = XMLUtil.getElement((Node)node, (String)ROOT_MOTION_MODEL)) != null) {
            parameterSet.isSingleMotion = XMLUtil.getAttributeBooleanValue((Element)nodeMotion, (String)IS_SINGLE_MOTION, (boolean)true);
            parameterSet.isDirectedMotion = XMLUtil.getAttributeBooleanValue((Element)nodeMotion, (String)IS_DIRECTED_MOTION_1, (boolean)false);
            parameterSet.displacementXY = XMLUtil.getAttributeDoubleValue((Element)nodeMotion, (String)XYDISPLACEMENT_1, (double)3.0);
            parameterSet.displacementZ = XMLUtil.getAttributeDoubleValue((Element)nodeMotion, (String)ZDISPLACEMENT_1, (double)3.0);
            parameterSet.isUpdateMotion = XMLUtil.getAttributeBooleanValue((Element)nodeMotion, (String)IS_UPDATE_MOTION_1, (boolean)false);
            if (!parameterSet.isSingleMotion) {
                parameterSet.isDirectedMotion2 = XMLUtil.getAttributeBooleanValue((Element)nodeMotion, (String)IS_DIRECTED_MOTION_2, (boolean)true);
                parameterSet.displacementXY2 = XMLUtil.getAttributeDoubleValue((Element)nodeMotion, (String)XYDISPLACEMENT_2, (double)3.0);
                parameterSet.displacementZ2 = XMLUtil.getAttributeDoubleValue((Element)nodeMotion, (String)ZDISPLACEMENT_2, (double)3.0);
                parameterSet.isUpdateMotion2 = XMLUtil.getAttributeBooleanValue((Element)nodeMotion, (String)IS_UPDATE_MOTION_2, (boolean)XMLUtil.getAttributeBooleanValue((Element)nodeMotion, (String)IS_UPDATE_COVARIANCE_2, (boolean)false));
                parameterSet.useMostLikelyModel = XMLUtil.getAttributeBooleanValue((Element)nodeMotion, (String)IS_MOST_LIKELY_MODEL, (boolean)true);
                parameterSet.immInertia = XMLUtil.getAttributeDoubleValue((Element)nodeMotion, (String)IMM_INERTIA, (double)0.8);
            }
        }
        if ((nodeMHT = XMLUtil.getElement((Node)node, (String)ROOT_MHT)) != null) {
            parameterSet.gateFactor = XMLUtil.getAttributeDoubleValue((Element)nodeMHT, (String)GATE_FACTOR, (double)4.0);
            parameterSet.numberNewObjects = XMLUtil.getAttributeDoubleValue((Element)nodeMHT, (String)NUMBER_NEW_OBJECTS, (double)10.0);
            parameterSet.numberInitialObjects = XMLUtil.getAttributeDoubleValue((Element)nodeMHT, (String)NUMBER_OBJECTS_FIRST_FRAME, (double)20.0);
            parameterSet.mhtDepth = XMLUtil.getAttributeIntValue((Element)nodeMHT, (String)MHT_DEPTH, (int)4);
        }
        if ((nodeOutput = XMLUtil.getElement((Node)node, (String)ROOT_OUTPUT)) != null) {
            parameterSet.trackGroupName = XMLUtil.getAttributeValue((Element)nodeOutput, (String)TRACK_GROUP_NAME, (String)defaultTrackGroupName);
        }
        return parameterSet;
    }

    public void saveToXML(Node configurationElement) {
        Element nodeOutput;
        Element nodeMHT;
        Element nodeMotionModel;
        Element nodeExistence;
        Element nodeDetection = XMLUtil.setElement((Node)configurationElement, (String)ROOT_DETECTION_INPUT);
        if (nodeDetection != null) {
            if (this.detectionResults != null) {
                XMLUtil.setAttributeValue((Element)nodeDetection, (String)DETECTION_SOURCE, (String)this.detectionResults.toString());
            } else {
                XMLUtil.setAttributeValue((Element)nodeDetection, (String)DETECTION_SOURCE, (String)NO_SOURCE);
            }
            XMLUtil.setAttributeIntValue((Element)nodeDetection, (String)FALSE_DETECTION, (int)this.numberOfFalseDetections);
            XMLUtil.setAttributeDoubleValue((Element)nodeDetection, (String)DETECTION_RATE, (double)this.detectionRate);
        }
        if ((nodeExistence = XMLUtil.setElement((Node)configurationElement, (String)ROOT_TARGET_EXISTENCE)) != null) {
            XMLUtil.setAttributeDoubleValue((Element)nodeExistence, (String)TRACK_LENGTH, (double)this.meanTrackLength);
            XMLUtil.setAttributeDoubleValue((Element)nodeExistence, (String)CONFIRMATION_THRESHOLD, (double)this.confirmationThreshold);
            XMLUtil.setAttributeDoubleValue((Element)nodeExistence, (String)TERMINATION_THRESHOLD, (double)this.terminationThreshold);
        }
        if ((nodeMotionModel = XMLUtil.setElement((Node)configurationElement, (String)ROOT_MOTION_MODEL)) != null) {
            XMLUtil.setAttributeBooleanValue((Element)nodeMotionModel, (String)IS_SINGLE_MOTION, (boolean)this.isSingleMotion);
            if (this.isSingleMotion) {
                XMLUtil.setAttributeBooleanValue((Element)nodeMotionModel, (String)IS_DIRECTED_MOTION_1, (boolean)this.isDirectedMotion);
                XMLUtil.setAttributeDoubleValue((Element)nodeMotionModel, (String)XYDISPLACEMENT_1, (double)this.displacementXY);
                XMLUtil.setAttributeDoubleValue((Element)nodeMotionModel, (String)ZDISPLACEMENT_1, (double)this.displacementZ);
                XMLUtil.setAttributeBooleanValue((Element)nodeMotionModel, (String)IS_UPDATE_MOTION_1, (boolean)this.isUpdateMotion);
            } else {
                XMLUtil.setAttributeBooleanValue((Element)nodeMotionModel, (String)IS_DIRECTED_MOTION_1, (boolean)this.isDirectedMotion);
                XMLUtil.setAttributeDoubleValue((Element)nodeMotionModel, (String)XYDISPLACEMENT_1, (double)this.displacementXY);
                XMLUtil.setAttributeDoubleValue((Element)nodeMotionModel, (String)ZDISPLACEMENT_1, (double)this.displacementZ);
                XMLUtil.setAttributeBooleanValue((Element)nodeMotionModel, (String)IS_UPDATE_MOTION_1, (boolean)this.isUpdateMotion);
                XMLUtil.setAttributeBooleanValue((Element)nodeMotionModel, (String)IS_DIRECTED_MOTION_2, (boolean)this.isDirectedMotion2);
                XMLUtil.setAttributeDoubleValue((Element)nodeMotionModel, (String)XYDISPLACEMENT_2, (double)this.displacementXY2);
                XMLUtil.setAttributeDoubleValue((Element)nodeMotionModel, (String)ZDISPLACEMENT_2, (double)this.displacementZ2);
                XMLUtil.setAttributeBooleanValue((Element)nodeMotionModel, (String)IS_UPDATE_MOTION_2, (boolean)this.isUpdateMotion2);
                XMLUtil.setAttributeBooleanValue((Element)nodeMotionModel, (String)IS_MOST_LIKELY_MODEL, (boolean)this.useMostLikelyModel);
                XMLUtil.setAttributeDoubleValue((Element)nodeMotionModel, (String)IMM_INERTIA, (double)this.immInertia);
            }
        }
        if ((nodeMHT = XMLUtil.setElement((Node)configurationElement, (String)ROOT_MHT)) != null) {
            XMLUtil.setAttributeDoubleValue((Element)nodeMHT, (String)NUMBER_NEW_OBJECTS, (double)this.numberNewObjects);
            XMLUtil.setAttributeDoubleValue((Element)nodeMHT, (String)NUMBER_OBJECTS_FIRST_FRAME, (double)this.numberInitialObjects);
            XMLUtil.setAttributeIntValue((Element)nodeMHT, (String)MHT_DEPTH, (int)this.mhtDepth);
            XMLUtil.setAttributeDoubleValue((Element)nodeMHT, (String)GATE_FACTOR, (double)this.gateFactor);
        }
        if ((nodeOutput = XMLUtil.setElement((Node)configurationElement, (String)ROOT_OUTPUT)) != null) {
            XMLUtil.setAttributeValue((Element)nodeOutput, (String)TRACK_GROUP_NAME, (String)this.trackGroupName);
        }
    }

    public String toString() {
        String result = this.isSingleMotion ? this.trackGroupName + " - Single motion [" + Boolean.toString(this.isDirectedMotion) + ";" + Boolean.toString(this.isUpdateMotion) + ";" + StringUtil.toString((double)this.displacementXY, (int)1) + ";" + StringUtil.toString((double)this.displacementZ, (int)1) + "]\n" : this.trackGroupName + " - Multi motion [" + Boolean.toString(this.isDirectedMotion) + ";" + Boolean.toString(this.isUpdateMotion) + ";" + StringUtil.toString((double)this.displacementXY, (int)1) + ";" + StringUtil.toString((double)this.displacementZ, (int)1) + "][" + Boolean.toString(this.isDirectedMotion2) + ";" + Boolean.toString(this.isUpdateMotion2) + ";" + StringUtil.toString((double)this.displacementXY2, (int)1) + ";" + StringUtil.toString((double)this.displacementZ2, (int)1) + "][" + Boolean.toString(this.useMostLikelyModel) + ";" + StringUtil.toString((double)this.immInertia, (int)2) + "]\n";
        result = result + "(" + StringUtil.toString((double)this.gateFactor, (int)1) + ";" + StringUtil.toString((int)this.mhtDepth) + ";" + StringUtil.toString((double)this.numberInitialObjects, (int)1) + ";" + StringUtil.toString((double)this.numberNewObjects, (int)1) + ";" + StringUtil.toString((double)this.confirmationThreshold, (int)1) + ";" + StringUtil.toString((double)this.terminationThreshold, (int)1) + ";" + StringUtil.toString((double)this.meanTrackLength, (int)1) + ")";
        return result;
    }
}

