/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.particletracking;

import icy.gui.frame.progress.CancelableProgressFrame;
import icy.main.Icy;
import icy.util.XMLUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.fab.trackmanager.TrackGroup;
import plugins.fab.trackmanager.TrackSegment;
import plugins.nchenouard.particletracking.MHTparameterSet;
import plugins.nchenouard.particletracking.MHTracker.HMMMHTracker;
import plugins.nchenouard.particletracking.SpotTrackingPlugin;
import plugins.nchenouard.particletracking.filtering.IMM2D;
import plugins.nchenouard.particletracking.filtering.IMM3D;
import plugins.nchenouard.particletracking.filtering.KF2dDirected;
import plugins.nchenouard.particletracking.filtering.KF2dRandomWalk;
import plugins.nchenouard.particletracking.filtering.KF3dDirected;
import plugins.nchenouard.particletracking.filtering.KF3dRandomWalk;
import plugins.nchenouard.particletracking.filtering.KalmanFilter;
import plugins.nchenouard.particletracking.filtering.Predictor;
import plugins.nchenouard.particletracking.filtering.Predictor2D;
import plugins.nchenouard.particletracking.filtering.Predictor3D;
import plugins.nchenouard.particletracking.legacytracker.associationMethod.InstantaneousTracker;
import plugins.nchenouard.particletracking.legacytracker.associationMethod.SolveMLAssociation;
import plugins.nchenouard.particletracking.legacytracker.associationMethod.Track;
import plugins.nchenouard.spot.DetectionResult;
import plugins.nchenouard.spot.Spot;

public class SpotTracking {
    public static String ID_CONFIG = "MHTconfiguration";

    static synchronized boolean loadOptimizationLibray() {
        if (SpotTrackingPlugin.optimizationLibraryLoaded) {
            return true;
        }
        new SpotTrackingPlugin();
        return SpotTrackingPlugin.optimizationLibraryLoaded;
    }

    public static MHTparameterSet estimateParameters(DetectionResult detections, boolean directedMotion, boolean singleMotion, boolean updateMotion) {
        MHTparameterSet parameters = new MHTparameterSet();
        SpotTracking.estimateParameters(parameters, detections, directedMotion, singleMotion, updateMotion);
        return parameters;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean estimateParameters(MHTparameterSet parameters, DetectionResult detections, boolean directedMotion, boolean singleMotion, boolean updateMotion) {
        void var30_48;
        void var27_40;
        void var26_37;
        ArrayList<Predictor2D> predictors;
        parameters.isDirectedMotion = directedMotion;
        parameters.isSingleMotion = singleMotion;
        parameters.isUpdateMotion = updateMotion;
        if (detections == null) {
            return false;
        }
        parameters.detectionResults = detections;
        int maxNumDetections = 10000;
        int numDetections = 0;
        int numT = 0;
        for (int t = parameters.detectionResults.getFirstFrameTime(); t < parameters.detectionResults.getLastFrameTime(); ++t) {
            ++numT;
            if ((numDetections += parameters.detectionResults.getDetectionsAtT(t).size()) > 10000) break;
        }
        double[] distTabXY = new double[numDetections];
        double[] distTabZ = new double[numDetections];
        int cntDist = 0;
        for (int t = parameters.detectionResults.getFirstFrameTime(); t < parameters.detectionResults.getFirstFrameTime() + numT; ++t) {
            Vector dList1 = parameters.detectionResults.getDetectionsAtT(t);
            Vector dList2 = parameters.detectionResults.getDetectionsAtT(t + 1);
            if (dList1.isEmpty() || dList2.isEmpty()) continue;
            for (Spot s1 : dList1) {
                double minDist = Double.MAX_VALUE;
                Spot minSpot = null;
                for (Spot s2 : dList2) {
                    double d = SpotTracking.squaredDistance(s1, s2);
                    if (!(d < minDist)) continue;
                    minDist = d;
                    minSpot = s2;
                }
                if (!(minDist < Double.MAX_VALUE) || minSpot == null) continue;
                distTabXY[cntDist] = (s1.mass_center.x - minSpot.mass_center.x) * (s1.mass_center.x - minSpot.mass_center.x) + (s1.mass_center.y - minSpot.mass_center.y) * (s1.mass_center.y - minSpot.mass_center.y);
                int n = cntDist++;
                distTabZ[n] = distTabZ[n] + (s1.mass_center.z - minSpot.mass_center.z) * (s1.mass_center.z - minSpot.mass_center.z);
            }
        }
        Arrays.sort(distTabXY);
        Arrays.sort(distTabZ);
        double varDiffXY = distTabXY[(int)((double)distTabXY.length * 0.45)];
        double varDiffZ = distTabZ[(int)((double)distTabXY.length * 0.45)];
        int maxConsecutivePred = 1;
        int gateFactor = 3;
        boolean gateLikelihood = true;
        Predictor predictor = null;
        if (singleMotion) {
            if (varDiffZ > 0.0) {
                predictor = directedMotion ? new KF3dDirected() : new KF3dRandomWalk();
                predictor.setTrackingCovariances(new double[]{varDiffXY, varDiffXY, varDiffZ});
            } else {
                predictor = directedMotion ? new KF2dDirected() : new KF2dRandomWalk();
                predictor.setTrackingCovariances(new double[]{varDiffXY, varDiffXY});
            }
        } else if (varDiffZ > 0.0) {
            predictors = new ArrayList<Predictor2D>();
            predictors.add((Predictor2D)((Object)new KF3dRandomWalk()));
            predictors.add((Predictor2D)((Object)new KF3dDirected()));
            ((Predictor3D)predictors.get(0)).setTrackingCovariances(new double[]{varDiffXY, varDiffXY, varDiffZ});
            ((Predictor3D)predictors.get(1)).setTrackingCovariances(new double[]{varDiffXY, varDiffXY, varDiffZ});
            predictor = parameters.useMostLikelyModel ? new IMM3D(IMM3D.LikelihoodTypes.IMM_MAX_LIKELIHOOD, parameters.immInertia, predictors) : new IMM3D(IMM3D.LikelihoodTypes.IMM_WEIGHTED_LIKELIHOOD, parameters.immInertia, predictors);
        } else {
            predictors = new ArrayList();
            predictors.add(new KF2dRandomWalk());
            predictors.add(new KF2dDirected());
            ((Predictor2D)predictors.get(0)).setTrackingCovariances(new double[]{varDiffXY, varDiffXY});
            ((Predictor2D)predictors.get(1)).setTrackingCovariances(new double[]{varDiffXY, varDiffXY});
            predictor = parameters.useMostLikelyModel ? new IMM2D(IMM2D.LikelihoodTypes.IMM_MAX_LIKELIHOOD, parameters.immInertia, predictors) : new IMM2D(IMM2D.LikelihoodTypes.IMM_WEIGHTED_LIKELIHOOD, parameters.immInertia, predictors);
        }
        SolveMLAssociation assignementSolver = new SolveMLAssociation(true);
        InstantaneousTracker tracker = new InstantaneousTracker(assignementSolver, predictor, gateLikelihood, gateFactor, maxConsecutivePred);
        for (int tt = parameters.detectionResults.getFirstFrameTime(); tt < parameters.detectionResults.getLastFrameTime(); ++tt) {
            tracker.track(tt, parameters.detectionResults.getDetectionsAtT(tt));
        }
        ArrayList<Track> tracks = tracker.getTracks();
        ArrayList<Track> trueTracks = new ArrayList<Track>();
        ArrayList<Track> falseTracks = new ArrayList<Track>();
        for (Track track : tracks) {
            if (track.getLastIndex() - track.getFirstIndex() > 2) {
                trueTracks.add(track);
                continue;
            }
            falseTracks.add(track);
        }
        if (trueTracks.isEmpty()) {
            return false;
        }
        int sumTrackLength = 0;
        for (Track track : trueTracks) {
            sumTrackLength += track.getLastIndex() - track.getFirstIndex() + 1;
        }
        parameters.meanTrackLength = sumTrackLength / trueTracks.size();
        boolean bl = false;
        boolean bl2 = false;
        for (Object tr : trueTracks) {
            if (((Track)tr).getFirstIndex() == 0) {
                ++var26_37;
                continue;
            }
            ++var27_40;
        }
        parameters.numberInitialObjects = (double)var26_37;
        parameters.numberNewObjects = (double)var27_40 / (1.0 + (double)parameters.detectionResults.getLastFrameTime() - (double)parameters.detectionResults.getFirstFrameTime());
        int numFalseDetections = 0;
        for (Track track : falseTracks) {
            for (int tt = track.getFirstIndex(); tt < track.getLastIndex() + 1; ++tt) {
                if (!track.isPredictionAtFrame(tt)) continue;
                ++numFalseDetections;
            }
        }
        parameters.numberOfFalseDetections = (int)Math.round((double)numFalseDetections / (1.0 + (double)parameters.detectionResults.getLastFrameTime() - (double)parameters.detectionResults.getFirstFrameTime()));
        double sumDistSq = 0.0;
        double sumDistSqZ = 0.0;
        int numDist = 0;
        for (Track track : trueTracks) {
            for (int f = track.getFirstIndex(); f < track.getLastIndex(); ++f) {
                if (track.isPredictionAtFrame(f) || track.isPredictionAtFrame(f + 1)) continue;
                Spot s1 = track.getSpotAtFrame(f);
                Spot s2 = track.getSpotAtFrame(f + 1);
                sumDistSq += (s1.mass_center.x - s2.mass_center.x) * (s1.mass_center.x - s2.mass_center.x) + (s1.mass_center.y - s2.mass_center.y) * (s1.mass_center.y - s2.mass_center.y);
                sumDistSqZ += (s1.mass_center.z - s2.mass_center.z) * (s1.mass_center.z - s2.mass_center.z);
                if (++numDist > 10000) break;
            }
            if (numDist <= 10000) continue;
            break;
        }
        parameters.displacementXY = Math.sqrt(sumDistSq / (double)numDist);
        parameters.displacementZ = Math.sqrt(sumDistSqZ / (double)numDist);
        int numTrueDetections = 0;
        boolean bl3 = false;
        for (Track track : trueTracks) {
            for (int f = track.getFirstIndex(); f < track.getLastIndex(); ++f) {
                if (track.isPredictionAtFrame(f)) {
                    ++var30_48;
                    continue;
                }
                ++numTrueDetections;
            }
        }
        parameters.detectionRate = (double)numTrueDetections / ((double)numTrueDetections + (double)var30_48);
        return true;
    }

    public static MHTparameterSet loadParameters(File file) {
        Document document = XMLUtil.loadDocument((File)file);
        Element root = XMLUtil.getRootElement((Document)document);
        if (root == null) {
            throw new IllegalArgumentException("can't find: <root> tag.");
        }
        Element configurationElement = (Element)XMLUtil.getElements((Node)root, (String)ID_CONFIG).get(0);
        if (configurationElement == null) {
            throw new IllegalArgumentException("can't find: <root><" + ID_CONFIG + "> tag.");
        }
        return MHTparameterSet.loadFromXML(configurationElement);
    }

    public static MHTparameterSet loadParameters(String path) {
        return SpotTracking.loadParameters(new File(path));
    }

    public static void saveParameters(MHTparameterSet value, File f) {
        SpotTracking.saveParameters(value, f.getAbsolutePath());
    }

    public static void saveParameters(MHTparameterSet parameters, String path) {
        Document document = XMLUtil.createDocument((boolean)true);
        Element root = XMLUtil.getRootElement((Document)document);
        Element configurationElement = XMLUtil.setElement((Node)root, (String)ID_CONFIG);
        if (parameters != null) {
            parameters.saveToXML(configurationElement);
        }
        XMLUtil.saveDocument((Document)document, (String)path);
    }

    public static TrackGroup executeTracking(MHTparameterSet parameters, DetectionResult dr, boolean useLPSolver, boolean multiThread, boolean showProgress) throws IllegalArgumentException {
        CancelableProgressFrame progress;
        if (dr == null) {
            throw new IllegalArgumentException("Tracking requires to specify a set of detections. You can use the Spot Detector plugin to create some.");
        }
        if (dr.getNumberOfDetection() < 1) {
            throw new IllegalArgumentException("A non empty set of detections needs to process the tracking.");
        }
        SpotTracking.loadOptimizationLibray();
        HMMMHTracker mhtracker = SpotTracking.buildTracker(parameters, dr, useLPSolver, multiThread);
        if (showProgress) {
            progress = new CancelableProgressFrame("Processing...");
            progress.setLength((double)dr.getLastFrameTime());
        } else {
            progress = null;
        }
        boolean headless = Icy.getMainInterface().isHeadLess();
        for (int t = dr.getFirstFrameTime(); t <= dr.getLastFrameTime(); ++t) {
            if (headless) {
                System.out.print("Track extraction at frame " + t + "\r");
            }
            if (progress != null) {
                progress.setMessage("Track extraction at frame " + t);
                progress.setPosition((double)t);
                if (progress.isCancelRequested()) break;
            }
            mhtracker.track(t, dr.getDetectionsAtT(t));
        }
        if (headless) {
            System.out.println();
        }
        if (progress != null) {
            progress.close();
        }
        ArrayList<TrackSegment> tracks = mhtracker.getCompleteTracks();
        TrackGroup result = new TrackGroup(dr.getSequence());
        result.setDescription(parameters.trackGroupName);
        for (TrackSegment ts : tracks) {
            result.addTrackSegment(ts);
        }
        return result;
    }

    public static TrackGroup executeTracking(MHTparameterSet parameters, DetectionResult dr, boolean showProgress) throws IllegalArgumentException {
        return SpotTracking.executeTracking(parameters, dr, true, true, showProgress);
    }

    protected static HMMMHTracker buildTracker(MHTparameterSet parameters, DetectionResult dr, int dim, double volume, boolean useLPSolve, boolean multithreaded) throws IllegalArgumentException {
        double[] trackingCovariances;
        Enum predictorType;
        double probaDetect = parameters.detectionRate;
        if (probaDetect < 0.0 || probaDetect > 1.0) {
            throw new IllegalArgumentException("The probability of detection for each particle has to lie between 0 and 1");
        }
        double densityFalseDetection = (double)parameters.numberOfFalseDetections / volume;
        if (densityFalseDetection < 0.0) {
            throw new IllegalArgumentException("The expected number of false detections needs to be a positive number");
        }
        double gateFactor = parameters.gateFactor;
        if (gateFactor <= 0.0) {
            throw new IllegalArgumentException("The gate factor needs to be a positive number");
        }
        double densityInitialTrack = parameters.numberInitialObjects / volume;
        if (densityInitialTrack < 0.0) {
            throw new IllegalArgumentException("The expected number of initial needs to be a positive number");
        }
        double densityNewTrack = parameters.numberNewObjects / volume;
        if (densityNewTrack < 0.0) {
            throw new IllegalArgumentException("The expected number of new tracks per frame needs to be a positive number");
        }
        int treeDepth = parameters.mhtDepth;
        if (treeDepth < 1) {
            throw new IllegalArgumentException("The tree depth needs to be an integer greater or equal to 1");
        }
        Predictor pred = null;
        if (parameters.isSingleMotion) {
            if (parameters.isDirectedMotion) {
                if (dim == 3) {
                    double[] trackingCovariances2 = new double[]{parameters.displacementXY, parameters.displacementXY, parameters.displacementZ};
                    if (trackingCovariances2[0] < 0.0 || trackingCovariances2[1] < 0.0 || trackingCovariances2[2] < 0.0) {
                        throw new IllegalArgumentException("The expected particle displacement has to be a positive number.");
                    }
                    KF3dDirected predictor = new KF3dDirected();
                    predictor.setTrackingCovariances(trackingCovariances2);
                    predictor.setUpdateCovariances(parameters.isUpdateMotion);
                    pred = predictor;
                } else {
                    double[] trackingCovariances3 = new double[]{parameters.displacementXY, parameters.displacementXY};
                    if (trackingCovariances3[0] < 0.0 || trackingCovariances3[1] < 0.0) {
                        throw new IllegalArgumentException("The expected particle displacement has to be a positive number.");
                    }
                    KF2dDirected predictor = new KF2dDirected();
                    predictor.setTrackingCovariances(trackingCovariances3);
                    predictor.setUpdateCovariances(parameters.isUpdateMotion);
                    pred = predictor;
                }
            } else if (dim == 3) {
                double[] trackingCovariances4 = new double[3];
                double displacementXY = parameters.displacementXY;
                double displacementZ = parameters.displacementZ;
                trackingCovariances4[0] = displacementXY * displacementXY / 2.0;
                trackingCovariances4[1] = displacementXY * displacementXY / 2.0;
                trackingCovariances4[2] = displacementZ * displacementZ;
                if (trackingCovariances4[0] < 0.0 || trackingCovariances4[1] < 0.0 || trackingCovariances4[2] < 0.0) {
                    throw new IllegalArgumentException("The expected particle displacement has to be a positive number");
                }
                KF3dRandomWalk predictor = new KF3dRandomWalk();
                predictor.setTrackingCovariances(trackingCovariances4);
                predictor.setUpdateCovariances(parameters.isUpdateMotion);
                pred = predictor;
            } else {
                double[] trackingCovariances5 = new double[2];
                double displacementXY = parameters.displacementXY;
                trackingCovariances5[0] = displacementXY * displacementXY / 2.0;
                trackingCovariances5[1] = displacementXY * displacementXY / 2.0;
                if (trackingCovariances5[0] < 0.0 || trackingCovariances5[1] < 0.0) {
                    throw new IllegalArgumentException("The expected particle displacement has to be a positive number");
                }
                KF2dRandomWalk predictor = new KF2dRandomWalk();
                predictor.setTrackingCovariances(trackingCovariances5);
                predictor.setUpdateCovariances(parameters.isUpdateMotion);
                pred = predictor;
            }
        } else if (dim == 3) {
            KalmanFilter predictor;
            double displacementZ;
            double displacementXY;
            double immInertia = parameters.immInertia;
            if (immInertia < 0.0 || immInertia > 1.0) {
                throw new IllegalArgumentException("The inertia for model switching must be a number lying between 0 and 1.");
            }
            predictorType = parameters.useMostLikelyModel ? IMM3D.LikelihoodTypes.IMM_MAX_LIKELIHOOD : IMM3D.LikelihoodTypes.IMM_WEIGHTED_LIKELIHOOD;
            ArrayList<Predictor3D> p3DList = new ArrayList<Predictor3D>();
            if (parameters.isDirectedMotion) {
                trackingCovariances = new double[3];
                displacementXY = parameters.displacementXY;
                displacementZ = parameters.displacementZ;
                trackingCovariances[0] = displacementXY * displacementXY / 2.0;
                trackingCovariances[1] = displacementXY * displacementXY / 2.0;
                trackingCovariances[2] = displacementZ * displacementZ;
                if (trackingCovariances[0] < 0.0 || trackingCovariances[1] < 0.0 || trackingCovariances[2] < 0.0) {
                    throw new IllegalArgumentException("The expected particle displacement has to be a positive number.");
                }
                predictor = new KF3dDirected();
                ((KF3dDirected)predictor).setTrackingCovariances(trackingCovariances);
                predictor.setUpdateCovariances(parameters.isUpdateMotion);
                p3DList.add((Predictor3D)((Object)predictor));
            } else {
                trackingCovariances = new double[3];
                displacementXY = parameters.displacementXY;
                displacementZ = parameters.displacementZ;
                trackingCovariances[0] = displacementXY * displacementXY / 2.0;
                trackingCovariances[1] = displacementXY * displacementXY / 2.0;
                trackingCovariances[2] = displacementZ * displacementZ;
                if (trackingCovariances[0] < 0.0 || trackingCovariances[1] < 0.0 || trackingCovariances[2] < 0.0) {
                    throw new IllegalArgumentException("The expected particle displacement has to be a positive number");
                }
                predictor = new KF3dRandomWalk();
                ((KF3dRandomWalk)predictor).setTrackingCovariances(trackingCovariances);
                predictor.setUpdateCovariances(parameters.isUpdateMotion);
                p3DList.add((Predictor3D)((Object)predictor));
            }
            if (parameters.isDirectedMotion2) {
                trackingCovariances = new double[3];
                displacementXY = parameters.displacementXY2;
                displacementZ = parameters.displacementZ2;
                trackingCovariances[0] = displacementXY * displacementXY / 2.0;
                trackingCovariances[1] = displacementXY * displacementXY / 2.0;
                trackingCovariances[2] = displacementZ * displacementZ;
                if (trackingCovariances[0] < 0.0 || trackingCovariances[1] < 0.0 || trackingCovariances[2] < 0.0) {
                    throw new IllegalArgumentException("The expected particle displacement has to be a positive number.");
                }
                predictor = new KF3dDirected();
                ((KF3dDirected)predictor).setTrackingCovariances(trackingCovariances);
                predictor.setUpdateCovariances(parameters.isUpdateMotion2);
                p3DList.add((Predictor3D)((Object)predictor));
            } else {
                trackingCovariances = new double[3];
                displacementXY = parameters.displacementXY2;
                displacementZ = parameters.displacementZ2;
                trackingCovariances[0] = displacementXY * displacementXY / 2.0;
                trackingCovariances[1] = displacementXY * displacementXY / 2.0;
                trackingCovariances[2] = displacementZ * displacementZ;
                if (trackingCovariances[0] < 0.0 || trackingCovariances[1] < 0.0 || trackingCovariances[2] < 0.0) {
                    throw new IllegalArgumentException("The expected particle displacement has to be a positive number");
                }
                predictor = new KF3dRandomWalk();
                ((KF3dRandomWalk)predictor).setTrackingCovariances(trackingCovariances);
                predictor.setUpdateCovariances(parameters.isUpdateMotion2);
                p3DList.add((Predictor3D)((Object)predictor));
            }
            pred = new IMM3D((IMM3D.LikelihoodTypes)predictorType, immInertia, p3DList);
        } else {
            KalmanFilter predictor;
            double displacementXY;
            double immInertia = parameters.immInertia;
            if (immInertia < 0.0 || immInertia > 1.0) {
                throw new IllegalArgumentException("The inertia for model switching must be a number lying between 0 and 1.");
            }
            predictorType = parameters.useMostLikelyModel ? IMM2D.LikelihoodTypes.IMM_MAX_LIKELIHOOD : IMM2D.LikelihoodTypes.IMM_WEIGHTED_LIKELIHOOD;
            ArrayList<Predictor2D> p2DList = new ArrayList<Predictor2D>();
            if (parameters.isDirectedMotion) {
                trackingCovariances = new double[2];
                displacementXY = parameters.displacementXY;
                trackingCovariances[0] = displacementXY * displacementXY / 2.0;
                trackingCovariances[1] = displacementXY * displacementXY / 2.0;
                if (trackingCovariances[0] < 0.0 || trackingCovariances[1] < 0.0) {
                    throw new IllegalArgumentException("The expected particle displacement has to be a positive number");
                }
                predictor = new KF2dDirected();
                ((KF2dDirected)predictor).setTrackingCovariances(trackingCovariances);
                predictor.setUpdateCovariances(parameters.isUpdateMotion);
                p2DList.add((Predictor2D)((Object)predictor));
            } else {
                trackingCovariances = new double[2];
                displacementXY = parameters.displacementXY;
                trackingCovariances[0] = displacementXY * displacementXY / 2.0;
                trackingCovariances[1] = displacementXY * displacementXY / 2.0;
                if (trackingCovariances[0] < 0.0 || trackingCovariances[1] < 0.0) {
                    throw new IllegalArgumentException("The expected particle displacement has to be a positive number");
                }
                predictor = new KF2dRandomWalk();
                ((KF2dRandomWalk)predictor).setTrackingCovariances(trackingCovariances);
                predictor.setUpdateCovariances(parameters.isUpdateMotion);
                p2DList.add((Predictor2D)((Object)predictor));
            }
            if (parameters.isDirectedMotion2) {
                trackingCovariances = new double[2];
                displacementXY = parameters.displacementXY2;
                trackingCovariances[0] = displacementXY * displacementXY / 2.0;
                trackingCovariances[1] = displacementXY * displacementXY / 2.0;
                if (trackingCovariances[0] < 0.0 || trackingCovariances[1] < 0.0) {
                    throw new IllegalArgumentException("The expected particle displacement has to be a positive number");
                }
                predictor = new KF2dDirected();
                ((KF2dDirected)predictor).setTrackingCovariances(trackingCovariances);
                predictor.setUpdateCovariances(parameters.isUpdateMotion2);
                p2DList.add((Predictor2D)((Object)predictor));
            } else {
                trackingCovariances = new double[2];
                displacementXY = parameters.displacementXY2;
                trackingCovariances[0] = displacementXY * displacementXY / 2.0;
                trackingCovariances[1] = displacementXY * displacementXY / 2.0;
                if (trackingCovariances[0] < 0.0 || trackingCovariances[1] < 0.0) {
                    throw new IllegalArgumentException("The expected particle displacement has to be a positive number");
                }
                predictor = new KF2dRandomWalk();
                ((KF2dRandomWalk)predictor).setTrackingCovariances(trackingCovariances);
                predictor.setUpdateCovariances(parameters.isUpdateMotion2);
                p2DList.add((Predictor2D)((Object)predictor));
            }
            pred = new IMM2D((IMM2D.LikelihoodTypes)predictorType, immInertia, p2DList);
        }
        ArrayList<Predictor> predictors = new ArrayList<Predictor>();
        predictors.add(pred);
        HMMMHTracker tracker = new HMMMHTracker(predictors, volume, gateFactor, probaDetect, densityFalseDetection, densityInitialTrack, densityNewTrack, treeDepth, dim, multithreaded, useLPSolve);
        double meanTrackLength = parameters.meanTrackLength;
        double pc = parameters.confirmationThreshold;
        double pt = parameters.terminationThreshold;
        if (meanTrackLength <= 0.0) {
            throw new IllegalArgumentException("The expected track length must be a positive number.");
        }
        if (pc < 0.0 || pc > 1.0) {
            throw new IllegalArgumentException("The confirmation probability threshold must be a number lying between 0 and 1.");
        }
        if (pt < 0.0 || pt > 1.0) {
            throw new IllegalArgumentException("The termination probability threshold must be a number lying between 0 and 1.");
        }
        tracker.changeExistenceSettings(1.0 / meanTrackLength, pc, pt);
        return tracker;
    }

    public static HMMMHTracker buildTracker(MHTparameterSet parameters, DetectionResult dr, boolean useLPSolver, boolean multiThread) throws IllegalArgumentException {
        int dim = 2;
        double volume = 65536.0;
        if (dr.getSequence() != null) {
            if (dr.getSequence().getSizeZ() > 1) {
                dim = 3;
            }
            volume = dr.getSequence().getSizeX() * dr.getSequence().getSizeY() * dr.getSequence().getSizeZ();
        } else {
            double minX = 0.0;
            double minY = 0.0;
            double minZ = 0.0;
            double maxX = 0.0;
            double maxY = 0.0;
            double maxZ = 0.0;
            for (int t = dr.getFirstFrameTime(); t <= dr.getLastFrameTime(); ++t) {
                for (Spot s : dr.getDetectionsAtT(t)) {
                    minX = Math.min(minX, s.mass_center.x);
                    minY = Math.min(minY, s.mass_center.y);
                    minZ = Math.min(minZ, s.mass_center.z);
                    maxX = Math.max(maxX, s.mass_center.x);
                    maxY = Math.max(maxY, s.mass_center.y);
                    maxZ = Math.max(maxZ, s.mass_center.z);
                }
            }
            if (maxZ > minZ) {
                dim = 3;
                volume = (maxX - minX + 1.0) * (maxY - minY + 1.0) * (maxZ - minZ + 1.0);
            } else {
                dim = 2;
                volume = (maxX - minX + 1.0) * (maxY - minY + 1.0);
            }
        }
        return SpotTracking.buildTracker(parameters, dr, dim, volume, SpotTrackingPlugin.optimizationLibraryLoaded && useLPSolver, multiThread);
    }

    public static HMMMHTracker buildTracker(MHTparameterSet parameters, DetectionResult dr) throws IllegalArgumentException {
        return SpotTracking.buildTracker(parameters, dr, true, true);
    }

    static double squaredDistance(Spot s1, Spot s2) {
        return (s1.mass_center.x - s2.mass_center.x) * (s1.mass_center.x - s2.mass_center.x) + (s1.mass_center.y - s2.mass_center.y) * (s1.mass_center.y - s2.mass_center.y) + (s1.mass_center.z - s2.mass_center.z) * (s1.mass_center.z - s2.mass_center.z);
    }
}

