/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.particletracking.simplifiedMHT;

import icy.gui.frame.progress.AnnounceFrame;
import icy.main.Icy;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLauncher;
import icy.plugin.PluginLoader;
import icy.swimmingPool.SwimmingObject;
import icy.swimmingPool.SwimmingPoolEvent;
import icy.swimmingPool.SwimmingPoolEventType;
import icy.swimmingPool.SwimmingPoolListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import plugins.fab.spotDetector.SpotDetector;
import plugins.fab.trackmanager.TrackGroup;
import plugins.nchenouard.particletracking.DetectionChooser;
import plugins.nchenouard.particletracking.MHTparameterSet;
import plugins.nchenouard.spot.DetectionResult;

public class SimplifiedMHTPanel
extends JPanel {
    private static final long serialVersionUID = 7516111529309828176L;
    public DetectionChooser detectionChooser;
    JEditorPane detectionDescriptionPanel;
    JLabel detectionIcon;
    JEditorPane parametersDescriptionPanel;
    public JButton estimateParametersButton;
    public JButton loadParametersButton;
    JLabel parametersIcon;
    AnnounceFrame defaultParametersAnnouce = null;
    boolean usingDefaultParameters = true;
    JEditorPane outputDescriptionPanel;
    JLabel outputIcon;
    public JTextField trackGroupNameTF;
    AnnounceFrame outputAnnouce = null;
    JLabel runIncon;
    public JButton runTrackingButton;
    JEditorPane runDescriptionPanel;
    boolean areDetectionSettingsOk = false;
    boolean areTrackingSettingsOk = false;
    boolean areOutputSettingsOk = false;
    public MHTparameterSet mhtParameterSet = null;
    SpotDetector s;

    public SimplifiedMHTPanel() {
        this(null, null, null, null);
    }

    public SimplifiedMHTPanel(ImageIcon detectionIconImage, ImageIcon parametersIconImage, ImageIcon outputIconImage, ImageIcon runIconImage) {
        this.setLayout(new GridBagLayout());
        int h = 0;
        if (detectionIconImage != null) {
            h += detectionIconImage.getIconHeight();
        }
        if (parametersIconImage != null) {
            h += parametersIconImage.getIconHeight();
        }
        if (outputIconImage != null) {
            h += outputIconImage.getIconHeight();
        }
        if (runIconImage != null) {
            h += runIconImage.getIconHeight();
        }
        if (h > 0) {
            this.setPreferredSize(new Dimension(400, h + 70));
        } else {
            this.setPreferredSize(new Dimension(400, 450));
        }
        GridBagConstraints gcMain = new GridBagConstraints();
        gcMain.fill = 1;
        gcMain.gridwidth = 1;
        gcMain.gridx = 0;
        gcMain.gridy = 0;
        JPanel westDetectionPanel = new JPanel(new BorderLayout());
        gcMain.gridx = 0;
        gcMain.weightx = 0.2;
        this.add((Component)westDetectionPanel, gcMain);
        this.detectionIcon = new JLabel("", detectionIconImage, 0);
        westDetectionPanel.add((Component)this.detectionIcon, "Center");
        if (detectionIconImage != null) {
            westDetectionPanel.setPreferredSize(new Dimension(detectionIconImage.getIconWidth(), detectionIconImage.getIconWidth()));
        }
        JPanel eastDetectionPanel = new JPanel(new BorderLayout());
        gcMain.gridx = 1;
        gcMain.weightx = 0.8;
        this.add((Component)eastDetectionPanel, gcMain);
        this.detectionDescriptionPanel = new JEditorPane();
        this.detectionDescriptionPanel.setContentType("text/html");
        this.detectionDescriptionPanel.setEditable(false);
        this.detectionDescriptionPanel.setText("The particle tracking method links through time a set of spatial locations (detections). First <strong>create a detection set</strong> using the <a href=http://icy.bioimageanalysis.org/plugin/Spot_Detector>Spot Detector plugin</a> and then select results in the box below.");
        this.detectionDescriptionPanel.setEditable(false);
        eastDetectionPanel.add((Component)this.detectionDescriptionPanel, "Center");
        JPanel eastSouthDetectionPanel = new JPanel(new GridLayout(2, 1));
        eastDetectionPanel.add((Component)eastSouthDetectionPanel, "South");
        JButton launchDetectorButton = new JButton("Run the Spot Detector plugin");
        launchDetectorButton.setToolTipText("Runs the Spot Detector plugin in order to create a set of locations for spot targets over the whole image sequence.");
        launchDetectorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PluginDescriptor plugin = PluginLoader.getPlugin((String)"plugins.fab.spotDetector.SpotDetector");
                if (plugin != null) {
                    PluginLauncher.start((PluginDescriptor)plugin);
                } else {
                    JOptionPane.showMessageDialog(SimplifiedMHTPanel.this.detectionDescriptionPanel, "The Spot Detector plugin is missing.\n Please install it first through the ICY interface for online plugin browsing.", "Missing plugin error", 0);
                }
            }
        });
        eastSouthDetectionPanel.add(launchDetectorButton);
        this.detectionChooser = new DetectionChooser();
        this.detectionChooser.setToolTipText("<html>The tracking algorithm requires a set of detections (locations of targets) through time to proceed.<br> Use the plugin 'Spot Detector' and then select the results in this box.</html>");
        this.detectionChooser.addListener(new DetectionChooser.DetectionResultChooserListener(){

            @Override
            public void DetectionResultChanged(DetectionResult detectionResult) {
                SimplifiedMHTPanel.this.refreshPanelStatus();
            }
        });
        this.detectionChooser.swimmingPoolChangeEvent(new SwimmingPoolEvent(SwimmingPoolEventType.ELEMENT_REMOVED, new SwimmingObject(null)));
        eastSouthDetectionPanel.add(this.detectionChooser);
        gcMain.weightx = 1.0;
        gcMain.gridx = 0;
        gcMain.gridwidth = 2;
        ++gcMain.gridy;
        this.add((Component)new JSeparator(0), gcMain);
        gcMain.gridwidth = 1;
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.gridwidth = 1;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.weightx = 0.0;
        JPanel westParameterPanel = new JPanel(new BorderLayout());
        this.parametersIcon = new JLabel("", parametersIconImage, 0);
        westParameterPanel.add((Component)this.parametersIcon, "Center");
        if (parametersIconImage != null) {
            westParameterPanel.setPreferredSize(new Dimension(parametersIconImage.getIconWidth(), parametersIconImage.getIconWidth()));
        }
        gcMain.gridx = 0;
        ++gcMain.gridy;
        gcMain.weightx = 0.2;
        this.add((Component)westParameterPanel, gcMain);
        JPanel eastParameterPanel = new JPanel(new GridBagLayout());
        gcMain.gridx = 1;
        gcMain.weightx = 0.8;
        this.add((Component)eastParameterPanel, gcMain);
        gc.gridy = 0;
        gc.gridwidth = 2;
        this.parametersDescriptionPanel = new JEditorPane();
        this.parametersDescriptionPanel.setContentType("text/html");
        this.parametersDescriptionPanel.setEditable(false);
        this.parametersDescriptionPanel.setText("The Multiple Hypothesis Tracking (MHT) method link detections through time to form tracks. It requires a number of parameters to proceed. Please, either:");
        this.parametersDescriptionPanel.setEditable(false);
        eastParameterPanel.add((Component)this.parametersDescriptionPanel, gc);
        ++gc.gridy;
        gc.weightx = 0.5;
        gc.gridwidth = 1;
        this.estimateParametersButton = new JButton("Estimate parameters");
        this.estimateParametersButton.setToolTipText("<html>Automatically get an estimation of the parameters for the tracking algorithm.<br>The estimation is rough, hence performance may not be optimal.<br>Switch to the advanced inteface for complete control of the parameterss.</html>");
        eastParameterPanel.add((Component)this.estimateParametersButton, gc);
        gc.gridx = 1;
        this.loadParametersButton = new JButton("Load existing parameters");
        this.loadParametersButton.setToolTipText("Load a set of parameters saved from a previous session in a XML file.");
        eastParameterPanel.add((Component)this.loadParametersButton, gc);
        gc.weightx = 0.0;
        gcMain.weightx = 1.0;
        gcMain.gridx = 0;
        gcMain.gridwidth = 2;
        ++gcMain.gridy;
        this.add((Component)new JSeparator(0), gcMain);
        gcMain.gridwidth = 1;
        JPanel westOutPutPanel = new JPanel(new BorderLayout());
        this.outputIcon = new JLabel("", outputIconImage, 0);
        westOutPutPanel.add((Component)this.outputIcon, "Center");
        if (outputIconImage != null) {
            westOutPutPanel.setPreferredSize(new Dimension(outputIconImage.getIconWidth(), outputIconImage.getIconWidth()));
        }
        gcMain.gridx = 0;
        ++gcMain.gridy;
        gcMain.weightx = 0.2;
        this.add((Component)westOutPutPanel, gcMain);
        JPanel eastOutputPanel = new JPanel(new BorderLayout());
        gcMain.gridx = 1;
        gcMain.weightx = 0.8;
        this.add((Component)eastOutputPanel, gcMain);
        this.outputDescriptionPanel = new JEditorPane();
        this.outputDescriptionPanel.setContentType("text/html");
        this.outputDescriptionPanel.setEditable(false);
        this.outputDescriptionPanel.setText("Tracking results will be automatically exported to the  <a href=http://icy.bioimageanalysis.org/plugin/Spot_Detector>TrackManager</a> plugin from where they can be analyzed and saved.</p><p>Choose a name for the results:");
        this.outputDescriptionPanel.setEditable(false);
        eastOutputPanel.add((Component)this.outputDescriptionPanel, "Center");
        this.trackGroupNameTF = new JTextField("MHT-tracks-1");
        this.trackGroupNameTF.setToolTipText("<html>Name of the tracking results that will be exported to the 'SwimmingPool' of ICY<br> and will be accessible through the 'TrackManager' plugin for analysis and export.<br>The name needs to be different from that of the already existing results.</html>");
        this.trackGroupNameTF.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
                SimplifiedMHTPanel.this.refreshPanelStatus();
            }

            @Override
            public void keyPressed(KeyEvent arg0) {
            }
        });
        eastOutputPanel.add((Component)this.trackGroupNameTF, "South");
        Icy.getMainInterface().getSwimmingPool().addListener(new SwimmingPoolListener(){

            public void swimmingPoolChangeEvent(SwimmingPoolEvent event) {
                SimplifiedMHTPanel.this.refreshPanelStatus();
            }
        });
        gcMain.weightx = 1.0;
        gcMain.gridx = 0;
        gcMain.gridwidth = 2;
        ++gcMain.gridy;
        this.add((Component)new JSeparator(0), gcMain);
        gcMain.gridwidth = 1;
        JPanel westRunPanel = new JPanel(new BorderLayout());
        this.runIncon = new JLabel("", runIconImage, 0);
        westRunPanel.add((Component)this.runIncon, "Center");
        if (runIconImage != null) {
            westRunPanel.setPreferredSize(new Dimension(runIconImage.getIconWidth(), runIconImage.getIconWidth()));
        }
        ++gcMain.gridy;
        gcMain.gridx = 0;
        gcMain.weightx = 0.2;
        this.add((Component)westRunPanel, gcMain);
        JPanel eastRunPanel = new JPanel(new BorderLayout());
        gcMain.gridx = 1;
        gcMain.weightx = 0.8;
        this.add((Component)eastRunPanel, gcMain);
        this.runDescriptionPanel = new JEditorPane();
        this.runDescriptionPanel.setContentType("text/html");
        this.runDescriptionPanel.setEditable(false);
        this.runDescriptionPanel.setText("<p>Press 'Run tracking' to proceed with the <strong>track extraction</strong> process (this can take from a few seconds to several minutes).");
        this.runDescriptionPanel.setEditable(false);
        eastRunPanel.add((Component)this.runDescriptionPanel, "Center");
        this.runTrackingButton = new JButton("Run tracking");
        this.runTrackingButton.setToolTipText("<html>Compute the set of optimal track with respect to the set of detections and parameters.<br>This may take from few seconds to several minutes depending of the size of the data and the parameters.</html>");
        eastRunPanel.add((Component)this.runTrackingButton, "South");
        this.refreshPanelStatus();
    }

    public void refreshPanelStatus() {
        DetectionResult dr = this.detectionChooser.getSelectedDetectionResult();
        this.areDetectionSettingsOk = dr != null;
        if (this.mhtParameterSet == null) {
            this.areTrackingSettingsOk = false;
        } else {
            this.areTrackingSettingsOk = true;
            if (this.areDetectionSettingsOk && this.usingDefaultParameters && this.defaultParametersAnnouce == null) {
                this.defaultParametersAnnouce = new AnnounceFrame("Using default tracking parameters for tracking, which is NOT optimal for performance.", 20);
            }
        }
        this.areOutputSettingsOk = this.testOutputName();
        this.refreshPanels();
    }

    public void refreshPanels() {
        this.detectionChooser.setEnabled(true);
        this.detectionDescriptionPanel.setEnabled(true);
        this.detectionIcon.setEnabled(true);
        if (this.areDetectionSettingsOk) {
            this.estimateParametersButton.setEnabled(true);
            this.loadParametersButton.setEnabled(true);
            this.parametersIcon.setEnabled(true);
            this.parametersDescriptionPanel.setEnabled(true);
            if (this.areTrackingSettingsOk) {
                this.outputDescriptionPanel.setEnabled(true);
                this.outputIcon.setEnabled(true);
                this.trackGroupNameTF.setEnabled(true);
                if (this.areOutputSettingsOk) {
                    this.runTrackingButton.setEnabled(true);
                    this.runIncon.setEnabled(true);
                    this.runDescriptionPanel.setEnabled(true);
                    this.outputAnnouce = null;
                } else {
                    this.runTrackingButton.setEnabled(false);
                    this.runIncon.setEnabled(false);
                    this.runDescriptionPanel.setEnabled(false);
                }
            } else {
                this.outputDescriptionPanel.setEnabled(false);
                this.outputIcon.setEnabled(false);
                this.trackGroupNameTF.setEnabled(false);
                this.runTrackingButton.setEnabled(false);
                this.runIncon.setEnabled(false);
                this.runDescriptionPanel.setEnabled(false);
            }
        } else {
            this.estimateParametersButton.setEnabled(false);
            this.loadParametersButton.setEnabled(false);
            this.parametersIcon.setEnabled(false);
            this.parametersDescriptionPanel.setEnabled(false);
            this.outputDescriptionPanel.setEnabled(false);
            this.outputIcon.setEnabled(false);
            this.trackGroupNameTF.setEnabled(false);
            this.runTrackingButton.setEnabled(false);
            this.runIncon.setEnabled(false);
            this.runDescriptionPanel.setEnabled(false);
        }
    }

    public boolean testOutputName() {
        String outputName = this.trackGroupNameTF.getText();
        for (SwimmingObject s : new ArrayList(Icy.getMainInterface().getSwimmingPool().getObjects())) {
            if (!(s.getObject() instanceof TrackGroup) || !((TrackGroup)s.getObject()).getDescription().trim().equals(outputName.trim())) continue;
            if (this.outputAnnouce == null) {
                this.outputAnnouce = new AnnounceFrame("Track group with similar name already existing. Please change output name.");
            }
            return false;
        }
        if (this.outputAnnouce != null) {
            this.outputAnnouce.close();
            this.outputAnnouce = null;
        }
        return true;
    }

    public void changeTrackingState(boolean isRunning) {
        this.runTrackingButton.setEnabled(!isRunning);
        this.loadParametersButton.setEnabled(!isRunning);
        this.detectionChooser.setEnabled(!isRunning);
        this.estimateParametersButton.setEnabled(!isRunning);
        this.trackGroupNameTF.setEnabled(!isRunning);
        this.trackGroupNameTF.setEditable(!isRunning);
        this.refreshPanelStatus();
    }

    public void setSelectedDetectionResults(DetectionResult dr) {
        if (this.detectionChooser.getSelectedDetectionResult() == dr) {
            return;
        }
        int cnt = this.detectionChooser.getItemCount();
        for (int i = 0; i < cnt; ++i) {
            Object o = this.detectionChooser.getItemAt(i);
            if (!(o instanceof DetectionResult) || o != dr) continue;
            this.detectionChooser.setSelectedIndex(i);
            break;
        }
        this.refreshPanelStatus();
    }

    public void setParameter(MHTparameterSet mhtParameterSet2) {
        this.mhtParameterSet = mhtParameterSet2;
        this.detectionChooser.setSelectedItem(this.mhtParameterSet.detectionResults);
        this.trackGroupNameTF.setText(this.mhtParameterSet.trackGroupName);
        this.refreshPanelStatus();
    }

    public void setUsingDefaultParameters(boolean useDefault) {
        this.usingDefaultParameters = useDefault;
    }
}

