/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.blocks.tools.io;

import icy.file.FileUtil;
import icy.plugin.abstract_.Plugin;
import java.io.File;
import plugins.adufour.blocks.tools.io.IOBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.gui.FileMode;
import plugins.adufour.vars.gui.model.FileTypeModel;
import plugins.adufour.vars.gui.model.VarEditorModel;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarFile;
import plugins.adufour.vars.lang.VarString;
import plugins.adufour.vars.util.VarException;

public class CreateFolder
extends Plugin
implements IOBlock {
    VarFile parentFolder = new VarFile("Base folder", new File(System.getProperty("user.home")));
    VarString folderName = new VarString("Folder name", "myFolder");
    VarFile folder = new VarFile("New folder", null);

    @Override
    public void declareInput(VarList inputMap) {
        this.parentFolder.setDefaultEditorModel((VarEditorModel)new FileTypeModel(((File)this.parentFolder.getValue()).getPath(), FileMode.FOLDERS, null, true));
        inputMap.add("parent folder", (Var<?>)this.parentFolder);
        inputMap.add("folder name", (Var<?>)this.folderName);
    }

    @Override
    public void declareOutput(VarList outputMap) {
        outputMap.add("new folder", (Var<?>)this.folder);
    }

    @Override
    public void run() {
        File parent = (File)this.parentFolder.getValue();
        if (parent == null || !parent.exists() || !parent.isDirectory()) {
            throw new VarException((Var)this.parentFolder, "The parent folder does not exist or is not a folder");
        }
        if (((String)this.folderName.getValue()).isEmpty()) {
            throw new VarException((Var)this.folderName, "The name of the folder cannot be empty");
        }
        File newFolder = new File(this.parentFolder + File.separator + (String)this.folderName.getValue());
        if (newFolder.exists() && !newFolder.isDirectory()) {
            throw new VarException((Var)this.folderName, "Cannot create folder " + newFolder.getPath() + "\n=> A file with this name already exists");
        }
        FileUtil.createDir((File)newFolder);
        this.folder.setValue((Object)newFolder);
    }
}

