/*
 * Decompiled with CFR 0.152.
 */
package vtk;

public enum CellType {
    VERTEX(1, 1),
    POLY_VERTEX(2, -1),
    LINE(3, 2),
    POLY_LINE(4, -1),
    TRIANGLE(5, 3),
    TRIANGLE_STRIP(6, -1),
    POLYGON(7, -1),
    PIXEL(8, 4),
    QUAD(9, 4),
    TETRA(10, 4),
    VOXEL(11, 8),
    HEXAHEDRON(12, 8),
    WEDGE(13, 6),
    PYRAMID(14, 5),
    PENTAGONAL_PRISM(15, 10),
    HEXAGONAL_PRISM(16, 12),
    QUADRATRIC_EDGE(21, 3),
    QUADRATRIC_TRIANGLE(22, 6),
    QUADRATRIC_QUAD(23, 8),
    QUADRATRIC_TETRA(24, 10),
    QUADRATRIC_HEXAHEDRON(25, 20),
    QUADRATRIC_WEDGE(26, 15),
    QUADRATRIC_PYRAMID(27, 13);

    private int id;
    private int nbPoints;
    private static CellType[] MAPPING;

    private CellType(int id, int nbPoints) {
        this.id = id;
        this.nbPoints = nbPoints;
    }

    public int GetId() {
        return this.id;
    }

    public int GetNumberOfPoints() {
        return this.nbPoints;
    }

    public boolean IsDynamicNumberOfPoints() {
        return this.nbPoints == -1;
    }

    public static CellType GetCellType(int vtkCellId) {
        if (MAPPING == null) {
            int max = 0;
            for (CellType cellType : CellType.values()) {
                max = Math.max(max, cellType.GetId());
            }
            MAPPING = new CellType[max + 1];
            CellType[] cellTypeArray = CellType.values();
            int n = cellTypeArray.length;
            for (int i = 0; i < n; ++i) {
                CellType cellType;
                CellType.MAPPING[cellType.GetId()] = cellType = cellTypeArray[i];
            }
        }
        return MAPPING[vtkCellId];
    }
}

