/*
 * Decompiled with CFR 0.152.
 */
package vtk.sample.rendering;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import vtk.rendering.jogl.vtkAbstractJoglComponent;
import vtk.rendering.jogl.vtkJoglCanvasComponent;
import vtk.rendering.jogl.vtkJoglPanelComponent;
import vtk.rendering.vtkAbstractEventInterceptor;
import vtk.vtkActor;
import vtk.vtkBoxRepresentation;
import vtk.vtkBoxWidget2;
import vtk.vtkCell;
import vtk.vtkCellPicker;
import vtk.vtkConeSource;
import vtk.vtkLookupTable;
import vtk.vtkNativeLibrary;
import vtk.vtkPolyDataMapper;
import vtk.vtkScalarBarRepresentation;
import vtk.vtkScalarBarWidget;
import vtk.vtkTransform;

public class JoglConeRendering {
    public static void main(String[] args) {
        final boolean usePanel = Boolean.getBoolean("usePanel");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                vtkConeSource cone = new vtkConeSource();
                cone.SetResolution(8);
                cone.Update();
                vtkPolyDataMapper coneMapper = new vtkPolyDataMapper();
                coneMapper.SetInputConnection(cone.GetOutputPort());
                final vtkActor coneActor = new vtkActor();
                coneActor.SetMapper(coneMapper);
                final vtkAbstractJoglComponent joglWidget = usePanel ? new vtkJoglPanelComponent() : new vtkJoglCanvasComponent();
                System.out.println("We are using " + joglWidget.getComponent().getClass().getName() + " for the rendering.");
                joglWidget.getRenderer().AddActor(coneActor);
                vtkAbstractJoglComponent.attachOrientationAxes(joglWidget);
                vtkLookupTable lut = new vtkLookupTable();
                lut.SetHueRange(0.66, 0.0);
                lut.Build();
                vtkScalarBarWidget scalarBar = new vtkScalarBarWidget();
                scalarBar.SetInteractor(joglWidget.getRenderWindowInteractor());
                scalarBar.GetScalarBarActor().SetTitle("Example");
                scalarBar.GetScalarBarActor().SetLookupTable(lut);
                scalarBar.GetScalarBarActor().SetOrientationToHorizontal();
                scalarBar.GetScalarBarActor().SetTextPositionToPrecedeScalarBar();
                vtkScalarBarRepresentation srep = (vtkScalarBarRepresentation)scalarBar.GetRepresentation();
                srep.SetPosition(0.5, 0.053796);
                srep.SetPosition2(0.33, 0.106455);
                scalarBar.EnabledOn();
                scalarBar.RepositionableOn();
                vtkBoxRepresentation representation = new vtkBoxRepresentation();
                representation.SetPlaceFactor(1.25);
                representation.PlaceWidget(cone.GetOutput().GetBounds());
                final vtkBoxWidget2 boxWidget = new vtkBoxWidget2();
                boxWidget.SetRepresentation(representation);
                boxWidget.SetInteractor(joglWidget.getRenderWindowInteractor());
                boxWidget.SetPriority(1.0f);
                Runnable callback = new Runnable(){
                    vtkTransform trasform = new vtkTransform();

                    @Override
                    public void run() {
                        vtkBoxRepresentation rep = (vtkBoxRepresentation)boxWidget.GetRepresentation();
                        rep.GetTransform(this.trasform);
                        coneActor.SetUserTransform(this.trasform);
                    }
                };
                boxWidget.AddObserver("InteractionEvent", callback, "run");
                representation.VisibilityOn();
                representation.HandlesOn();
                boxWidget.SetEnabled(1);
                boxWidget.SetMoveFacesEnabled(1);
                final vtkCellPicker picker = new vtkCellPicker();
                Runnable pickerCallback = new Runnable(){

                    @Override
                    public void run() {
                        if (picker.GetCellId() != -1L) {
                            vtkCell cell = picker.GetDataSet().GetCell(picker.GetCellId());
                            System.out.println("Pick cell: " + picker.GetCellId() + " - Bounds: " + Arrays.toString(cell.GetBounds()));
                        }
                    }
                };
                joglWidget.getRenderWindowInteractor().SetPicker(picker);
                picker.AddObserver("EndPickEvent", pickerCallback, "run");
                joglWidget.getInteractorForwarder().setEventInterceptor(new vtkAbstractEventInterceptor(){

                    @Override
                    public boolean mouseClicked(MouseEvent e) {
                        double[] position = new double[]{e.getX(), ((Component)joglWidget.getComponent()).getHeight() - e.getY(), 0.0};
                        if (e.getClickCount() == 2) {
                            System.out.println("Click trigger the picking (" + position[0] + ", " + position[1] + ")");
                            picker.Pick(position, joglWidget.getRenderer());
                        }
                        return false;
                    }
                });
                JFrame frame = new JFrame("SimpleVTK");
                frame.setDefaultCloseOperation(3);
                frame.getContentPane().setLayout(new BorderLayout());
                frame.getContentPane().add((Component)joglWidget.getComponent(), "Center");
                frame.setSize(400, 400);
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
                joglWidget.resetCamera();
                ((Component)joglWidget.getComponent()).requestFocus();
                ((Component)joglWidget.getComponent()).addKeyListener(new KeyListener(){

                    @Override
                    public void keyTyped(KeyEvent e) {
                        if (e.getKeyChar() == 'r') {
                            joglWidget.resetCamera();
                        } else if (e.getKeyChar() == 'q') {
                            System.exit(0);
                        }
                    }

                    @Override
                    public void keyReleased(KeyEvent e) {
                    }

                    @Override
                    public void keyPressed(KeyEvent e) {
                    }
                });
            }
        });
    }

    static {
        if (!vtkNativeLibrary.LoadAllNativeLibraries()) {
            for (vtkNativeLibrary lib : vtkNativeLibrary.values()) {
                if (lib.IsLoaded()) continue;
                System.out.println(lib.GetLibraryName() + " not loaded");
            }
        }
        vtkNativeLibrary.DisableOutputWindow(null);
    }
}

