/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.itertools;

import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyIterator;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules.itertools.combinations$PyExposer;
import org.python.modules.itertools.itertools;

@ExposedType(name="itertools.combinations", base=PyObject.class)
public class combinations
extends PyObject {
    public static final PyType TYPE;
    private PyIterator iter;
    public static PyString __doc__;

    public combinations() {
    }

    public combinations(PyType subType) {
        super(subType);
    }

    public combinations(PyObject iterable, int r) {
        this.combinations___init__(iterable, r);
    }

    @ExposedNew
    final void combinations___init__(PyObject[] args, String[] kwds) {
        if (args.length > 2) {
            throw Py.TypeError(String.format("combinations_with_replacement() takes at most 2 arguments (%d given)", args.length));
        }
        ArgParser ap = new ArgParser("combinations_with_replacement", args, kwds, "iterable", "r");
        PyObject iterable = ap.getPyObject(0);
        int r = ap.getInt(1);
        if (r < 0) {
            throw Py.ValueError("r must be non-negative");
        }
        this.combinations___init__(iterable, r);
    }

    private void combinations___init__(PyObject iterable, final int r) {
        if (r < 0) {
            throw Py.ValueError("r must be non-negative");
        }
        final PyTuple pool = PyTuple.fromIterable(iterable);
        final int n = pool.__len__();
        final int[] indices = new int[r];
        for (int i = 0; i < r; ++i) {
            indices[i] = i;
        }
        this.iter = new itertools.ItertoolsIterator(){
            boolean firstthru = true;

            @Override
            public PyObject __iternext__() {
                int i;
                if (r > n) {
                    return null;
                }
                if (this.firstthru) {
                    this.firstthru = false;
                    return itertools.makeIndexedTuple(pool, indices);
                }
                for (i = r - 1; i >= 0 && indices[i] == i + n - r; --i) {
                }
                if (i < 0) {
                    return null;
                }
                int n2 = i;
                indices[n2] = indices[n2] + 1;
                for (int j = i + 1; j < r; ++j) {
                    indices[j] = indices[j - 1] + 1;
                }
                return itertools.makeIndexedTuple(pool, indices);
            }
        };
    }

    @Override
    public PyObject __iter__() {
        return this.iter;
    }

    public PyObject next() {
        return this.iter.next();
    }

    static {
        PyType.addBuilder(combinations.class, new combinations$PyExposer());
        TYPE = PyType.fromClass(combinations.class);
        __doc__ = new PyString("combinations(iterable, r) --> combinations object\n\nReturn successive r-length combinations of elements in the iterable.\n\ncombinations(range(4), 3) --> (0,1,2), (0,1,3), (0,2,3), (1,2,3)");
    }
}

