/*
 * Decompiled with CFR 0.152.
 */
package vtk.sample;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import vtk.sample.VTKCanvas;
import vtk.vtkNativeLibrary;

public class InternalFrames
extends JFrame {
    private static final long serialVersionUID = 1L;
    private Desktop theDesktop;
    private Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();

    public InternalFrames() {
        super("VTK Internal Frame Demo");
        this.setSize(900, 900);
        WindowAdapter l = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        };
        this.addWindowListener(l);
        this.getContentPane().add(new SplitFrame());
        new MenuMgr();
        this.setVisible(true);
    }

    public void addMenuBar(JMenuBar m) {
        this.setJMenuBar(m);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new InternalFrames();
            }
        });
    }

    static {
        if (!vtkNativeLibrary.LoadAllNativeLibraries()) {
            for (vtkNativeLibrary lib : vtkNativeLibrary.values()) {
                if (lib.IsLoaded()) continue;
                System.out.println(lib.GetLibraryName() + " not loaded");
            }
        }
        vtkNativeLibrary.DisableOutputWindow(null);
    }

    private class Desktop
    extends JDesktopPane {
        private static final long serialVersionUID = 1L;

        public Desktop() {
            this.setPreferredSize(InternalFrames.this.screenSize);
            this.setDragMode(1);
            this.add(new VTKFrame(10, 10));
            this.add(new VTKFrame(500, 10));
        }
    }

    private class SplitFrame
    extends JSplitPane {
        private static final long serialVersionUID = 1L;

        public SplitFrame() {
            super(0);
            this.setDividerLocation(((InternalFrames)InternalFrames.this).screenSize.height / 2);
            this.setContinuousLayout(true);
            this.setOneTouchExpandable(true);
            this.add(InternalFrames.this.theDesktop = new Desktop());
            this.add(new Tabbed());
        }
    }

    private class MenuMgr
    extends JMenuBar {
        private static final long serialVersionUID = 1L;
        private JMenu menu;

        public MenuMgr() {
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            this.menu = new JMenu("File");
            this.menu.add(new CreateWindowAction("Create New VTK Window"));
            this.menu.add(new KillAction("Exit"));
            this.add(this.menu);
            InternalFrames.this.addMenuBar(this);
        }
    }

    private class KillAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public KillAction(String label) {
            super(label);
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            System.exit(0);
        }
    }

    private class CreateWindowAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private int layer;

        public CreateWindowAction(String label) {
            super(label);
            this.layer = 0;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            InternalFrames.this.theDesktop.add((Component)new VTKFrame(340, 200), (Object)this.layer);
        }
    }

    private class VTKFrame
    extends JInternalFrame {
        private static final long serialVersionUID = 1L;

        public VTKFrame(int x, int y) {
            super("VTK Window", true, true, true, true);
            Dimension mySize = new Dimension();
            mySize.height = 300;
            mySize.width = 300;
            this.setSize(mySize);
            this.getContentPane().setLayout(new BorderLayout());
            this.setLocation(x, y);
            this.getContentPane().add((Component)new VTKCanvas(), "Center");
            this.pack();
            this.setVisible(true);
        }
    }

    private class Tabbed
    extends JTabbedPane {
        private static final long serialVersionUID = 1L;

        public Tabbed() {
            this.addTab("vtk1", new VTKCanvas());
            this.addTab("vtk2", new VTKCanvas());
            this.setMinimumSize(new Dimension(300, 300));
            this.setSelectedIndex(1);
        }
    }
}

