/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.geom;

import java.io.IOException;
import java.io.Writer;
import java.util.Random;
import javax.vecmath.Point3f;
import mcib3d.geom.Vector3D;

public class Point3D {
    public double x = 0.0;
    public double y = 0.0;
    public double z = 0.0;

    public Point3D() {
    }

    public Point3D(double a, double b, double c) {
        this.x = a;
        this.y = b;
        this.z = c;
    }

    public Point3D(Point3D P) {
        this.x = P.getX();
        this.y = P.getY();
        this.z = P.getZ();
    }

    public Point3D(Point3f P) {
        this.x = P.x;
        this.y = P.y;
        this.z = P.z;
    }

    public void setX(double newVar) {
        this.x = newVar;
    }

    public double getX() {
        return this.x;
    }

    public int getRoundX() {
        return (int)Math.round(this.x);
    }

    public int getRoundY() {
        return (int)Math.round(this.y);
    }

    public int getRoundZ() {
        return (int)Math.round(this.z);
    }

    public void setY(double newVar) {
        this.y = newVar;
    }

    public double getY() {
        return this.y;
    }

    public void setZ(double newVar) {
        this.z = newVar;
    }

    public double getZ() {
        return this.z;
    }

    public Vector3D getVector3D() {
        return new Vector3D(this.x, this.y, this.z);
    }

    public Point3D getPosition() {
        return new Point3D(this.x, this.y, this.z);
    }

    public Point3f getPoint3f() {
        return new Point3f((float)this.x, (float)this.y, (float)this.z);
    }

    public void translate(Vector3D v) {
        this.x += v.getX();
        this.y += v.getY();
        this.z += v.getZ();
    }

    public void translate(double dx, double dy, double dz) {
        this.x += dx;
        this.y += dy;
        this.z += dz;
    }

    public void scale(double sx, double sy, double sz) {
        this.x *= sx;
        this.y *= sy;
        this.z *= sz;
    }

    public double distance(Point3D other) {
        return Math.sqrt(this.distanceSquare(other));
    }

    public double distance(Point3D other, double resXY, double resZ) {
        return Math.sqrt(this.distanceSquare(other, resXY, resZ));
    }

    public double distanceSquare(Point3D other) {
        return (this.x - other.getX()) * (this.x - other.getX()) + (this.y - other.getY()) * (this.y - other.getY()) + (this.z - other.getZ()) * (this.z - other.getZ());
    }

    public double distanceSquare(Point3D other, double resXY, double resZ) {
        return (this.x - other.getX()) * (this.x - other.getX()) * resXY * resXY + (this.y - other.getY()) * (this.y - other.getY()) * resXY * resXY + (this.z - other.getZ()) * (this.z - other.getZ()) * resZ * resZ;
    }

    public double distBlock(Point3D other) {
        return Math.abs(this.x - other.getX()) + Math.abs(this.y - other.getY()) + Math.abs(this.z - other.getZ());
    }

    public String toString() {
        return "(" + this.x + " " + this.y + " " + this.z + ")";
    }

    public void xmlWrite(Writer wr) {
        try {
            wr.write("<Point3D x=\"" + this.x + "\" y=\"" + this.y + "\" z=\"" + this.z + "\" />\n");
            wr.flush();
        }
        catch (IOException e) {
            System.out.println("error in Point3D::XmlWrite " + e);
        }
    }

    public void setCoordRandom() {
        Random rand = new Random();
        this.setX(rand.nextGaussian());
        this.setY(rand.nextGaussian());
        this.setZ(rand.nextGaussian());
    }

    public boolean equals(Object o) {
        if (o instanceof Point3D) {
            Point3D other = (Point3D)o;
            return other.x == this.x && other.y == this.y && other.z == this.z;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (int)(Double.doubleToLongBits(this.x) ^ Double.doubleToLongBits(this.x) >>> 32);
        hash = 31 * hash + (int)(Double.doubleToLongBits(this.y) ^ Double.doubleToLongBits(this.y) >>> 32);
        hash = 31 * hash + (int)(Double.doubleToLongBits(this.z) ^ Double.doubleToLongBits(this.z) >>> 32);
        return hash;
    }

    public double[] getArray() {
        return new double[]{this.x, this.y, this.z};
    }

    public boolean isInsideBoundingBox(int[] boundingBox) {
        return this.x >= (double)boundingBox[0] && this.x <= (double)boundingBox[1] && this.y >= (double)boundingBox[2] && this.y <= (double)boundingBox[3] && this.z >= (double)boundingBox[4] && this.z <= (double)boundingBox[5];
    }

    public boolean sameVoxel(Point3D other) {
        return Math.abs(this.x - other.x) < 0.5 && Math.abs(this.y - other.y) < 0.5 && Math.abs(this.z - other.z) < 0.5;
    }

    public boolean samePosition(Point3D other, double error) {
        return other.x - this.x < error && this.x - other.x < error && other.y - this.y < error && this.y - other.y < error && other.z - this.z < error && this.z - other.z < error;
    }

    public boolean samePosition(Point3D other) {
        return this.samePosition(other, 0.5);
    }

    public Point3D projectionPlane(double a, double b, double c, double d) {
        double k = -(a * this.x + b * this.y + c * this.z + d) / (a * a + b * b + c * c);
        return new Point3D(this.x + k * a, this.y + k * b, this.z + k * c);
    }
}

