/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Plot;
import ij.measure.CurveFitter;
import java.util.ArrayList;
import java.util.Iterator;
import mcib3d.geom.Object3D;
import mcib3d.geom.Object3DVoxels;
import mcib3d.geom.Voxel3D;
import mcib3d.image3d.ImageByte;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.ImageShort;
import mcib3d.image3d.distanceMap3d.EDT;
import mcib3d.image3d.processing.FastFilters3D;
import mcib3d.image3d.regionGrowing.Watershed3D;
import mcib3d.utils.ArrayUtil;
import mcib3d.utils.ThreadUtil;

public class Segment3DSpots {
    ArrayList<Object3D> segmentedObjects = null;
    ImageHandler rawImage;
    ImageHandler seedsImage;
    ImageInt watershedImage = null;
    ImageHandler labelImage = null;
    ImageHandler indexImage = null;
    int seedsThreshold = -1;
    public static final int SEG_CLASSICAL = 1;
    public static final int SEG_MAX = 3;
    public static final int SEG_BLOCK = 4;
    int methodSeg = 1;
    public static final int LOCAL_CONSTANT = 1;
    public static final int LOCAL_MEAN = 2;
    public static final int LOCAL_GAUSS = 3;
    public static final int LOCAL_DIFF = 4;
    int localValue = -1;
    int localMethod = 1;
    float radius0;
    float radius1;
    float radius2;
    private double localWeight = 0.5;
    private int GAUSS_MAXR = 10;
    private double GAUSS_PC = 1.285;
    private int volMax = Integer.MAX_VALUE;
    private int volMin = 2;
    private boolean WATERSHED = false;
    public boolean show = true;
    public boolean multithread = true;
    public boolean bigLabel = false;
    private float diff;

    public Segment3DSpots(ImageHandler image, ImageHandler seeds) {
        this.rawImage = image;
        this.seedsImage = seeds;
    }

    public int getLocalThreshold() {
        return this.localValue;
    }

    public void setLocalThreshold(int localThreshold) {
        this.localValue = localThreshold;
    }

    public int getSeedsThreshold() {
        return this.seedsThreshold;
    }

    public void setSeedsThreshold(int globalThreshold) {
        this.seedsThreshold = globalThreshold;
    }

    public ImageHandler getRawImage() {
        return this.rawImage;
    }

    public void setRawImage(ImageHandler image) {
        this.rawImage = image;
    }

    public void setLabelImage(ImageHandler image) {
        this.labelImage = image;
    }

    public ImageHandler getSeeds() {
        return this.seedsImage;
    }

    public void setSeeds(ImageInt seeds) {
        this.seedsImage = seeds;
    }

    public ArrayList<Object3D> getObjects() {
        return this.segmentedObjects;
    }

    public ImageHandler getInternalLabelImage() {
        return this.labelImage;
    }

    public ImageHandler getLabelImage() {
        IJ.log((String)("Create label image with " + this.segmentedObjects.size() + " objects"));
        if (this.indexImage == null) {
            this.indexImage = !this.bigLabel ? new ImageShort("Index", this.rawImage.sizeX, this.rawImage.sizeY, this.rawImage.sizeZ) : new ImageFloat("Index", this.rawImage.sizeX, this.rawImage.sizeY, this.rawImage.sizeZ);
        }
        for (Object3D obj : this.segmentedObjects) {
            obj.draw(this.indexImage, obj.getValue());
        }
        return this.indexImage;
    }

    public void setMethodSeg(int method) {
        this.methodSeg = method;
    }

    public void setMethodLocal(int method) {
        this.localMethod = method;
    }

    public void setWatershed(boolean wa) {
        this.WATERSHED = wa;
        if (this.WATERSHED) {
            this.computeWatershed();
        }
    }

    @Deprecated
    public void setNoiseWatershed(int noiseWatershed) {
    }

    public void setRadiusLocalMean(float r0, float r1, float r2) {
        this.setRadiusLocalMean(r0, r1, r2, 0.5);
    }

    public void setLocalDiff(int d) {
        this.diff = d;
    }

    public void setRadiusLocalMean(float r0, float r1, float r2, double we) {
        this.radius0 = r0;
        this.radius1 = r1;
        this.radius2 = r2;
        this.localWeight = we;
    }

    public void setGaussPc(double pc) {
        this.GAUSS_PC = pc;
    }

    public void setGaussMaxr(int gm) {
        this.GAUSS_MAXR = gm;
    }

    public int getVolumeMax() {
        return this.volMax;
    }

    public void setVolumeMax(int volMax) {
        this.volMax = volMax;
    }

    public int getVolumeMin() {
        return this.volMin;
    }

    public void setVolumeMin(int volMin) {
        this.volMin = volMin;
    }

    private void computeWatershed() {
        ImageByte seedsTh = this.seedsImage.thresholdAboveExclusive(this.seedsThreshold);
        ImageFloat edt = EDT.run(seedsTh, 0.0f, (float)this.rawImage.getScaleXY(), (float)this.rawImage.getScaleZ(), true, 0);
        ImageShort edt16 = edt.convertToShort(true);
        edt16.invert();
        Watershed3D wat3D = new Watershed3D(edt16, this.seedsImage, 0, 0);
        this.watershedImage = wat3D.getWatershedImage3D();
    }

    public double localMean(int xc, int yc, int zc) {
        double mback;
        double mspot;
        int sx = this.rawImage.sizeX;
        int sy = this.rawImage.sizeY;
        int sz = this.rawImage.sizeZ;
        float rad0 = this.radius0;
        float rad1 = this.radius1;
        float rad2 = this.radius2;
        double weight = this.localWeight;
        if (!this.WATERSHED) {
            ArrayUtil neigh = this.rawImage.getNeighborhood(xc, yc, zc, rad0, rad0, rad0);
            mspot = neigh.getMean();
            neigh = this.rawImage.getNeighborhoodLayer(xc, yc, zc, rad1, rad2);
            mback = neigh.getMean();
        } else {
            int xf;
            int xd;
            int yf;
            int yd;
            int zf;
            double rad02 = rad0 * rad0;
            double rad12 = rad1 * rad1;
            double rad22 = rad2 * rad2;
            int nbspot = 0;
            int nbback = 0;
            double sumspot = 0.0;
            double sumback = 0.0;
            int waterc = this.watershedImage.getPixelInt(xc, yc, zc);
            int zd = (int)((float)zc - rad2);
            if (zd < 0) {
                zd = 0;
            }
            if ((zf = (int)((float)zc + rad2)) >= sz) {
                zf = sz;
            }
            if ((yd = (int)((float)yc - rad2)) < 0) {
                yd = 0;
            }
            if ((yf = (int)((float)yc + rad2)) >= sy) {
                yf = sy;
            }
            if ((xd = (int)((float)xc - rad2)) < 0) {
                xd = 0;
            }
            if ((xf = (int)((float)xc + rad2)) >= sx) {
                xf = sx;
            }
            for (int z = zd; z < zf; ++z) {
                for (int y = yd; y < yf; ++y) {
                    for (int x = xd; x < xf; ++x) {
                        float pix;
                        int water;
                        double dist = (x - xc) * (x - xc) + (y - yc) * (y - yc) + (z - zc) * (z - zc);
                        if (dist <= rad02) {
                            water = this.watershedImage.getPixelInt(x, y, z);
                            if (water != waterc) continue;
                            pix = this.rawImage.getPixel(x, y, z);
                            sumspot += (double)pix;
                            ++nbspot;
                            continue;
                        }
                        if (!(dist >= rad12) || !(dist <= rad22) || (water = this.watershedImage.getPixelInt(x, y, z)) != waterc) continue;
                        pix = this.rawImage.getPixel(x, y, z);
                        sumback += (double)pix;
                        ++nbback;
                    }
                }
            }
            if (nbspot <= 1) {
                return -1.0;
            }
            mspot = sumspot / (double)nbspot;
            if (nbback > 1) {
                mback = sumback / (double)nbback;
            } else {
                return -1.0;
            }
        }
        return mspot * weight + (1.0 - weight) * mback;
    }

    public double[] gaussianFit(int x, int y, int z, boolean plotb) {
        double[] gaussFit = this.WATERSHED ? this.rawImage.radialDistribution(x, y, z, this.GAUSS_MAXR, 10, this.watershedImage) : this.rawImage.radialDistribution(x, y, z, this.GAUSS_MAXR);
        double[] params = ArrayUtil.fitGaussian(gaussFit, 3.0, this.GAUSS_MAXR);
        if (plotb) {
            double[] xx = new double[gaussFit.length];
            for (int i = 0; i < xx.length; ++i) {
                xx[i] = i;
            }
            Plot plot = new Plot("Rad", "X", "Y", xx, gaussFit);
            plot.show();
        }
        return params;
    }

    private void createLabelImage() {
        this.labelImage = !this.bigLabel ? new ImageShort("Label", this.rawImage.sizeX, this.rawImage.sizeY, this.rawImage.sizeZ) : new ImageFloat("Label", this.rawImage.sizeX, this.rawImage.sizeY, this.rawImage.sizeZ);
    }

    public void segmentAll() {
        this.segmentedObjects = new ArrayList();
        int o = 1;
        int localThreshold = this.localValue;
        if (this.labelImage == null) {
            this.createLabelImage();
        }
        for (int z = 0; z < this.seedsImage.sizeZ; ++z) {
            IJ.showStatus((String)("Segmenting slice " + (z + 1)));
            for (int y = 0; y < this.seedsImage.sizeY; ++y) {
                for (int x = 0; x < this.seedsImage.sizeX; ++x) {
                    ArrayList<Voxel3D> obj;
                    if (!(this.seedsImage.getPixel(x, y, z) > (float)this.seedsThreshold)) continue;
                    if (this.localMethod == 2) {
                        localThreshold = (int)this.localMean(x, y, z);
                    } else if (this.localMethod == 3) {
                        double[] gauss = this.gaussianFit(x, y, z, false);
                        if (gauss != null) {
                            double thresh = CurveFitter.f((int)12, (double[])gauss, (double)(this.GAUSS_PC * gauss[3]));
                            localThreshold = (int)thresh;
                        }
                    } else if (this.localMethod == 4) {
                        localThreshold = (int)Math.max(1.0f, this.seedsImage.getPixel(x, y, z) - this.diff);
                    }
                    if (localThreshold > 0 && this.show) {
                        IJ.log((String)("segmenting spot at : " + x + " " + y + "  " + z + " lc=" + localThreshold));
                    }
                    switch (this.methodSeg) {
                        case 1: {
                            obj = this.segmentSpotClassical(x, y, z, localThreshold, o);
                            break;
                        }
                        case 3: {
                            obj = this.segmentSpotMax(x, y, z, localThreshold, o);
                            break;
                        }
                        case 4: {
                            obj = this.segmentSpotBlock(x, y, z, localThreshold, o);
                            break;
                        }
                        default: {
                            obj = this.segmentSpotClassical(x, y, z, localThreshold, o);
                        }
                    }
                    if (obj != null && obj.size() >= this.volMin && obj.size() <= this.volMax) {
                        this.segmentedObjects.add(new Object3DVoxels(obj));
                        ++o;
                        continue;
                    }
                    if (obj == null) continue;
                    for (Voxel3D vo : obj) {
                        this.labelImage.setPixel(vo.getRoundX(), vo.getRoundY(), vo.getRoundZ(), 0.0f);
                    }
                    if (!this.show) continue;
                    IJ.log((String)("object volume outside range : " + obj.size()));
                }
            }
        }
    }

    public ArrayList<Voxel3D> segmentOneSpot(int x, int y, int z, int o) {
        ArrayList<Voxel3D> obj;
        double[] gauss;
        int localThreshold = this.localValue;
        if (this.localMethod == 2) {
            localThreshold = (int)this.localMean(x, y, z);
        } else if (this.localMethod == 3 && (gauss = this.gaussianFit(x, y, z, false)) != null) {
            double thresh = CurveFitter.f((int)12, (double[])gauss, (double)(this.GAUSS_PC * gauss[3]));
            localThreshold = (int)thresh;
        }
        if (localThreshold > 0 && this.show) {
            IJ.log((String)("segmenting spot at : " + x + " " + y + "  " + z + " lc=" + localThreshold));
        }
        switch (this.methodSeg) {
            case 1: {
                obj = this.segmentSpotClassical(x, y, z, localThreshold, o);
                break;
            }
            case 3: {
                obj = this.segmentSpotMax(x, y, z, localThreshold, o);
                break;
            }
            case 4: {
                obj = this.segmentSpotBlock(x, y, z, localThreshold, o);
                break;
            }
            default: {
                obj = this.segmentSpotClassical(x, y, z, localThreshold, o);
            }
        }
        if (obj != null && obj.size() >= this.volMin && obj.size() <= this.volMax) {
            return obj;
        }
        return null;
    }

    private ArrayList<Voxel3D> segmentSpotTemplate(int xdep, int ydep, int zdep, int lcThreshold, int val) {
        boolean changement = true;
        int xfin = xdep + 1;
        int yfin = ydep + 1;
        int zfin = zdep + 1;
        int sens = 1;
        if (this.labelImage == null) {
            this.createLabelImage();
        }
        if (this.labelImage.getPixel(xdep, ydep, zdep) > 0.0f) {
            return null;
        }
        this.labelImage.setPixel(xdep, ydep, zdep, val);
        ArrayList<Voxel3D> object = new ArrayList<Voxel3D>();
        object.add(new Voxel3D(xdep, ydep, zdep, val));
        int volume = 1;
        ImageHandler original = this.rawImage;
        while (changement) {
            int k;
            changement = false;
            int n = k = sens == 1 ? zdep : zfin;
            while (sens == 1 && k <= zfin || sens == -1 && k >= zdep) {
                int j;
                int n2 = j = sens == 1 ? ydep : yfin;
                while (sens == 1 && j <= yfin || sens == -1 && j >= ydep) {
                    int i;
                    int n3 = i = sens == 1 ? xdep : xfin;
                    while (sens == 1 && i <= xfin || sens == -1 && i >= xdep) {
                        if (this.labelImage.getPixel(i, j, k) == (float)val) {
                            int l;
                            int m;
                            int n4;
                            ArrayList<Voxel3D> neigh = new ArrayList<Voxel3D>();
                            for (n4 = k - 1; n4 < k + 2; ++n4) {
                                for (m = j - 1; m < j + 2; ++m) {
                                    for (l = i - 1; l < i + 2; ++l) {
                                        if (this.labelImage.getPixel(l, m, n4) != 0.0f) continue;
                                        neigh.add(new Voxel3D(l, m, n4, original.getPixel(l, m, n4)));
                                    }
                                }
                            }
                            for (Voxel3D tmpneigh : neigh) {
                                if (!(tmpneigh.getValue() >= (double)lcThreshold)) continue;
                                l = tmpneigh.getRoundX();
                                m = tmpneigh.getRoundY();
                                n4 = tmpneigh.getRoundZ();
                                this.labelImage.setPixel(l, m, n4, val);
                                object.add(new Voxel3D(l, m, n4, val));
                                if (++volume > this.volMax) {
                                    if (this.show) {
                                        IJ.log((String)("VOL :" + volume));
                                    }
                                    return null;
                                }
                                if (l < xdep) {
                                    --xdep;
                                }
                                if (l > xfin) {
                                    ++xfin;
                                }
                                if (m < ydep) {
                                    --ydep;
                                }
                                if (m > yfin) {
                                    ++yfin;
                                }
                                if (n4 < zdep) {
                                    --zdep;
                                }
                                if (n4 > zfin) {
                                    ++zfin;
                                }
                                changement = true;
                            }
                        }
                        i += sens;
                    }
                    j += sens;
                }
                k += sens;
            }
            sens *= -1;
        }
        return object;
    }

    public ArrayList<Voxel3D> segmentSpotBlock(int xdep, int ydep, int zdep, int lcThreshold, int val) {
        boolean changement = true;
        int xfin = xdep + 1;
        int yfin = ydep + 1;
        int zfin = zdep + 1;
        int sens = 1;
        if (this.labelImage == null) {
            this.createLabelImage();
        }
        if (this.labelImage.getPixel(xdep, ydep, zdep) > 0.0f) {
            return null;
        }
        this.labelImage.setPixel(xdep, ydep, zdep, val);
        ArrayList<Voxel3D> object = new ArrayList<Voxel3D>();
        object.add(new Voxel3D(xdep, ydep, zdep, val));
        int volume = 1;
        int sx = this.rawImage.sizeX;
        int sy = this.rawImage.sizeY;
        int sz = this.rawImage.sizeZ;
        ImageHandler original = this.rawImage;
        int waterne = 0;
        int water = 0;
        while (changement) {
            int k;
            changement = false;
            int n = k = sens == 1 ? zdep : zfin;
            while (sens == 1 && k <= zfin || sens == -1 && k >= zdep) {
                int j;
                int n2 = j = sens == 1 ? ydep : yfin;
                while (sens == 1 && j <= yfin || sens == -1 && j >= ydep) {
                    int i;
                    int n3 = i = sens == 1 ? xdep : xfin;
                    while (sens == 1 && i <= xfin || sens == -1 && i >= xdep) {
                        if (this.labelImage.contains(i, j, k) && this.labelImage.getPixel(i, j, k) == (float)val) {
                            int l;
                            int m;
                            int n4;
                            float pixelCenter = original.getPixel(i, j, k);
                            if (this.WATERSHED) {
                                water = this.watershedImage.getPixelInt(i, j, k);
                            }
                            ArrayList<Voxel3D> neigh = new ArrayList<Voxel3D>();
                            for (n4 = k - 1; n4 < k + 2; ++n4) {
                                for (m = j - 1; m < j + 2; ++m) {
                                    for (l = i - 1; l < i + 2; ++l) {
                                        if (l < 0 || l >= sx || m < 0 || m >= sy || n4 < 0 || n4 >= sz) continue;
                                        if (this.WATERSHED) {
                                            waterne = this.watershedImage.getPixelInt(l, m, n4);
                                        }
                                        if (this.labelImage.getPixel(l, m, n4) != 0.0f || !(original.getPixel(l, m, n4) >= (float)lcThreshold) || waterne != water) continue;
                                        neigh.add(new Voxel3D(l, m, n4, original.getPixel(l, m, n4)));
                                    }
                                }
                            }
                            boolean ok = true;
                            if (neigh.isEmpty()) {
                                ok = false;
                            }
                            if (neigh.size() == 1) {
                                ok = false;
                            }
                            Iterator it = neigh.iterator();
                            while (it.hasNext() && ok) {
                                Voxel3D tmpneigh = (Voxel3D)it.next();
                                if (!(tmpneigh.getValue() > (double)pixelCenter)) continue;
                                ok = false;
                                break;
                            }
                            if (ok) {
                                changement = true;
                                if (neigh.size() > this.volMax) {
                                    return null;
                                }
                                for (Voxel3D tmpneigh : neigh) {
                                    l = tmpneigh.getRoundX();
                                    m = tmpneigh.getRoundY();
                                    n4 = tmpneigh.getRoundZ();
                                    this.labelImage.setPixel(l, m, n4, val);
                                    object.add(new Voxel3D(l, m, n4, val));
                                    if (++volume > this.volMax) {
                                        if (this.show) {
                                            IJ.log((String)("VOL :" + volume));
                                        }
                                        return null;
                                    }
                                    if (l < xdep) {
                                        --xdep;
                                    }
                                    if (l > xfin) {
                                        ++xfin;
                                    }
                                    if (m < ydep) {
                                        --ydep;
                                    }
                                    if (m > yfin) {
                                        ++yfin;
                                    }
                                    if (n4 < zdep) {
                                        --zdep;
                                    }
                                    if (n4 <= zfin) continue;
                                    ++zfin;
                                }
                            }
                        }
                        i += sens;
                    }
                    j += sens;
                }
                k += sens;
            }
            sens *= -1;
        }
        return object;
    }

    public ArrayList<Voxel3D> segmentSpotClassical(int xdep, int ydep, int zdep, int lcThreshold, int val) {
        boolean change = true;
        int xEnd = xdep + 1;
        int yEnd = ydep + 1;
        int zEnd = zdep + 1;
        int sens = 1;
        if (this.labelImage == null) {
            this.createLabelImage();
        }
        if (this.labelImage.getPixel(xdep, ydep, zdep) > 0.0f) {
            return null;
        }
        this.labelImage.setPixel(xdep, ydep, zdep, val);
        ArrayList<Voxel3D> object = new ArrayList<Voxel3D>();
        object.add(new Voxel3D(xdep, ydep, zdep, val));
        int volume = 1;
        ImageHandler original = this.rawImage;
        int waterCenter = 0;
        int water = 0;
        while (change) {
            int k;
            change = false;
            int n = k = sens == 1 ? zdep : zEnd;
            while (sens == 1 && k <= zEnd || sens == -1 && k >= zdep) {
                int j;
                int n2 = j = sens == 1 ? ydep : yEnd;
                while (sens == 1 && j <= yEnd || sens == -1 && j >= ydep) {
                    int i;
                    int n3 = i = sens == 1 ? xdep : xEnd;
                    while (sens == 1 && i <= xEnd || sens == -1 && i >= xdep) {
                        if (this.labelImage.contains(i, j, k) && this.labelImage.getPixel(i, j, k) == (float)val) {
                            if (this.WATERSHED) {
                                waterCenter = this.watershedImage.getPixelInt(i, j, k);
                            }
                            for (int n4 = k - 1; n4 < k + 2; ++n4) {
                                for (int m = j - 1; m < j + 2; ++m) {
                                    for (int l = i - 1; l < i + 2; ++l) {
                                        if (!this.labelImage.contains(l, m, n4)) continue;
                                        if (this.WATERSHED) {
                                            water = this.watershedImage.getPixelInt(l, m, n4);
                                        }
                                        if (this.labelImage.getPixel(l, m, n4) != 0.0f || !(original.getPixel(l, m, n4) >= (float)lcThreshold) || water != waterCenter) continue;
                                        this.labelImage.setPixel(l, m, n4, val);
                                        object.add(new Voxel3D(l, m, n4, val));
                                        if (++volume > this.volMax) {
                                            if (this.show) {
                                                IJ.log((String)("VOL TOO BIG STOP SEG :" + volume));
                                            }
                                            return null;
                                        }
                                        if (l < xdep) {
                                            --xdep;
                                        }
                                        if (l > xEnd) {
                                            ++xEnd;
                                        }
                                        if (m < ydep) {
                                            --ydep;
                                        }
                                        if (m > yEnd) {
                                            ++yEnd;
                                        }
                                        if (n4 < zdep) {
                                            --zdep;
                                        }
                                        if (n4 > zEnd) {
                                            ++zEnd;
                                        }
                                        change = true;
                                    }
                                }
                            }
                        }
                        i += sens;
                    }
                    j += sens;
                }
                k += sens;
            }
            sens *= -1;
        }
        return object;
    }

    public ArrayList<Voxel3D> segmentSpotMax(int xdep, int ydep, int zdep, int lcThreshold, int val) {
        boolean changement = true;
        int xfin = xdep + 1;
        int yfin = ydep + 1;
        int zfin = zdep + 1;
        int sens = 1;
        if (this.labelImage == null) {
            this.createLabelImage();
        }
        if (this.labelImage.getPixel(xdep, ydep, zdep) > 0.0f) {
            return null;
        }
        this.labelImage.setPixel(xdep, ydep, zdep, val);
        ArrayList<Voxel3D> object = new ArrayList<Voxel3D>();
        object.add(new Voxel3D(xdep, ydep, zdep, val));
        ImageHandler original = this.rawImage;
        int waterCenter = 0;
        int water = 0;
        while (changement) {
            int k;
            changement = false;
            int n = k = sens == 1 ? zdep : zfin;
            while (sens == 1 && k <= zfin || sens == -1 && k >= zdep) {
                int j;
                int n2 = j = sens == 1 ? ydep : yfin;
                while (sens == 1 && j <= yfin || sens == -1 && j >= ydep) {
                    int i;
                    int n3 = i = sens == 1 ? xdep : xfin;
                    while (sens == 1 && i <= xfin || sens == -1 && i >= xdep) {
                        if (this.labelImage.contains(i, j, k) && this.labelImage.getPixel(i, j, k) == (float)val) {
                            if (this.WATERSHED) {
                                waterCenter = this.watershedImage.getPixelInt(i, j, k);
                            }
                            float pixelCenter = original.getPixel(i, j, k);
                            for (int n4 = k - 1; n4 < k + 2; ++n4) {
                                for (int m = j - 1; m < j + 2; ++m) {
                                    for (int l = i - 1; l < i + 2; ++l) {
                                        if (!this.labelImage.contains(l, m, n4)) continue;
                                        if (this.WATERSHED) {
                                            water = this.watershedImage.getPixelInt(l, m, n4);
                                        }
                                        if (this.labelImage.getPixel(l, m, n4) != 0.0f || !(original.getPixel(l, m, n4) >= (float)lcThreshold) || !(original.getPixel(l, m, n4) <= pixelCenter) || water != waterCenter) continue;
                                        this.labelImage.setPixel(l, m, n4, val);
                                        object.add(new Voxel3D(l, m, n4, val));
                                        if (l < xdep) {
                                            --xdep;
                                        }
                                        if (l > xfin) {
                                            ++xfin;
                                        }
                                        if (m < ydep) {
                                            --ydep;
                                        }
                                        if (m > yfin) {
                                            ++yfin;
                                        }
                                        if (n4 < zdep) {
                                            --zdep;
                                        }
                                        if (n4 > zfin) {
                                            ++zfin;
                                        }
                                        changement = true;
                                    }
                                }
                            }
                        }
                        i += sens;
                    }
                    j += sens;
                }
                k += sens;
            }
            sens *= -1;
        }
        return object;
    }

    public static Object3DVoxels[] splitSpotWatershed(Object3D obj, float rad, float dist) {
        ImageInt seg = obj.createSegImage(0, 0, 0, obj.getXmax() + 1, obj.getYmax() + 1, obj.getZmax() + 1, 255);
        ImagePlus segplus = seg.getImagePlus();
        segplus.setCalibration(obj.getCalibration());
        Object3DVoxels[] res = null;
        try {
            int cpus = ThreadUtil.getNbCpus();
            ImageFloat edt3d = EDT.run(seg, 1.0f, false, cpus);
            edt3d = FastFilters3D.filterFloatImage(edt3d, 0, 2.0f, 2.0f, 2.0f, cpus, false);
            ImageFloat maxlocal3d = FastFilters3D.filterFloatImage(edt3d, 4, rad, rad, rad, cpus, false);
            ArrayList<Voxel3D> locals = obj.listVoxels(maxlocal3d, 0.0);
            int nb = locals.size();
            if (nb < 2) {
                return null;
            }
            int i1 = 0;
            int i2 = 0;
            double dmax = 0.0;
            for (int i = 0; i < nb; ++i) {
                for (int j = i + 1; j < nb; ++j) {
                    double d = locals.get(i).distance(locals.get(j));
                    if (!(d > dmax)) continue;
                    dmax = d;
                    i1 = i;
                    i2 = j;
                }
            }
            double cx1 = 0.0;
            double cy1 = 0.0;
            double cz1 = 0.0;
            double cx2 = 0.0;
            double cy2 = 0.0;
            double cz2 = 0.0;
            Voxel3D PP1 = new Voxel3D(locals.get(i1).getX(), locals.get(i1).getY(), locals.get(i1).getZ(), 1.0);
            Voxel3D PP2 = new Voxel3D(locals.get(i2).getX(), locals.get(i2).getY(), locals.get(i2).getZ(), 2.0);
            Voxel3D P1 = new Voxel3D(cx1, cy1, cz1, 0.0);
            Voxel3D P2 = new Voxel3D(cx2, cy2, cz2, 0.0);
            int nbite = 0;
            while (nb > 2 && (P1.distance(PP1) > 1.0 || P2.distance(PP2) > 1.0) && nbite < 100) {
                ++nbite;
                cx1 = 0.0;
                cy1 = 0.0;
                cx2 = 0.0;
                cy2 = 0.0;
                cz1 = 0.0;
                cz2 = 0.0;
                int nb1 = 0;
                int nb2 = 0;
                P1.setX(PP1.getX());
                P1.setY(PP1.getY());
                P1.setZ(PP1.getZ());
                P2.setX(PP2.getX());
                P2.setY(PP2.getY());
                P2.setZ(PP2.getZ());
                for (Voxel3D local : locals) {
                    double d2;
                    double d1 = P1.distance(local);
                    if (d1 < (d2 = P2.distance(local))) {
                        cx1 += local.getX();
                        cy1 += local.getY();
                        cz1 += local.getZ();
                        ++nb1;
                        continue;
                    }
                    cx2 += local.getX();
                    cy2 += local.getY();
                    cz2 += local.getZ();
                    ++nb2;
                }
                cx2 /= (double)nb2;
                cy2 /= (double)nb2;
                cz2 /= (double)nb2;
                PP1.setX(cx1 /= (double)nb1);
                PP1.setY(cy1 /= (double)nb1);
                PP1.setZ(cz1 /= (double)nb1);
                PP2.setX(cx2);
                PP2.setY(cy2);
                PP2.setZ(cz2);
            }
            double distPP = PP1.distance(PP2);
            IJ.log((String)("Centers found for split PP1=" + PP1 + " PP2=" + PP2 + " distance " + distPP));
            if (distPP < (double)dist) {
                return null;
            }
            ImageShort seeds = new ImageShort("seeds", seg.sizeX, seg.sizeY, seg.sizeZ);
            ((ImageInt)seeds).setPixel(PP1.getRoundX(), PP1.getRoundY(), PP1.getRoundZ(), 255);
            ((ImageInt)seeds).setPixel(PP2.getRoundX(), PP2.getRoundY(), PP2.getRoundZ(), 255);
            ImageShort edt16 = edt3d.convertToShort(true);
            Watershed3D wat = new Watershed3D(edt16, seeds, 0, 0);
            ImageInt wat2 = wat.getWatershedImage3D();
            Object3DVoxels ob1 = new Object3DVoxels((ImageHandler)wat2, 2);
            Object3DVoxels ob2 = new Object3DVoxels((ImageHandler)wat2, 3);
            res = new Object3DVoxels[]{ob1, ob2};
        }
        catch (Exception e) {
            IJ.log((String)("Exception EDT " + e));
        }
        return res;
    }

    public Voxel3D getLocalMaximum(int x, int y, int z, float radx, float rady, float radz) {
        Voxel3D v = null;
        int sizex = this.rawImage.sizeX;
        int sizey = this.rawImage.sizeY;
        int sizez = this.rawImage.sizeZ;
        double vmax = Double.NEGATIVE_INFINITY;
        double rx2 = radx != 0.0f ? (double)(radx * radx) : 1.0;
        double ry2 = rady != 0.0f ? (double)(rady * rady) : 1.0;
        double rz2 = radz != 0.0f ? (double)(radz * radz) : 1.0;
        int vx = (int)Math.ceil(radx);
        int vy = (int)Math.ceil(rady);
        int vz = (int)Math.ceil(radz);
        for (int k = z - vz; k <= z + vz; ++k) {
            for (int j = y - vy; j <= y + vy; ++j) {
                for (int i = x - vx; i <= x + vx; ++i) {
                    double pix;
                    double dist;
                    if (i < 0 || j < 0 || k < 0 || i >= sizex || j >= sizey || k >= sizez || !((dist = (double)((x - i) * (x - i)) / rx2 + (double)((y - j) * (y - j)) / ry2 + (double)((z - k) * (z - k)) / rz2) <= 1.0) || !((pix = (double)this.rawImage.getPixel(i, j, k)) > vmax)) continue;
                    v = new Voxel3D(i, j, k, pix);
                    vmax = pix;
                }
            }
        }
        return v;
    }
}

