/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.activecontours;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import plugins.adufour.activecontours.ActiveContour;
import plugins.adufour.activecontours.TopologyException;
import plugins.fab.trackmanager.TrackGroup;
import plugins.fab.trackmanager.TrackSegment;
import plugins.nchenouard.spot.Detection;

public class ReSampler
implements Callable<Boolean> {
    private final TrackGroup trackGroup;
    private final ActiveContour contour;
    private final Set<ActiveContour> allContours;
    private final Set<ActiveContour> evolvingContours;

    ReSampler(TrackGroup trackGroup, ActiveContour contour, HashSet<ActiveContour> evolvingContours, HashSet<ActiveContour> allContours) {
        this.trackGroup = trackGroup;
        this.contour = contour;
        this.allContours = allContours;
        this.evolvingContours = evolvingContours;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() {
        boolean change = false;
        try {
            this.contour.reSample(0.6, 1.4);
        }
        catch (Exception e) {
            change = true;
            this.contour.clean();
            this.allContours.remove(this.contour);
            this.evolvingContours.remove(this.contour);
            TrackSegment currentSegment = null;
            TrackGroup trackGroup = this.trackGroup;
            synchronized (trackGroup) {
                for (TrackSegment track : this.trackGroup.getTrackSegmentList()) {
                    if (track == null || !track.containsDetection((Detection)this.contour)) continue;
                    currentSegment = track;
                    break;
                }
                if (currentSegment != null) {
                    currentSegment.removeDetection((Detection)this.contour);
                    if (currentSegment.getDetectionList().size() == 0) {
                        this.trackGroup.removeTrackSegment(currentSegment);
                        currentSegment = null;
                    }
                }
                if (!(e instanceof TopologyException)) {
                    e.printStackTrace();
                    return change;
                }
                ActiveContour[] children = ((TopologyException)e).children;
                if (children == null) {
                    return change;
                }
                for (ActiveContour child : children) {
                    child.setT(this.contour.getT());
                    this.allContours.add(child);
                    this.evolvingContours.add(child);
                    TrackSegment childSegment = new TrackSegment();
                    childSegment.addDetection((Detection)child);
                    TrackGroup trackGroup2 = this.trackGroup;
                    synchronized (trackGroup2) {
                        this.trackGroup.addTrackSegment(childSegment);
                    }
                    if (currentSegment == null) continue;
                    currentSegment.addNext(childSegment);
                }
            }
        }
        return change;
    }
}

