/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.ImagePlus;
import ij.Prefs;
import ij.gui.Line;
import ij.gui.ShapeRoi;
import ij.gui.Toolbar;
import ij.process.ImageProcessor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;

public class Arrow
extends Line {
    public static final String STYLE_KEY = "arrow.style";
    public static final String WIDTH_KEY = "arrow.width";
    public static final String SIZE_KEY = "arrow.size";
    public static final String DOUBLE_HEADED_KEY = "arrow.double";
    public static final String OUTLINE_KEY = "arrow.outline";
    public static final int FILLED = 0;
    public static final int NOTCHED = 1;
    public static final int OPEN = 2;
    public static final int HEADLESS = 3;
    public static final int BAR = 4;
    public static final String[] styles = new String[]{"Filled", "Notched", "Open", "Headless", "Bar"};
    private static int defaultStyle = (int)Prefs.get("arrow.style", 0.0);
    private static float defaultWidth = (float)Prefs.get("arrow.width", 2.0);
    private static double defaultHeadSize = (int)Prefs.get("arrow.size", 10.0);
    private static boolean defaultDoubleHeaded = Prefs.get("arrow.double", false);
    private static boolean defaultOutline = Prefs.get("arrow.outline", false);
    private int style;
    private double headSize = 10.0;
    private boolean doubleHeaded;
    private boolean outline;
    private float[] points = new float[10];
    private GeneralPath path = new GeneralPath();
    private static Stroke defaultStroke = new BasicStroke();
    double headShaftRatio;

    public Arrow(double ox1, double oy1, double ox2, double oy2) {
        super(ox1, oy1, ox2, oy2);
        this.setStrokeWidth(2.0f);
    }

    public Arrow(int sx, int sy, ImagePlus imp) {
        super(sx, sy, imp);
        this.setStrokeWidth(defaultWidth);
        this.style = defaultStyle;
        this.headSize = defaultHeadSize;
        this.doubleHeaded = defaultDoubleHeaded;
        this.outline = defaultOutline;
        this.setStrokeColor(Toolbar.getForegroundColor());
    }

    @Override
    public void draw(Graphics g) {
        Color color;
        Shape shape2 = null;
        if (this.doubleHeaded) {
            this.flipEnds();
            shape2 = this.getShape();
            this.flipEnds();
        }
        Shape shape = this.getShape();
        Color color2 = color = this.strokeColor != null ? this.strokeColor : ROIColor;
        if (this.fillColor != null) {
            color = this.fillColor;
        }
        g.setColor(color);
        Graphics2D g2 = (Graphics2D)g;
        this.setRenderingHint(g2);
        AffineTransform at = g2.getDeviceConfiguration().getDefaultTransform();
        double mag = this.getMagnification();
        int xbase = 0;
        int ybase = 0;
        if (this.ic != null) {
            Rectangle r = this.ic.getSrcRect();
            xbase = r.x;
            ybase = r.y;
        }
        at.setTransform(mag, 0.0, 0.0, mag, ((double)(-xbase) + 0.5) * mag, ((double)(-ybase) + 0.5) * mag);
        if (this.outline) {
            float lineWidth = (float)(this.getOutlineWidth() * mag);
            g2.setStroke(new BasicStroke(lineWidth, 0, 1));
            g2.draw(at.createTransformedShape(shape));
            if (this.doubleHeaded) {
                g2.draw(at.createTransformedShape(shape2));
            }
            g2.setStroke(defaultStroke);
        } else {
            g2.fill(at.createTransformedShape(shape));
            if (this.doubleHeaded) {
                g2.fill(at.createTransformedShape(shape2));
            }
        }
        if (!this.overlay) {
            this.handleColor = Color.white;
            this.drawHandle(g, this.screenXD(this.x1d), this.screenYD(this.y1d));
            this.drawHandle(g, this.screenXD(this.x2d), this.screenYD(this.y2d));
            this.drawHandle(g, this.screenXD(this.x1d + (this.x2d - this.x1d) / 2.0), this.screenYD(this.y1d + (this.y2d - this.y1d) / 2.0));
        }
        if (this.state != 3 && this.imp != null && this.imp.getRoi() != null) {
            this.showStatus();
        }
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
    }

    private void flipEnds() {
        double tmp = this.x1R;
        this.x1R = this.x2R;
        this.x2R = tmp;
        tmp = this.y1R;
        this.y1R = this.y2R;
        this.y2R = tmp;
    }

    private Shape getPath() {
        this.path.reset();
        this.path = new GeneralPath();
        this.calculatePoints();
        float tailx = this.points[0];
        float taily = this.points[1];
        float headbackx = this.points[2];
        float headbacky = this.points[3];
        float headtipx = this.points[6];
        float headtipy = this.points[7];
        if (this.outline) {
            double dx = headtipx - tailx;
            double dy = headtipy - taily;
            double shaftLength = Math.sqrt(dx * dx + dy * dy);
            dx = headtipx - headbackx;
            dy = headtipy - headbacky;
            double headLength = Math.sqrt(dx * dx + dy * dy);
            this.headShaftRatio = headLength / shaftLength;
            if (this.headShaftRatio > 1.0) {
                this.headShaftRatio = 1.0;
            }
        }
        this.path.moveTo(tailx, taily);
        this.path.lineTo(headbackx, headbacky);
        this.path.moveTo(headbackx, headbacky);
        if (this.style == 2) {
            this.path.moveTo(this.points[4], this.points[5]);
        } else {
            this.path.lineTo(this.points[4], this.points[5]);
        }
        this.path.lineTo(headtipx, headtipy);
        this.path.lineTo(this.points[8], this.points[9]);
        this.path.lineTo(headbackx, headbacky);
        return this.path;
    }

    private void calculatePoints() {
        double tip = 0.0;
        double shaftWidth = this.getStrokeWidth();
        double length = 8.0 + 10.0 * shaftWidth * 0.5;
        length *= this.headSize / 10.0;
        length -= shaftWidth * 1.42;
        if (this.style == 1) {
            length *= 0.74;
        }
        if (this.style == 2) {
            length *= 1.32;
        }
        if (length < 0.0 || this.style == 3) {
            length = 0.0;
        }
        double x = this.getXBase();
        double y = this.getYBase();
        this.x1d = x + this.x1R;
        this.y1d = y + this.y1R;
        this.x2d = x + this.x2R;
        this.y2d = y + this.y2R;
        this.x1 = (int)this.x1d;
        this.y1 = (int)this.y1d;
        this.x2 = (int)this.x2d;
        this.y2 = (int)this.y2d;
        double dx = this.x2d - this.x1d;
        double dy = this.y2d - this.y1d;
        double arrowLength = Math.sqrt(dx * dx + dy * dy);
        dx /= arrowLength;
        dy /= arrowLength;
        if (this.doubleHeaded && this.style != 3) {
            this.points[0] = (float)(this.x1d + dx * shaftWidth * 2.0);
            this.points[1] = (float)(this.y1d + dy * shaftWidth * 2.0);
        } else {
            this.points[0] = (float)this.x1d;
            this.points[1] = (float)this.y1d;
        }
        if (length > 0.0) {
            double factor = this.style == 2 ? 1.3 : 1.42;
            this.points[6] = (float)(this.x2d - dx * shaftWidth * factor);
            this.points[7] = (float)(this.y2d - dy * shaftWidth * factor);
            if (this.style == 4) {
                this.points[6] = (float)(this.x2d - dx * shaftWidth * 0.5);
                this.points[7] = (float)(this.y2d - dy * shaftWidth * 0.5);
            }
        } else {
            this.points[6] = (float)this.x2d;
            this.points[7] = (float)this.y2d;
        }
        double alpha = Math.atan2(this.points[7] - this.points[1], this.points[6] - this.points[0]);
        double SL = 0.0;
        switch (this.style) {
            case 0: 
            case 3: {
                tip = Math.toRadians(20.0);
                double base = Math.toRadians(90.0);
                this.points[2] = (float)((double)this.points[6] - length * Math.cos(alpha));
                this.points[3] = (float)((double)this.points[7] - length * Math.sin(alpha));
                SL = length * Math.sin(base) / Math.sin(base + tip);
                break;
            }
            case 1: {
                tip = Math.toRadians(20.0);
                double base = Math.toRadians(120.0);
                this.points[2] = (float)((double)this.points[6] - length * Math.cos(alpha));
                this.points[3] = (float)((double)this.points[7] - length * Math.sin(alpha));
                SL = length * Math.sin(base) / Math.sin(base + tip);
                break;
            }
            case 2: {
                tip = Math.toRadians(25.0);
                this.points[2] = this.points[6];
                this.points[3] = this.points[7];
                SL = length;
                break;
            }
            case 4: {
                tip = Math.toRadians(90.0);
                this.points[2] = this.points[6];
                this.points[3] = this.points[7];
                SL = length;
                this.updateFullWindow = true;
            }
        }
        this.points[4] = (float)((double)this.points[6] - SL * Math.cos(alpha + tip));
        this.points[5] = (float)((double)this.points[7] - SL * Math.sin(alpha + tip));
        this.points[8] = (float)((double)this.points[6] - SL * Math.cos(alpha - tip));
        this.points[9] = (float)((double)this.points[7] - SL * Math.sin(alpha - tip));
    }

    private Shape getShape() {
        Shape arrow = this.getPath();
        BasicStroke stroke = new BasicStroke(this.getStrokeWidth(), 0, 0);
        Shape outlineShape = stroke.createStrokedShape(arrow);
        Area a1 = new Area(arrow);
        Area a2 = new Area(outlineShape);
        try {
            a1.add(a2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return a1;
    }

    private ShapeRoi getShapeRoi() {
        Shape arrow = this.getPath();
        BasicStroke stroke = new BasicStroke(this.getStrokeWidth(), 0, 0);
        ShapeRoi sroi = new ShapeRoi(arrow);
        Shape outlineShape = stroke.createStrokedShape(arrow);
        sroi.or(new ShapeRoi(outlineShape));
        return sroi;
    }

    @Override
    public ImageProcessor getMask() {
        if (this.width == 0 && this.height == 0) {
            return null;
        }
        return this.getShapeRoi().getMask();
    }

    private double getOutlineWidth() {
        double head;
        double width = (double)this.getStrokeWidth() / 8.0;
        double lineWidth = width + (head = this.headSize / 7.0) + this.headShaftRatio;
        if (lineWidth < 1.0) {
            lineWidth = 1.0;
        }
        return lineWidth;
    }

    @Override
    public void drawPixels(ImageProcessor ip) {
        ShapeRoi shapeRoi = this.getShapeRoi();
        ShapeRoi shapeRoi2 = null;
        if (this.doubleHeaded) {
            this.flipEnds();
            shapeRoi2 = this.getShapeRoi();
            this.flipEnds();
        }
        if (this.outline) {
            int lineWidth = ip.getLineWidth();
            ip.setLineWidth((int)Math.round(this.getOutlineWidth()));
            shapeRoi.drawPixels(ip);
            if (this.doubleHeaded) {
                shapeRoi2.drawPixels(ip);
            }
            ip.setLineWidth(lineWidth);
        } else {
            ip.fill(shapeRoi);
            if (this.doubleHeaded) {
                ip.fill(shapeRoi2);
            }
        }
    }

    @Override
    public boolean contains(int x, int y) {
        return this.getShapeRoi().contains(x, y);
    }

    @Override
    public Rectangle getBounds() {
        return this.getShapeRoi().getBounds();
    }

    @Override
    protected void handleMouseDown(int sx, int sy) {
        super.handleMouseDown(sx, sy);
        this.startxd = this.ic != null ? this.ic.offScreenXD(sx) : (double)sx;
        this.startyd = this.ic != null ? this.ic.offScreenYD(sy) : (double)sy;
    }

    @Override
    protected int clipRectMargin() {
        double mag = this.getMagnification();
        double arrowWidth = this.getStrokeWidth();
        double size = 8.0 + 10.0 * arrowWidth * mag * 0.5;
        return (int)Math.max(size * 2.0, this.headSize);
    }

    @Override
    public boolean isDrawingTool() {
        return true;
    }

    public static void setDefaultWidth(double width) {
        defaultWidth = (float)width;
    }

    public static double getDefaultWidth() {
        return defaultWidth;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public void setStyle(String style) {
        style = style.toLowerCase();
        int newStyle = 0;
        if (style.contains("notched")) {
            newStyle = 1;
        } else if (style.contains("open")) {
            newStyle = 2;
        } else if (style.contains("headless")) {
            newStyle = 3;
        } else if (style.contains("bar")) {
            newStyle = 4;
        }
        this.setStyle(newStyle);
        this.setOutline(style.contains("outline"));
        this.setDoubleHeaded(style.contains("double"));
        if (style.contains("small")) {
            this.setHeadSize(5.0);
        } else if (style.contains("large")) {
            this.setHeadSize(15.0);
        }
    }

    public int getStyle() {
        return this.style;
    }

    public static void setDefaultStyle(int style) {
        defaultStyle = style;
    }

    public static int getDefaultStyle() {
        return defaultStyle;
    }

    public void setHeadSize(double headSize) {
        this.headSize = headSize;
    }

    public double getHeadSize() {
        return this.headSize;
    }

    public static void setDefaultHeadSize(double size) {
        defaultHeadSize = size;
    }

    public static double getDefaultHeadSize() {
        return defaultHeadSize;
    }

    public void setDoubleHeaded(boolean b) {
        this.doubleHeaded = b;
    }

    public boolean getDoubleHeaded() {
        return this.doubleHeaded;
    }

    public static void setDefaultDoubleHeaded(boolean b) {
        defaultDoubleHeaded = b;
    }

    public static boolean getDefaultDoubleHeaded() {
        return defaultDoubleHeaded;
    }

    public void setOutline(boolean b) {
        this.outline = b;
    }

    public boolean getOutline() {
        return this.outline;
    }

    public static void setDefaultOutline(boolean b) {
        defaultOutline = b;
    }

    public static boolean getDefaultOutline() {
        return defaultOutline;
    }

    static {
        if (defaultStyle < 0 || defaultStyle > 3) {
            defaultStyle = 0;
        }
    }
}

