/*
 * Decompiled with CFR 0.152.
 */
package ij.macro;

import ij.IJ;
import ij.macro.MacroConstants;

public class Variable
implements MacroConstants,
Cloneable {
    static final int VALUE = 0;
    static final int ARRAY = 1;
    static final int STRING = 2;
    int symTabIndex;
    private double value;
    private String str;
    private Variable[] array;
    private int arraySize;

    public Variable() {
    }

    public Variable(double value) {
        this.value = value;
    }

    public Variable(String str) {
        this.str = str;
    }

    public Variable(Variable[] array) {
        this.array = array;
    }

    Variable(int symTabIndex, double value, String str) {
        this.symTabIndex = symTabIndex;
        this.value = value;
        this.str = str;
    }

    Variable(int symTabIndex, double value, String str, Variable[] array) {
        this.symTabIndex = symTabIndex;
        this.value = value;
        this.str = str;
        this.array = array;
    }

    Variable(byte[] array) {
        this.array = new Variable[array.length];
        for (int i = 0; i < array.length; ++i) {
            this.array[i] = new Variable(array[i] & 0xFF);
        }
    }

    Variable(int[] array) {
        this.array = new Variable[array.length];
        for (int i = 0; i < array.length; ++i) {
            this.array[i] = new Variable(array[i]);
        }
    }

    Variable(double[] array) {
        this.array = new Variable[array.length];
        for (int i = 0; i < array.length; ++i) {
            this.array[i] = new Variable(array[i]);
        }
    }

    public double getValue() {
        if (this.str != null) {
            return this.convertToDouble();
        }
        return this.value;
    }

    double convertToDouble() {
        try {
            Double d = Double.valueOf(this.str);
            return d;
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    void setValue(double value) {
        this.value = value;
        this.str = null;
        this.array = null;
    }

    public String getString() {
        return this.str;
    }

    void setString(String str) {
        this.str = str;
        this.value = 0.0;
        this.array = null;
    }

    Variable[] getArray() {
        return this.array;
    }

    void setArray(Variable[] array) {
        this.array = array;
        this.value = 0.0;
        this.str = null;
        this.arraySize = 0;
    }

    void setArraySize(int size) {
        if (this.array == null) {
            size = 0;
        } else if (size > this.array.length) {
            size = this.array.length;
        }
        this.arraySize = size;
    }

    int getArraySize() {
        int size;
        int n = size = this.array != null ? this.array.length : 0;
        if (this.arraySize > 0) {
            size = this.arraySize;
        }
        return size;
    }

    int getType() {
        if (this.array != null) {
            return 1;
        }
        if (this.str != null) {
            return 2;
        }
        return 0;
    }

    public String toString() {
        String s = "";
        if (this.array != null) {
            s = s + "array[" + this.array.length + "]";
        } else if (this.str != null) {
            s = this.str;
            if (s.length() > 80) {
                s = s.substring(0, 80) + "...";
            }
            s = s.replaceAll("\n", " | ");
            s = "\"" + s + "\"";
        } else {
            s = this.value == (double)((int)this.value) ? s + (int)this.value : s + IJ.d2s(this.value, 4);
        }
        return s;
    }

    public synchronized Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

