/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.MiceProfiler;

import icy.canvas.Canvas2D;
import icy.canvas.IcyCanvas;
import icy.file.FileUtil;
import icy.gui.dialog.MessageDialog;
import icy.gui.frame.IcyFrame;
import icy.gui.util.GuiUtil;
import icy.gui.viewer.Viewer;
import icy.gui.viewer.ViewerEvent;
import icy.gui.viewer.ViewerListener;
import icy.image.IcyBufferedImage;
import icy.main.Icy;
import icy.painter.Overlay;
import icy.painter.Painter;
import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginImageAnalysis;
import icy.sequence.DimensionId;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import plugins.fab.MiceProfiler.LockScrollHelperOverlay;
import plugins.fab.MiceProfiler.ManualHelper;
import plugins.fab.MiceProfiler.MouseGuidePainter;
import plugins.fab.MiceProfiler.PhyMouse;
import plugins.fab.MiceProfiler.XugglerAviFile;

public class MiceProfilerTracker
extends Plugin
implements Painter,
PluginImageAnalysis,
ActionListener,
ChangeListener,
ViewerListener {
    IcyFrame mainFrame = null;
    JPanel mainPanel = GuiUtil.generatePanelWithoutBorder();
    PhyMouse phyMouse01A = null;
    JButton startButton = new JButton("Start");
    JButton trackAllButton = new JButton("<html><br><b>Track All Start</b><br><br></html>");
    JButton stopTrackAllButton = new JButton("<html><br><b>Track All Stop</b><br><br></html>");
    JButton start2Button = new JButton("Start (step)");
    Point mousePoint = new Point(100, 100);
    Animator animator = new Animator();
    JButton startThreadStepButton = new JButton("Start Step Anim");
    JButton stopThreadStepButton = new JButton("Stop Step Anim");
    JButton readPositionFromROIButton = new JButton("Read starting position from Line ROI.");
    JCheckBox limitTrackingSpeedCheckBox = new JCheckBox("Limit tracking speed to 15fps");
    JComboBox mouseColorComboBox = new JComboBox<String>(new String[]{"Track black mice", "Track white mice"});
    JCheckBox updatePhysicsGuidesCheckBox = new JCheckBox("update phys. guides", true);
    JButton previousFrame = new JButton("Previous Frame");
    JButton nextFrame = new JButton("Next Frame");
    JButton previous10Frame = new JButton("Previous 10 Frame");
    JButton next10Frame = new JButton("Next 10 Frame");
    JButton divPer2Button = new JButton("Div per 2 fps");
    JCheckBox useTotalSystemEnergyStopConditionBox = new JCheckBox("use total system energy stop condition", true);
    JCheckBox useImageBufferOptimisation = new JCheckBox("Use image load optimisation", true);
    JTextField numberOfImageForBufferTextField = new JTextField("200");
    JLabel bufferValue = new JLabel("0%");
    JButton setVideoSourceButton = new JButton("Click to set/change video source");
    JLabel currentTimeLabel = new JLabel("current time");
    JLabel lastFrameLoadTime = new JLabel("lastFrameLoadTime");
    JLabel lastFramePhysicTime = new JLabel("lastFramePhysicTime");
    JLabel lastFrameForceMapTime = new JLabel("lastFrameForceMapTime");
    JLabel totalImageTime = new JLabel("time last image");
    JButton reverseTrackFromTButton = new JButton("Reverse Identity (from now to end of sequence)");
    JSlider sliderTime = new JSlider();
    JButton saveXMLButton = new JButton("Save XML Data");
    JButton loadXMLButton = new JButton("Load XML Data");
    int ITERATION = 50;
    Sequence sequenceOut;
    XugglerAviFile aviFile;
    int currentFrame = 0;
    MouseGuidePainter mouseGuidePainter;
    Timer checkBufferTimer = new Timer(1000, this);
    ManualHelper manualHelperA;
    ManualHelper manualHelperB;
    TrackAllThread trackAllThread = null;
    StepThread stepThread = null;
    File currentFile = null;
    ImageBufferThread bufferThread;

    public void compute() {
        this.stopTrackAllButton.setEnabled(false);
        BufferedImage bImage = new BufferedImage(400, 400, 5);
        this.sequenceOut = new Sequence();
        this.sequenceOut.setImage(0, 0, bImage);
        this.addSequence(this.sequenceOut);
        this.sequenceOut.removeAllImages();
        System.out.println("----------");
        System.out.println("Mice Profiler / Fab / Version 7");
        System.out.println("Red mice: occupante /// Green: visiteur");
        this.phyMouse01A = new PhyMouse(this.sequenceOut);
        this.mainFrame = new IcyFrame("Mice Profiler", true, true, true, true);
        this.mainFrame.setLayout((LayoutManager)new BorderLayout());
        this.mainFrame.add((Component)this.mainPanel, (Object)"Center");
        JPanel videoPanel = GuiUtil.generatePanel((String)"Video Settings");
        videoPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{this.setVideoSourceButton}));
        videoPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{this.sliderTime}));
        videoPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{this.useImageBufferOptimisation, this.numberOfImageForBufferTextField}));
        videoPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{new JLabel("Current buffer:"), this.bufferValue}));
        videoPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{this.previousFrame, this.nextFrame}));
        videoPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{this.previous10Frame, this.next10Frame}));
        videoPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{this.updatePhysicsGuidesCheckBox}));
        this.previousFrame.addActionListener(this);
        this.nextFrame.addActionListener(this);
        this.previous10Frame.addActionListener(this);
        this.next10Frame.addActionListener(this);
        videoPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{this.currentTimeLabel}));
        this.sliderTime.setMajorTickSpacing(1000);
        this.sliderTime.setPaintTicks(true);
        this.sliderTime.setPaintTrack(true);
        this.sliderTime.addChangeListener(this);
        this.mainPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{videoPanel}));
        this.mainPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{this.trackAllButton, this.stopTrackAllButton}));
        this.mainPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{this.readPositionFromROIButton}));
        this.mainPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{this.saveXMLButton}));
        this.mainPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{this.limitTrackingSpeedCheckBox}));
        this.mainPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{this.mouseColorComboBox}));
        this.mainPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{this.reverseTrackFromTButton}));
        this.mainPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{this.phyMouse01A.getPanel()}));
        this.mainPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{this.startThreadStepButton, this.stopThreadStepButton}));
        this.mainPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{this.lastFramePhysicTime, this.lastFrameLoadTime}));
        this.mainPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{this.lastFrameForceMapTime, this.totalImageTime}));
        this.mouseColorComboBox.addActionListener(this);
        this.saveXMLButton.addActionListener(this);
        this.loadXMLButton.setEnabled(false);
        this.stopTrackAllButton.addActionListener(this);
        this.setVideoSourceButton.addActionListener(this);
        this.readPositionFromROIButton.addActionListener(this);
        this.startButton.addActionListener(this);
        this.start2Button.addActionListener(this);
        this.trackAllButton.addActionListener(this);
        this.startThreadStepButton.addActionListener(this);
        this.stopThreadStepButton.addActionListener(this);
        this.stopThreadStepButton.setEnabled(false);
        this.reverseTrackFromTButton.addActionListener(this);
        this.mainFrame.pack();
        this.mainFrame.center();
        this.mainFrame.setVisible(true);
        this.mainFrame.addToMainDesktopPane();
        this.sequenceOut.addPainter((Painter)this);
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Viewer v = Icy.getMainInterface().getFirstViewer(MiceProfilerTracker.this.sequenceOut);
                if (v != null) {
                    v.addListener((ViewerListener)MiceProfilerTracker.this);
                }
            }
        });
        this.checkBufferTimer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPositionFromROI() {
        PhyMouse phyMouse = this.phyMouse01A;
        synchronized (phyMouse) {
            this.phyMouse01A.mouseList.clear();
            this.phyMouse01A.bodyList.clear();
            this.phyMouse01A.distanceJointList.clear();
            this.phyMouse01A.slideJointList.clear();
            this.phyMouse01A.world.clear();
            float alpha = (float)Math.atan2(this.mouseGuidePainter.M1h.getY() - this.mouseGuidePainter.M1b.getY(), this.mouseGuidePainter.M1h.getX() - this.mouseGuidePainter.M1b.getX());
            this.phyMouse01A.generateMouse((float)this.mouseGuidePainter.M1h.getX(), (float)this.mouseGuidePainter.M1h.getY(), alpha + 1.5707964f);
            alpha = (float)Math.atan2(this.mouseGuidePainter.M2h.getY() - this.mouseGuidePainter.M2b.getY(), this.mouseGuidePainter.M2h.getX() - this.mouseGuidePainter.M2b.getX());
            this.phyMouse01A.generateMouse((float)this.mouseGuidePainter.M2h.getX(), (float)this.mouseGuidePainter.M2h.getY(), alpha + 1.5707964f);
            this.phyMouse01A.recordMousePosition(this.sliderTime.getValue());
        }
        this.sequenceOut.painterChanged(null);
    }

    public void keyPressed(Point p, KeyEvent e) {
    }

    public void mouseClick(Point p, MouseEvent e) {
    }

    public void mouseDrag(Point p, MouseEvent e) {
    }

    public void mouseMove(Point p, MouseEvent e) {
        this.mousePoint = p;
    }

    private void saveXML() {
        String directory = FileUtil.getDirectory((String)this.currentFile.getAbsolutePath().toString());
        directory = directory + "/xml tracking backup";
        FileUtil.createDir((String)directory);
        String backupFileName = FileUtil.getFileName((String)this.currentFile.getAbsolutePath().toString(), (boolean)false);
        backupFileName = backupFileName + " " + new Date().toString();
        backupFileName = backupFileName.replace(":", "_");
        String backupFullName = directory + "/" + backupFileName;
        this.phyMouse01A.saveXML(new File(backupFullName));
        this.phyMouse01A.saveXML(this.currentFile);
    }

    private void displayImageAt(int frameNumber) {
        if (this.aviFile != null) {
            this.currentFrame = frameNumber;
            this.phyMouse01A.currentFrame = frameNumber;
            if (this.sequenceOut.getImage(frameNumber, 0) == null) {
                boolean wasEmpty = this.sequenceOut.getNumImage() == 0;
                this.sequenceOut.setImage(frameNumber, 0, this.aviFile.getImage(frameNumber));
                if (wasEmpty) {
                    for (Viewer viewer : this.sequenceOut.getViewers()) {
                        if (!(viewer.getCanvas() instanceof Canvas2D)) continue;
                        ((Canvas2D)viewer.getCanvas()).centerImage();
                    }
                }
            }
            String timeString = "";
            timeString = timeString + "(#frame): " + frameNumber + "/" + this.aviFile.getTotalNumberOfFrame() + " " + this.aviFile.getTimeForFrame(frameNumber);
            this.currentTimeLabel.setText(timeString);
        }
    }

    public void displayRelativeFrame(int nbFrame) {
        this.sliderTime.setValue(this.sliderTime.getValue() + nbFrame);
    }

    public void startTrackAll() {
        this.readPositionFromROI();
        this.trackAllThread = new TrackAllThread();
        this.trackAllThread.start();
        this.stopTrackAllButton.setEnabled(true);
        this.trackAllButton.setEnabled(false);
        this.startThreadStepButton.setEnabled(false);
        this.readPositionFromROIButton.setEnabled(false);
    }

    public void stopTrackAll() {
        this.trackAllThread.shouldRun = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        IcyBufferedImage imageSource;
        if (e.getSource() == this.checkBufferTimer && this.bufferThread != null) {
            int bufferPercent = this.bufferThread.getCurrentBufferLoadPercent();
            this.bufferValue.setText(bufferPercent + " %");
        }
        if (e.getSource() == this.previousFrame) {
            this.displayRelativeFrame(-1);
        }
        if (e.getSource() == this.nextFrame) {
            this.displayRelativeFrame(1);
        }
        if (e.getSource() == this.saveXMLButton) {
            this.saveXML();
        }
        if (e.getSource() == this.previous10Frame) {
            this.displayRelativeFrame(-10);
        }
        if (e.getSource() == this.next10Frame) {
            this.displayRelativeFrame(10);
        }
        if (e.getSource() == this.startButton) {
            IcyBufferedImage imageSourceR;
            this.sliderTime.setValue(1 + this.sliderTime.getValue());
            imageSource = imageSourceR = this.sequenceOut.getImage(0, 0);
            PhyMouse phyMouse = this.phyMouse01A;
            synchronized (phyMouse) {
                this.phyMouse01A.computeForcesMap(imageSource);
            }
            for (int i = 0; i < this.ITERATION; ++i) {
                PhyMouse phyMouse2 = this.phyMouse01A;
                synchronized (phyMouse2) {
                    this.phyMouse01A.computeForces();
                    this.phyMouse01A.worldStep(this.currentFrame);
                    continue;
                }
            }
            this.sequenceOut.painterChanged(null);
        }
        if (e.getSource() == this.divPer2Button) {
            this.phyMouse01A.divideTimePer2();
        }
        if (e.getSource() == this.setVideoSourceButton) {
            JFileChooser fileChooser = new JFileChooser();
            String node = "plugins/PhysicTracker/browser";
            Preferences preferences = Preferences.userRoot().node("plugins/PhysicTracker/browser");
            String path = preferences.get("path", "");
            fileChooser.setCurrentDirectory(new File(path));
            int x = preferences.getInt("x", 0);
            int y = preferences.getInt("y", 0);
            int width = preferences.getInt("width", 400);
            int height = preferences.getInt("height", 400);
            fileChooser.setLocation(x, y);
            fileChooser.setPreferredSize(new Dimension(width, height));
            int returnValue = fileChooser.showDialog(null, "Load");
            if (returnValue == 0) {
                preferences.put("path", fileChooser.getCurrentDirectory().getAbsolutePath());
                preferences.putInt("x", fileChooser.getX());
                preferences.putInt("y", fileChooser.getY());
                preferences.putInt("width", fileChooser.getWidth());
                preferences.putInt("height", fileChooser.getHeight());
                try {
                    this.aviFile = new XugglerAviFile(fileChooser.getSelectedFile().getAbsolutePath(), true);
                }
                catch (Exception exc) {
                    MessageDialog.showDialog((String)"File type or video-codec not supported.", (int)0);
                    this.aviFile = null;
                    return;
                }
                this.sequenceOut.removeAllImages();
                this.sequenceOut.setName(fileChooser.getSelectedFile().getName());
                this.displayImageAt(0);
                this.sliderTime.setMaximum((int)this.aviFile.getTotalNumberOfFrame());
                this.sliderTime.setValue(0);
                this.setVideoSourceButton.setText(fileChooser.getSelectedFile().getName());
                this.currentFile = fileChooser.getSelectedFile();
                this.phyMouse01A.loadXML(this.currentFile);
                if (this.bufferThread != null) {
                    this.bufferThread.pleaseStop = true;
                    try {
                        this.bufferThread.join();
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
                this.bufferThread = new ImageBufferThread();
                this.bufferThread.setName("Buffer Thread");
                this.bufferThread.setPriority(5);
                this.bufferThread.start();
                this.useImageBufferOptimisation.setEnabled(false);
                this.numberOfImageForBufferTextField.setEnabled(false);
                PhyMouse phyMouse = this.phyMouse01A;
                synchronized (phyMouse) {
                    this.phyMouse01A.generateMouse(246.0f, 48.0f, 0.0f);
                    this.phyMouse01A.generateMouse(238.0f, 121.0f, (float)Math.PI);
                }
                this.manualHelperA = new ManualHelper("Manual Helper", Color.red, 1, this.sequenceOut);
                this.manualHelperB = new ManualHelper("Manual Helper", Color.green, 2, this.sequenceOut);
                this.sequenceOut.addOverlay((Overlay)this.manualHelperA);
                this.sequenceOut.addOverlay((Overlay)this.manualHelperB);
                this.sequenceOut.addOverlay((Overlay)new LockScrollHelperOverlay());
                this.mouseGuidePainter = new MouseGuidePainter(this.sequenceOut, false);
            }
        }
        if (e.getSource() == this.trackAllButton) {
            this.startTrackAll();
        }
        if (e.getSource() == this.stopTrackAllButton) {
            this.stopTrackAll();
        }
        if (e.getSource() == this.startThreadStepButton) {
            this.startThreadStepButton.setEnabled(false);
            this.trackAllButton.setEnabled(false);
            this.stopThreadStepButton.setEnabled(true);
            this.readPositionFromROIButton.setEnabled(false);
            this.stepThread = new StepThread();
            this.stepThread.start();
        }
        if (e.getSource() == this.stopThreadStepButton) {
            this.stepThread.shouldRun = false;
            this.startThreadStepButton.setEnabled(true);
            this.trackAllButton.setEnabled(true);
            this.stopThreadStepButton.setEnabled(false);
            this.readPositionFromROIButton.setEnabled(true);
        }
        if (e.getSource() == this.mouseColorComboBox) {
            boolean reverseThresholdBoolean = this.mouseColorComboBox.getSelectedIndex() == 1;
            System.out.println("Setting mouse color: " + this.mouseColorComboBox.getSelectedIndex());
            this.phyMouse01A.setReverseThreshold(reverseThresholdBoolean);
        }
        if (e.getSource() == this.readPositionFromROIButton) {
            this.readPositionFromROI();
        }
        if (e.getSource() == this.start2Button) {
            IcyBufferedImage imageSourceR;
            imageSource = imageSourceR = this.sequenceOut.getImage(this.currentFrame, 0);
            this.phyMouse01A.computeForcesMap(imageSource);
            this.phyMouse01A.computeForces();
            this.phyMouse01A.worldStep(this.currentFrame);
            this.sequenceOut.painterChanged(null);
        }
        if (e.getSource() == this.reverseTrackFromTButton) {
            this.phyMouse01A.swapIdentityRecordFromTToTheEnd(this.sliderTime.getValue());
            this.sequenceOut.painterChanged(null);
        }
    }

    public void keyPressed(KeyEvent e, Point2D imagePoint, IcyCanvas quiaCanvas) {
        if (e.getKeyCode() == 37) {
            this.displayRelativeFrame(-1);
            e.consume();
        }
        if (e.getKeyCode() == 39) {
            this.displayRelativeFrame(1);
            e.consume();
        }
        if (e.getKeyCode() == 40) {
            this.displayRelativeFrame(-10);
            e.consume();
        }
        if (e.getKeyCode() == 38) {
            this.displayRelativeFrame(10);
            e.consume();
        }
        if (e.getKeyCode() == 32) {
            if (this.trackAllThread == null) {
                this.startTrackAll();
            } else if (!this.trackAllThread.shouldRun) {
                this.startTrackAll();
            } else {
                this.stopTrackAll();
            }
            e.consume();
        }
        if (e.getKeyChar() == 'r') {
            this.readPositionFromROI();
            this.displayRelativeFrame(1);
            this.readPositionFromROI();
            e.consume();
        }
    }

    public void mouseClick(MouseEvent e, Point2D p, IcyCanvas quiaCanvas) {
    }

    public void mouseDrag(MouseEvent e, Point2D p, IcyCanvas quiaCanvas) {
    }

    public void mouseMove(MouseEvent e, Point2D p, IcyCanvas quiaCanvas) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
        PhyMouse phyMouse = this.phyMouse01A;
        synchronized (phyMouse) {
            this.phyMouse01A.paint(g, canvas);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.sliderTime) {
            Viewer v = Icy.getMainInterface().getFirstViewer(this.sequenceOut);
            if (v != null) {
                v.setT(this.sliderTime.getValue());
            }
            this.displayImageAt(this.sliderTime.getValue());
            if (this.trackAllButton.isEnabled()) {
                PhyMouse.MouseInfoRecord record = this.phyMouse01A.mouseARecord.get(this.sliderTime.getValue());
                if (record != null) {
                    this.mouseGuidePainter.M1h.setPosition(record.headPosition);
                    this.mouseGuidePainter.M1b.setPosition(record.tailPosition);
                }
                if ((record = this.phyMouse01A.mouseBRecord.get(this.sliderTime.getValue())) != null) {
                    this.mouseGuidePainter.M2h.setPosition(record.headPosition);
                    this.mouseGuidePainter.M2b.setPosition(record.tailPosition);
                }
            }
        }
    }

    public void keyReleased(KeyEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    public void mousePressed(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    public void mouseReleased(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    public void viewerChanged(ViewerEvent event) {
        if (event.getType() == ViewerEvent.ViewerEventType.POSITION_CHANGED && event.getDim() == DimensionId.T) {
            this.sliderTime.setValue(event.getSource().getPositionT());
        }
    }

    public void viewerClosed(Viewer viewer) {
    }

    class Animator
    extends Thread {
        Animator() {
        }

        @Override
        public void run() {
            while (true) {
                Point bodyPoint = new Point((int)MiceProfilerTracker.this.phyMouse01A.getBodyList().get(0).getLastPosition().getX(), (int)MiceProfilerTracker.this.phyMouse01A.getBodyList().get(0).getLastPosition().getY());
                MiceProfilerTracker.this.phyMouse01A.getBodyList().get(0).setForce(100 * (MiceProfilerTracker.this.mousePoint.x - bodyPoint.x), 100 * (MiceProfilerTracker.this.mousePoint.y - bodyPoint.y));
                MiceProfilerTracker.this.phyMouse01A.worldStep(MiceProfilerTracker.this.currentFrame);
                MiceProfilerTracker.this.sequenceOut.painterChanged(null);
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    class TrackAllThread
    extends Thread {
        public boolean shouldRun = true;

        TrackAllThread() {
        }

        @Override
        public void run() {
            Calendar cal = Calendar.getInstance();
            double msStart = cal.getTimeInMillis();
            for (int t = MiceProfilerTracker.this.sliderTime.getValue(); t < MiceProfilerTracker.this.sliderTime.getMaximum(); ++t) {
                MiceProfilerTracker.this.currentFrame = t;
                double totalImageTimerStart = Calendar.getInstance().getTimeInMillis();
                if (!this.shouldRun) {
                    ThreadUtil.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MiceProfilerTracker.this.stopTrackAllButton.setEnabled(false);
                            MiceProfilerTracker.this.trackAllButton.setEnabled(true);
                            MiceProfilerTracker.this.startThreadStepButton.setEnabled(true);
                            MiceProfilerTracker.this.readPositionFromROIButton.setEnabled(true);
                        }
                    });
                    return;
                }
                MiceProfilerTracker.this.sliderTime.setValue(t);
                IcyBufferedImage imageSourceR = MiceProfilerTracker.this.sequenceOut.getImage(t, 0);
                while (imageSourceR == null) {
                    imageSourceR = MiceProfilerTracker.this.sequenceOut.getImage(t, 0);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (this.shouldRun) continue;
                    MiceProfilerTracker.this.stopTrackAllButton.setEnabled(false);
                    MiceProfilerTracker.this.trackAllButton.setEnabled(true);
                    MiceProfilerTracker.this.startThreadStepButton.setEnabled(true);
                    MiceProfilerTracker.this.readPositionFromROIButton.setEnabled(true);
                    return;
                }
                IcyBufferedImage imageSource = null;
                imageSource = imageSourceR;
                double frameForceMapTimerStart = Calendar.getInstance().getTimeInMillis();
                MiceProfilerTracker.this.phyMouse01A.setHeadLocation(0, MiceProfilerTracker.this.manualHelperA.getControlPoint(MiceProfilerTracker.this.sliderTime.getValue()));
                MiceProfilerTracker.this.phyMouse01A.setHeadLocation(1, MiceProfilerTracker.this.manualHelperB.getControlPoint(MiceProfilerTracker.this.sliderTime.getValue()));
                MiceProfilerTracker.this.phyMouse01A.computeForcesMap(imageSource);
                for (int i = 0; !(i >= MiceProfilerTracker.this.ITERATION || MiceProfilerTracker.this.useTotalSystemEnergyStopConditionBox.isSelected() && i > 3 && MiceProfilerTracker.this.phyMouse01A.isStable()); ++i) {
                    MiceProfilerTracker.this.phyMouse01A.computeForces();
                    MiceProfilerTracker.this.phyMouse01A.worldStep(t);
                }
                MiceProfilerTracker.this.phyMouse01A.applyMotionPrediction();
                this.updateMouseGuidePainter();
                double totalImageMs = (double)Calendar.getInstance().getTimeInMillis() - totalImageTimerStart;
                MiceProfilerTracker.this.totalImageTime.setText("total image time: " + totalImageMs + " ms / FPS: " + (double)((int)(10000.0 / totalImageMs)) / 10.0);
                if (!MiceProfilerTracker.this.limitTrackingSpeedCheckBox.isSelected()) continue;
                try {
                    Thread.sleep(66L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            cal = Calendar.getInstance();
            double msEnd = cal.getTimeInMillis();
            double fps = 0.0;
            MiceProfilerTracker.this.stopTrackAllButton.setEnabled(false);
            MiceProfilerTracker.this.trackAllButton.setEnabled(true);
            MiceProfilerTracker.this.startThreadStepButton.setEnabled(true);
            MiceProfilerTracker.this.readPositionFromROIButton.setEnabled(true);
        }

        private void updateMouseGuidePainter() {
            MiceProfilerTracker.this.mouseGuidePainter.setVisible(MiceProfilerTracker.this.updatePhysicsGuidesCheckBox.isSelected());
            MiceProfilerTracker.this.mouseGuidePainter.M1h.moveTo((double)((int)MiceProfilerTracker.this.phyMouse01A.mouseList.get((int)0).headBody.getPosition().getX()), (double)((int)MiceProfilerTracker.this.phyMouse01A.mouseList.get((int)0).headBody.getPosition().getY()));
            MiceProfilerTracker.this.mouseGuidePainter.M1b.moveTo((double)((int)MiceProfilerTracker.this.phyMouse01A.mouseList.get((int)0).tail.getPosition().getX()), (double)((int)MiceProfilerTracker.this.phyMouse01A.mouseList.get((int)0).tail.getPosition().getY()));
            if (MiceProfilerTracker.this.phyMouse01A.mouseList.size() > 1) {
                MiceProfilerTracker.this.mouseGuidePainter.M2h.moveTo((double)((int)MiceProfilerTracker.this.phyMouse01A.mouseList.get((int)1).headBody.getPosition().getX()), (double)((int)MiceProfilerTracker.this.phyMouse01A.mouseList.get((int)1).headBody.getPosition().getY()));
                MiceProfilerTracker.this.mouseGuidePainter.M2b.moveTo((double)((int)MiceProfilerTracker.this.phyMouse01A.mouseList.get((int)1).tail.getPosition().getX()), (double)((int)MiceProfilerTracker.this.phyMouse01A.mouseList.get((int)1).tail.getPosition().getY()));
            }
        }
    }

    class StepThread
    extends Thread {
        public boolean shouldRun = true;

        StepThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.shouldRun) {
                IcyBufferedImage imageSourceR = null;
                while (imageSourceR == null) {
                    imageSourceR = MiceProfilerTracker.this.sequenceOut.getImage(MiceProfilerTracker.this.currentFrame, 0);
                }
                IcyBufferedImage imageSource = imageSourceR;
                MiceProfilerTracker.this.phyMouse01A.computeForcesMap(imageSource);
                PhyMouse phyMouse = MiceProfilerTracker.this.phyMouse01A;
                synchronized (phyMouse) {
                    MiceProfilerTracker.this.phyMouse01A.computeForces();
                    MiceProfilerTracker.this.phyMouse01A.worldStep(MiceProfilerTracker.this.currentFrame);
                }
                MiceProfilerTracker.this.sequenceOut.painterChanged(null);
            }
        }
    }

    class ImageBufferThread
    extends Thread {
        public boolean pleaseStop = false;
        boolean bufferOn = true;
        int fenetre;

        ImageBufferThread() {
            this.fenetre = Integer.parseInt(MiceProfilerTracker.this.numberOfImageForBufferTextField.getText());
        }

        int getCurrentBufferLoadPercent() {
            int currentBufferPercent = 0;
            int frameStart = MiceProfilerTracker.this.currentFrame - 10;
            int frameEnd = MiceProfilerTracker.this.currentFrame + this.fenetre;
            float nbImage = 0.0f;
            float nbImageLoaded = 0.0f;
            for (int t = frameStart; t < frameEnd; ++t) {
                if (t < 0 || (long)t >= MiceProfilerTracker.this.aviFile.getTotalNumberOfFrame()) continue;
                nbImage += 1.0f;
                if (MiceProfilerTracker.this.sequenceOut.getImage(t, 0) == null) continue;
                nbImageLoaded += 1.0f;
            }
            currentBufferPercent = (int)(nbImageLoaded * 100.0f / nbImage);
            return currentBufferPercent;
        }

        @Override
        public void run() {
            try {
                block2: while (!this.pleaseStop) {
                    int t;
                    ThreadUtil.sleep((int)100);
                    if (!this.bufferOn) continue;
                    int cachedCurrentFrame = MiceProfilerTracker.this.currentFrame;
                    int frameStart = MiceProfilerTracker.this.currentFrame - 10;
                    int frameEnd = MiceProfilerTracker.this.currentFrame + this.fenetre;
                    if (frameStart < 0) {
                        frameStart = 0;
                    }
                    if ((long)frameEnd > MiceProfilerTracker.this.aviFile.getTotalNumberOfFrame()) {
                        frameEnd = (int)MiceProfilerTracker.this.aviFile.getTotalNumberOfFrame();
                    }
                    for (t = 0; t < MiceProfilerTracker.this.sequenceOut.getSizeT() - 1; ++t) {
                        if (Math.abs(t - MiceProfilerTracker.this.currentFrame) <= this.fenetre + 10) continue;
                        if (cachedCurrentFrame != MiceProfilerTracker.this.currentFrame) break;
                        if (this.pleaseStop) {
                            return;
                        }
                        MiceProfilerTracker.this.sequenceOut.removeImage(t, 0);
                    }
                    for (t = frameStart; t < frameEnd; ++t) {
                        if (MiceProfilerTracker.this.sequenceOut.getImage(t, 0) == null) {
                            MiceProfilerTracker.this.sequenceOut.setImage(t, 0, MiceProfilerTracker.this.aviFile.getImage(t));
                        }
                        if (cachedCurrentFrame != MiceProfilerTracker.this.currentFrame) continue block2;
                        if (!this.pleaseStop) continue;
                        return;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

