/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.jpeg2000.I18N;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriteParamJava;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriter;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.image.DataBlkInt;

public class RenderedImageSrc
implements BlkImgDataSrc {
    private int w;
    private int h;
    int tileWidth;
    int tileHeight;
    int tileXOffset;
    int tileYOffset;
    int scaleX;
    int scaleY;
    int xOffset;
    int yOffset;
    int[] sourceBands = null;
    int minX;
    int minY;
    private int nc;
    private int rb;
    private int[][] barr = null;
    private DataBlkInt dbi = new DataBlkInt();
    private byte[] buf;
    private DataBlkInt intBlk;
    private RenderedImage src;
    private J2KImageWriteParamJava param;
    private Raster raster;
    private Raster aTile;
    private Point co = new Point();
    private int dcOffset = 0;
    private boolean isBinary = false;
    private Rectangle destinationRegion;
    private Rectangle sourceRegion;
    private ColorModel cm;
    private SampleModel sm;
    private boolean noTransform = true;
    private boolean noSubband = true;
    private J2KImageWriter writer;
    private boolean inputIsRaster = false;

    public RenderedImageSrc(Raster raster, J2KImageWriteParamJava param, J2KImageWriter writer) {
        this.raster = raster;
        this.param = param;
        this.writer = writer;
        this.inputIsRaster = true;
        this.sourceRegion = param.getSourceRegion();
        this.sourceRegion = this.sourceRegion == null ? new Rectangle(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight()) : this.sourceRegion.intersection(raster.getBounds());
        if (this.sourceRegion.isEmpty()) {
            throw new RuntimeException(I18N.getString("J2KImageWriterCodecLib0"));
        }
        this.sm = raster.getSampleModel();
        this.getFromParam();
        this.setSampleModelAndMore();
        this.setTile(0, 0);
    }

    public RenderedImageSrc(RenderedImage src, J2KImageWriteParamJava param, J2KImageWriter writer) {
        this.src = src;
        this.param = param;
        this.writer = writer;
        this.sourceRegion = param.getSourceRegion();
        this.sourceRegion = this.sourceRegion == null ? new Rectangle(src.getMinX(), src.getMinY(), src.getWidth(), src.getHeight()) : this.sourceRegion.intersection(new Rectangle(src.getMinX(), src.getMinY(), src.getWidth(), src.getHeight()));
        if (this.sourceRegion.isEmpty()) {
            throw new RuntimeException(I18N.getString("J2KImageWriterCodecLib0"));
        }
        this.sm = src.getSampleModel();
        this.cm = src.getColorModel();
        this.getFromParam();
        this.setSampleModelAndMore();
    }

    private void getFromParam() {
        try {
            this.tileWidth = this.param.getTileWidth();
            this.tileHeight = this.param.getTileHeight();
            this.tileXOffset = this.param.getTileGridXOffset();
            this.tileYOffset = this.param.getTileGridYOffset();
        }
        catch (IllegalStateException e) {
            this.param.setTilingMode(2);
            if (this.inputIsRaster) {
                this.param.setTiling(this.raster.getWidth(), this.raster.getHeight(), this.raster.getMinX(), this.raster.getMinY());
            } else {
                this.param.setTiling(this.src.getWidth(), this.src.getHeight(), this.src.getMinX(), this.src.getMinY());
            }
            this.tileWidth = this.param.getTileWidth();
            this.tileHeight = this.param.getTileHeight();
            this.tileXOffset = this.param.getTileGridXOffset();
            this.tileYOffset = this.param.getTileGridYOffset();
        }
        this.scaleX = this.param.getSourceXSubsampling();
        this.scaleY = this.param.getSourceYSubsampling();
        this.xOffset = this.param.getSubsamplingXOffset();
        this.yOffset = this.param.getSubsamplingYOffset();
        this.sourceRegion.translate(this.xOffset, this.yOffset);
        this.sourceRegion.width -= this.xOffset;
        this.sourceRegion.height -= this.yOffset;
        this.xOffset = this.sourceRegion.x % this.scaleX;
        this.yOffset = this.sourceRegion.y % this.scaleY;
        this.minX = this.sourceRegion.x / this.scaleX;
        this.minY = this.sourceRegion.y / this.scaleY;
        this.w = (this.sourceRegion.width + this.scaleX - 1) / this.scaleX;
        this.h = (this.sourceRegion.height + this.scaleY - 1) / this.scaleY;
        this.tileXOffset += (this.minX - this.tileXOffset) / this.tileWidth * this.tileWidth;
        this.tileYOffset += (this.minY - this.tileYOffset) / this.tileHeight * this.tileHeight;
        this.destinationRegion = new Rectangle(this.minX, this.minY, this.w, this.h);
        if (!this.destinationRegion.equals(this.sourceRegion) || this.tileWidth != this.sm.getWidth() || this.tileHeight != this.sm.getHeight() || !this.inputIsRaster && (this.tileXOffset != this.src.getTileGridXOffset() || this.tileYOffset != this.src.getTileGridYOffset()) || this.inputIsRaster && (this.tileXOffset != this.raster.getMinX() || this.tileYOffset != this.raster.getMinY())) {
            this.noTransform = false;
        }
    }

    private void setSampleModelAndMore() {
        int i;
        this.nc = this.sm.getNumBands();
        this.sourceBands = this.param.getSourceBands();
        if (this.sourceBands != null) {
            this.sm = this.sm.createSubsetSampleModel(this.sourceBands);
            this.noSubband = false;
        } else {
            this.sourceBands = new int[this.nc];
            for (i = 0; i < this.nc; ++i) {
                this.sourceBands[i] = i;
            }
        }
        this.sm = this.sm.createCompatibleSampleModel(this.tileWidth, this.tileHeight);
        this.nc = this.sm.getNumBands();
        this.isBinary = ImageUtil.isBinary(this.sm);
        if (this.cm != null) {
            this.rb = this.cm.getComponentSize(0);
            for (i = 1; i < this.cm.getNumComponents(); ++i) {
                if (this.rb >= this.cm.getComponentSize(i)) continue;
                this.rb = this.cm.getComponentSize(i);
            }
        } else {
            this.rb = this.sm.getSampleSize(0);
            for (i = 1; i < this.sm.getNumBands(); ++i) {
                if (this.rb >= this.sm.getSampleSize(i)) continue;
                this.rb = this.sm.getSampleSize(i);
            }
        }
        if (!this.isOrigSigned(0) && this.rb > 1) {
            this.dcOffset = 1 << this.rb - 1;
        }
    }

    @Override
    public int getTilePartULX() {
        return this.tileXOffset;
    }

    @Override
    public int getTilePartULY() {
        return this.tileYOffset;
    }

    @Override
    public int getTileWidth() {
        int width = this.tileWidth;
        int x = this.co.x * this.tileWidth + this.tileXOffset;
        int maxX = this.getImgULX() + this.getImgWidth();
        if (x + this.tileWidth >= maxX) {
            width = maxX - x;
        }
        return width;
    }

    @Override
    public int getTileHeight() {
        int height = this.tileHeight;
        int y = this.co.y * this.tileHeight + this.tileYOffset;
        int maxY = this.getImgULY() + this.getImgHeight();
        if (y + this.tileHeight >= maxY) {
            height = maxY - y;
        }
        return height;
    }

    @Override
    public int getNomTileWidth() {
        return this.tileWidth;
    }

    @Override
    public int getNomTileHeight() {
        return this.tileHeight;
    }

    @Override
    public int getImgWidth() {
        return this.w;
    }

    @Override
    public int getImgHeight() {
        return this.h;
    }

    @Override
    public int getNumComps() {
        return this.nc;
    }

    public int getTileGridXOffset() {
        return this.param.getTileGridXOffset();
    }

    public int getTileGridYOffset() {
        return this.param.getTileGridYOffset();
    }

    @Override
    public int getTileCompHeight(int t, int c) {
        return this.tileHeight;
    }

    @Override
    public int getTileCompWidth(int t, int c) {
        return this.tileWidth;
    }

    @Override
    public int getCompSubsX(int c) {
        return 1;
    }

    @Override
    public int getCompSubsY(int c) {
        return 1;
    }

    public int getCompWidth(int n) {
        return this.w;
    }

    public int getCompHeight(int c) {
        return this.h;
    }

    @Override
    public int getCompImgWidth(int c) {
        return this.w;
    }

    @Override
    public int getCompImgHeight(int c) {
        return this.h;
    }

    @Override
    public void setTile(int x, int y) {
        if (x >= this.getNumXTiles()) {
            y += x / this.getNumXTiles();
            x %= this.getNumXTiles();
        }
        this.co.x = x;
        this.co.y = y;
        this.aTile = null;
    }

    @Override
    public void nextTile() {
        ++this.co.x;
        if (this.co.x >= this.getNumXTiles()) {
            this.co.x = 0;
            ++this.co.y;
        }
        this.setTile(this.co.x, this.co.y);
    }

    @Override
    public Point getTile(Point co) {
        if (co != null) {
            return co;
        }
        return new Point(0, 0);
    }

    @Override
    public int getTileIdx() {
        return this.getNumXTiles() * this.co.y + this.co.x;
    }

    public Point getTileOff(Point p, int c) {
        if (p != null) {
            p.x = this.co.x * this.tileWidth + this.tileXOffset;
            p.y = this.co.y * this.tileHeight + this.tileYOffset;
            return this.co;
        }
        return new Point(this.co.x * this.tileWidth + this.tileXOffset, this.co.y * this.tileHeight + this.tileYOffset);
    }

    @Override
    public int getCompULX(int c) {
        return this.raster.getMinX();
    }

    @Override
    public int getCompULY(int c) {
        return this.raster.getMinY();
    }

    @Override
    public int getImgULX() {
        return this.destinationRegion.x;
    }

    @Override
    public int getImgULY() {
        return this.destinationRegion.y;
    }

    @Override
    public Point getNumTiles(Point co) {
        if (co != null) {
            co.x = this.getNumXTiles();
            co.y = this.getNumYTiles();
            return co;
        }
        return new Point(this.getNumXTiles(), this.getNumYTiles());
    }

    @Override
    public int getNumTiles() {
        return this.getNumXTiles() * this.getNumYTiles();
    }

    @Override
    public int getNomRangeBits(int c) {
        return this.rb;
    }

    @Override
    public int getFixedPoint(int c) {
        return 0;
    }

    @Override
    public final DataBlk getInternCompData(DataBlk blk, int c) {
        if (this.writer != null && this.writer.getAbortRequest()) {
            throw new RuntimeException(J2KImageWriter.WRITE_ABORTED);
        }
        if (this.barr == null) {
            this.barr = new int[this.nc][];
        }
        if (blk.getDataType() != 3) {
            if (this.intBlk == null) {
                this.intBlk = new DataBlkInt(blk.ulx, blk.uly, blk.w, blk.h);
            } else {
                this.intBlk.ulx = blk.ulx;
                this.intBlk.uly = blk.uly;
                this.intBlk.w = blk.w;
                this.intBlk.h = blk.h;
            }
            blk = this.intBlk;
        }
        float percentage = ((float)this.getTileIdx() + ((float)blk.uly + 1.0f) / (float)blk.h) / (float)this.getNumTiles();
        this.writer.processImageProgressWrapper(percentage * 100.0f);
        if (this.barr[c] == null || this.dbi.ulx > blk.ulx || this.dbi.uly > blk.uly || this.dbi.ulx + this.dbi.w < blk.ulx + blk.w || this.dbi.uly + this.dbi.h < blk.uly + blk.h) {
            if (this.barr[c] == null || this.barr[c].length < blk.w * blk.h) {
                this.barr[c] = new int[blk.w * blk.h];
            }
            blk.setData(this.barr[c]);
            int i = (c + 1) % this.nc;
            while (i != c) {
                if (this.barr[i] == null || this.barr[i].length < blk.w * blk.h) {
                    this.barr[i] = new int[blk.w * blk.h];
                }
                i = (i + 1) % this.nc;
            }
            this.dbi.ulx = blk.ulx;
            this.dbi.uly = blk.uly;
            this.dbi.w = blk.w;
            this.dbi.h = blk.h;
            if (this.aTile == null) {
                this.aTile = this.getTile(this.co.x, this.co.y);
                Rectangle temp = this.aTile.getBounds();
                this.aTile = this.aTile.createTranslatedChild(temp.x - this.minX, temp.y - this.minY);
            }
            for (i = 0; i < this.nc; ++i) {
                this.aTile.getSamples(blk.ulx, blk.uly, blk.w, blk.h, i, this.barr[i]);
                int k = 0;
                while (k < this.barr[i].length) {
                    int[] nArray = this.barr[i];
                    int n = k++;
                    nArray[n] = nArray[n] - this.dcOffset;
                }
            }
            blk.setData(this.barr[c]);
            blk.offset = 0;
            blk.scanw = blk.w;
        } else {
            blk.setData(this.barr[c]);
            blk.offset = (blk.ulx - this.dbi.ulx) * this.dbi.w + blk.ulx - this.dbi.ulx;
            blk.scanw = this.dbi.scanw;
        }
        blk.progressive = false;
        return blk;
    }

    @Override
    public final DataBlk getCompData(DataBlk blk, int c) {
        if (blk.getDataType() != 3) {
            DataBlkInt tmp = new DataBlkInt(blk.ulx, blk.uly, blk.w, blk.h);
            blk = tmp;
        }
        int[] bakarr = (int[])blk.getData();
        int ulx = blk.ulx;
        int uly = blk.uly;
        int w = blk.w;
        int h2 = blk.h;
        blk.setData(null);
        this.getInternCompData(blk, c);
        if (bakarr == null) {
            bakarr = new int[w * h2];
        }
        if (blk.offset == 0 && blk.scanw == w) {
            System.arraycopy(blk.getData(), 0, bakarr, 0, w * h2);
        } else {
            for (int i = h2 - 1; i >= 0; --i) {
                System.arraycopy(blk.getData(), blk.offset + i * blk.scanw, bakarr, i * w, w);
            }
        }
        blk.setData(bakarr);
        blk.offset = 0;
        blk.scanw = blk.w;
        return blk;
    }

    public boolean isOrigSigned(int c) {
        if (this.isBinary) {
            return true;
        }
        SampleModel sm = null;
        sm = this.inputIsRaster ? this.raster.getSampleModel() : this.src.getSampleModel();
        return sm.getDataType() != 1 && sm.getDataType() != 0;
    }

    private int getNumXTiles() {
        int x = this.destinationRegion.x;
        int tx = this.tileXOffset;
        int tw = this.tileWidth;
        return RenderedImageSrc.ToTile(x + this.destinationRegion.width - 1, tx, tw) - RenderedImageSrc.ToTile(x, tx, tw) + 1;
    }

    private int getNumYTiles() {
        int y = this.destinationRegion.y;
        int ty = this.tileYOffset;
        int th = this.tileHeight;
        return RenderedImageSrc.ToTile(y + this.destinationRegion.height - 1, ty, th) - RenderedImageSrc.ToTile(y, ty, th) + 1;
    }

    private static int ToTile(int pos, int tileOffset, int tileSize) {
        if ((pos -= tileOffset) < 0) {
            pos += 1 - tileSize;
        }
        return pos / tileSize;
    }

    private Raster getTile(int tileX, int tileY) {
        int sx = this.tileXOffset + tileX * this.tileWidth;
        int sy = this.tileYOffset + tileY * this.tileHeight;
        tileX += this.tileXOffset / this.tileWidth;
        tileY += this.tileYOffset / this.tileHeight;
        if (this.inputIsRaster) {
            if (this.noTransform) {
                return this.raster.createChild(sx, sy, this.getTileWidth(), this.getTileHeight(), sx, sy, this.sourceBands);
            }
            WritableRaster ras = Raster.createWritableRaster(this.sm, new Point(sx, sy));
            int x = this.mapToSourceX(sx);
            int y = this.mapToSourceY(sy);
            int minY = this.raster.getMinY();
            int maxY = this.raster.getMinY() + this.raster.getHeight();
            int cTileWidth = this.getTileWidth();
            int j = 0;
            while (j < this.getTileHeight()) {
                if (y >= minY && y < maxY) {
                    Raster source = this.raster.createChild(x, y, (cTileWidth - 1) * this.scaleX + 1, 1, x, y, null);
                    int tempX = sx;
                    int i = 0;
                    int offset = x;
                    while (i < cTileWidth) {
                        for (int k = 0; k < this.nc; ++k) {
                            int p = source.getSample(offset, y, this.sourceBands[k]);
                            ras.setSample(tempX, sy, k, p);
                        }
                        ++i;
                        ++tempX;
                        offset += this.scaleX;
                    }
                }
                ++j;
                ++sy;
                y += this.scaleY;
            }
            return ras;
        }
        if (this.noTransform) {
            Raster ras = this.src.getTile(tileX, tileY);
            if (this.noSubband) {
                return ras;
            }
            return ras.createChild(sx, sy, this.tileWidth, this.tileHeight, sx, sy, this.sourceBands);
        }
        WritableRaster ras = Raster.createWritableRaster(this.sm, new Point(sx, sy));
        int x = this.mapToSourceX(sx);
        int y = this.mapToSourceY(sy);
        int minY = this.src.getMinY();
        int maxY = this.src.getMinY() + this.src.getHeight();
        int length = this.tileWidth * this.scaleX;
        if (x + length >= this.src.getWidth()) {
            length = this.src.getWidth() - x;
        }
        int dLength = (length + this.scaleX - 1) / this.scaleX;
        int j = 0;
        while (j < this.tileHeight) {
            if (y >= minY && y < maxY) {
                Raster source = this.src.getData(new Rectangle(x, y, length, 1));
                int tempX = sx;
                int i = 0;
                int offset = x;
                while (i < dLength) {
                    for (int k = 0; k < this.nc; ++k) {
                        int p = source.getSample(offset, y, this.sourceBands[k]);
                        ras.setSample(tempX, sy, k, p);
                    }
                    ++i;
                    ++tempX;
                    offset += this.scaleX;
                }
            }
            ++j;
            ++sy;
            y += this.scaleY;
        }
        return ras;
    }

    private int mapToSourceX(int x) {
        return x * this.scaleX + this.xOffset;
    }

    private int mapToSourceY(int y) {
        return y * this.scaleY + this.yOffset;
    }
}

