/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage;

import java.util.Formatter;
import javax.annotation.Nonnull;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.NCdumpW;
import ucar.nc2.ft2.coverage.CoordSysContainer;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.CoverageCoordAxis1D;
import ucar.nc2.ft2.coverage.CoverageCoordAxisBuilder;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.util.Indent;
import ucar.nc2.util.Misc;
import ucar.nc2.util.Optional;

public class TimeAxis2DSwath
extends CoverageCoordAxis {
    private int[] shape;

    public TimeAxis2DSwath(CoverageCoordAxisBuilder builder) {
        super(builder);
    }

    @Override
    protected void setDataset(CoordSysContainer dataset) {
        if (this.shape != null) {
            throw new RuntimeException("Cant change axis, once dataset is set");
        }
        this.shape = new int[2];
        assert (this.dependsOn.size() == 2);
        CoverageCoordAxis axis1 = dataset.findCoordAxis((String)this.dependsOn.get(0));
        if (axis1 == null) {
            throw new IllegalStateException("TimeAxis2DSwath cant find axis with name " + (String)this.dependsOn.get(0));
        }
        CoverageCoordAxis axis2 = dataset.findCoordAxis((String)this.dependsOn.get(1));
        if (axis2 == null) {
            throw new IllegalStateException("TimeAxis2DSwath cant find axis with name " + (String)this.dependsOn.get(1));
        }
        this.shape[0] = axis1.getNcoords();
        this.shape[1] = axis2.getNcoords();
        assert (this.shape[0] * this.shape[1] == this.getNcoords());
    }

    @Override
    public CoverageCoordAxis copy() {
        return new TimeAxis2DSwath(new CoverageCoordAxisBuilder(this));
    }

    @Override
    public int[] getShape() {
        return this.shape;
    }

    @Override
    public void toString(Formatter f, Indent indent) {
        super.toString(f, indent);
        f.format("%s  %s%n", indent, Misc.showInts(this.shape));
        Array data = this.getCoordsAsArray();
        f.format("%s%n", NCdumpW.toString(data, this.getName() + " values", null));
    }

    @Override
    public Optional<CoverageCoordAxis> subset(SubsetParams params) {
        if (params == null) {
            return Optional.of(new TimeAxis2DSwath(new CoverageCoordAxisBuilder(this)));
        }
        return Optional.of(new TimeAxis2DSwath(new CoverageCoordAxisBuilder(this)));
    }

    @Override
    public Optional<CoverageCoordAxis> subset(double minValue, double maxValue, int stride) {
        return Optional.of(new TimeAxis2DSwath(new CoverageCoordAxisBuilder(this)));
    }

    @Override
    @Nonnull
    public Optional<CoverageCoordAxis> subsetDependent(CoverageCoordAxis1D from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Array getCoordsAsArray() {
        double[] values = this.getValues();
        return Array.factory(DataType.DOUBLE, this.shape, (Object)values);
    }

    @Override
    public Array getCoordBoundsAsArray() {
        double[] values = this.getValues();
        int[] shapeB = new int[3];
        System.arraycopy(this.shape, 0, shapeB, 0, 2);
        shapeB[2] = 2;
        return Array.factory(DataType.DOUBLE, shapeB, (Object)values);
    }
}

