/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.scan;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft2.coverage.adapter.DtCoverageCS;
import ucar.nc2.ft2.coverage.adapter.DtCoverageCSBuilder;

public class FeatureScan {
    private String top;
    private boolean subdirs;
    private static final boolean debug = true;

    public FeatureScan(String top, boolean subdirs) {
        this.top = top;
        this.subdirs = subdirs;
    }

    public List<Bean> scan(Formatter errlog) {
        ArrayList<Bean> result = new ArrayList<Bean>();
        File topFile = new File(this.top);
        if (!topFile.exists()) {
            errlog.format("File %s does not exist", this.top);
            return result;
        }
        if (topFile.isDirectory()) {
            this.scanDirectory(topFile, result);
        } else {
            Bean fdb = new Bean(topFile);
            result.add(fdb);
        }
        return result;
    }

    private void scanDirectory(File dir, List<Bean> result) {
        if (dir.getName().equals("exclude") || dir.getName().equals("problem")) {
            return;
        }
        File[] fila = dir.listFiles();
        if (fila == null) {
            return;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (File f : fila) {
            if (f.isDirectory()) continue;
            files.add(f);
        }
        if (!files.isEmpty()) {
            Collections.sort(files);
            ArrayList files2 = new ArrayList(files);
            File prev = null;
            for (File f : files) {
                String name = f.getName();
                String stem = this.stem(name);
                if (name.contains(".gbx") || name.contains(".ncx") || name.endsWith(".xml") || name.endsWith(".pdf") || name.endsWith(".txt") || name.endsWith(".tar")) {
                    files2.remove(f);
                } else if (prev != null) {
                    if (name.endsWith(".ncml")) {
                        if (prev.getName().equals(stem) || prev.getName().equals(stem + ".nc")) {
                            files2.remove(prev);
                        }
                    } else if (name.endsWith(".bz2")) {
                        if (prev.getName().equals(stem)) {
                            files2.remove(f);
                        }
                    } else if (name.endsWith(".gz")) {
                        if (prev.getName().equals(stem)) {
                            files2.remove(f);
                        }
                    } else if (name.endsWith(".gzip")) {
                        if (prev.getName().equals(stem)) {
                            files2.remove(f);
                        }
                    } else if (name.endsWith(".zip")) {
                        if (prev.getName().equals(stem)) {
                            files2.remove(f);
                        }
                    } else if (name.endsWith(".Z") && prev.getName().equals(stem)) {
                        files2.remove(f);
                    }
                }
                prev = f;
            }
            for (File f : files2) {
                result.add(new Bean(f));
            }
        }
        if (this.subdirs) {
            for (File f : fila) {
                if (!f.isDirectory() || f.getName().equals("exclude")) continue;
                this.scanDirectory(f, result);
            }
        }
    }

    private String stem(String name) {
        int pos = name.lastIndexOf(46);
        return pos > 0 ? name.substring(0, pos) : name;
    }

    public static void main(String[] arg) {
        String usage = "usage: ucar.nc2.ft.scan.FeatureScan directory [-subdirs]";
        if (arg.length < 1) {
            System.out.println(usage);
            System.exit(0);
        }
        boolean subdirs = false;
        for (int i = 1; i < arg.length; ++i) {
            String s2 = arg[i];
            if (!s2.equalsIgnoreCase("-subdirs")) continue;
            subdirs = true;
        }
        FeatureScan scanner = new FeatureScan(arg[0], subdirs);
        System.out.printf(" %-60s %-20s %-10s %-10s%n", "name", "fileType", "featureType", "featureImpl");
        List<Bean> beans = scanner.scan(new Formatter());
        for (Bean b : beans) {
            System.out.printf(" %-60s %-20s %n", b.getName(), b.getFileType());
        }
    }

    public static class Bean {
        public File f;
        String fileType;
        String coordMap;
        FeatureType featureType;
        FeatureType ftFromMetadata;
        String ftype;
        StringBuilder info;
        String coordSysBuilder;
        String ftImpl;
        Throwable problem;
        DtCoverageCSBuilder builder;

        public Bean() {
            this.info = new StringBuilder();
        }

        public Bean(File f) {
            block18: {
                this.info = new StringBuilder();
                this.f = f;
                System.out.printf(" featureScan=%s%n", f.getPath());
                try (NetcdfDataset ds = NetcdfDataset.openDataset(f.getPath());){
                    this.fileType = ds.getFileTypeId();
                    this.coordSysBuilder = ds.getRootGroup().findAttValueIgnoreCase("_CoordSysBuilder", "none");
                    Formatter errlog = new Formatter();
                    this.builder = DtCoverageCSBuilder.classify(ds, errlog);
                    this.info.append(errlog);
                    this.setCoordMap();
                    this.ftFromMetadata = FeatureDatasetFactoryManager.findFeatureType(ds);
                    try {
                        errlog = new Formatter();
                        FeatureDataset featureDataset = FeatureDatasetFactoryManager.wrap(null, ds, null, errlog);
                        this.info.append("FeatureDatasetFactoryManager errlog = ");
                        this.info.append(errlog);
                        this.info.append("\n\n");
                        if (featureDataset != null) {
                            this.featureType = featureDataset.getFeatureType();
                            if (this.featureType != null) {
                                this.ftype = this.featureType.toString();
                            }
                            this.ftImpl = featureDataset.getImplementationName();
                            Formatter infof = new Formatter();
                            featureDataset.getDetailInfo(infof);
                            this.info.append(infof);
                            break block18;
                        }
                        this.ftype = "";
                    }
                    catch (Throwable t) {
                        this.ftype = " ERR: " + t.getMessage();
                        this.info.append(errlog);
                        this.problem = t;
                    }
                }
                catch (Throwable t) {
                    this.fileType = " ERR: " + t.getMessage();
                    this.problem = t;
                }
            }
        }

        public String getName() {
            return this.f.getPath();
        }

        public String getFileType() {
            return this.fileType;
        }

        public double getSizeM() {
            return (double)this.f.length() / 1000.0 / 1000.0;
        }

        public String getCoordMap() {
            return this.coordMap;
        }

        public String getCoordSysBuilder() {
            return this.coordSysBuilder;
        }

        public void setCoordMap() {
            if (this.builder == null) {
                return;
            }
            DtCoverageCS cs = this.builder.makeCoordSys();
            if (cs == null || cs.getCoverageType() == null) {
                return;
            }
            this.coordMap = "f:D(" + cs.getDomainRank() + ")->R(" + cs.getRangeRank() + ")";
        }

        public String getFtMetadata() {
            return this.ftFromMetadata == null ? "" : this.ftFromMetadata.toString();
        }

        public String getFeatureType() {
            return this.ftype;
        }

        public String getCoverage() {
            return this.builder == null ? "" : this.builder.showSummary();
        }

        public void toString(Formatter f, boolean showInfo) {
            f.format("%s%n %s%n map = '%s'%n", this.getName(), this.getFileType(), this.getCoordMap());
            if (this.builder != null) {
                f.format("%n%s%n", this.builder.toString());
            }
            if (showInfo && this.info != null) {
                f.format("%n%s", this.info);
            }
            if (this.problem != null) {
                StringWriter sw = new StringWriter(5000);
                this.problem.printStackTrace(new PrintWriter(sw));
                f.format(sw.toString(), new Object[0]);
            }
        }

        public String toString() {
            Formatter f = new Formatter();
            this.toString(f, true);
            return f.toString();
        }

        public String runClassifier() {
            Formatter ff = new Formatter();
            String type = null;
            try (NetcdfDataset ds = NetcdfDataset.openDataset(this.f.getPath());){
                type = DtCoverageCSBuilder.describe(ds, ff);
            }
            catch (IOException e) {
                StringWriter sw = new StringWriter(10000);
                e.printStackTrace(new PrintWriter(sw));
                ff.format("%n%s", sw.toString());
            }
            ff.format("CoverageCS.Type = %s", type);
            return ff.toString();
        }
    }
}

