/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.menu;

import icy.action.GeneralActions;
import icy.gui.component.button.IcyCommandButton;
import icy.gui.component.button.IcyCommandToggleButton;
import icy.gui.main.MainFrame;
import icy.gui.util.LookAndFeelUtil;
import icy.gui.util.RibbonUtil;
import icy.image.ImageUtil;
import icy.imagej.ImageJWrapper;
import icy.main.Icy;
import icy.resource.ResourceUtil;
import icy.resource.icon.BasicResizableIcon;
import icy.resource.icon.IcyIcon;
import icy.system.SystemUtil;
import ij.Executer;
import ij.ImageJ;
import ij.WindowManager;
import ij.gui.ImageWindow;
import java.awt.Component;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandToggleButtonGroup;
import org.pushingpixels.flamingo.api.common.JCommandToggleButton;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbonComponent;
import org.pushingpixels.flamingo.api.ribbon.RibbonElementPriority;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;

public class ImageJTask
extends RibbonTask
implements PropertyChangeListener {
    static final Image detachForIJ = ResourceUtil.getImage("help/ij_detached.jpg");
    public static final String NAME = "ImageJ";
    protected final ImageJToolRibbonBand ijToolBand = (ImageJToolRibbonBand)this.getBand(1);

    public ImageJTask() {
        super(NAME, new AbstractRibbonBand[]{new ImageJRibbonBand(), new ImageJToolRibbonBand()});
        this.getImageJ().addActiveImageListener(new ImageJWrapper.ImageJActiveImageListener(){

            @Override
            public void imageActived(ImageWindow iw) {
                if (iw != null) {
                    ImageJTask.this.ijToolBand.setActionToIcy();
                } else if (Icy.getMainInterface().getActiveSequence() != null) {
                    ImageJTask.this.ijToolBand.setActionToIJ();
                } else {
                    ImageJTask.this.ijToolBand.updateButtonsState();
                }
            }
        });
    }

    public void init() {
        this.propertyChange(null);
        MainFrame mainFrame = Icy.getMainInterface().getMainFrame();
        if (mainFrame != null) {
            mainFrame.addPropertyChangeListener("detachedMode", this);
        }
    }

    public ImageJWrapper getImageJ() {
        return ((ImageJRibbonBand)this.getBand((int)0)).imageJ;
    }

    public void quitImageJ() {
        new Executer("Quit", null);
    }

    public void onSequenceActivationChange() {
        if (Icy.getMainInterface().getActiveSequence() != null) {
            this.ijToolBand.setActionToIJ();
        } else if (WindowManager.getCurrentImage() != null) {
            this.ijToolBand.setActionToIcy();
        } else {
            this.ijToolBand.updateButtonsState();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.onSequenceActivationChange();
    }

    private static class ImageJToolRibbonBand
    extends JRibbonBand {
        private static final long serialVersionUID = -6873081018953405306L;
        public static final String NAME = "Tools";
        final IcyCommandButton button = new IcyCommandButton(GeneralActions.toIJAction);
        final IcyCommandToggleButton detachedBtn;
        final CommandToggleButtonGroup detachedGrp;

        public ImageJToolRibbonBand() {
            super(NAME, (ResizableIcon)new IcyIcon("brackets"));
            this.addCommandButton((AbstractCommandButton)this.button, RibbonElementPriority.TOP);
            this.detachedBtn = new IcyCommandToggleButton(GeneralActions.detachedModeAction);
            RichTooltip richToolTip = new RichTooltip("Detached windows", "Icy need to be set in detached mode to use ImageJ efficiently and enable image conversion.");
            richToolTip.setMainImage(detachForIJ);
            richToolTip.addDescriptionSection("This button has the same effect as the detached mode button in the top toolbar.");
            this.detachedBtn.setActionRichTooltip(richToolTip);
            this.detachedGrp = new CommandToggleButtonGroup();
            this.detachedGrp.add((JCommandToggleButton)this.detachedBtn);
            this.addCommandButton((AbstractCommandButton)this.detachedBtn, RibbonElementPriority.TOP);
            RibbonUtil.setPermissiveResizePolicies(this);
        }

        public void setActionToIJ() {
            this.button.setAction(GeneralActions.toIJAction);
            this.updateButtonsState();
        }

        public void setActionToIcy() {
            this.button.setAction(GeneralActions.toIcyAction);
            this.updateButtonsState();
        }

        public void updateButtonsState() {
            boolean isDetached = Icy.getMainInterface().isDetachedMode();
            this.detachedGrp.setSelected((JCommandToggleButton)this.detachedBtn, isDetached);
            if (this.button.getAction() == GeneralActions.toIcyAction) {
                this.button.setEnabled(isDetached && WindowManager.getCurrentImage() != null);
            } else {
                this.button.setEnabled(isDetached && Icy.getMainInterface().getActiveSequence() != null);
            }
        }
    }

    private static class ImageJRibbonBand
    extends JRibbonBand {
        private static final long serialVersionUID = 4431425194428863269L;
        public static final String NAME = "ImageJ";
        ImageJWrapper imageJ;
        final JRibbonComponent imageJComp;

        public ImageJRibbonBand() {
            super("ImageJ", (ResizableIcon)new BasicResizableIcon(ImageUtil.load(ImageJ.class.getResource("/microscope.gif"))));
            SystemUtil.setProperty("plugins.dir", "ij");
            ImageJ.backgroundColor = LookAndFeelUtil.getBackground((Component)((Object)this));
            try {
                this.imageJ = new ImageJWrapper();
            }
            catch (Throwable t) {
                System.err.println(t.getMessage());
                this.imageJ = null;
            }
            this.imageJComp = this.imageJ != null ? new JRibbonComponent((JComponent)this.imageJ.getSwingPanel()) : new JRibbonComponent((JComponent)new JPanel());
            this.addRibbonComponent(this.imageJComp, 3);
            RibbonUtil.setRestrictiveResizePolicies(this);
        }
    }
}

