/*
 * Decompiled with CFR 0.152.
 */
package icy.type.geom.areax;

import icy.type.geom.areax.AreaXBody;
import icy.type.geom.areax.CurveX;
import icy.type.geom.areax.RawCurveArrayList;
import java.awt.geom.PathIterator;

public abstract class CrossingsX {
    public static final boolean debug = false;
    int limit = 0;
    double[] yranges = new double[10];
    double xlo;
    double ylo;
    double xhi;
    double yhi;
    private RawCurveArrayList tmp = new RawCurveArrayList(0);

    public CrossingsX(double xlo, double ylo, double xhi, double yhi) {
        this.xlo = xlo;
        this.ylo = ylo;
        this.xhi = xhi;
        this.yhi = yhi;
    }

    public final double getXLo() {
        return this.xlo;
    }

    public final double getYLo() {
        return this.ylo;
    }

    public final double getXHi() {
        return this.xhi;
    }

    public final double getYHi() {
        return this.yhi;
    }

    public abstract void record(double var1, double var3, int var5);

    public void print() {
        System.out.println("CrossingsX [");
        System.out.println("  bounds = [" + this.ylo + ", " + this.yhi + "]");
        for (int i = 0; i < this.limit; i += 2) {
            System.out.println("  [" + this.yranges[i] + ", " + this.yranges[i + 1] + "]");
        }
        System.out.println("]");
    }

    public final boolean isEmpty() {
        return this.limit == 0;
    }

    public abstract boolean covers(double var1, double var3);

    public static CrossingsX findCrossings(AreaXBody body, double xlo, double ylo, double xhi, double yhi) {
        EvenOdd cross = new EvenOdd(xlo, ylo, xhi, yhi);
        for (int a = 0; a < body.size(); ++a) {
            CurveX c = body.get(a);
            if (!c.accumulateCrossings(cross)) continue;
            return null;
        }
        return cross;
    }

    public static CrossingsX findCrossings(PathIterator pi, double xlo, double ylo, double xhi, double yhi) {
        CrossingsX cross = pi.getWindingRule() == 0 ? new EvenOdd(xlo, ylo, xhi, yhi) : new NonZero(xlo, ylo, xhi, yhi);
        double[] coords = new double[23];
        double movx = 0.0;
        double movy = 0.0;
        double curx = 0.0;
        double cury = 0.0;
        while (!pi.isDone()) {
            int type = pi.currentSegment(coords);
            switch (type) {
                case 0: {
                    if (movy != cury && cross.accumulateLine(curx, cury, movx, movy)) {
                        return null;
                    }
                    movx = curx = coords[0];
                    movy = cury = coords[1];
                    break;
                }
                case 1: {
                    double newx = coords[0];
                    double newy = coords[1];
                    if (cross.accumulateLine(curx, cury, newx, newy)) {
                        return null;
                    }
                    curx = newx;
                    cury = newy;
                    break;
                }
                case 2: {
                    double newx = coords[2];
                    double newy = coords[3];
                    if (cross.accumulateQuad(curx, cury, coords)) {
                        return null;
                    }
                    curx = newx;
                    cury = newy;
                    break;
                }
                case 3: {
                    double newx = coords[4];
                    double newy = coords[5];
                    if (cross.accumulateCubic(curx, cury, coords)) {
                        return null;
                    }
                    curx = newx;
                    cury = newy;
                    break;
                }
                case 4: {
                    if (movy != cury && cross.accumulateLine(curx, cury, movx, movy)) {
                        return null;
                    }
                    curx = movx;
                    cury = movy;
                }
            }
            pi.next();
        }
        if (movy != cury && cross.accumulateLine(curx, cury, movx, movy)) {
            return null;
        }
        return cross;
    }

    public boolean accumulateLine(double x0, double y0, double x1, double y1) {
        if (y0 <= y1) {
            return this.accumulateLine(x0, y0, x1, y1, 1);
        }
        return this.accumulateLine(x1, y1, x0, y0, -1);
    }

    public boolean accumulateLine(double x0, double y0, double x1, double y1, int direction) {
        double yend;
        double xend;
        double ystart;
        double xstart;
        if (this.yhi <= y0 || this.ylo >= y1) {
            return false;
        }
        if (x0 >= this.xhi && x1 >= this.xhi) {
            return false;
        }
        if (y0 == y1) {
            return x0 >= this.xlo || x1 >= this.xlo;
        }
        double dx = x1 - x0;
        double dy = y1 - y0;
        if (y0 < this.ylo) {
            xstart = x0 + (this.ylo - y0) * dx / dy;
            ystart = this.ylo;
        } else {
            xstart = x0;
            ystart = y0;
        }
        if (this.yhi < y1) {
            xend = x0 + (this.yhi - y0) * dx / dy;
            yend = this.yhi;
        } else {
            xend = x1;
            yend = y1;
        }
        if (xstart >= this.xhi && xend >= this.xhi) {
            return false;
        }
        if (xstart > this.xlo || xend > this.xlo) {
            return true;
        }
        this.record(ystart, yend, direction);
        return false;
    }

    public boolean accumulateQuad(double x0, double y0, double[] coords) {
        if (y0 < this.ylo && coords[1] < this.ylo && coords[3] < this.ylo) {
            return false;
        }
        if (y0 > this.yhi && coords[1] > this.yhi && coords[3] > this.yhi) {
            return false;
        }
        if (x0 > this.xhi && coords[0] > this.xhi && coords[2] > this.xhi) {
            return false;
        }
        if (x0 < this.xlo && coords[0] < this.xlo && coords[2] < this.xlo) {
            if (y0 < coords[3]) {
                this.record(Math.max(y0, this.ylo), Math.min(coords[3], this.yhi), 1);
            } else if (y0 > coords[3]) {
                this.record(Math.max(coords[3], this.ylo), Math.min(y0, this.yhi), -1);
            }
            return false;
        }
        CurveX.insertQuad(this.tmp, x0, y0, coords);
        for (int a = 0; a < this.tmp.size(); ++a) {
            CurveX c = this.tmp.get(a);
            if (!c.accumulateCrossings(this)) continue;
            return true;
        }
        this.tmp.clear();
        return false;
    }

    public boolean accumulateCubic(double x0, double y0, double[] coords) {
        if (y0 < this.ylo && coords[1] < this.ylo && coords[3] < this.ylo && coords[5] < this.ylo) {
            return false;
        }
        if (y0 > this.yhi && coords[1] > this.yhi && coords[3] > this.yhi && coords[5] > this.yhi) {
            return false;
        }
        if (x0 > this.xhi && coords[0] > this.xhi && coords[2] > this.xhi && coords[4] > this.xhi) {
            return false;
        }
        if (x0 < this.xlo && coords[0] < this.xlo && coords[2] < this.xlo && coords[4] < this.xlo) {
            if (y0 <= coords[5]) {
                this.record(Math.max(y0, this.ylo), Math.min(coords[5], this.yhi), 1);
            } else {
                this.record(Math.max(coords[5], this.ylo), Math.min(y0, this.yhi), -1);
            }
            return false;
        }
        CurveX.insertCubic(this.tmp, x0, y0, coords);
        for (int a = 0; a < this.tmp.size(); ++a) {
            CurveX c = this.tmp.get(a);
            if (!c.accumulateCrossings(this)) continue;
            return true;
        }
        this.tmp.clear();
        return false;
    }

    public static final class NonZero
    extends CrossingsX {
        private int[] crosscounts;

        public NonZero(double xlo, double ylo, double xhi, double yhi) {
            super(xlo, ylo, xhi, yhi);
            this.crosscounts = new int[this.yranges.length / 2];
        }

        @Override
        public final boolean covers(double ystart, double yend) {
            int i = 0;
            while (i < this.limit) {
                double yhi;
                double ylo = this.yranges[i++];
                if (ystart >= (yhi = this.yranges[i++])) continue;
                if (ystart < ylo) {
                    return false;
                }
                if (yend <= yhi) {
                    return true;
                }
                ystart = yhi;
            }
            return ystart >= yend;
        }

        public void remove(int cur) {
            this.limit -= 2;
            int rem = this.limit - cur;
            if (rem > 0) {
                System.arraycopy(this.yranges, cur + 2, this.yranges, cur, rem);
                System.arraycopy(this.crosscounts, cur / 2 + 1, this.crosscounts, cur / 2, rem / 2);
            }
        }

        public void insert(int cur, double lo, double hi, int dir) {
            int rem = this.limit - cur;
            double[] oldranges = this.yranges;
            int[] oldcounts = this.crosscounts;
            if (this.limit >= this.yranges.length) {
                this.yranges = new double[this.limit + 10];
                System.arraycopy(oldranges, 0, this.yranges, 0, cur);
                this.crosscounts = new int[(this.limit + 10) / 2];
                System.arraycopy(oldcounts, 0, this.crosscounts, 0, cur / 2);
            }
            if (rem > 0) {
                System.arraycopy(oldranges, cur, this.yranges, cur + 2, rem);
                System.arraycopy(oldcounts, cur / 2, this.crosscounts, cur / 2 + 1, rem / 2);
            }
            this.yranges[cur + 0] = lo;
            this.yranges[cur + 1] = hi;
            this.crosscounts[cur / 2] = dir;
            this.limit += 2;
        }

        @Override
        public void record(double ystart, double yend, int direction) {
            int cur;
            if (ystart >= yend) {
                return;
            }
            for (cur = 0; cur < this.limit && ystart > this.yranges[cur + 1]; cur += 2) {
            }
            if (cur < this.limit) {
                int rdir = this.crosscounts[cur / 2];
                double yrlo = this.yranges[cur + 0];
                double yrhi = this.yranges[cur + 1];
                if (yrhi == ystart && rdir == direction) {
                    if (cur + 2 == this.limit) {
                        this.yranges[cur + 1] = yend;
                        return;
                    }
                    this.remove(cur);
                    ystart = yrlo;
                    rdir = this.crosscounts[cur / 2];
                    yrlo = this.yranges[cur + 0];
                    yrhi = this.yranges[cur + 1];
                }
                if (yend < yrlo) {
                    this.insert(cur, ystart, yend, direction);
                    return;
                }
                if (yend == yrlo && rdir == direction) {
                    this.yranges[cur] = ystart;
                    return;
                }
                if (ystart < yrlo) {
                    this.insert(cur, ystart, yrlo, direction);
                    cur += 2;
                    ystart = yrlo;
                } else if (yrlo < ystart) {
                    this.insert(cur, yrlo, ystart, rdir);
                    cur += 2;
                    yrlo = ystart;
                }
                int newdir = rdir + direction;
                double newend = Math.min(yend, yrhi);
                if (newdir == 0) {
                    this.remove(cur);
                } else {
                    this.crosscounts[cur / 2] = newdir;
                    this.yranges[cur++] = ystart;
                    this.yranges[cur++] = newend;
                }
                ystart = yrlo = newend;
                if (yrlo < yrhi) {
                    this.insert(cur, yrlo, yrhi, rdir);
                }
            }
            if (ystart < yend) {
                this.insert(cur, ystart, yend, direction);
            }
        }
    }

    public static final class EvenOdd
    extends CrossingsX {
        public EvenOdd(double xlo, double ylo, double xhi, double yhi) {
            super(xlo, ylo, xhi, yhi);
        }

        @Override
        public final boolean covers(double ystart, double yend) {
            return this.limit == 2 && this.yranges[0] <= ystart && this.yranges[1] >= yend;
        }

        @Override
        public void record(double ystart, double yend, int direction) {
            int from;
            if (ystart >= yend) {
                return;
            }
            for (from = 0; from < this.limit && ystart > this.yranges[from + 1]; from += 2) {
            }
            int to = from;
            while (from < this.limit) {
                double yhh;
                double yhl;
                double ylh;
                double yll;
                double yrlo = this.yranges[from++];
                double yrhi = this.yranges[from++];
                if (yend < yrlo) {
                    this.yranges[to++] = ystart;
                    this.yranges[to++] = yend;
                    ystart = yrlo;
                    yend = yrhi;
                    continue;
                }
                if (ystart < yrlo) {
                    yll = ystart;
                    ylh = yrlo;
                } else {
                    yll = yrlo;
                    ylh = ystart;
                }
                if (yend < yrhi) {
                    yhl = yend;
                    yhh = yrhi;
                } else {
                    yhl = yrhi;
                    yhh = yend;
                }
                if (ylh == yhl) {
                    ystart = yll;
                    yend = yhh;
                } else {
                    if (ylh > yhl) {
                        ystart = yhl;
                        yhl = ylh;
                        ylh = ystart;
                    }
                    if (yll != ylh) {
                        this.yranges[to++] = yll;
                        this.yranges[to++] = ylh;
                    }
                    ystart = yhl;
                    yend = yhh;
                }
                if (!(ystart >= yend)) continue;
                break;
            }
            if (to < from && from < this.limit) {
                System.arraycopy(this.yranges, from, this.yranges, to, this.limit - from);
            }
            to += this.limit - from;
            if (ystart < yend) {
                if (to >= this.yranges.length) {
                    double[] newranges = new double[to + 10];
                    System.arraycopy(this.yranges, 0, newranges, 0, to);
                    this.yranges = newranges;
                }
                this.yranges[to++] = ystart;
                this.yranges[to++] = yend;
            }
            this.limit = to;
        }
    }
}

