/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.roi3d;

import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.common.CollapsibleEvent;
import icy.painter.Anchor3D;
import icy.painter.OverlayEvent;
import icy.resource.ResourceUtil;
import icy.roi.ROI;
import icy.roi.ROIEvent;
import icy.sequence.Sequence;
import icy.type.geom.Line3D;
import icy.type.point.Point3D;
import icy.type.point.Point5D;
import icy.util.GraphicsUtil;
import icy.util.StringUtil;
import icy.util.XMLUtil;
import icy.vtk.IcyVtkPanel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.w3c.dom.Node;
import plugins.kernel.canvas.VtkCanvas;
import plugins.kernel.roi.roi3d.ROI3DShape;
import vtk.vtkActor;
import vtk.vtkMapper;
import vtk.vtkPolyDataMapper;
import vtk.vtkSphereSource;

public class ROI3DPoint
extends ROI3DShape {
    public static final String ID_POSITION = "position";
    private final Anchor3D position;

    @Deprecated
    public ROI3DPoint(Point3D pt, boolean cm) {
        this(pt);
    }

    public ROI3DPoint(Point3D position) {
        super(new Line3D());
        this.position = this.createAnchor(position);
        this.position.setSelected(true);
        this.addPoint(this.position);
        this.setIcon(ResourceUtil.ICON_ROI_POINT);
    }

    public ROI3DPoint(Point5D pt) {
        this(pt.toPoint3D());
    }

    public ROI3DPoint(double x, double y, double z) {
        this(new Point3D.Double(x, y, z));
    }

    public ROI3DPoint() {
        this(new Point3D.Double());
    }

    @Override
    public String getDefaultName() {
        return "Point3D";
    }

    @Override
    protected ROI3DShape.ROI3DShapePainter createPainter() {
        return new ROI3DPointPainter();
    }

    public Line3D getLine() {
        return (Line3D)this.shape;
    }

    public Point3D getPoint() {
        return this.position.getPosition();
    }

    @Override
    public void controlPointOverlayChanged(OverlayEvent event) {
        if (event.getType() == OverlayEvent.OverlayEventType.PAINTER_CHANGED) {
            this.getOverlay().painterChanged();
        }
    }

    @Override
    public boolean isOverEdge(IcyCanvas canvas, double x, double y, double z) {
        if (this.isSelected()) {
            return this.position.isOver(canvas, new Point3D.Double(x, y, z));
        }
        return super.isOverEdge(canvas, x, y, z);
    }

    @Override
    public boolean contains(ROI roi) {
        return false;
    }

    @Override
    public boolean intersects(ROI r) throws InterruptedException {
        if (r instanceof ROI3DPoint) {
            return this.onSamePos((ROI3DPoint)r, false) && ((ROI3DPoint)r).getPoint().equals(this.getPoint());
        }
        return super.intersects(r);
    }

    @Override
    public boolean[] getBooleanMask2D(int x, int y, int width, int height, int z, boolean inclusive) {
        if (width <= 0 || height <= 0) {
            return new boolean[0];
        }
        boolean[] result = new boolean[width * height];
        Rectangle bounds2d = new Rectangle(x, y, width, height);
        Point3D pos = this.getPoint();
        if (Math.floor(pos.getZ()) == (double)z && bounds2d.contains(pos.toPoint2D())) {
            int px = (int)Math.floor(pos.getX());
            int py = (int)Math.floor(pos.getY());
            result[px - x + (py - y) * width] = true;
        }
        return result;
    }

    @Override
    public void onChanged(CollapsibleEvent object) {
        ROIEvent event = (ROIEvent)object;
        switch (event.getType()) {
            case PROPERTY_CHANGED: {
                String property = event.getPropertyName();
                if (!StringUtil.equals(property, "stroke")) break;
                ((ROI3DShape.ROI3DShapePainter)this.getOverlay()).needRebuild = true;
                break;
            }
            case SELECTION_CHANGED: {
                if (!this.isSelected()) break;
                this.position.setSelected(true);
                break;
            }
        }
        super.onChanged(object);
    }

    @Override
    protected void updateShape() {
        Point3D pt = this.getPoint();
        double x = pt.getX();
        double y = pt.getY();
        double z = pt.getZ();
        this.getLine().setLine(x, y, z, x, y, z);
        super.updateShape();
    }

    @Override
    public boolean canAddPoint() {
        return false;
    }

    @Override
    protected boolean removePoint(IcyCanvas canvas, Anchor3D pt) {
        if (canvas != null) {
            canvas.getSequence().removeROI(this);
            return true;
        }
        return false;
    }

    @Override
    public double computeNumberOfContourPoints() {
        return 0.0;
    }

    @Override
    public double computeNumberOfPoints() {
        return 0.0;
    }

    @Override
    public boolean loadFromXML(Node node) {
        this.beginUpdate();
        try {
            if (!super.loadFromXML(node)) {
                boolean bl = false;
                return bl;
            }
            this.position.loadPositionFromXML(XMLUtil.getElement(node, ID_POSITION));
        }
        finally {
            this.endUpdate();
        }
        return true;
    }

    @Override
    public boolean saveToXML(Node node) {
        if (!super.saveToXML(node)) {
            return false;
        }
        this.position.savePositionToXML(XMLUtil.setElement(node, ID_POSITION));
        return true;
    }

    public class ROI3DPointPainter
    extends ROI3DShape.ROI3DShapePainter {
        vtkSphereSource vtkSource;

        public ROI3DPointPainter() {
            super(ROI3DPoint.this);
        }

        @Override
        protected void finalize() throws Throwable {
            super.finalize();
            if (this.vtkSource != null) {
                this.vtkSource.Delete();
            }
        }

        @Override
        protected boolean isSmall(Rectangle2D bounds, Graphics2D g, IcyCanvas canvas) {
            return !ROI3DPoint.this.isSelected();
        }

        @Override
        protected boolean isTiny(Rectangle2D bounds, Graphics2D g, IcyCanvas canvas) {
            return !ROI3DPoint.this.isSelected();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drawROI(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
            if (canvas instanceof IcyCanvas2D) {
                Graphics2D g2 = (Graphics2D)g.create();
                if (ROI3DPoint.this.isSelected() && !this.isReadOnly()) {
                    List list = ROI3DPoint.this.controlPoints;
                    synchronized (list) {
                        for (Anchor3D pt : ROI3DPoint.this.controlPoints) {
                            pt.paint(g2, sequence, canvas);
                        }
                    }
                } else {
                    Point3D pos = ROI3DPoint.this.getPoint();
                    double ray = this.getAdjustedStroke(canvas);
                    Ellipse2D.Double ellipse = new Ellipse2D.Double(pos.getX() - ray, pos.getY() - ray, ray * 2.0, ray * 2.0);
                    int cnvZ = canvas.getPositionZ();
                    double zRange = Math.min(10.0, Math.max(3.0, (double)sequence.getSizeZ() / 8.0));
                    double z = pos.getZ();
                    double dz = Math.abs(z - (double)cnvZ);
                    if (dz > zRange) {
                        return;
                    }
                    float ratio = 1.0f - (float)(dz / zRange);
                    if (ratio != 1.0f) {
                        GraphicsUtil.mixAlpha(g2, ratio);
                    }
                    g2.setColor(this.getDisplayColor());
                    g2.fill(ellipse);
                }
                g2.dispose();
            } else {
                super.drawROI(g, sequence, canvas);
            }
        }

        @Override
        protected void initVtkObjects() {
            super.initVtkObjects();
            this.vtkSource = new vtkSphereSource();
            this.vtkSource.SetRadius(this.getStroke());
            this.vtkSource.SetThetaResolution(12);
            this.vtkSource.SetPhiResolution(12);
            if (this.actor != null) {
                this.actor.Delete();
            }
            if (this.polyMapper != null) {
                this.polyMapper.Delete();
            }
            this.polyMapper = new vtkPolyDataMapper();
            this.polyMapper.SetInputConnection(this.vtkSource.GetOutputPort());
            this.actor = new vtkActor();
            this.actor.SetMapper((vtkMapper)this.polyMapper);
            Color col = this.getColor();
            this.actor.GetProperty().SetColor((double)col.getRed() / 255.0, (double)col.getGreen() / 255.0, (double)col.getBlue() / 255.0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void rebuildVtkObjects() {
            VtkCanvas canvas = (VtkCanvas)this.canvas3d.get();
            if (canvas == null) {
                return;
            }
            IcyVtkPanel vtkPanel = canvas.getVtkPanel();
            if (vtkPanel == null) {
                return;
            }
            Sequence seq = canvas.getSequence();
            if (seq == null) {
                return;
            }
            Point3D pos = ROI3DPoint.this.getPoint();
            vtkPanel.lock();
            try {
                this.vtkSource.SetRadius(this.getStroke() * this.scaling[0]);
                this.vtkSource.SetCenter(pos.getX() * this.scaling[0], pos.getY() * this.scaling[1], pos.getZ() * this.scaling[2]);
                this.polyMapper.Update();
            }
            finally {
                vtkPanel.unlock();
            }
            this.painterChanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void updateVtkDisplayProperties() {
            IcyVtkPanel vtkPanel;
            if (this.actor == null) {
                return;
            }
            VtkCanvas cnv = (VtkCanvas)this.canvas3d.get();
            Color col = this.getDisplayColor();
            double r = (double)col.getRed() / 255.0;
            double g = (double)col.getGreen() / 255.0;
            double b = (double)col.getBlue() / 255.0;
            IcyVtkPanel icyVtkPanel = vtkPanel = cnv != null ? cnv.getVtkPanel() : null;
            if (vtkPanel != null) {
                vtkPanel.lock();
            }
            try {
                this.actor.GetProperty().SetColor(r, g, b);
            }
            finally {
                if (vtkPanel != null) {
                    vtkPanel.unlock();
                }
            }
            this.painterChanged();
        }

        @Override
        protected boolean updateFocus(InputEvent e, Point5D imagePoint, IcyCanvas canvas) {
            if (canvas instanceof VtkCanvas) {
                boolean focus = this.actor != null && this.actor == ((VtkCanvas)canvas).getPickedObject();
                ROI3DPoint.this.setFocused(focus);
                return focus;
            }
            return super.updateFocus(e, imagePoint, canvas);
        }
    }
}

