/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.YesNoCancelDialog;
import ij.io.FileInfo;
import ij.io.FileSaver;
import ij.io.Opener;
import ij.plugin.PlugIn;
import ij.util.StringSorter;
import java.awt.Frame;
import java.io.File;

public class NextImageOpener
implements PlugIn {
    boolean forward = true;
    boolean closeCurrent = true;
    ImagePlus imp0;

    @Override
    public void run(String arg) {
        String rtn;
        if (arg.equals("backward") || IJ.altKeyDown()) {
            this.forward = false;
        }
        if (arg.equals("backwardsc")) {
            this.forward = false;
            this.closeCurrent = false;
        }
        if (arg.equals("forwardsc")) {
            this.forward = true;
            this.closeCurrent = false;
        }
        this.imp0 = IJ.getImage();
        String currentPath = this.getDirectory(this.imp0);
        if (IJ.debugMode) {
            IJ.log("OpenNext.currentPath:" + currentPath);
        }
        if (currentPath == null) {
            IJ.error("Next Image", "Directory information for \"" + this.imp0.getTitle() + "\" not found.");
            return;
        }
        String nextPath = this.getNext(currentPath, this.getName(this.imp0), this.forward);
        if (IJ.debugMode) {
            IJ.log("OpenNext.nextPath:" + nextPath);
        }
        if (nextPath != null && (rtn = this.open(nextPath)) == null) {
            this.open(this.getNext(currentPath, new File(nextPath).getName(), this.forward));
        }
    }

    String getDirectory(ImagePlus imp) {
        FileInfo fi = imp.getOriginalFileInfo();
        if (fi == null) {
            return null;
        }
        String dir = fi.openNextDir;
        if (dir == null) {
            dir = fi.directory;
        }
        return dir;
    }

    String getName(ImagePlus imp) {
        String name = imp.getTitle();
        FileInfo fi = imp.getOriginalFileInfo();
        if (fi != null) {
            if (fi.openNextName != null) {
                name = fi.openNextName;
            } else if (fi.fileName != null) {
                name = fi.fileName;
            }
        }
        return name;
    }

    String open(String nextPath) {
        int nImages = WindowManager.getImageCount();
        ImagePlus imp2 = IJ.openImage(nextPath);
        if (imp2 == null) {
            if (WindowManager.getImageCount() > nImages) {
                return "ok";
            }
            return null;
        }
        String newTitle = imp2.getTitle();
        if (this.imp0.changes) {
            FileSaver fs;
            String name = this.imp0.getTitle();
            String msg = name.length() > 22 ? "Save changes to\n\"" + name + "\"?" : "Save changes to \"" + name + "\"?";
            YesNoCancelDialog d = new YesNoCancelDialog((Frame)this.imp0.getWindow(), "ImageJ", msg);
            if (d.cancelPressed()) {
                return "Canceled";
            }
            if (d.yesPressed() && !(fs = new FileSaver(this.imp0)).save()) {
                return "Canceled";
            }
            this.imp0.changes = false;
        }
        if (!(this.imp0 instanceof CompositeImage) && (imp2.isComposite() || imp2.isHyperStack())) {
            imp2.show();
            this.imp0.close();
            this.imp0 = imp2;
        } else {
            this.imp0.setImage(imp2);
        }
        return "ok";
    }

    String getNext(String path, String imageName, boolean forward) {
        File dir = new File(path);
        if (!dir.isDirectory()) {
            return null;
        }
        String[] names = dir.list();
        StringSorter.sort(names);
        int thisfile = -1;
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equals(imageName)) continue;
            thisfile = i;
            break;
        }
        if (IJ.debugMode) {
            IJ.log("OpenNext.thisfile:" + thisfile);
        }
        if (thisfile == -1) {
            return null;
        }
        int candidate = thisfile + 1;
        if (!forward) {
            candidate = thisfile - 1;
        }
        if (candidate < 0) {
            candidate = names.length - 1;
        }
        if (candidate == names.length) {
            candidate = 0;
        }
        while (candidate != thisfile) {
            Opener o;
            int type;
            String nextPath = path + names[candidate];
            if (IJ.debugMode) {
                IJ.log("OpenNext: " + candidate + "  " + names[candidate]);
            }
            File nextFile = new File(nextPath);
            boolean canOpen = true;
            if (names[candidate].startsWith(".") || nextFile.isDirectory()) {
                canOpen = false;
            }
            if (canOpen && ((type = (o = new Opener()).getFileType(nextPath)) == 10 || type == 11 || type == 12)) {
                canOpen = false;
            }
            if (canOpen) {
                return nextPath;
            }
            candidate = forward ? ++candidate : --candidate;
            if (candidate < 0) {
                candidate = names.length - 1;
            }
            if (candidate != names.length) continue;
            candidate = 0;
        }
        if (IJ.debugMode) {
            IJ.log("OpenNext: Search failed");
        }
        return null;
    }
}

