/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.trackmanager;

import icy.sequence.Sequence;
import java.util.ArrayList;
import plugins.fab.trackmanager.TrackSegment;
import plugins.nchenouard.spot.Detection;

public class TrackGroup {
    private final Sequence sequence;
    private ArrayList<TrackSegment> trackSegmentList;
    private String description;

    public TrackGroup(Sequence sequence) {
        this.sequence = sequence;
        this.trackSegmentList = new ArrayList();
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public ArrayList<TrackSegment> getTrackSegmentList() {
        return this.trackSegmentList;
    }

    public void addTrackSegment(TrackSegment ts) {
        if (ts.getOwnerTrackGroup() != null) {
            System.err.println("The trackSegment is already owned by another TrackGroup.");
            return;
        }
        ts.setOwnerTrackGroup(this);
        this.trackSegmentList.add(ts);
    }

    public TrackSegment getTrackSegmentWithDetection(Detection detection) {
        ArrayList<TrackSegment> trackSegmentList = this.getTrackSegmentList();
        for (TrackSegment ts : trackSegmentList) {
            if (!ts.containsDetection(detection)) continue;
            return ts;
        }
        return null;
    }

    public void clearAllTrackSegment() {
        ArrayList<TrackSegment> trackSegmentListCopy = new ArrayList<TrackSegment>(this.trackSegmentList);
        for (TrackSegment ts : trackSegmentListCopy) {
            this.removeTrackSegment(ts);
        }
    }

    public void removeTrackSegment(TrackSegment ts) {
        ts.setOwnerTrackGroup(null);
        ts.removeAllLinks();
        this.trackSegmentList.remove(ts);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return this.description;
    }
}

