/*
 * Decompiled with CFR 0.152.
 */
package icy.file;

import icy.common.exception.UnsupportedFormatException;
import icy.file.FileUtil;
import icy.file.Loader;
import icy.file.SequenceFileImporter;
import icy.file.SequenceFileSticher;
import icy.gui.dialog.LoaderDialog;
import icy.image.AbstractImageProvider;
import icy.image.IcyBufferedImage;
import icy.image.ImageUtil;
import icy.image.colormap.IcyColorMap;
import icy.sequence.MetaDataUtil;
import icy.system.IcyExceptionHandler;
import icy.type.collection.CollectionUtil;
import icy.type.collection.array.Array1DUtil;
import icy.util.OMEUtil;
import icy.util.StringUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.filechooser.FileFilter;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.ome.OMEXMLMetadataImpl;
import ome.xml.meta.MetadataRetrieve;
import ome.xml.meta.OMEXMLMetadata;
import ome.xml.model.Channel;
import ome.xml.model.Pixels;
import ome.xml.model.Plane;
import plugins.kernel.importer.LociImporterPlugin;

public class SequenceFileGroupImporter
extends AbstractImageProvider
implements SequenceFileImporter {
    static final int MAX_IMPORTER = 16;
    protected SequenceFileSticher.SequenceFileGroup currentGroup = null;
    protected OMEXMLMetadata currentMetadata = null;
    protected SequenceFileSticher.SequencePosition[] positions;
    protected boolean ordering = true;
    protected int openFlags;
    protected int indYMul;
    protected int indZMul;
    protected int indTMul;
    protected int indCMul;
    protected int indSMul;
    protected final Map<String, SequenceFileImporter> importersPool = new HashMap<String, SequenceFileImporter>();

    public void setOrdering(boolean ordering) {
        this.ordering = ordering;
    }

    public boolean getOrdering() {
        return this.ordering;
    }

    @Override
    public boolean acceptFile(String path) {
        boolean result = false;
        if (this.currentGroup != null && this.currentGroup.ident.importer != null) {
            result = this.currentGroup.ident.importer.acceptFile(path);
        }
        if (!result) {
            result = Loader.isSupportedImageFile(path);
        }
        return result;
    }

    @Override
    public List<FileFilter> getFileFilters() {
        ArrayList<FileFilter> result = new ArrayList<FileFilter>();
        result.add(LoaderDialog.allImagesFileFilter);
        return result;
    }

    public boolean isOpen() {
        return this.getOpenedGroup() != null;
    }

    @Override
    public String getOpened() {
        if (this.currentGroup != null) {
            if (this.currentGroup.positions.size() == 1) {
                return this.currentGroup.positions.get(0).getPath();
            }
            return this.currentGroup.getBasePath();
        }
        return null;
    }

    public SequenceFileSticher.SequenceFileGroup getOpenedGroup() {
        return this.currentGroup;
    }

    @Override
    @Deprecated
    public boolean open(String path, int flags) throws UnsupportedFormatException, IOException, InterruptedException {
        this.open(CollectionUtil.createArrayList(path), flags);
        return true;
    }

    public void open(Collection<String> ids, int flags) throws InterruptedException, ClosedByInterruptException {
        this.open(SequenceFileSticher.groupFiles(null, ids, this.ordering, null), flags);
    }

    public void open(SequenceFileSticher.SequenceFileGroup group, int flags) {
        try {
            this.close();
        }
        catch (IOException e) {
            IcyExceptionHandler.showErrorMessage(e, true, true);
        }
        if (group == null) {
            return;
        }
        this.currentGroup = group;
        this.currentMetadata = null;
        this.openFlags = flags;
        if (!Loader.hasMetadata(group.basePath)) {
            this.openFlags |= 1;
        }
        this.buildIndexes();
    }

    protected boolean openImporter(SequenceFileImporter result, String path) throws UnsupportedFormatException, IOException, InterruptedException {
        if (!StringUtil.isEmpty(result.getOpened())) {
            result.close();
        }
        if (result instanceof LociImporterPlugin) {
            ((LociImporterPlugin)result).setGroupFiles(false);
        }
        return result.open(path, this.openFlags);
    }

    protected SequenceFileImporter createImporter(String path) throws InstantiationException, IllegalAccessException, UnsupportedFormatException, IOException, InterruptedException {
        if (!this.isOpen()) {
            return null;
        }
        SequenceFileImporter result = (SequenceFileImporter)this.currentGroup.ident.importer.getClass().newInstance();
        this.openImporter(result, path);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getFirstImporterPath() throws IOException, UnsupportedFormatException {
        Map<String, SequenceFileImporter> map = this.importersPool;
        synchronized (map) {
            if (!this.importersPool.isEmpty()) {
                return this.importersPool.keySet().iterator().next();
            }
        }
        for (SequenceFileSticher.SequencePosition pos : this.currentGroup.positions) {
            if (pos == null) continue;
            return pos.getPath();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequenceFileImporter getImporter(String path) throws IOException, UnsupportedFormatException, InterruptedException {
        if (StringUtil.isEmpty(path)) {
            return null;
        }
        try {
            SequenceFileImporter result;
            int numImporter;
            Map<String, SequenceFileImporter> map = this.importersPool;
            synchronized (map) {
                numImporter = this.importersPool.size();
                result = this.importersPool.remove(path);
            }
            if (result == null) {
                if (numImporter >= 16 && (result = this.getImporter(this.getFirstImporterPath())) != null) {
                    this.openImporter(result, path);
                }
                if (result == null) {
                    result = this.createImporter(path);
                }
            }
            return result;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseImporter(String path, SequenceFileImporter importer) {
        Map<String, SequenceFileImporter> map = this.importersPool;
        synchronized (map) {
            this.importersPool.put(path, importer);
        }
    }

    protected void buildIndexes() {
        SequenceFileSticher.SequenceFileGroup group = this.currentGroup;
        SequenceFileSticher.SequenceType baseType = group.ident.baseType;
        this.indYMul = group.totalSizeX / baseType.sizeX;
        this.indZMul = this.indYMul * (group.totalSizeY / baseType.sizeY);
        this.indTMul = this.indZMul * (group.totalSizeZ / baseType.sizeZ);
        this.indCMul = this.indTMul * (group.totalSizeT / baseType.sizeT);
        int totalLen = this.indCMul * (group.totalSizeC / baseType.sizeC);
        this.positions = new SequenceFileSticher.SequencePosition[totalLen];
        for (SequenceFileSticher.SequencePosition pos : this.currentGroup.positions) {
            int ind = this.getIdIndex(pos.getIndexX(), pos.getIndexY(), pos.getIndexZ(), pos.getIndexT(), pos.getIndexC());
            this.positions[ind] = pos;
        }
    }

    public boolean isStitchedImage() {
        if (!this.isOpen()) {
            return false;
        }
        return this.currentGroup.totalSizeX != this.currentGroup.ident.baseType.sizeX || this.currentGroup.totalSizeY != this.currentGroup.ident.baseType.sizeY;
    }

    protected FileCursor getCursor(int z, int t, int c) {
        SequenceFileSticher.SequenceType baseType = this.currentGroup.ident.baseType;
        int externalZ = z / baseType.sizeZ;
        int externalT = t / baseType.sizeT;
        int externalC = c / baseType.sizeC;
        int internalZ = z % baseType.sizeZ;
        int internalT = t % baseType.sizeT;
        int internalC = c % baseType.sizeC;
        int idInd = this.getIdIndex(0, 0, externalZ, externalT, externalC);
        return new FileCursor(idInd < this.positions.length ? this.positions[idInd] : null, idInd, internalZ, internalT, internalC);
    }

    protected List<TileIndex> getTileIndexes(Rectangle xyRegion) {
        if (!this.isStitchedImage()) {
            return CollectionUtil.createArrayList(new TileIndex(xyRegion, 0));
        }
        ArrayList<TileIndex> result = new ArrayList<TileIndex>();
        SequenceFileSticher.SequenceType baseType = this.currentGroup.ident.baseType;
        int tsx = baseType.sizeX;
        int tsy = baseType.sizeY;
        List<Rectangle> tiles = ImageUtil.getTileList(xyRegion, tsx, tsy);
        for (Rectangle tile : tiles) {
            int x = tile.x / tsx;
            int y = tile.y / tsy;
            result.add(new TileIndex(tile.intersection(xyRegion), x + y * this.indYMul));
        }
        return result;
    }

    public String getPath(int z, int t, int c) {
        if (!this.isOpen()) {
            return "";
        }
        SequenceFileSticher.SequencePosition pos = this.getCursor((int)z, (int)t, (int)c).position;
        if (pos != null) {
            return pos.getPath();
        }
        return "";
    }

    protected int getIdIndex(int x, int y, int z, int t, int c) {
        return x + y * this.indYMul + z * this.indZMul + t * this.indTMul + c * this.indCMul;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeInternalsImporters() throws IOException {
        Map<String, SequenceFileImporter> map = this.importersPool;
        synchronized (map) {
            for (SequenceFileImporter imp : this.importersPool.values()) {
                imp.close();
            }
            this.importersPool.clear();
        }
    }

    @Override
    public void close() throws IOException {
        this.closeInternalsImporters();
        this.positions = null;
        this.currentMetadata = null;
        this.currentGroup = null;
    }

    @Override
    public OMEXMLMetadataImpl getMetaData() throws UnsupportedFormatException, IOException, InterruptedException {
        return (OMEXMLMetadataImpl)this.getOMEXMLMetaData();
    }

    @Override
    public OMEXMLMetadata getOMEXMLMetaData() throws UnsupportedFormatException, IOException, InterruptedException {
        if (!this.isOpen()) {
            return null;
        }
        if (this.currentMetadata == null) {
            this.currentMetadata = this.buildMetaData();
        }
        return this.currentMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OMEXMLMetadata buildMetaData() throws UnsupportedFormatException, IOException, InterruptedException {
        SequenceFileImporter imp;
        SequenceFileSticher.SequencePosition position;
        SequenceFileSticher.SequenceFileGroup group = this.currentGroup;
        SequenceFileSticher.SequenceIdent ident = group.ident;
        SequenceFileSticher.SequenceType baseType = ident.baseType;
        String name = FileUtil.getFileName(group.positions.size() == 1 ? group.positions.get(0).getPath() : group.getBasePath(), false);
        OMEXMLMetadata result = null;
        if ((this.openFlags & 3) != 1 && (position = this.getCursor((int)0, (int)0, (int)0).position) != null && (imp = this.getImporter(position.getPath())) != null) {
            result = OMEUtil.createOMEXMLMetadata((MetadataRetrieve)imp.getOMEXMLMetaData(), 0);
            MetaDataUtil.setName(result, 0, name);
        }
        if (result == null) {
            result = MetaDataUtil.createMetadata(name);
        }
        MetaDataUtil.setMetaData(result, group.totalSizeX, group.totalSizeY, group.totalSizeC, group.totalSizeZ, group.totalSizeT, baseType.dataType, true);
        if (baseType.pixelSizeX > 0.0) {
            MetaDataUtil.setPixelSizeX(result, 0, baseType.pixelSizeX);
        }
        if (baseType.pixelSizeY > 0.0) {
            MetaDataUtil.setPixelSizeY(result, 0, baseType.pixelSizeY);
        }
        if (baseType.pixelSizeZ > 0.0) {
            MetaDataUtil.setPixelSizeZ(result, 0, baseType.pixelSizeZ);
        }
        if (baseType.timeInterval > 0.0) {
            MetaDataUtil.setTimeInterval(result, 0, baseType.timeInterval);
        }
        Pixels resultPixels = MetaDataUtil.getPixels(result, 0);
        MetaDataUtil.ensurePlane(resultPixels, group.totalSizeT - 1, group.totalSizeZ - 1, group.totalSizeC - 1);
        for (int c = 0; c < group.totalSizeC; ++c) {
            for (int z = 0; z < group.totalSizeZ; ++z) {
                for (int t = 0; t < group.totalSizeT; ++t) {
                    SequenceFileImporter imp2;
                    FileCursor cursor = this.getCursor(z, t, c);
                    SequenceFileSticher.SequencePosition position2 = cursor.position;
                    if (position2 == null) continue;
                    Plane metaPlane = null;
                    if ((this.openFlags & 3) != 1 && (imp2 = this.getImporter(position2.getPath())) != null) {
                        try {
                            OMEXMLMetadata meta = imp2.getOMEXMLMetaData();
                            Pixels metaPixels = MetaDataUtil.getPixels(meta, 0);
                            if (z == 0 && t == 0) {
                                Channel metaChannel = cursor.internalC < metaPixels.sizeOfChannelList() ? metaPixels.getChannel(cursor.internalC) : new Channel();
                                resultPixels.setChannel(c, metaChannel);
                                result.setChannelID(MetadataTools.createLSID("Channel", 0, c), 0, c);
                            }
                            if ((metaPlane = MetaDataUtil.getPlane(metaPixels, cursor.internalT, cursor.internalZ, cursor.internalC)) != null) {
                                for (int a = metaPlane.sizeOfLinkedAnnotationList() - 1; a >= 0; --a) {
                                    metaPlane.unlinkAnnotation(metaPlane.getLinkedAnnotation(a));
                                }
                            }
                        }
                        finally {
                            this.releaseImporter(position2.getPath(), imp2);
                        }
                    }
                    if (metaPlane == null) {
                        metaPlane = new Plane();
                    }
                    int resultPlaneInd = FormatTools.getIndex(result.getPixelsDimensionOrder(0).getValue(), group.totalSizeZ, group.totalSizeC, group.totalSizeT, group.totalSizeZ * group.totalSizeC * group.totalSizeT, z, c, t);
                    resultPixels.setPlane(resultPlaneInd, metaPlane);
                    metaPlane.setTheC(OMEUtil.getNonNegativeInteger(c));
                    metaPlane.setTheZ(OMEUtil.getNonNegativeInteger(z));
                    metaPlane.setTheT(OMEUtil.getNonNegativeInteger(t));
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTileHeight(int series) throws UnsupportedFormatException, IOException, InterruptedException {
        String path;
        SequenceFileImporter imp;
        if (!this.isOpen()) {
            return 0;
        }
        int tsy = this.currentGroup.totalSizeY;
        int isy = this.currentGroup.ident.baseType.sizeY;
        if ((tsy == isy || isy > 2048) && (imp = this.getImporter(path = this.getFirstImporterPath())) != null) {
            try {
                int n = imp.getTileHeight(series);
                return n;
            }
            finally {
                this.releaseImporter(path, imp);
            }
        }
        return isy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTileWidth(int series) throws UnsupportedFormatException, IOException, InterruptedException {
        String path;
        SequenceFileImporter imp;
        if (!this.isOpen()) {
            return 0;
        }
        int tsx = this.currentGroup.totalSizeX;
        int isx = this.currentGroup.ident.baseType.sizeX;
        if ((tsx == isx || isx > 2048) && (imp = this.getImporter(path = this.getFirstImporterPath())) != null) {
            try {
                int n = imp.getTileWidth(series);
                return n;
            }
            finally {
                this.releaseImporter(path, imp);
            }
        }
        return isx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getPixelsInternal(SequenceFileSticher.SequencePosition pos, int series, int resolution, Rectangle region, int z, int t, int c) throws UnsupportedFormatException, IOException, InterruptedException {
        if (pos == null) {
            SequenceFileSticher.SequenceType bt = this.currentGroup.ident.baseType;
            System.err.println("SequenceIdGroupImporter.getPixelsInternal: no image for tile [" + region.x / bt.sizeX + "," + region.y / bt.sizeY + "] !");
            return null;
        }
        SequenceFileImporter imp = this.getImporter(pos.getPath());
        if (imp == null) {
            System.err.println("SequenceIdGroupImporter.getPixelsInternal: cannot get importer for image '" + pos.getPath() + "' !");
            return null;
        }
        try {
            Object object = imp.getPixels(series, resolution, region, z, t, c);
            return object;
        }
        finally {
            this.releaseImporter(pos.getPath(), imp);
        }
    }

    @Override
    public Object getPixels(int series, int resolution, Rectangle rectangle, int z, int t, int c) throws UnsupportedFormatException, IOException, InterruptedException {
        if (!this.isOpen()) {
            return null;
        }
        SequenceFileSticher.SequenceFileGroup group = this.currentGroup;
        SequenceFileSticher.SequenceIdent ident = group.ident;
        SequenceFileSticher.SequenceType baseType = ident.baseType;
        Rectangle region = new Rectangle(group.totalSizeX, group.totalSizeY);
        if (rectangle != null) {
            region = region.intersection(rectangle);
        }
        FileCursor cursor = this.getCursor(z, t, c);
        List<TileIndex> tiles = this.getTileIndexes(region);
        if (tiles.size() == 1) {
            return this.getPixelsInternal(this.positions[cursor.index + tiles.get((int)0).index], series, resolution, region, cursor.internalZ, cursor.internalT, cursor.internalC);
        }
        Rectangle finalRegion = new Rectangle(region.x >> resolution, region.y >> resolution, region.width >> resolution, region.height >> resolution);
        Object result = Array1DUtil.createArray(baseType.dataType, finalRegion.width * finalRegion.height);
        boolean signed = baseType.dataType.isSigned();
        int dx = -finalRegion.x;
        int dy = -finalRegion.y;
        for (TileIndex tile : tiles) {
            Rectangle tileRegion = tile.region.intersection(region);
            Object pixels = this.getPixelsInternal(this.positions[cursor.index + tile.index], series, resolution, tileRegion, cursor.internalZ, cursor.internalT, cursor.internalC);
            if (pixels == null) continue;
            Rectangle finalTileRegion = new Rectangle(tileRegion.x >> resolution, tileRegion.y >> resolution, tileRegion.width >> resolution, tileRegion.height >> resolution);
            Point pt = finalTileRegion.getLocation();
            pt.translate(dx, dy);
            Array1DUtil.copyRect(pixels, finalTileRegion.getSize(), null, result, finalRegion.getSize(), pt, signed);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IcyBufferedImage getImageInternal(SequenceFileSticher.SequencePosition pos, int series, int resolution, Rectangle region, int z, int t, int c) throws UnsupportedFormatException, IOException, InterruptedException {
        if (pos == null) {
            SequenceFileSticher.SequenceType bt = this.currentGroup.ident.baseType;
            System.err.println("SequenceIdGroupImporter.getImageInternal: no image for tile [" + region.x / bt.sizeX + "," + region.y / bt.sizeY + "] !");
            return null;
        }
        SequenceFileImporter imp = this.getImporter(pos.getPath());
        if (imp == null) {
            System.err.println("SequenceIdGroupImporter.getImageInternal: cannot get importer for image '" + pos.getPath() + "' !");
            return null;
        }
        try {
            IcyBufferedImage icyBufferedImage = imp.getImage(series, resolution, region, z, t, c);
            return icyBufferedImage;
        }
        finally {
            this.releaseImporter(pos.getPath(), imp);
        }
    }

    private IcyBufferedImage getImageInternal(int series, int resolution, Rectangle rectangle, int z, int t, int c) throws UnsupportedFormatException, IOException, InterruptedException {
        if (!this.isOpen()) {
            return null;
        }
        SequenceFileSticher.SequenceFileGroup group = this.currentGroup;
        SequenceFileSticher.SequenceIdent ident = group.ident;
        SequenceFileSticher.SequenceType baseType = ident.baseType;
        Rectangle region = new Rectangle(group.totalSizeX, group.totalSizeY);
        if (rectangle != null) {
            region = region.intersection(rectangle);
        }
        FileCursor cursor = this.getCursor(z, t, c);
        List<TileIndex> tiles = this.getTileIndexes(region);
        if (tiles.size() == 1) {
            return this.getImageInternal(this.positions[cursor.index + tiles.get((int)0).index], series, resolution, region, cursor.internalZ, cursor.internalT, cursor.internalC);
        }
        Rectangle finalRegion = new Rectangle(region.x >> resolution, region.y >> resolution, region.width >> resolution, region.height >> resolution);
        IcyBufferedImage result = new IcyBufferedImage(finalRegion.width, finalRegion.height, 1, baseType.dataType);
        IcyColorMap colormap = null;
        int dx = -finalRegion.x;
        int dy = -finalRegion.y;
        for (TileIndex tile : tiles) {
            Rectangle tileRegion = tile.region.intersection(region);
            IcyBufferedImage image = this.getImageInternal(this.positions[cursor.index + tile.index], series, resolution, tileRegion, cursor.internalZ, cursor.internalT, cursor.internalC);
            if (image == null) continue;
            if (colormap == null) {
                colormap = image.getColorMap(0);
            }
            Point pt = new Point(tileRegion.x >> resolution, tileRegion.y >> resolution);
            pt.translate(dx, dy);
            result.copyData(image, null, pt);
        }
        if (colormap != null) {
            result.setColorMap(0, colormap);
        }
        return result;
    }

    @Override
    public IcyBufferedImage getImage(int series, int resolution, Rectangle rectangle, int z, int t, int c) throws UnsupportedFormatException, IOException, InterruptedException {
        if (!this.isOpen()) {
            return null;
        }
        SequenceFileSticher.SequenceFileGroup group = this.currentGroup;
        int sizeC = c == -1 ? group.totalSizeC : 1;
        ArrayList<IcyBufferedImage> result = new ArrayList<IcyBufferedImage>();
        if (sizeC > 1) {
            for (int ch = 0; ch < sizeC; ++ch) {
                result.add(this.getImageInternal(series, resolution, rectangle, z, t, ch));
            }
        } else {
            result.add(this.getImageInternal(series, resolution, rectangle, z, t, c == -1 ? 0 : c));
        }
        if (result.contains(null)) {
            SequenceFileSticher.SequenceIdent ident = group.ident;
            SequenceFileSticher.SequenceType baseType = ident.baseType;
            Rectangle region = new Rectangle(group.totalSizeX, group.totalSizeY);
            if (rectangle != null) {
                region = region.intersection(rectangle);
            }
            int sizeX = region.width >> resolution;
            int sizeY = region.height >> resolution;
            for (int i = 0; i < result.size(); ++i) {
                if (result.get(i) != null) continue;
                result.set(i, new IcyBufferedImage(sizeX, sizeY, 1, baseType.dataType));
            }
        }
        return IcyBufferedImage.createFrom(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IcyBufferedImage getThumbnail(int series) throws UnsupportedFormatException, IOException, InterruptedException {
        OMEXMLMetadata meta = this.getOMEXMLMetaData();
        if (meta == null) {
            return null;
        }
        if (this.isStitchedImage()) {
            return super.getThumbnail(series);
        }
        int sizeZ = MetaDataUtil.getSizeZ(meta, series);
        int sizeT = MetaDataUtil.getSizeT(meta, series);
        FileCursor cursor = this.getCursor(sizeZ / 2, sizeT / 2, 0);
        String path = cursor.position != null ? cursor.position.getPath() : this.getFirstImporterPath();
        SequenceFileImporter imp = this.getImporter(path);
        if (imp == null) {
            System.err.println("SequenceIdGroupImporter.getThumbnail: cannot find importer...");
            return null;
        }
        try {
            IcyBufferedImage icyBufferedImage = imp.getThumbnail(series);
            return icyBufferedImage;
        }
        finally {
            this.releaseImporter(path, imp);
        }
    }

    class TileIndex {
        public final Rectangle region;
        public final int index;

        public TileIndex(Rectangle region, int index) {
            this.region = region;
            this.index = index;
        }
    }

    class FileCursor {
        public final SequenceFileSticher.SequencePosition position;
        public final int index;
        public final int internalZ;
        public final int internalT;
        public final int internalC;

        public FileCursor(SequenceFileSticher.SequencePosition position, int index, int z, int t, int c) {
            this.position = position;
            this.index = index;
            this.internalZ = z;
            this.internalT = t;
            this.internalC = c;
        }
    }
}

