/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.frame.progress;

import icy.gui.frame.progress.CancelableProgressFrame;
import icy.math.RateMeter;
import icy.math.UnitUtil;
import icy.util.StringUtil;

public class DownloadFrame
extends CancelableProgressFrame {
    private double rate;
    private final RateMeter meter = new RateMeter();

    public DownloadFrame() {
        this("", 0.0);
    }

    public DownloadFrame(String path) {
        this(path, 0.0);
    }

    public DownloadFrame(String path, double length) {
        super(StringUtil.isEmpty(path) ? "" : StringUtil.limit("Downloading " + path, 64));
        this.length = length;
        this.rate = 0.0;
    }

    public void setPath(String path) {
        this.setMessage(StringUtil.limit("Downloading " + path, 64));
    }

    @Deprecated
    public void setMessageBase(String messageBase) {
        this.setMessage(messageBase);
    }

    @Override
    protected String buildMessage(String text) {
        String mess = text + "  [";
        mess = this.position != -1.0 ? mess + UnitUtil.getBytesString(this.position) : mess + "???";
        mess = mess + " / ";
        mess = this.length > 0.0 ? mess + UnitUtil.getBytesString(this.length) : mess + "???";
        if (this.rate > 0.0) {
            mess = mess + " - " + UnitUtil.getBytesString(this.rate) + "/s";
        }
        mess = mess + "]";
        return super.buildMessage(mess);
    }

    @Override
    public void setLength(double length) {
        if (this.getLength() != length) {
            this.meter.reset();
        }
        super.setLength(length);
    }

    @Override
    public void setPosition(double position) {
        this.rate = this.getPosition() < position ? this.meter.updateFromTotal(position) : 0.0;
        super.setPosition(position);
    }
}

