/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.inspector;

import icy.gui.component.AbstractRoisPanel;
import icy.gui.inspector.RoiControlPanel;
import icy.main.Icy;
import icy.preferences.GeneralPreferences;
import icy.roi.ROI;
import icy.roi.ROIEvent;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import java.awt.Component;
import javax.swing.event.ListSelectionEvent;

public class RoisPanel
extends AbstractRoisPanel {
    protected static final String PREF_ID = "ROIPanel";
    protected RoiControlPanel roiControlPanel;

    public RoisPanel() {
        super(GeneralPreferences.getPreferences().node(PREF_ID));
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.roiControlPanel = new RoiControlPanel(this);
        this.add((Component)this.roiControlPanel, "South");
        this.validate();
    }

    @Override
    protected AbstractRoisPanel.ROIResults createNewROIResults(ROI roi) {
        return new CustomROIResults(roi);
    }

    @Override
    protected Sequence getSequence() {
        return Icy.getMainInterface().getActiveSequence();
    }

    @Override
    protected void refreshTableDataStructureInternal() {
        super.refreshTableDataStructureInternal();
        this.roiControlPanel.selectionChanged();
    }

    @Override
    protected void refreshTableDataInternal() {
        super.refreshTableDataInternal();
        this.roiControlPanel.selectionChanged();
    }

    @Override
    protected void refreshTableSelectionInternal() {
        super.refreshTableSelectionInternal();
        this.roiControlPanel.selectionChanged();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.roiSelectionModel.getValueIsAdjusting()) {
            return;
        }
        if (this.modifySelection.availablePermits() <= 0) {
            return;
        }
        this.roiControlPanel.selectionChanged();
    }

    @Override
    public void activeSequenceChanged(SequenceEvent event) {
        super.activeSequenceChanged(event);
        if (event.getSourceType() == SequenceEvent.SequenceEventSourceType.SEQUENCE_DATA) {
            this.roiControlPanel.refreshROIActions();
        }
    }

    protected class CustomROIResults
    extends AbstractRoisPanel.ROIResults {
        protected CustomROIResults(ROI roi) {
            super(roi);
        }

        @Override
        public void roiChanged(ROIEvent event) {
            ROI r = event.getSource();
            if (r.isSelected()) {
                RoisPanel.this.roiControlPanel.roiChanged(event);
            }
            super.roiChanged(event);
        }
    }
}

