/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.lut;

import icy.action.IcyAbstractAction;
import icy.gui.component.BorderedPanel;
import icy.image.colormap.IcyColorMap;
import icy.image.colormap.IcyColorMapComponent;
import icy.image.lut.LUT;
import icy.resource.icon.IcyIcon;
import icy.util.ColorUtil;
import icy.util.EventUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.EventListenerList;

public class ColormapViewer
extends BorderedPanel
implements MouseListener,
MouseMotionListener,
LUT.LUTChannelListener {
    private static final long serialVersionUID = -8338817004756013113L;
    private static final int POINT_SIZE = 10;
    private static final int LINE_SIZE = 3;
    private static final int BORDER_WIDTH = 4;
    private static final int BORDER_HEIGHT = 4;
    private static final int MIN_INDEX = 0;
    private static final int MAX_INDEX = 255;
    private static final int MIN_VALUE = 0;
    private static final int MAX_VALUE = 255;
    private final LUT.LUTChannel lutChannel;
    private boolean alphaEnabled;
    private final JPopupMenu menu;
    private final EventListenerList colorMapPositionListeners;
    final IcyColorMap colormap;
    private float pixToIndexRatio;
    private float indexToPixRatio;
    private float pixToValueRatio;
    private float valueToPixRatio;
    private ActionType action;
    private IcyColorMapComponent currentComponent;
    IcyColorMapComponent.ControlPoint currentControlPoint;

    public ColormapViewer(LUT.LUTChannel lutChannel) {
        this.setMinimumSize(new Dimension(100, 100));
        this.setPreferredSize(new Dimension(240, 100));
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setFocusable(true);
        this.lutChannel = lutChannel;
        this.colormap = lutChannel.getColorMap();
        this.colorMapPositionListeners = new EventListenerList();
        this.menu = new JPopupMenu();
        this.alphaEnabled = true;
        this.action = ActionType.NULL;
        this.currentComponent = null;
        this.currentControlPoint = null;
        this.updateRatios();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.buildActionMap();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.lutChannel.addListener(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.lutChannel.removeListener(this);
    }

    void buildActionMap() {
        InputMap imap = this.getInputMap(0);
        ActionMap amap = this.getActionMap();
        imap.put(KeyStroke.getKeyStroke(127, 0), "delete");
        amap.put("delete", new IcyAbstractAction("delete", (IcyIcon)null, "Delete control point", 127, 0){
            private static final long serialVersionUID = 2375566345981567387L;

            @Override
            protected boolean doAction(ActionEvent e) {
                if (ColormapViewer.this.currentControlPoint != null) {
                    ColormapViewer.this.currentControlPoint.remove();
                    return true;
                }
                return false;
            }
        });
    }

    public IcyColorMap getColormap() {
        return this.colormap;
    }

    public int indexToPix(int index) {
        int clientX = this.getClientX();
        int pix = (int)((float)index * this.indexToPixRatio) + clientX;
        return Math.max(Math.min(pix, this.getClientWidth() + clientX), clientX);
    }

    public int pixToIndex(int pixel) {
        int ind = (int)((float)(pixel - this.getClientX()) * this.pixToIndexRatio);
        return Math.max(Math.min(ind, 255), 0);
    }

    public int valueToPix(int value) {
        int clientY = this.getClientY();
        int hl = this.getClientHeight() - 1 + clientY;
        int pix = hl - (int)((float)value * this.valueToPixRatio);
        return Math.max(Math.min(pix, hl), clientY);
    }

    public int pixToValue(int pixel) {
        int hl = this.getClientHeight() - 1 + this.getClientY();
        int value = (int)((float)(hl - pixel) * this.pixToValueRatio);
        return Math.max(Math.min(value, 255), 0);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.updateRatios();
        Graphics2D g2 = (Graphics2D)g.create();
        int w = this.getWidth();
        int h = this.getHeight();
        for (int i = 0; i < w; ++i) {
            Color curColor = this.getColorFromPixel(i);
            Color grayMixed = ColorUtil.mixOver(Color.gray, curColor);
            Color whiteMixed = ColorUtil.mixOver(Color.white, curColor);
            for (int j = 0; j < h; j += 16) {
                if (((i ^ j) & 0x10) != 0) {
                    g2.setColor(grayMixed);
                } else {
                    g2.setColor(whiteMixed);
                }
                g2.drawLine(i, j, i, j + 15);
            }
        }
        if (this.alphaEnabled) {
            this.drawColormapBand(g2, this.colormap.alpha);
        }
        switch (this.colormap.getType()) {
            case RGB: {
                this.drawColormapBand(g2, this.colormap.blue);
                this.drawColormapBand(g2, this.colormap.green);
                this.drawColormapBand(g2, this.colormap.red);
                break;
            }
            case GRAY: {
                this.drawColormapBand(g2, this.colormap.gray);
            }
        }
        g2.setColor(Color.black);
        g2.drawRect(0, 0, w - 1, h - 1);
        g2.dispose();
    }

    private void drawColormapBand(Graphics2D g, IcyColorMapComponent band) {
        this.drawColormap(g, band);
        this.drawControlPoints(g, band);
    }

    private void drawColormap(Graphics2D g, IcyColorMapComponent cmc) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GeneralPath polyline = null;
        if (cmc.isRawData()) {
            int x = this.getClientX();
            int w = this.getClientWidth();
            polyline = new GeneralPath(0, w);
            int intensity = this.valueToPix(cmc.map[this.pixToIndex(0)]);
            polyline.moveTo(x, intensity);
            for (int i = x; i < w + x; ++i) {
                intensity = this.valueToPix(cmc.map[this.pixToIndex(i)]);
                polyline.lineTo(i, intensity);
            }
        } else if (cmc.getControlPointCount() > 0) {
            polyline = new GeneralPath(0, cmc.getControlPointCount());
            ArrayList<IcyColorMapComponent.ControlPoint> controlPoints = cmc.getControlPoints();
            int x = this.getPixelPosX(controlPoints.get(0));
            int y = this.getPixelPosY(controlPoints.get(0));
            polyline.moveTo(x, y);
            for (int i = 1; i < cmc.getControlPointCount(); ++i) {
                x = this.getPixelPosX(controlPoints.get(i));
                y = this.getPixelPosY(controlPoints.get(i));
                polyline.lineTo(x, y);
            }
        }
        if (this.isFocused(cmc)) {
            g2.setColor(Color.lightGray);
        } else {
            g2.setColor(Color.black);
        }
        g2.setStroke(new BasicStroke(4.0f));
        g2.draw(polyline);
        g2.setColor(this.getColor(cmc));
        g2.setStroke(new BasicStroke(3.0f));
        g2.draw(polyline);
        g2.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawControlPoints(Graphics2D g, IcyColorMapComponent cmc) {
        ArrayList<IcyColorMapComponent.ControlPoint> controlPoints;
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int offset_oval = 5;
        Color color = this.getColor(cmc);
        ArrayList<IcyColorMapComponent.ControlPoint> arrayList = cmc.getControlPoints();
        synchronized (arrayList) {
            controlPoints = new ArrayList<IcyColorMapComponent.ControlPoint>(cmc.getControlPoints());
        }
        for (IcyColorMapComponent.ControlPoint controlPoint : controlPoints) {
            int x = this.getPixelPosX(controlPoint);
            int y = this.getPixelPosY(controlPoint);
            if (controlPoint.isFixed()) {
                g2.setColor(color);
                g2.fillRect(x - 4, y - 4, 8, 8);
                g2.setColor(Color.darkGray);
                g2.drawRect(x - 4, y - 4, 8, 8);
                if (this.isFocused(controlPoint)) {
                    g2.setColor(Color.white);
                } else {
                    g2.setColor(Color.black);
                }
                g2.drawRect(x - 5, y - 5, 10, 10);
                continue;
            }
            g2.setColor(color);
            g2.fillOval(x - 4, y - 4, 8, 8);
            g2.setColor(Color.darkGray);
            g2.drawOval(x - 4, y - 4, 8, 8);
            if (this.isFocused(controlPoint)) {
                g2.setColor(Color.white);
            } else {
                g2.setColor(Color.black);
            }
            g2.drawOval(x - 5, y - 5, 10, 10);
        }
        g2.dispose();
    }

    public boolean isAlphaEnabled() {
        return this.alphaEnabled;
    }

    public void setAlphaEnabled(boolean value) {
        if (this.alphaEnabled != value) {
            this.alphaEnabled = value;
            if (!value) {
                this.colormap.alpha.removeAllControlPoint();
            }
            this.repaint();
        }
    }

    public void setCurrentElements(IcyColorMapComponent cmc, IcyColorMapComponent.ControlPoint cp) {
        if (this.currentControlPoint != cp) {
            this.currentControlPoint = cp;
            this.repaint();
        }
        if (this.currentComponent != cmc) {
            this.currentComponent = cmc;
            this.repaint();
        }
        int cursor = cmc != null || cp != null ? 12 : 0;
        if (this.getCursor().getType() != cursor) {
            this.setCursor(new Cursor(cursor));
        }
    }

    private boolean isFocused(IcyColorMapComponent cmc) {
        return cmc != null && this.currentComponent == cmc;
    }

    private boolean isFocused(IcyColorMapComponent.ControlPoint cp) {
        return cp != null && this.currentControlPoint == cp;
    }

    public Color getColor(int index) {
        return this.colormap.getColor(index);
    }

    public Color getColor(IcyColorMapComponent cmc) {
        if (cmc == this.colormap.red) {
            return Color.red;
        }
        if (cmc == this.colormap.green) {
            return Color.green;
        }
        if (cmc == this.colormap.blue) {
            return Color.blue;
        }
        if (cmc == this.colormap.gray) {
            return Color.gray;
        }
        if (cmc == this.colormap.alpha) {
            return Color.white;
        }
        return Color.black;
    }

    public Color getColorFromPixel(int pixel) {
        return this.getColor(this.pixToIndex(pixel));
    }

    private void updateRatios() {
        int w = this.getClientWidth();
        int h = this.getClientHeight();
        if (w <= 0) {
            this.indexToPixRatio = 0.0f;
            this.pixToIndexRatio = 0.0f;
        } else {
            this.indexToPixRatio = (float)(w - 1) / 255.0f;
            this.pixToIndexRatio = this.indexToPixRatio != 0.0f ? 1.0f / this.indexToPixRatio : 0.0f;
        }
        if (h <= 0) {
            this.valueToPixRatio = 0.0f;
            this.pixToValueRatio = 0.0f;
        } else {
            this.valueToPixRatio = (float)(h - 1) / 255.0f;
            this.pixToValueRatio = this.valueToPixRatio != 0.0f ? 1.0f / this.valueToPixRatio : 0.0f;
        }
    }

    public boolean isOverlapped(IcyColorMapComponent cmc, Point pos) {
        int index_min = Math.max(0, this.pixToIndex(pos.x - 3));
        int index_max = Math.min(255, this.pixToIndex(pos.x + 3));
        for (int ind = index_min; ind < index_max; ++ind) {
            if (!(Point2D.distance(pos.x, pos.y, this.indexToPix(ind), this.valueToPix(cmc.map[ind])) <= 4.0)) continue;
            return true;
        }
        return false;
    }

    public boolean isOverlapped(IcyColorMapComponent.ControlPoint cp, Point p) {
        return this.getDistance(cp, p) <= 5.0;
    }

    public double getDistance(IcyColorMapComponent.ControlPoint cp, Point p) {
        return Point2D.distance(p.x, p.y, this.indexToPix(cp.getIndex()), this.valueToPix(cp.getValue()));
    }

    public void setPixelPosition(IcyColorMapComponent.ControlPoint cp, int x, int y) {
        cp.setPosition(this.pixToIndex(x), this.pixToValue(y));
    }

    public int getPixelPosX(IcyColorMapComponent.ControlPoint cp) {
        return this.indexToPix(cp.getIndex());
    }

    public int getPixelPosY(IcyColorMapComponent.ControlPoint cp) {
        return this.valueToPix(cp.getValue());
    }

    private IcyColorMapComponent getOverlappedColormapController(Point pos) {
        IcyColorMap.IcyColorMapType type = this.colormap.getType();
        if (type == IcyColorMap.IcyColorMapType.RGB) {
            if (this.isOverlapped(this.colormap.red, pos)) {
                return this.colormap.red;
            }
            if (this.isOverlapped(this.colormap.green, pos)) {
                return this.colormap.green;
            }
            if (this.isOverlapped(this.colormap.blue, pos)) {
                return this.colormap.blue;
            }
        }
        if (type == IcyColorMap.IcyColorMapType.GRAY && this.isOverlapped(this.colormap.gray, pos)) {
            return this.colormap.gray;
        }
        if (this.alphaEnabled && this.isOverlapped(this.colormap.alpha, pos)) {
            return this.colormap.alpha;
        }
        return null;
    }

    private IcyColorMapComponent.ControlPoint getClosestOverlappedControlPoint(Point pos) {
        IcyColorMapComponent.ControlPoint point;
        IcyColorMap.IcyColorMapType type = this.colormap.getType();
        if (type == IcyColorMap.IcyColorMapType.RGB) {
            point = this.getClosestOverlappedControlPoint(this.colormap.red, pos);
            if (point != null) {
                return point;
            }
            point = this.getClosestOverlappedControlPoint(this.colormap.green, pos);
            if (point != null) {
                return point;
            }
            point = this.getClosestOverlappedControlPoint(this.colormap.blue, pos);
            if (point != null) {
                return point;
            }
        }
        if (type == IcyColorMap.IcyColorMapType.GRAY && (point = this.getClosestOverlappedControlPoint(this.colormap.gray, pos)) != null) {
            return point;
        }
        if (this.alphaEnabled && (point = this.getClosestOverlappedControlPoint(this.colormap.alpha, pos)) != null) {
            return point;
        }
        return null;
    }

    private IcyColorMapComponent.ControlPoint getClosestOverlappedControlPoint(IcyColorMapComponent cmc, Point pos) {
        ArrayList<IcyColorMapComponent.ControlPoint> overlapped = new ArrayList<IcyColorMapComponent.ControlPoint>();
        for (IcyColorMapComponent.ControlPoint point : cmc.getControlPoints()) {
            if (!this.isOverlapped(point, pos)) continue;
            overlapped.add(point);
        }
        int size = overlapped.size();
        if (size > 0) {
            IcyColorMapComponent.ControlPoint closestPoint = (IcyColorMapComponent.ControlPoint)overlapped.get(0);
            double minDist = this.getDistance(closestPoint, pos);
            for (int i = 1; i < size; ++i) {
                IcyColorMapComponent.ControlPoint currentPoint = (IcyColorMapComponent.ControlPoint)overlapped.get(i);
                double curDist = this.getDistance(currentPoint, pos);
                if (!(curDist < minDist)) continue;
                closestPoint = currentPoint;
                minDist = curDist;
            }
            return closestPoint;
        }
        return null;
    }

    IcyColorMapComponent.ControlPoint setControlPoint(IcyColorMapComponent comp, Point pos) {
        return comp.setControlPoint(this.pixToIndex(pos.x), this.pixToValue(pos.y));
    }

    private void showPopupMenu(final Point pos) {
        this.menu.removeAll();
        final IcyColorMapComponent.ControlPoint cp = this.currentControlPoint;
        if (cp != null) {
            if (cp.isFixed()) {
                return;
            }
            JMenuItem removeItem = new JMenuItem("remove (Shift + Click)");
            removeItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    cp.remove();
                }
            });
            this.menu.add(removeItem);
        } else {
            IcyColorMap.IcyColorMapType type = this.colormap.getType();
            if (type == IcyColorMap.IcyColorMapType.GRAY) {
                JMenuItem addCPItem = new JMenuItem("add Gray point");
                addCPItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ColormapViewer.this.setControlPoint(ColormapViewer.this.colormap.gray, pos);
                    }
                });
                this.menu.add(addCPItem);
            }
            if (type == IcyColorMap.IcyColorMapType.RGB) {
                JMenuItem addCRPItem = new JMenuItem("add Red point");
                JMenuItem addCGPItem = new JMenuItem("add Green point");
                JMenuItem addCBPItem = new JMenuItem("add Blue point");
                addCRPItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ColormapViewer.this.setControlPoint(ColormapViewer.this.colormap.red, pos);
                    }
                });
                addCGPItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ColormapViewer.this.setControlPoint(ColormapViewer.this.colormap.green, pos);
                    }
                });
                addCBPItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ColormapViewer.this.setControlPoint(ColormapViewer.this.colormap.blue, pos);
                    }
                });
                this.menu.add(addCRPItem);
                this.menu.add(addCGPItem);
                this.menu.add(addCBPItem);
            }
            if (this.alphaEnabled) {
                JMenuItem addAlphaCPItem = new JMenuItem("add Alpha point");
                addAlphaCPItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ColormapViewer.this.setControlPoint(ColormapViewer.this.colormap.alpha, pos);
                    }
                });
                this.menu.add(addAlphaCPItem);
            }
        }
        this.menu.pack();
        this.menu.validate();
        this.menu.show(this, pos.x, pos.y);
    }

    private void updateCurrentElements(Point pos) {
        IcyColorMapComponent.ControlPoint cp = this.getClosestOverlappedControlPoint(pos);
        IcyColorMapComponent cmc = cp == null ? this.getOverlappedColormapController(pos) : null;
        this.setCurrentElements(cmc, cp);
    }

    private void updateColormapPositionInfo(Point pos) {
        int value;
        int index;
        IcyColorMapComponent.ControlPoint cp = this.action != ActionType.NULL ? this.currentControlPoint : this.getClosestOverlappedControlPoint(pos);
        if (cp != null) {
            index = cp.getIndex();
            value = cp.getValue();
        } else {
            index = this.pixToIndex(pos.x);
            value = this.pixToValue(pos.y);
        }
        this.colormapPositionChanged(index, value);
    }

    public void onColormapChanged() {
        this.repaint();
    }

    public void addColormapPositionListener(ColormapPositionListener listener) {
        this.colorMapPositionListeners.add(ColormapPositionListener.class, listener);
    }

    public void removeColormapPositionListener(ColormapPositionListener listener) {
        this.colorMapPositionListeners.remove(ColormapPositionListener.class, listener);
    }

    public void colormapPositionChanged(int index, int value) {
        for (ColormapPositionListener listener : (ColormapPositionListener[])this.colorMapPositionListeners.getListeners(ColormapPositionListener.class)) {
            listener.positionChanged(index, value);
        }
    }

    @Override
    public void lutChannelChanged(LUT.LUTChannelEvent e) {
        if (e.getType() == LUT.LUTChannelEvent.LUTChannelEventType.COLORMAP_CHANGED) {
            this.onColormapChanged();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.colormapPositionChanged(-1, -1);
        if (this.action == ActionType.NULL) {
            this.setCurrentElements(null, null);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Point pos = e.getPoint();
        if (EventUtil.isLeftMouseButton(e)) {
            if (this.currentControlPoint != null) {
                if (EventUtil.isShiftDown(e)) {
                    this.currentControlPoint.remove();
                } else {
                    this.action = ActionType.MODIFY_CONTROLPOINT;
                }
            } else if (this.currentComponent != null) {
                this.action = ActionType.MODIFY_CONTROLPOINT;
                this.setCurrentElements(null, this.setControlPoint(this.currentComponent, pos));
            }
        } else if (EventUtil.isRightMouseButton(e)) {
            this.showPopupMenu(pos);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (EventUtil.isLeftMouseButton(e)) {
            this.action = ActionType.NULL;
            this.updateCurrentElements(e.getPoint());
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Point pos = e.getPoint();
        switch (this.action) {
            case MODIFY_CONTROLPOINT: {
                this.setPixelPosition(this.currentControlPoint, pos.x, pos.y);
            }
        }
        this.updateColormapPositionInfo(pos);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Point pos = e.getPoint();
        this.updateCurrentElements(pos);
        this.updateColormapPositionInfo(pos);
    }

    public static interface ColormapPositionListener
    extends EventListener {
        public void positionChanged(int var1, int var2);
    }

    private static enum ActionType {
        NULL,
        MODIFY_CONTROLPOINT;

    }
}

