/*
 * Decompiled with CFR 0.152.
 */
package icy.image;

import icy.gui.util.FontUtil;
import icy.network.URLUtil;
import icy.system.thread.ThreadUtil;
import icy.util.GraphicsUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

public class ImageUtil {
    public static String getImageTypeString(int type) {
        switch (type) {
            case 0: {
                return "TYPE_CUSTOM";
            }
            case 1: {
                return "TYPE_INT_RGB";
            }
            case 2: {
                return "TYPE_INT_ARGB";
            }
            case 3: {
                return "TYPE_INT_ARGB_PRE";
            }
            case 4: {
                return "TYPE_INT_BGR";
            }
            case 5: {
                return "TYPE_3BYTE_BGR";
            }
            case 6: {
                return "TYPE_4BYTE_ABGR";
            }
            case 7: {
                return "TYPE_4BYTE_ABGR_PRE";
            }
            case 8: {
                return "TYPE_USHORT_565_RGB";
            }
            case 9: {
                return "TYPE_USHORT_555_RGB";
            }
            case 10: {
                return "TYPE_BYTE_GRAY";
            }
            case 11: {
                return "TYPE_USHORT_GRAY";
            }
            case 12: {
                return "TYPE_BYTE_BINARY";
            }
            case 13: {
                return "TYPE_BYTE_INDEXED";
            }
        }
        return "UNKNOWN TYPE";
    }

    public static String getTransparencyString(int transparency) {
        switch (transparency) {
            case 1: {
                return "OPAQUE";
            }
            case 2: {
                return "BITMASK";
            }
            case 3: {
                return "TRANSLUCENT";
            }
        }
        return "UNKNOWN TRANSPARENCY";
    }

    public static void waitImageReady(Image image) {
        if (image != null) {
            long st = System.currentTimeMillis();
            while (image.getWidth(null) == -1 && System.currentTimeMillis() - st < 2000L) {
                ThreadUtil.sleep(1);
            }
        }
    }

    public static BufferedImage createIndexedImage(int w, int h, IndexColorModel cm, byte[] data) {
        WritableRaster raster = Raster.createInterleavedRaster(new DataBufferByte(data, w * h, 0), w, h, w, 1, new int[]{0}, null);
        return new BufferedImage(cm, raster, false, null);
    }

    public static BufferedImage load(String path, boolean displayError) {
        return ImageUtil.load(URLUtil.getURL(path), displayError);
    }

    public static BufferedImage load(String path) {
        return ImageUtil.load(path, true);
    }

    public static BufferedImage load(URL url, boolean displayError) {
        block3: {
            if (url != null) {
                try {
                    return ImageIO.read(url);
                }
                catch (Exception e) {
                    if (!displayError) break block3;
                    System.err.println("Can't load image from " + url);
                }
            }
        }
        return null;
    }

    public static Image loadAsync(URL url) {
        return Toolkit.getDefaultToolkit().createImage(url);
    }

    public static Image loadAsync(String path) {
        return Toolkit.getDefaultToolkit().createImage(path);
    }

    public static BufferedImage load(URL url) {
        return ImageUtil.load(url, true);
    }

    public static BufferedImage load(File file, boolean displayError) {
        block3: {
            if (file != null) {
                try {
                    return ImageIO.read(file);
                }
                catch (IOException e) {
                    if (!displayError) break block3;
                    System.err.println("Can't load image from " + file);
                }
            }
        }
        return null;
    }

    public static BufferedImage load(File file) {
        return ImageUtil.load(file, true);
    }

    public static BufferedImage load(InputStream input, boolean displayError) {
        block3: {
            if (input != null) {
                try {
                    return ImageIO.read(input);
                }
                catch (Exception e) {
                    if (!displayError) break block3;
                    System.err.println("Can't load image from stream " + input);
                }
            }
        }
        return null;
    }

    public static BufferedImage load(InputStream input) {
        return ImageUtil.load(input, true);
    }

    @Deprecated
    public static BufferedImage loadImage(String path, boolean displayError) {
        return ImageUtil.load(path, displayError);
    }

    @Deprecated
    public static BufferedImage loadImage(String path) {
        return ImageUtil.load(path);
    }

    @Deprecated
    public static BufferedImage loadImage(URL url, boolean displayError) {
        return ImageUtil.load(url, displayError);
    }

    @Deprecated
    public static Image loadImage(URL url) {
        return ImageUtil.load(url);
    }

    @Deprecated
    public static BufferedImage loadImage(File file, boolean displayError) {
        return ImageUtil.load(file, displayError);
    }

    @Deprecated
    public static BufferedImage loadImage(File file) {
        return ImageUtil.load(file);
    }

    @Deprecated
    public static BufferedImage loadImage(InputStream input, boolean displayError) {
        return ImageUtil.load(input, displayError);
    }

    @Deprecated
    public static BufferedImage loadImage(InputStream input) {
        return ImageUtil.load(input);
    }

    public static boolean save(RenderedImage image, String format, String path) {
        if (path != null) {
            try {
                return ImageIO.write(image, format, new FileOutputStream(path));
            }
            catch (IOException e) {
                System.err.println("Can't save image to " + path);
            }
        }
        return false;
    }

    public static boolean save(RenderedImage image, String format, File file) {
        if (file != null) {
            try {
                return ImageIO.write(image, format, file);
            }
            catch (IOException e) {
                System.err.println("Can't save image to " + file);
            }
        }
        return false;
    }

    @Deprecated
    public static boolean saveImage(RenderedImage image, String format, String path) {
        return ImageUtil.save(image, format, path);
    }

    @Deprecated
    public static boolean saveImage(RenderedImage image, String format, File file) {
        return ImageUtil.save(image, format, file);
    }

    public static RenderedImage toRenderedImage(Image image) {
        return ImageUtil.toBufferedImage(image);
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        ImageUtil.waitImageReady(image);
        BufferedImage bufImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g = bufImage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bufImage;
    }

    public static BufferedImage scale(Image image, int width, int height) {
        if (image != null) {
            BufferedImage result = new BufferedImage(width, height, 2);
            Graphics2D g = result.createGraphics();
            g.setComposite(AlphaComposite.Src);
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(image, 0, 0, width, height, null);
            g.dispose();
            return result;
        }
        return null;
    }

    public static BufferedImage scaleQuality(Image image, int width, int height) {
        if (image != null) {
            Image current = image;
            ImageUtil.waitImageReady(image);
            int w = image.getWidth(null);
            int h = image.getHeight(null);
            do {
                if (w > width) {
                    if ((w /= 2) < width) {
                        w = width;
                    }
                } else {
                    w = width;
                }
                if (h > height) {
                    if ((h /= 2) < height) {
                        h = height;
                    }
                } else {
                    h = height;
                }
                BufferedImage result = new BufferedImage(w, h, 2);
                Graphics2D g = result.createGraphics();
                g.setComposite(AlphaComposite.Src);
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g.drawImage(current, 0, 0, w, h, null);
                g.dispose();
                current = result;
            } while (w != width || h != height);
            return (BufferedImage)current;
        }
        return null;
    }

    public static BufferedImage convert(Image in, BufferedImage out) {
        ImageUtil.waitImageReady(in);
        BufferedImage result = out == null ? new BufferedImage(in.getWidth(null), in.getHeight(null), 2) : out;
        Graphics g = result.getGraphics();
        g.drawImage(in, 0, 0, null);
        g.dispose();
        return result;
    }

    public static boolean isGray(BufferedImage image) {
        int[] rgbArray;
        if (image == null) {
            return false;
        }
        if (image.getType() == 10) {
            return true;
        }
        if (image.getType() == 11) {
            return true;
        }
        for (int value : rgbArray = image.getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth())) {
            int c0 = value >> 0 & 0xFF;
            int c1 = value >> 8 & 0xFF;
            if (c0 != c1) {
                return false;
            }
            int c2 = value >> 16 & 0xFF;
            if (c0 == c2) continue;
            return false;
        }
        return true;
    }

    public static BufferedImage toGray(Image image) {
        if (image != null) {
            ImageUtil.waitImageReady(image);
            return ImageUtil.convert(image, new BufferedImage(image.getWidth(null), image.getHeight(null), 10));
        }
        return null;
    }

    public static BufferedImage toRGBImage(Image image) {
        if (image != null) {
            ImageUtil.waitImageReady(image);
            return ImageUtil.convert(image, new BufferedImage(image.getWidth(null), image.getHeight(null), 1));
        }
        return null;
    }

    public static BufferedImage toARGBImage(Image image) {
        if (image != null) {
            ImageUtil.waitImageReady(image);
            return ImageUtil.convert(image, new BufferedImage(image.getWidth(null), image.getHeight(null), 2));
        }
        return null;
    }

    @Deprecated
    public static BufferedImage scaleImage(Image image, int width, int height) {
        return ImageUtil.scale(image, width, height);
    }

    @Deprecated
    public static BufferedImage scaleImageQuality(Image image, int width, int height) {
        return ImageUtil.scaleQuality(image, width, height);
    }

    @Deprecated
    public static BufferedImage convertImage(Image in, BufferedImage out) {
        return ImageUtil.convert(in, out);
    }

    @Deprecated
    public static BufferedImage toGrayImage(Image image) {
        return ImageUtil.toGray(image);
    }

    public static BufferedImage getCopy(Image in) {
        return ImageUtil.convert(in, null);
    }

    public static boolean sameSize(BufferedImage im1, BufferedImage im2) {
        return im1.getWidth() == im2.getWidth() && im1.getHeight() == im2.getHeight();
    }

    public static List<Rectangle> getTileList(Rectangle region, int tileW, int tileH) {
        ArrayList<Rectangle> result = new ArrayList<Rectangle>();
        if (tileW <= 0 || tileH <= 0 || region.isEmpty()) {
            return result;
        }
        int startX = region.x / tileW * tileW;
        int startY = region.y / tileH * tileH;
        int endX = (region.x + (region.width - 1)) / tileW * tileW;
        int endY = (region.y + (region.height - 1)) / tileH * tileH;
        for (int y = startY; y <= endY; y += tileH) {
            for (int x = startX; x <= endX; x += tileW) {
                result.add(new Rectangle(x, y, tileW, tileH));
            }
        }
        return result;
    }

    public static List<Rectangle> getTileList(int sizeX, int sizeY, int tileW, int tileH) {
        return ImageUtil.getTileList(new Rectangle(0, 0, sizeX, sizeY), tileW, tileH);
    }

    public static void applyColorFilter(Image image, Color color, float alpha) {
        if (image != null) {
            ImageUtil.waitImageReady(image);
            Graphics2D g = (Graphics2D)image.getGraphics();
            Rectangle rect = new Rectangle(image.getWidth(null), image.getHeight(null));
            g.setComposite(AlphaComposite.getInstance(3, alpha));
            g.setColor(color);
            g.fill(rect);
            g.dispose();
        }
    }

    public static Image getColorImageFromAlphaImage(Image alphaImage, Color color) {
        return ImageUtil.paintColorImageFromAlphaImage(alphaImage, null, color);
    }

    public static Image paintColorImageFromAlphaImage(Image alphaImage, Image out, Color color) {
        Image result;
        int h;
        int w;
        if (alphaImage == null) {
            return null;
        }
        if (out == null) {
            ImageUtil.waitImageReady(alphaImage);
            w = alphaImage.getWidth(null);
            h = alphaImage.getHeight(null);
            if (w == -1 || h == -1) {
                return null;
            }
            result = new BufferedImage(w, h, 2);
        } else {
            ImageUtil.waitImageReady(out);
            w = out.getWidth(null);
            h = out.getHeight(null);
            if (w == -1 || h == -1) {
                return null;
            }
            result = out;
        }
        Graphics2D g = (Graphics2D)result.getGraphics();
        g.setBackground(new Color(0, true));
        g.clearRect(0, 0, w, h);
        ImageUtil.waitImageReady(alphaImage);
        g.drawImage(alphaImage, 0, 0, null);
        g.setComposite(AlphaComposite.SrcAtop);
        g.setColor(color);
        g.fillRect(0, 0, w, h);
        g.dispose();
        return result;
    }

    public static void drawText(Image image, String text, float x, float y, int size, Color color) {
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setColor(color);
        g.setFont(FontUtil.setSize(g.getFont(), size));
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.drawString(text, x, y);
        g.dispose();
    }

    public static void drawTextTopRight(Image image, String text, int size, boolean bold, Color color) {
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setColor(color);
        g.setFont(FontUtil.setSize(g.getFont(), size));
        if (bold) {
            g.setFont(FontUtil.setStyle(g.getFont(), 1));
        }
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Rectangle2D bounds = GraphicsUtil.getStringBounds(g, text);
        ImageUtil.waitImageReady(image);
        float w = image.getWidth(null);
        g.drawString(text, w - (float)bounds.getWidth(), 0.0f - (float)bounds.getY());
        g.dispose();
    }
}

