/*
 * Decompiled with CFR 0.152.
 */
package icy.roi;

import icy.common.CollapsibleEvent;
import icy.roi.ROI;
import icy.util.StringUtil;

public class ROIEvent
implements CollapsibleEvent {
    private final ROI source;
    private final ROIEventType type;
    private String propertyName;
    @Deprecated
    private Object point;
    @Deprecated
    private ROIPointEventType pointEventType;

    @Deprecated
    public ROIEvent(ROI source, ROIEventType type, ROIPointEventType pointEventType, Object point) {
        this.source = source;
        this.type = type;
        this.propertyName = null;
        this.point = point;
        this.pointEventType = pointEventType;
    }

    public ROIEvent(ROI source, ROIEventType type, String propertyName) {
        this.source = source;
        this.type = type;
        this.propertyName = propertyName;
    }

    public ROIEvent(ROI source, String propertyName) {
        this(source, ROIEventType.PROPERTY_CHANGED, propertyName);
    }

    public ROIEvent(ROI source, ROIEventType type) {
        this(source, type, null);
    }

    public ROI getSource() {
        return this.source;
    }

    public ROIEventType getType() {
        return this.type;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    @Deprecated
    public Object getPoint() {
        return this.point;
    }

    @Deprecated
    public ROIPointEventType getPointEventType() {
        return this.pointEventType;
    }

    @Override
    public boolean collapse(CollapsibleEvent event) {
        return this.equals(event);
    }

    @Override
    public int hashCode() {
        int res = this.source.hashCode() ^ this.type.hashCode();
        if (this.type == ROIEventType.PROPERTY_CHANGED) {
            res ^= this.propertyName.hashCode();
        }
        return res;
    }

    @Override
    public boolean equals(Object obj) {
        ROIEvent e;
        if (obj instanceof ROIEvent && (e = (ROIEvent)obj).getSource() == this.source && e.getType() == this.type) {
            switch (this.type) {
                case ROI_CHANGED: {
                    return StringUtil.equals(this.propertyName, e.getPropertyName());
                }
                case FOCUS_CHANGED: 
                case SELECTION_CHANGED: 
                case NAME_CHANGED: 
                case PAINTER_CHANGED: {
                    return true;
                }
                case PROPERTY_CHANGED: {
                    return StringUtil.equals(this.propertyName, e.getPropertyName());
                }
            }
        }
        return super.equals(obj);
    }

    public static enum ROIEventType {
        FOCUS_CHANGED,
        SELECTION_CHANGED,
        ROI_CHANGED,
        PROPERTY_CHANGED,
        PAINTER_CHANGED,
        NAME_CHANGED;

    }

    @Deprecated
    public static enum ROIPointEventType {
        NULL,
        POINT_ADDED,
        POINT_REMOVED,
        POINT_CHANGED;

    }
}

