/*
 * Decompiled with CFR 0.152.
 */
package icy.sequence;

import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import java.util.ArrayList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class VolumetricImage {
    protected final Sequence sequence;
    protected final TreeMap<Integer, IcyBufferedImage> images;

    public VolumetricImage(Sequence seq) {
        this.sequence = seq;
        this.images = new TreeMap();
    }

    public VolumetricImage() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumImage() {
        int result = 0;
        TreeMap<Integer, IcyBufferedImage> treeMap = this.images;
        synchronized (treeMap) {
            for (Map.Entry<Integer, IcyBufferedImage> entry : this.images.entrySet()) {
                if (entry.getValue() == null) continue;
                ++result;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        TreeMap<Integer, IcyBufferedImage> treeMap = this.images;
        synchronized (treeMap) {
            if (this.images.isEmpty()) {
                return 0;
            }
            return this.images.lastKey() + 1;
        }
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IcyBufferedImage getFirstImage() {
        Map.Entry<Integer, IcyBufferedImage> entry;
        TreeMap<Integer, IcyBufferedImage> treeMap = this.images;
        synchronized (treeMap) {
            entry = this.images.firstEntry();
        }
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IcyBufferedImage getFirstNonNullImage() {
        TreeMap<Integer, IcyBufferedImage> treeMap = this.images;
        synchronized (treeMap) {
            for (IcyBufferedImage img : this.images.values()) {
                if (img == null) continue;
                return img;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IcyBufferedImage getLastImage() {
        Map.Entry<Integer, IcyBufferedImage> entry;
        TreeMap<Integer, IcyBufferedImage> treeMap = this.images;
        synchronized (treeMap) {
            entry = this.images.lastEntry();
        }
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IcyBufferedImage getImage(int z) {
        TreeMap<Integer, IcyBufferedImage> treeMap = this.images;
        synchronized (treeMap) {
            return this.images.get(z);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.sequence != null) {
            this.sequence.beginUpdate();
        }
        try {
            TreeMap<Integer, IcyBufferedImage> treeMap = this.images;
            synchronized (treeMap) {
                while (!this.images.isEmpty()) {
                    IcyBufferedImage image = this.images.pollFirstEntry().getValue();
                    if (image == null || this.sequence == null) continue;
                    this.sequence.onImageRemoved(image);
                }
            }
        }
        finally {
            if (this.sequence != null) {
                this.sequence.endUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeImage(int z) {
        IcyBufferedImage image;
        TreeMap<Integer, IcyBufferedImage> treeMap = this.images;
        synchronized (treeMap) {
            image = this.images.remove(z);
        }
        if (image != null && this.sequence != null) {
            this.sequence.onImageRemoved(image);
        }
        return image != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(int z, IcyBufferedImage image) {
        IcyBufferedImage oldImg = this.getImage(z);
        if (this.sequence != null) {
            this.sequence.beginUpdate();
        }
        try {
            TreeMap<Integer, IcyBufferedImage> treeMap = this.images;
            synchronized (treeMap) {
                this.images.put(z, image);
            }
            if (this.sequence != null) {
                if (oldImg != null) {
                    this.sequence.onImageReplaced(oldImg, image);
                } else {
                    this.sequence.onImageAdded(image);
                }
            }
        }
        finally {
            if (this.sequence != null) {
                this.sequence.endUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeMap<Integer, IcyBufferedImage> getImages() {
        TreeMap<Integer, IcyBufferedImage> treeMap = this.images;
        synchronized (treeMap) {
            return new TreeMap<Integer, IcyBufferedImage>((SortedMap<Integer, IcyBufferedImage>)this.images);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<IcyBufferedImage> getAllImage() {
        TreeMap<Integer, IcyBufferedImage> treeMap = this.images;
        synchronized (treeMap) {
            return new ArrayList<IcyBufferedImage>(this.images.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pack() {
        if (this.sequence != null) {
            this.sequence.beginUpdate();
        }
        try {
            TreeMap<Integer, IcyBufferedImage> treeMap = this.images;
            synchronized (treeMap) {
                for (Map.Entry<Integer, IcyBufferedImage> entry : this.images.entrySet()) {
                    IcyBufferedImage image = entry.getValue();
                    if (image != null) continue;
                    this.removeImage(entry.getKey());
                }
            }
        }
        finally {
            if (this.sequence != null) {
                this.sequence.endUpdate();
            }
        }
    }
}

