/*
 * Decompiled with CFR 0.152.
 */
package icy.system;

import icy.gui.dialog.LoaderDialog;
import icy.gui.frame.AboutFrame;
import icy.gui.preferences.PreferenceFrame;
import icy.main.Icy;
import icy.resource.ResourceUtil;
import icy.system.SystemUtil;
import icy.system.thread.ThreadUtil;
import icy.util.ClassUtil;
import icy.util.ReflectionUtil;
import java.awt.Desktop;
import java.awt.Image;
import java.awt.Toolkit;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class AppleUtil {
    static final Thread fixThread = new Thread(new Runnable(){

        @Override
        public void run() {
            AppleUtil.appleFixLiveRun();
        }
    }, "AppleFix");

    public static void init() {
        if (!Icy.getMainInterface().isHeadLess()) {
            try {
                System.setProperty("apple.eawt.quitStrategy", "CLOSE_ALL_WINDOWS");
                if (SystemUtil.getJavaVersionAsNumber() < 9.0) {
                    ClassLoader classLoader = SystemUtil.getSystemClassLoader();
                    Class<?> appClass = classLoader.loadClass("com.apple.eawt.Application");
                    Object app = appClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    Class<?> listenerClass = classLoader.loadClass("com.apple.eawt.ApplicationListener");
                    Object listener = Proxy.newProxyInstance(classLoader, new Class[]{listenerClass}, new InvocationHandler(){

                        @Override
                        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                            Object applicationEvent = args[0];
                            Class<?> appEventClass = applicationEvent.getClass();
                            Method m = appEventClass.getMethod("setHandled", Boolean.TYPE);
                            if (method.getName().equals("handleQuit")) {
                                Icy.exit(false);
                                m.invoke(applicationEvent, true);
                            }
                            if (method.getName().equals("handleAbout")) {
                                new AboutFrame();
                                m.invoke(applicationEvent, true);
                            }
                            if (method.getName().equals("handleOpenFile")) {
                                new LoaderDialog();
                                m.invoke(applicationEvent, true);
                            }
                            if (method.getName().equals("handlePreferences")) {
                                new PreferenceFrame("General");
                                m.invoke(applicationEvent, true);
                            }
                            return null;
                        }
                    });
                    Method m = appClass.getMethod("addApplicationListener", listenerClass);
                    m.invoke(app, listener);
                    m = appClass.getMethod("setDockIconImage", Image.class);
                    m.invoke(app, ResourceUtil.IMAGE_ICY_256);
                    m = appClass.getMethod("addPreferencesMenuItem", new Class[0]);
                    m.invoke(app, new Object[0]);
                } else {
                    Desktop desktop = Desktop.getDesktop();
                    Class<?> desktopClass = desktop.getClass();
                    ClassLoader classLoader = desktopClass.getClassLoader();
                    Class<?> aboutHandlerClass = ClassUtil.findClass("java.awt.desktop.AboutHandler");
                    Class<?> preferencesHandlerClass = ClassUtil.findClass("java.awt.desktop.PreferencesHandler");
                    Class<?> quitHandlerClass = ClassUtil.findClass("java.awt.desktop.QuitHandler");
                    Class<?> openFilesHandlerClass = ClassUtil.findClass("java.awt.desktop.OpenFilesHandler");
                    final Class<?> quitResponseClass = ClassUtil.findClass("java.awt.desktop.QuitResponse");
                    Object proxyHandler = Proxy.newProxyInstance(classLoader, new Class[]{aboutHandlerClass, preferencesHandlerClass, quitHandlerClass, openFilesHandlerClass}, new InvocationHandler(){

                        @Override
                        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                            String methodName;
                            switch (methodName = method.getName()) {
                                case "openFiles": {
                                    new LoaderDialog();
                                    break;
                                }
                                case "handleAbout": {
                                    new AboutFrame();
                                    break;
                                }
                                case "handlePreferences": {
                                    new PreferenceFrame("General");
                                    break;
                                }
                                case "handleQuitRequestWith": {
                                    Icy.exit(false);
                                    ReflectionUtil.getMethod(quitResponseClass, "cancelQuit", new Class[0]).invoke(args[1], new Object[0]);
                                    break;
                                }
                            }
                            return null;
                        }
                    });
                    Method m = ReflectionUtil.getMethod(desktopClass, "setAboutHandler", aboutHandlerClass);
                    m.invoke((Object)desktop, proxyHandler);
                    m = ReflectionUtil.getMethod(desktopClass, "setPreferencesHandler", preferencesHandlerClass);
                    m.invoke((Object)desktop, proxyHandler);
                    m = ReflectionUtil.getMethod(desktopClass, "setQuitHandler", quitHandlerClass);
                    m.invoke((Object)desktop, proxyHandler);
                    m = ReflectionUtil.getMethod(desktopClass, "setOpenFileHandler", openFilesHandlerClass);
                    m.invoke((Object)desktop, proxyHandler);
                    Class<?> taskBarClass = ClassUtil.findClass("java.awt.Taskbar");
                    Object taskBar = taskBarClass.getDeclaredMethod("getTaskbar", new Class[0]).invoke(null, new Object[0]);
                    m = ReflectionUtil.getMethod(taskBarClass, "setIconImage", Image.class);
                    m.invoke(taskBar, ResourceUtil.IMAGE_ICY_256);
                }
                SystemUtil.setProperty("com.apple.mrj.application.apple.menu.about.name", "Icy");
                SystemUtil.setProperty("apple.awt.application.name", "Icy");
            }
            catch (Exception e) {
                System.err.println("Warning: can't install OSX application wrapper...");
                System.err.println(e.getMessage());
            }
        }
        fixThread.start();
    }

    static void appleFixLiveRun() {
        while (true) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            PropertyChangeListener[] leak = toolkit.getPropertyChangeListeners("apple.awt.contentScaleFactor");
            for (int i = 0; i < leak.length; ++i) {
                toolkit.removePropertyChangeListener("apple.awt.contentScaleFactor", leak[i]);
            }
            ThreadUtil.sleep(500);
        }
    }
}

