/*
 * Decompiled with CFR 0.152.
 */
package icy.type.rectangle;

import icy.type.dimension.Dimension5D;
import icy.type.point.Point5D;
import icy.type.rectangle.Rectangle3D;
import icy.type.rectangle.Rectangle4D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public abstract class Rectangle5D
implements Cloneable {
    public static Rectangle5D intersect(Rectangle5D src1, Rectangle5D src2, Rectangle5D dest) {
        Rectangle5D result = dest == null ? new Double() : dest;
        double x1 = Math.max(src1.getMinX(), src2.getMinX());
        double y1 = Math.max(src1.getMinY(), src2.getMinY());
        double z1 = Math.max(src1.getMinZ(), src2.getMinZ());
        double t1 = Math.max(src1.getMinT(), src2.getMinT());
        double c1 = Math.max(src1.getMinC(), src2.getMinC());
        double x2 = Math.min(src1.getMaxX(), src2.getMaxX());
        double y2 = Math.min(src1.getMaxY(), src2.getMaxY());
        double z2 = Math.min(src1.getMaxZ(), src2.getMaxZ());
        double t2 = Math.min(src1.getMaxT(), src2.getMaxT());
        double c2 = Math.min(src1.getMaxC(), src2.getMaxC());
        double dx = x2 == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : x2 - x1;
        double dy = y2 == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : y2 - y1;
        double dz = z2 == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : z2 - z1;
        double dt = t2 == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : t2 - t1;
        double dc = c2 == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : c2 - c1;
        result.setRect(x1, y1, z1, t1, c1, dx, dy, dz, dt, dc);
        return result;
    }

    public abstract Rectangle5D createIntersection(Rectangle5D var1);

    public static Rectangle5D union(Rectangle5D src1, Rectangle5D src2, Rectangle5D dest) {
        Rectangle5D result = dest == null ? new Double() : dest;
        double x1 = Math.min(src1.getMinX(), src2.getMinX());
        double y1 = Math.min(src1.getMinY(), src2.getMinY());
        double z1 = Math.min(src1.getMinZ(), src2.getMinZ());
        double t1 = Math.min(src1.getMinT(), src2.getMinT());
        double c1 = Math.min(src1.getMinC(), src2.getMinC());
        double x2 = Math.max(src1.getMaxX(), src2.getMaxX());
        double y2 = Math.max(src1.getMaxY(), src2.getMaxY());
        double z2 = Math.max(src1.getMaxZ(), src2.getMaxZ());
        double t2 = Math.max(src1.getMaxT(), src2.getMaxT());
        double c2 = Math.max(src1.getMaxC(), src2.getMaxC());
        double dx = x2 == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : x2 - x1;
        double dy = y2 == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : y2 - y1;
        double dz = z2 == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : z2 - z1;
        double dt = t2 == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : t2 - t1;
        double dc = c2 == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : c2 - c1;
        result.setRect(x1, y1, z1, t1, c1, dx, dy, dz, dt, dc);
        return result;
    }

    public abstract Rectangle5D createUnion(Rectangle5D var1);

    public abstract void setRect(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17, double var19);

    public abstract double getX();

    public abstract double getY();

    public abstract double getZ();

    public abstract double getT();

    public abstract double getC();

    public abstract double getSizeX();

    public abstract double getSizeY();

    public abstract double getSizeZ();

    public abstract double getSizeT();

    public abstract double getSizeC();

    public abstract Point5D getPosition();

    public abstract Dimension5D getDimension();

    public Integer toInteger() {
        double sx = this.getSizeX();
        double sy = this.getSizeY();
        double sz = this.getSizeZ();
        double st = this.getSizeT();
        double sc = this.getSizeC();
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        double t = this.getT();
        double c = this.getC();
        int ix = (int)Math.floor(x);
        int iy = (int)Math.floor(y);
        int iz = (int)Math.floor(z);
        int it = (int)Math.floor(t);
        int ic = (int)Math.floor(c);
        int isx = sx < 0.0 ? 0 : (sx >= 2.147483647E9 ? java.lang.Integer.MAX_VALUE : (int)Math.ceil(x + sx) - ix);
        int isy = sy < 0.0 ? 0 : (sy >= 2.147483647E9 ? java.lang.Integer.MAX_VALUE : (int)Math.ceil(y + sy) - iy);
        int isz = sz < 0.0 ? 0 : (sz >= 2.147483647E9 ? java.lang.Integer.MAX_VALUE : (int)Math.ceil(z + sz) - iz);
        int ist = st < 0.0 ? 0 : (st >= 2.147483647E9 ? java.lang.Integer.MAX_VALUE : (int)Math.ceil(t + st) - it);
        int isc = sc < 0.0 ? 0 : (sc >= 2.147483647E9 ? java.lang.Integer.MAX_VALUE : (int)Math.ceil(c + sc) - ic);
        return new Integer(ix, iy, iz, it, ic, isx, isy, isz, ist, isc);
    }

    public abstract void setX(double var1);

    public abstract void setY(double var1);

    public abstract void setZ(double var1);

    public abstract void setT(double var1);

    public abstract void setC(double var1);

    public abstract void setSizeX(double var1);

    public abstract void setSizeY(double var1);

    public abstract void setSizeZ(double var1);

    public abstract void setSizeT(double var1);

    public abstract void setSizeC(double var1);

    public double getMinX() {
        return this.getX();
    }

    public double getMinY() {
        return this.getY();
    }

    public double getMinZ() {
        return this.getZ();
    }

    public double getMinT() {
        return this.getT();
    }

    public double getMinC() {
        return this.getC();
    }

    public double getMaxX() {
        if (this.getSizeX() == java.lang.Double.POSITIVE_INFINITY) {
            return java.lang.Double.POSITIVE_INFINITY;
        }
        return this.getX() + this.getSizeX();
    }

    public double getMaxY() {
        if (this.getSizeY() == java.lang.Double.POSITIVE_INFINITY) {
            return java.lang.Double.POSITIVE_INFINITY;
        }
        return this.getY() + this.getSizeY();
    }

    public double getMaxZ() {
        if (this.getSizeZ() == java.lang.Double.POSITIVE_INFINITY) {
            return java.lang.Double.POSITIVE_INFINITY;
        }
        return this.getZ() + this.getSizeZ();
    }

    public double getMaxT() {
        if (this.getSizeT() == java.lang.Double.POSITIVE_INFINITY) {
            return java.lang.Double.POSITIVE_INFINITY;
        }
        return this.getT() + this.getSizeT();
    }

    public double getMaxC() {
        if (this.getSizeC() == java.lang.Double.POSITIVE_INFINITY) {
            return java.lang.Double.POSITIVE_INFINITY;
        }
        return this.getC() + this.getSizeC();
    }

    public double getCenterX() {
        if (this.isInfiniteX()) {
            return 0.0;
        }
        return this.getX() + this.getSizeX() / 2.0;
    }

    public double getCenterY() {
        if (this.isInfiniteY()) {
            return 0.0;
        }
        return this.getY() + this.getSizeY() / 2.0;
    }

    public double getCenterZ() {
        if (this.isInfiniteZ()) {
            return 0.0;
        }
        return this.getZ() + this.getSizeZ() / 2.0;
    }

    public double getCenterT() {
        if (this.isInfiniteT()) {
            return 0.0;
        }
        return this.getT() + this.getSizeT() / 2.0;
    }

    public double getCenterC() {
        if (this.isInfiniteC()) {
            return 0.0;
        }
        return this.getC() + this.getSizeC() / 2.0;
    }

    public boolean isEmpty() {
        return this.getSizeX() <= 0.0 || this.getSizeY() <= 0.0 || this.getSizeZ() <= 0.0 || this.getSizeT() <= 0.0 || this.getSizeC() <= 0.0;
    }

    public boolean isInfiniteX() {
        return this.getX() == java.lang.Double.NEGATIVE_INFINITY && this.getSizeX() == java.lang.Double.POSITIVE_INFINITY;
    }

    public boolean isInfiniteY() {
        return this.getY() == java.lang.Double.NEGATIVE_INFINITY && this.getSizeY() == java.lang.Double.POSITIVE_INFINITY;
    }

    public boolean isInfiniteZ() {
        return this.getZ() == java.lang.Double.NEGATIVE_INFINITY && this.getSizeZ() == java.lang.Double.POSITIVE_INFINITY;
    }

    public boolean isInfiniteT() {
        return this.getT() == java.lang.Double.NEGATIVE_INFINITY && this.getSizeT() == java.lang.Double.POSITIVE_INFINITY;
    }

    public boolean isInfiniteC() {
        return this.getC() == java.lang.Double.NEGATIVE_INFINITY && this.getSizeC() == java.lang.Double.POSITIVE_INFINITY;
    }

    public void setInfiniteX() {
        this.setX(java.lang.Double.NEGATIVE_INFINITY);
        this.setSizeX(java.lang.Double.POSITIVE_INFINITY);
    }

    public void setInfiniteY() {
        this.setY(java.lang.Double.NEGATIVE_INFINITY);
        this.setSizeY(java.lang.Double.POSITIVE_INFINITY);
    }

    public void setInfiniteZ() {
        this.setZ(java.lang.Double.NEGATIVE_INFINITY);
        this.setSizeZ(java.lang.Double.POSITIVE_INFINITY);
    }

    public void setInfiniteT() {
        this.setT(java.lang.Double.NEGATIVE_INFINITY);
        this.setSizeT(java.lang.Double.POSITIVE_INFINITY);
    }

    public void setInfiniteC() {
        this.setC(java.lang.Double.NEGATIVE_INFINITY);
        this.setSizeC(java.lang.Double.POSITIVE_INFINITY);
    }

    public boolean contains(double x, double y, double z, double t, double c) {
        return x >= this.getMinX() && y >= this.getMinY() && z >= this.getMinZ() && t >= this.getMinT() && c >= this.getMinC() && x < this.getMaxX() && y < this.getMaxY() && z < this.getMaxZ() && t < this.getMaxT() && c < this.getMaxC();
    }

    public boolean contains(double x, double y, double z, double t, double c, double sizeX, double sizeY, double sizeZ, double sizeT, double sizeC) {
        double maxX = sizeX == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : x + sizeX;
        double maxY = sizeY == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : y + sizeY;
        double maxZ = sizeZ == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : z + sizeZ;
        double maxT = sizeT == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : t + sizeT;
        double maxC = sizeC == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : c + sizeC;
        return x >= this.getMinX() && y >= this.getMinY() && z >= this.getMinZ() && t >= this.getMinT() && c >= this.getMinC() && maxX <= this.getMaxX() && maxY <= this.getMaxY() && maxZ <= this.getMaxZ() && maxT <= this.getMaxT() && maxC <= this.getMaxC();
    }

    public boolean contains(Rectangle5D rect) {
        return this.contains(rect.getX(), rect.getY(), rect.getZ(), rect.getT(), rect.getC(), rect.getSizeX(), rect.getSizeY(), rect.getSizeZ(), rect.getSizeT(), rect.getSizeC());
    }

    public boolean intersects(double x, double y, double z, double t, double c, double sizeX, double sizeY, double sizeZ, double sizeT, double sizeC) {
        double maxX = sizeX == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : x + sizeX;
        double maxY = sizeY == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : y + sizeY;
        double maxZ = sizeZ == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : z + sizeZ;
        double maxT = sizeT == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : t + sizeT;
        double maxC = sizeC == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : c + sizeC;
        return maxX > this.getMinX() && maxY > this.getMinY() && maxZ > this.getMinZ() && maxT > this.getMinT() && maxC > this.getMinC() && x < this.getMaxX() && y < this.getMaxY() && z < this.getMaxZ() && t < this.getMaxT() && c < this.getMaxC();
    }

    public boolean intersects(Rectangle5D rect) {
        return this.intersects(rect.getX(), rect.getY(), rect.getZ(), rect.getT(), rect.getC(), rect.getSizeX(), rect.getSizeY(), rect.getSizeZ(), rect.getSizeT(), rect.getSizeC());
    }

    public void add(double newx, double newy, double newz, double newt, double newc) {
        double x1 = Math.min(this.getMinX(), newx);
        double x2 = Math.max(this.getMaxX(), newx);
        double y1 = Math.min(this.getMinY(), newy);
        double y2 = Math.max(this.getMaxY(), newy);
        double z1 = Math.min(this.getMinZ(), newz);
        double z2 = Math.max(this.getMaxZ(), newz);
        double t1 = Math.min(this.getMinT(), newt);
        double t2 = Math.max(this.getMaxT(), newt);
        double c1 = Math.min(this.getMinC(), newc);
        double c2 = Math.max(this.getMaxC(), newc);
        double dx = x2 == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : x2 - x1;
        double dy = y2 == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : y2 - y1;
        double dz = z2 == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : z2 - z1;
        double dt = t2 == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : t2 - t1;
        double dc = c2 == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : c2 - c1;
        this.setRect(x1, y1, z1, t1, c1, dx, dy, dz, dt, dc);
    }

    public void add(Point5D pt) {
        this.add(pt.getX(), pt.getY(), pt.getZ(), pt.getT(), pt.getC());
    }

    public void add(Rectangle5D r) {
        Rectangle5D.union(this, r, this);
    }

    public abstract Rectangle2D toRectangle2D();

    public abstract Rectangle3D toRectangle3D();

    public abstract Rectangle4D toRectangle4D();

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Rectangle5D) {
            Rectangle5D rect = (Rectangle5D)obj;
            return this.getX() == rect.getX() && this.getY() == rect.getY() && this.getC() == rect.getC() && this.getZ() == rect.getZ() && this.getT() == rect.getT() && this.getSizeX() == rect.getSizeX() && this.getSizeY() == rect.getSizeY() && this.getSizeC() == rect.getSizeC() && this.getSizeZ() == rect.getSizeZ() && this.getSizeT() == rect.getSizeT();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        long bits = java.lang.Double.doubleToLongBits(this.getX());
        bits ^= java.lang.Double.doubleToLongBits(this.getY());
        bits ^= java.lang.Double.doubleToLongBits(this.getC());
        bits ^= java.lang.Double.doubleToLongBits(this.getZ());
        bits ^= java.lang.Double.doubleToLongBits(this.getT());
        bits ^= java.lang.Double.doubleToLongBits(this.getSizeX());
        bits ^= java.lang.Double.doubleToLongBits(this.getSizeY());
        bits ^= java.lang.Double.doubleToLongBits(this.getSizeC());
        bits ^= java.lang.Double.doubleToLongBits(this.getSizeZ());
        return (int)(bits ^= java.lang.Double.doubleToLongBits(this.getSizeT())) ^ (int)(bits >> 32);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getX() + "," + this.getY() + "," + this.getZ() + "," + this.getT() + "," + this.getC() + " - " + this.getSizeX() + "," + this.getSizeY() + "," + this.getSizeZ() + "," + this.getSizeT() + "," + this.getSizeC() + "]";
    }

    public static class Integer
    extends Rectangle5D {
        public int x;
        public int y;
        public int z;
        public int t;
        public int c;
        public int sizeX;
        public int sizeY;
        public int sizeZ;
        public int sizeT;
        public int sizeC;

        public Integer(int x, int y, int z, int t, int c, int sizeX, int sizeY, int sizeZ, int sizeT, int sizeC) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.t = t;
            this.c = c;
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.sizeZ = sizeZ;
            this.sizeT = sizeT;
            this.sizeC = sizeC;
        }

        public Integer(Integer r) {
            this(r.x, r.y, r.z, r.t, r.c, r.sizeX, r.sizeY, r.sizeZ, r.sizeT, r.sizeC);
        }

        public Integer(Rectangle5D r) {
            this(r.toInteger());
        }

        public Integer() {
            this(0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
        }

        @Override
        public void setRect(double x, double y, double z, double t, double c, double sizeX, double sizeY, double sizeZ, double sizeT, double sizeC) {
            Integer r = new Double(x, y, z, t, c, sizeX, sizeY, sizeZ, sizeT, sizeC).toInteger();
            this.setRect(r.x, r.y, r.z, r.t, r.c, r.sizeX, r.sizeY, r.sizeZ, r.sizeT, r.sizeC);
        }

        public void setRect(int x, int y, int z, int t, int c, int sizeX, int sizeY, int sizeZ, int sizeT, int sizeC) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.t = t;
            this.c = c;
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.sizeZ = sizeZ;
            this.sizeT = sizeT;
            this.sizeC = sizeC;
        }

        @Override
        public double getX() {
            if (this.x == java.lang.Integer.MIN_VALUE) {
                return java.lang.Double.NEGATIVE_INFINITY;
            }
            if (this.x == java.lang.Integer.MAX_VALUE) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.x;
        }

        @Override
        public void setX(double value) {
            this.x = (int)value;
        }

        @Override
        public double getY() {
            if (this.y == java.lang.Integer.MIN_VALUE) {
                return java.lang.Double.NEGATIVE_INFINITY;
            }
            if (this.y == java.lang.Integer.MAX_VALUE) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.y;
        }

        @Override
        public void setY(double value) {
            this.y = (int)value;
        }

        @Override
        public double getZ() {
            if (this.z == java.lang.Integer.MIN_VALUE) {
                return java.lang.Double.NEGATIVE_INFINITY;
            }
            if (this.z == java.lang.Integer.MAX_VALUE) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.z;
        }

        @Override
        public void setZ(double value) {
            this.z = (int)value;
        }

        @Override
        public double getT() {
            if (this.t == java.lang.Integer.MIN_VALUE) {
                return java.lang.Double.NEGATIVE_INFINITY;
            }
            if (this.t == java.lang.Integer.MAX_VALUE) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.t;
        }

        @Override
        public void setT(double value) {
            this.t = (int)value;
        }

        @Override
        public double getC() {
            if (this.c == java.lang.Integer.MIN_VALUE) {
                return java.lang.Double.NEGATIVE_INFINITY;
            }
            if (this.c == java.lang.Integer.MAX_VALUE) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.c;
        }

        @Override
        public void setC(double value) {
            this.c = (int)value;
        }

        @Override
        public double getSizeX() {
            if (this.sizeX == java.lang.Integer.MAX_VALUE) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.sizeX;
        }

        @Override
        public void setSizeX(double value) {
            this.sizeX = (int)value;
        }

        @Override
        public double getSizeY() {
            if (this.sizeY == java.lang.Integer.MAX_VALUE) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.sizeY;
        }

        @Override
        public void setSizeY(double value) {
            this.sizeY = (int)value;
        }

        @Override
        public double getSizeZ() {
            if (this.sizeZ == java.lang.Integer.MAX_VALUE) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.sizeZ;
        }

        @Override
        public void setSizeZ(double value) {
            this.sizeZ = (int)value;
        }

        @Override
        public double getSizeT() {
            if (this.sizeT == java.lang.Integer.MAX_VALUE) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.sizeT;
        }

        @Override
        public void setSizeT(double value) {
            this.sizeT = (int)value;
        }

        @Override
        public double getSizeC() {
            if (this.sizeC == java.lang.Integer.MAX_VALUE) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.sizeC;
        }

        @Override
        public void setSizeC(double value) {
            this.sizeC = (int)value;
        }

        @Override
        public Point5D.Integer getPosition() {
            return new Point5D.Integer(this.x, this.y, this.z, this.t, this.c);
        }

        @Override
        public Dimension5D.Integer getDimension() {
            return new Dimension5D.Integer(this.sizeX, this.sizeY, this.sizeZ, this.sizeT, this.sizeC);
        }

        @Override
        public Integer toInteger() {
            return (Integer)this.clone();
        }

        @Override
        public Rectangle5D createIntersection(Rectangle5D r) {
            Integer result = new Integer();
            Integer.intersect(this, r, result);
            return result;
        }

        @Override
        public Rectangle5D createUnion(Rectangle5D r) {
            Integer result = new Integer();
            Integer.union(this, r, result);
            return result;
        }

        @Override
        public Rectangle2D toRectangle2D() {
            return new Rectangle(this.x, this.y, this.sizeX, this.sizeY);
        }

        @Override
        public Rectangle3D toRectangle3D() {
            return new Rectangle3D.Integer(this.x, this.y, this.z, this.sizeX, this.sizeY, this.sizeZ);
        }

        @Override
        public Rectangle4D toRectangle4D() {
            return new Rectangle4D.Integer(this.x, this.y, this.z, this.t, this.sizeX, this.sizeY, this.sizeZ, this.sizeT);
        }
    }

    public static class Float
    extends Rectangle5D {
        public float x;
        public float y;
        public float z;
        public float t;
        public float c;
        public float sizeX;
        public float sizeY;
        public float sizeZ;
        public float sizeT;
        public float sizeC;

        public Float(float x, float y, float z, float t, float c, float sizeX, float sizeY, float sizeZ, float sizeT, float sizeC) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.t = t;
            this.c = c;
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.sizeZ = sizeZ;
            this.sizeT = sizeT;
            this.sizeC = sizeC;
        }

        public Float(Rectangle5D r) {
            this((float)r.getX(), (float)r.getY(), (float)r.getZ(), (float)r.getT(), (float)r.getC(), (float)r.getSizeX(), (float)r.getSizeY(), (float)r.getSizeZ(), (float)r.getSizeT(), (float)r.getSizeC());
        }

        public Float() {
            this(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }

        @Override
        public void setRect(double x, double y, double z, double t, double c, double sizeX, double sizeY, double sizeZ, double sizeT, double sizeC) {
            this.x = (float)x;
            this.y = (float)y;
            this.z = (float)z;
            this.t = (float)t;
            this.c = (float)c;
            this.sizeX = (float)sizeX;
            this.sizeY = (float)sizeY;
            this.sizeZ = (float)sizeZ;
            this.sizeT = (float)sizeT;
            this.sizeC = (float)sizeC;
        }

        @Override
        public double getX() {
            if (this.x == java.lang.Float.NEGATIVE_INFINITY) {
                return java.lang.Double.NEGATIVE_INFINITY;
            }
            if (this.x == java.lang.Float.POSITIVE_INFINITY) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.x;
        }

        @Override
        public void setX(double value) {
            this.x = (float)value;
        }

        @Override
        public double getY() {
            if (this.y == java.lang.Float.NEGATIVE_INFINITY) {
                return java.lang.Double.NEGATIVE_INFINITY;
            }
            if (this.y == java.lang.Float.POSITIVE_INFINITY) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.y;
        }

        @Override
        public void setY(double value) {
            this.y = (float)value;
        }

        @Override
        public double getZ() {
            if (this.z == java.lang.Float.NEGATIVE_INFINITY) {
                return java.lang.Double.NEGATIVE_INFINITY;
            }
            if (this.z == java.lang.Float.POSITIVE_INFINITY) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.z;
        }

        @Override
        public void setZ(double value) {
            this.z = (float)value;
        }

        @Override
        public double getT() {
            if (this.t == java.lang.Float.NEGATIVE_INFINITY) {
                return java.lang.Double.NEGATIVE_INFINITY;
            }
            if (this.t == java.lang.Float.POSITIVE_INFINITY) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.t;
        }

        @Override
        public void setT(double value) {
            this.t = (float)value;
        }

        @Override
        public double getC() {
            if (this.c == java.lang.Float.NEGATIVE_INFINITY) {
                return java.lang.Double.NEGATIVE_INFINITY;
            }
            if (this.c == java.lang.Float.POSITIVE_INFINITY) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.c;
        }

        @Override
        public void setC(double value) {
            this.c = (float)value;
        }

        @Override
        public double getSizeX() {
            if (this.sizeX == java.lang.Float.POSITIVE_INFINITY) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.sizeX;
        }

        @Override
        public void setSizeX(double value) {
            this.sizeX = (float)value;
        }

        @Override
        public double getSizeY() {
            if (this.sizeY == java.lang.Float.POSITIVE_INFINITY) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.sizeY;
        }

        @Override
        public void setSizeY(double value) {
            this.sizeY = (float)value;
        }

        @Override
        public double getSizeZ() {
            if (this.sizeZ == java.lang.Float.POSITIVE_INFINITY) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.sizeZ;
        }

        @Override
        public void setSizeZ(double value) {
            this.sizeZ = (float)value;
        }

        @Override
        public double getSizeT() {
            if (this.sizeT == java.lang.Float.POSITIVE_INFINITY) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.sizeT;
        }

        @Override
        public void setSizeT(double value) {
            this.sizeT = (float)value;
        }

        @Override
        public double getSizeC() {
            if (this.sizeC == java.lang.Float.POSITIVE_INFINITY) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.sizeC;
        }

        @Override
        public void setSizeC(double value) {
            this.sizeC = (float)value;
        }

        @Override
        public Point5D.Float getPosition() {
            return new Point5D.Float(this.x, this.y, this.z, this.t, this.c);
        }

        @Override
        public Dimension5D.Float getDimension() {
            return new Dimension5D.Float(this.sizeX, this.sizeY, this.sizeZ, this.sizeT, this.sizeC);
        }

        @Override
        public Rectangle5D createIntersection(Rectangle5D r) {
            Float result = new Float();
            Float.intersect(this, r, result);
            return result;
        }

        @Override
        public Rectangle5D createUnion(Rectangle5D r) {
            Float result = new Float();
            Float.union(this, r, result);
            return result;
        }

        @Override
        public Rectangle2D toRectangle2D() {
            return new Rectangle2D.Float(this.x, this.y, this.sizeX, this.sizeY);
        }

        @Override
        public Rectangle3D toRectangle3D() {
            return new Rectangle3D.Float(this.x, this.y, this.z, this.sizeX, this.sizeY, this.sizeZ);
        }

        @Override
        public Rectangle4D toRectangle4D() {
            return new Rectangle4D.Float(this.x, this.y, this.z, this.t, this.sizeX, this.sizeY, this.sizeZ, this.sizeT);
        }
    }

    public static class Double
    extends Rectangle5D {
        public double x;
        public double y;
        public double z;
        public double t;
        public double c;
        public double sizeX;
        public double sizeY;
        public double sizeZ;
        public double sizeT;
        public double sizeC;

        public Double(double x, double y, double z, double t, double c, double sizeX, double sizeY, double sizeZ, double sizeT, double sizeC) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.t = t;
            this.c = c;
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.sizeZ = sizeZ;
            this.sizeT = sizeT;
            this.sizeC = sizeC;
        }

        public Double(Rectangle5D r) {
            this(r.getX(), r.getY(), r.getZ(), r.getT(), r.getC(), r.getSizeX(), r.getSizeY(), r.getSizeZ(), r.getSizeT(), r.getSizeC());
        }

        public Double() {
            this(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }

        @Override
        public void setRect(double x, double y, double z, double t, double c, double sizeX, double sizeY, double sizeZ, double sizeT, double sizeC) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.t = t;
            this.c = c;
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.sizeZ = sizeZ;
            this.sizeT = sizeT;
            this.sizeC = sizeC;
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public void setX(double value) {
            this.x = value;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public void setY(double value) {
            this.y = value;
        }

        @Override
        public double getZ() {
            return this.z;
        }

        @Override
        public void setZ(double value) {
            this.z = value;
        }

        @Override
        public double getT() {
            return this.t;
        }

        @Override
        public void setT(double value) {
            this.t = value;
        }

        @Override
        public double getC() {
            return this.c;
        }

        @Override
        public void setC(double value) {
            this.c = value;
        }

        @Override
        public double getSizeX() {
            return this.sizeX;
        }

        @Override
        public void setSizeX(double value) {
            this.sizeX = value;
        }

        @Override
        public double getSizeY() {
            return this.sizeY;
        }

        @Override
        public void setSizeY(double value) {
            this.sizeY = value;
        }

        @Override
        public double getSizeZ() {
            return this.sizeZ;
        }

        @Override
        public void setSizeZ(double value) {
            this.sizeZ = value;
        }

        @Override
        public double getSizeT() {
            return this.sizeT;
        }

        @Override
        public void setSizeT(double value) {
            this.sizeT = value;
        }

        @Override
        public double getSizeC() {
            return this.sizeC;
        }

        @Override
        public void setSizeC(double value) {
            this.sizeC = value;
        }

        @Override
        public Point5D.Double getPosition() {
            return new Point5D.Double(this.x, this.y, this.z, this.t, this.c);
        }

        @Override
        public Dimension5D.Double getDimension() {
            return new Dimension5D.Double(this.sizeX, this.sizeY, this.sizeZ, this.sizeT, this.sizeC);
        }

        @Override
        public Rectangle5D createIntersection(Rectangle5D r) {
            Double result = new Double();
            Double.intersect(this, r, result);
            return result;
        }

        @Override
        public Rectangle5D createUnion(Rectangle5D r) {
            Double result = new Double();
            Double.union(this, r, result);
            return result;
        }

        @Override
        public Rectangle2D toRectangle2D() {
            return new Rectangle2D.Double(this.x, this.y, this.sizeX, this.sizeY);
        }

        @Override
        public Rectangle3D toRectangle3D() {
            return new Rectangle3D.Double(this.x, this.y, this.z, this.sizeX, this.sizeY, this.sizeZ);
        }

        @Override
        public Rectangle4D toRectangle4D() {
            return new Rectangle4D.Double(this.x, this.y, this.z, this.t, this.sizeX, this.sizeY, this.sizeZ, this.sizeT);
        }
    }
}

