/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.descriptor.property;

import icy.roi.ROI;
import icy.roi.ROIDescriptor;
import icy.roi.ROIEvent;
import icy.sequence.Sequence;
import icy.util.StringUtil;

public class ROIReadOnlyDescriptor
extends ROIDescriptor {
    public static final String ID = "Read only";

    public ROIReadOnlyDescriptor() {
        super(ID, "Read Only", Boolean.class);
    }

    @Override
    public String getDescription() {
        return "Read only state";
    }

    @Override
    public boolean needRecompute(ROIEvent change) {
        return change.getType() == ROIEvent.ROIEventType.PROPERTY_CHANGED && StringUtil.equals(change.getPropertyName(), "readOnly");
    }

    @Override
    public Object compute(ROI roi, Sequence sequence) throws UnsupportedOperationException {
        return ROIReadOnlyDescriptor.getReadOnly(roi);
    }

    public static boolean getReadOnly(ROI roi) {
        if (roi == null) {
            return false;
        }
        return roi.isReadOnly();
    }
}

